! gtfig.f90 - Definitions of Gtool Figure Subroutines
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

! _Kw͂ɂׂ̂AGTFigPutCont,
! GTFigPutAxis Ȃǂ͂ꂼ gtcontdefault.f90,
! gtaxis.f90 ɂĂB

subroutine GTFigOpen(fig)
    use gtgraph_types, only: GT_FIGURE
    type(GT_FIGURE), intent(out):: fig
    nullify(fig%h_axis)
    nullify(fig%v_axis)
    nullify(fig%contours)
    nullify(fig%line)
end subroutine

subroutine GTFigClose(fig)
    use gtgraph_types, only: GT_FIGURE
    use gtgraph_generic, only: Close
    type(GT_FIGURE), intent(out):: fig
    if (associated(fig%h_axis)) then
        deallocate(fig%h_axis)
    endif
    if (associated(fig%v_axis)) then
        deallocate(fig%v_axis)
    endif
    if (associated(fig%contours)) then
        deallocate(fig%contours)
    endif
    if (associated(fig%line)) then
        deallocate(fig%line)
    endif
end subroutine

subroutine GTFigDisplay(dev, fig)
    use gtgraph_types, only: GT_DEVICE, GT_FIGURE
    use gtgraph_generic, only: Display
    use dcl
    type(GT_DEVICE), intent(inout):: dev
    type(GT_FIGURE), intent(out):: fig
    integer:: i
    call DclNewFrame
    if (associated(fig%contours)) then
        do, i = 1, size(fig%contours)
            call Display(fig%contours(i))
        enddo        
    endif
    if (associated(fig%line)) then
        do, i = 1, size(fig%line)
            call Display(fig%line(i))
        enddo        
    endif
end subroutine
