! gtcontdefault.f90 - Definitions of Gtool Contours subroutines

function GTContDefault(var) result(result)
    use gtgraph_types, only: GT_CONTOURS
    use gtdata_types, only: GT_VARIABLE
    type(GT_CONTOURS):: result
    type(GT_VARIABLE), intent(in):: var
    result%var = var
    result%interval = 1.0
end function

subroutine GTFigPutCont(fig, cont)
    use gtgraph_types, only: GT_FIGURE, GT_CONTOURS
    type(GT_FIGURE), intent(inout):: fig
    type(GT_CONTOURS), intent(in):: cont
    type(GT_CONTOURS), pointer:: newconts(:)
    integer:: nconts
    if (associated(fig%contours)) then
        nconts = size(fig%contours)
        allocate(newconts(nconts + 1))
        newconts(1: nconts) = fig%contours(1: nconts)
        deallocate(fig%contours)
    else
        nconts = 0
        allocate(newconts(1))
    endif
    newconts(nconts + 1) = cont
    fig%contours => newconts
end subroutine

subroutine GTContDisplay(cont)
    use gtgraph_types, only: GT_CONTOURS
    use gtdata_generic, only: Get
    use dcl
    type(GT_CONTOURS), intent(inout):: cont
    real, pointer:: buffer(:, :)
    real:: top, bottom, leftmost, rightmost
    ! `͈͂̐ݒB̓C`LłB
    leftmost = 1
    rightmost = size(buffer, dim=1)
    bottom = 1
    top = size(buffer, dim=2)
    call DclSetWindow(leftmost, rightmost, bottom, top)
    call DclSetViewport(0.2, 0.8, 0.2, 0.6)
    call DclSetTransFunction()
    ! f[^̎擾ƕ`
    call Get(cont%var, buffer)
    call DclSetShadeLevel(buffer, 0.0)
    call DclShadeContour(buffer)
    call DclDrawScaledAxis
    call DclDrawContour(buffer)
    deallocate(buffer)
end subroutine