! gtaxisdefault.f90 - 
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

type(GT_AXIS) function GTAxisDefault(var, dimno, vertical) result(result)
    use gtgraph_types, only: GT_AXIS
    use gtdata_types, only: GT_VARIABLE
    type(GT_VARIABLE), intent(in):: var
    integer, intent(in):: dimno
    logical, intent(in), optional:: vertical
continue
    result%var = var
    result%vertical = .FALSE.
    if (present(vertical)) result%vertical = vertical
end function

subroutine GTFigPutAxis(fig, axis_given, vertical)
    use gtgraph_types, only: GT_FIGURE, GT_AXIS
    type(GT_FIGURE), intent(inout):: fig
    type(GT_AXIS), intent(in):: axis_given
    logical, intent(in), optional:: vertical
    type(GT_AXIS):: axis
continue
    axis = axis_given
    if (present(vertical)) axis%vertical = vertical
    if (axis%vertical) then
        if (.not. associated(fig%v_axis)) allocate(fig%v_axis)
        fig%v_axis = axis
    else
        if (.not. associated(fig%h_axis)) allocate(fig%h_axis)
        fig%h_axis = axis
    endif
end subroutine