subroutine ANVarOpen(var, url, writable, err)
    use iso_varying_string, &
        only: VARYING_STRING, operator(/=), char
    use an_types
    use an_file
    use an_url
    use dc_error
    use netcdf_f77
    implicit none
    type(AN_VARIABLE), intent(inout):: var
    type(VARYING_STRING), intent(in):: url
    logical, intent(in), optional:: writable
    logical, intent(out), optional:: err
    type(VARYING_STRING):: filename, varname
    integer:: stat, nvars, ndims, i
continue
    call ANUrlSplit(url, filename, varname)
    call ANFileOpen(var%fileid, filename, err=err, writable=writable)
    !
    ! OϐToBOȂΑ1ϐƂB
    ! [] ϐXLbvׂłB
    !
    if (varname /= '') then
        var%varid = 0
	stat = nf_inq_varid(var%fileid, char(varname), var%varid)
        if (stat == NF_ENOTVAR) goto 100
    else    
	var%varid = 1
	stat = nf_inq_nvars(var%fileid, nvars)
	if (stat == 0 .and. nvars < 1) stat = NF_ENOTVAR
    endif
    if (stat /= NF_NOERR) goto 999
    !
    ! id 𒲂ׂ
    !
100 continue
    stat = nf_inq_dimid(var%fileid, char(varname), var%dimid)
    if (stat /= NF_NOERR .and. var%varid <= 0) goto 999
    !
    ! 𒲂ׂĕKvȔzt
    !
    if (var%varid > 0) then
        stat = nf_inq_varndims(var%fileid, var%varid, ndims)
        if (stat /= NF_NOERR) goto 999
        allocate(var%dimids(ndims), var%allcount(ndims))
        stat = nf_inq_vardimid(var%fileid, var%varid, var%dimids)
        if (stat /= NF_NOERR) goto 999
    else
        ndims = 1
        allocate(var%dimids(1), var%allcount(1))
        var%dimids(1) = var%dimid
    endif
    do, i = 1, ndims
        stat = nf_inq_dimlen(var%fileid, var%dimids(i), var%allcount(i))
        if (stat /= NF_NOERR) goto 999
    enddo
    allocate(var%start(ndims), var%count(ndims), var%stride(ndims))
    var%start(:) = 1
    var%count(:) = var%allcount(:)
    var%stride(:) = 1
    !
    ! G[
    !
999 continue
    call StoreError(stat, 'ANVarOpen', err)
end subroutine
