! gtool_file.f90 - gtool4 file interface
! Copyright (C) by TOYODA Eizi, 2000.  All rights reserved.
! vi: set sw=4 ts=8:

module gtool_file 

    use netcdf
    use dc_string
    implicit none

    type GT_FILE
	type(NC_FILE):: ncfile
    end type

    interface Create;  module procedure GtoolFileCreate;  end interface
    interface Close;  module procedure GtoolFileClose;  end interface

    interface Open
	module procedure GtoolFileReopen
	module procedure GtoolFileOpen
    end interface

    interface PutAttribute
	module procedure GtoolFilePutAttribute
    end interface

    interface VariablesNumber
	module procedure GtoolFileNVars
    end interface

    interface Name;  module procedure GtoolFileName;  end interface

    interface operator(.error.)
	module procedure GtoolFileError
    end interface

    interface assignment(=)
	! 폜\
	module procedure LetGtoolFileNetcdfFile
	! 폜\
	module procedure LetNetcdfFileGtoolFile
    end interface

contains

    !
    ! --- copy ---
    !

    ! 폜\
    subroutine LetGtoolFileNetcdfFile(ncfile, gtfile)
	type(NC_FILE), intent(out):: ncfile
	type(GT_FILE), intent(in):: gtfile
    continue
	ncfile = gtfile%ncfile
    end subroutine

    ! 폜\
    subroutine LetNetcdfFileGtoolFile(gtfile, ncfile)
	type(GT_FILE), intent(out):: gtfile
	type(NC_FILE), intent(in):: ncfile
    continue
	gtfile%ncfile = ncfile
    end subroutine

    !
    ! --- RXgN^ ---
    !

    subroutine GtoolFilePutAttribute(file, attrname, value)
	type(GT_FILE), intent(inout):: file
	character(len=*), intent(in):: attrname, value
	type(NC_ATTRIBUTE):: attr
    continue
	attr = Attribute(file%ncfile, attrname)
	call DefineMode(file%ncfile)
	attr = value
    end subroutine

    subroutine GtoolFileCreate(file, filename, overwrite, fail, &
	& title, source, institution)
	type(GT_FILE), intent(inout):: file
	type(VARYING_STRING), intent(in):: filename
	logical, intent(in), optional:: overwrite
	logical, intent(out), optional:: fail
	character(len=*), intent(in), optional:: title, source, institution
    continue
	call Create(file%ncfile, char(filename), overwrite=overwrite, fail=fail)
	call PutAttribute(file, 'Conventions', &
	    & 'http://www.gfd-dennou.org/arch/gtool4/conventions/')
	call PutAttribute(file, 'gt_version', '4.0beta10')
	if (present(title)) call PutAttribute(file, 'title', title)
	if (present(source)) call PutAttribute(file, 'source', source)
	if (present(institution)) &
	    & call PutAttribute(file, 'institution', institution)
    end subroutine

    subroutine GtoolFileOpen(file, filename, writable, fail)
	type(GT_FILE), intent(inout):: file
	type(VARYING_STRING), intent(in):: filename
	logical, intent(in), optional:: writable
	logical, intent(out), optional:: fail
    continue
	call Open(file%ncfile, char(filename), writable=writable, fail=fail)
    end subroutine

    subroutine GtoolFileReopen(file, oldfile)
	type(GT_FILE), intent(inout):: file
	type(GT_FILE), intent(in):: oldfile
    continue
	call Open(file%ncfile, oldfile%ncfile)
    end subroutine

    !
    ! --- fXgN^ ---
    !

    subroutine GtoolFileClose(file, fail)
	type(GT_FILE), intent(inout):: file
	logical, optional, intent(out):: fail
	type(NC_ATTRIBUTE):: attr
    continue
	if (.writable.(file%ncfile)) then
	    attr = Attribute(file%ncfile, 'title')
	    if (.not. .exists. attr) then
		call DefineMode(file%ncfile)
		attr = '(title not given: written by gtool4/Fortran90)'
	    endif
	endif
	call Close(file%ncfile, fail=fail)
    end subroutine

    !
    ! --- GT_FILE IuWFNg̏̎擾 ---
    !

    logical function GtoolFileError(file) result(result)
	type(GT_FILE), intent(in):: file
    continue
	result = .error. file%ncfile
    end function

    type(VARYING_STRING) function GtoolFileName(file) result(result)
	type(GT_FILE), intent(in):: file
    continue
	result = Name(file%ncfile)
    end function

    integer function GtoolFileNVars(file) result(result)
	type(GT_FILE), intent(in):: file
    continue
	result = VariablesNumber(file%ncfile)
    end function

end module
