!-------------------------------------------------
!interface module of ctrlib
!-------------------------------------------------
module ctr_interface
  interface

    subroutine ct2pc(r,theta,x,y)                 !2ɍWƒpW̕ϊD
      real,      intent(in) :: r                  !ɍW
      real,      intent(in) :: theta
      real,      intent(out) :: x                 !pW
      real,      intent(out) :: y
    end subroutine
      
    subroutine ct2cp(x,y,r,theta)                 !2ɍWƒpW̕ϊD
      real,      intent(in) :: x                  !pW
      real,      intent(in) :: y
      real,      intent(out) :: r                 !ɍW
      real,      intent(out) :: theta
    end subroutine
      
    subroutine ct2ec(u,v,x,y)                     !ȉ~WƒpW̕ϊD
      real,      intent(in) :: u                  !ȉ~W
      real,      intent(in) :: v
      real,      intent(out) :: x                 !pW
      real,      intent(out) :: y
    end subroutine
      
    subroutine ct2bc(u,v,x,y)                     !oɍWƒpW̕ϊD
      real,      intent(in) :: u                  !oɍW
      real,      intent(in) :: v
      real,      intent(out) :: x                 !pW
      real,      intent(out) :: y
    end subroutine
      
    subroutine ct2hc(u,v,x,y)                     !poȐWƒpW̕ϊD
      real,      intent(in) :: u                  !poȐW
      real,      intent(in) :: v
      real,      intent(out) :: x                 !pW
      real,      intent(out) :: y
    end subroutine
      
    subroutine ct2ch(x,y,u,v)                     !poȐWƒpW̕ϊD
      real,      intent(in) :: x                  !pW
      real,      intent(in) :: y
      real,      intent(out) :: u                 !poȐW
      real,      intent(out) :: v
    end subroutine
      
    subroutine ct3sc(r,theta,phi,x,y,z)           !3ʍWƒpW̕ϊD
      real,      intent(in) :: r                  !ɍW
      real,      intent(in) :: theta
      real,      intent(in) :: phi
      real,      intent(out) :: x                 !pW
      real,      intent(out) :: y
      real,      intent(out) :: z
    end subroutine
      
    subroutine ct3cs(x,y,z,r,theta,phi)           !3ʍWƒpW̕ϊD
      real,      intent(in) :: x                  !pW
      real,      intent(in) :: y
      real,      intent(in) :: z
      real,      intent(out) :: r                 !ɍW
      real,      intent(out) :: theta
      real,      intent(out) :: phi
    end subroutine
      
    subroutine cr2c(theta,x0,y0,x1,y1)            !2pW]D
      real,      intent(in) :: theta              !]p
      real,      intent(in) :: x0                 !]O̍Wl
      real,      intent(in) :: y0
      real,      intent(out) :: x1                !]̍Wl
      real,      intent(out) :: y1
    end subroutine
      
    subroutine cr3c(theta,phi,psi,x0,y0,z0,x1,y1,z1) !3pW]D
      real,      intent(in) :: theta              !euler ̉]p (, , )
      real,      intent(in) :: phi
      real,      intent(in) :: psi
      real,      intent(in) :: x0                 !]O̍Wl
      real,      intent(in) :: y0
      real,      intent(in) :: z0
      real,      intent(out) :: x1                !]̍Wl
      real,      intent(out) :: y1
      real,      intent(out) :: z1
    end subroutine
      
    subroutine cr3s(theta,phi,psi,theta0,phi0,theta1,phi1) !ʍW]D
      real,      intent(in) :: theta              !euler ̉]p (, , )
      real,      intent(in) :: phi
      real,      intent(in) :: psi
      real,      intent(in) :: theta0             !]O̍Wl
      real,      intent(in) :: phi0
      real,      intent(out) :: theta1            !]̍Wl
      real,      intent(out) :: phi1
    end subroutine

  end interface
end module
!ctrlib library end ----
