! gtool_device.f90 - gtool4 graphic objects - device
! Copyright (C) by TOYODA Eizi, 2000.  All rights reserved.
! vi: set sw=4 ts=8:

!
! {W[̓foCX̃I[vƃN[YsB
! dcl ͂ӂ̃foCX𓯎ɈȂ̂ŁArsB
! 

module gtool_device 

    use dcl
    use gtool_error
    implicit none
    private
    public:: GT_DEVICE, Open, Close

    type GT_DEVICE
	integer:: ws_id
    end type

    interface Open
	module procedure GtoolDeviceOpen
    end interface

    interface Close
	module procedure GtoolDeviceClose
    end interface

    integer, save:: opened_wsn = 0

contains

    subroutine GtoolDeviceOpen(dev, ws_id, fail)
	type(GT_DEVICE), intent(out):: dev
	integer, optional, intent(in):: ws_id
	logical, optional, intent(out):: fail
	integer:: wsn
    continue
	wsn = 3
	if (present(ws_id)) wsn = ws_id
	if (opened_wsn /= 0) then
	    call GtoolSaveError(GT_EOPENDEV, 'Open(GT_DEVICE)', wsn)
	    if (.not. present(fail)) call GtoolAbort
	    fail = .TRUE.
	endif
	call DclOpenGraphics(wsn)
	dev%ws_id = wsn
	opened_wsn = wsn
    end subroutine

    subroutine GtoolDeviceClose(dev)
	type(GT_DEVICE), intent(inout):: dev
    continue
	if (opened_wsn == 0) return
	call DclCloseGraphics()
    	dev%ws_id = 0
	opened_wsn = 0
    end subroutine

end module
