! gtool.f90 - gtool4 module
! Copyright (C) by TOYODA Eizi, 2000.  All rights reserved.
! vi: set sw=4 ts=8:

module gtool 

    use dc_string
    use netcdf_v3
    use netcdf_error
    use netcdf_io
    use netcdf_slice
    use netcdf_file
    use netcdf_dimension
    use netcdf_variable
    use netcdf_attribute
    use gtool_error
    use gtool_file
    use gtool_frame
    use gtool_figure
    use gtool_variable
    use gtool_attribute
    implicit none

contains

    type(VARYING_STRING) function GtoolGetEnv(name)
	character(len = *), intent(in):: name
	character(len = 128):: buffer
    continue
	call DclGetEnv(name, buffer)
	GtoolGetEnv = trim(buffer)
    end function

    type(VARYING_STRING) function GtoolArgument(n, default) result(result)
	integer, intent(in):: n
	character(len = *), intent(in), optional:: default
	character(len = 128):: buffer
    continue
	call DclGetArgument(n, buffer)
	result = trim(buffer)
	if (present(default) .and. buffer == '') result = default
    end function

    type(VARYING_STRING) function GtoolUsername() result(result)
	character(len = 128):: buffer
    continue
	call DclGetEnv('USER', buffer)
	if (buffer == '') call DclGetEnv('LOGNAME', buffer)
	result = trim(buffer)
    end function

    type(VARYING_STRING) function GtoolCurrentTime() result(result)
	character(len = 8):: date
	character(len = 10):: time
	character(len = 5):: zone
    continue
	call date_and_time(date, time, zone)
	result = date(1:4) // '-' // date(5:6) // '-' // date(7:8) &
	    & // 'T' // time(1:2) // ':' // time(3:4) // ':' // time(5:6) &
	    & // zone(1:3) // ':' // zone(4:5)
    end function

end module
