#! /usr/local/bin/ruby

require "gtrb6.rb"

# ʪ̤
$temperature = Var.new(-1000.0, 1000.0)
$longitude   = Var.new(0.0,  360.0)
$latitude    = Var.new(-90.0, 90.0)
$height      = Var.new(0.0,  1.0e4)

# ʻҤ
$grid1 = Grid.new(20,7,5)

# ǥǡ
$tmp1 = Datum.new($temperature,     $grid1, G1|G2|G3)
$lon1 = RegularEdgeDatum.new($longitude,  $grid1, G1)
$lat1 = RegularEdgeDatum.new($latitude,   $grid1, G2)
$hgt1 = RegularEdgeDatum.new($height,     $grid1, G3)

# 4̥顼̥ǡ
$Tmp  = ScalarSphericalData.new($tmp1,$lon1,$lat1,$hgt1)

# ǥե̤
$Tmp.xdraw = $Tmp.lon
$Tmp.ydraw = $Tmp.lat

# ǡͤ
def $hgt1.val(i=0,j=0,k=0)
   1.0e3*k
end
def $lat1.val(i=0,j=0,k=0)
  [-90.0, -60.0, -30.0, 0.0, 30.0, 60.0, 90.0][j]
end
def $tmp1.val(i=0,j=0,k=0)
   Math.sin($lon1.val(i,j,k)*Pi/180.0)*Math.cos($lat1.val(i,j,k)*Pi/180.0) \
  *Math.exp(-$hgt1.val(i,j,k)/1.0e3)
end

####################################################
#   end data definition
####################################################

# 󥿡
$Tmp.cont
$Tmp.cont($Tmp.lon,$Tmp.z, {"$Tmp.lat"=>2})




