#! /usr/local/bin/ruby
require "gtrb4.rb"

$longitude   = Var.new(0.0,  360.0)
$latitude    = Var.new(-90.0, 90.0)
$temperature = Var.new(0.0, 1000.0)

$agrid   = Grid.new(20,7)

$tmp  = Datum.new($temperature,$agrid,GRID12)
$lon  = RegularDatum.new($longitude,   $agrid,GRID1)
$lat  = RegularDatum.new($latitude,    $agrid,GRID2)

$Tmp  = DataSet.new($tmp,$lon,$lat)
$Tmp.setmain($tmp,$lon,$lat)

#def $lon.val(i,j)
#   360.0*i/$lon.mat.ng[0]
#end
def $lat.val(i,j)
  [-90.0, -60.0, -30.0, 0.0, 30.0, 60.0, 90.0][j]
end
def $tmp.val(i,j)
   Math.sin($lon.val(i,j)*Pi/180.0)*Math.cos($lat.val(i,j)*Pi/180.0)
end

######
cont($Tmp)




