#! /usr/local/bin/ruby

##############################################################
# gtrb6.rb                  99/06/28  numa@ees.hokudai.ac.jp
##############################################################
require "dcl"    # dcl library interface

GALL=-1; G0=0; G1=1; G2=2; G3=4; 
Pi=3.14159265359

# ʪ̤
class Var
   def initialize(mn=0.0, mx=1.0); set_range(mn,mx)  end
   def set_range(mn,mx);  @min=mn;  @max=mx;         end
   def min;  @min    end	
   def max;  @max    end
   def name; @name   end
end

# ʻҿ
class Grid
   def initialize(*n); set_ng(*n)               end
   def set_ng(*n)
       @ng=[]; @ng=n.dup
       @ngall=1; for i in @ng; @ngall*=i;  end            
   end
   def ng; @ng                                  end
   def ngall; @ngall                            end
end

# ǥǡ
class Datum
   def initialize(va,ma,d=GALL,ed=NIL) 
       @var=va; @mat=ma; @dim=d; 
       if(ed) then  @eidx=edgeIndex(@dim)
       else         @eidx=NIL           
       end
   end
   def edgeIndex(dim)
     case dim
       when G1
         0
       when G2
         1
       when G3
         2
       else
         NIL
     end
   end
   def var; @var                                  end
   def mat; @mat                                  end
   def dim; @dim                                  end
   def eidx; @eidx                                end
   def vmn(*i);   val(*i)-del(*i)/2.0             end
   def vmx(*i);   val(*i)+del(*i)/2.0             end
   def del(*i);  (@var.max-@var.min)/@mat.ngall   end
end

# ʻդȤʤǥǡ
class EdgeDatum < Datum
   def initialize(va,ma,d=G1) 
       super(va,ma,d,1)
       if (!@eidx) then raise "EdgeDatum: not edge Index" end
   end
   def del(*i)
     im=i.dup; ip=i.dup; 
     im[@eidx]=max(im[@eidx]-1,0)
     ip[@eidx]=min(ip[@eidx]+1,@mat.ng[@eidx])
     abs(val(ip)-val(im))/2.0
   end
end

# ʻդȤʤǥǡ: §ʻ
class RegularEdgeDatum < EdgeDatum
   def val(*i)
     @var.min + ((@var.max-@var.min)*i[@eidx])/@mat.ng[@eidx]         
   end
   def del(*i)
     (@var.max-@var.min)/@mat.ng[@eidx]         
   end
end

# ǡ = ǥǡνޤ 
class ClassData
   def initialize(*dat)
      @datas = []; @datas=dat.dup
   end	
end

# 顼̥ǡ 
class ScalarData < ClassData
  def initialize(*dat)
      super(*dat)
      @xdraw=NIL; @ydraw=NIL; @sdraw={}
  end

  def cont(x=xdraw, y=ydraw, sel=sdraw, d=dat)
    xmin = x.var.min; xmax=x.var.max
    ymin = y.var.min; ymax=y.var.max
    xx=[]; yy=[]; dd=[]

    if (!(ix=x.eidx)) then raise "x is not edge" end
    if (!(iy=y.eidx)) then raise "y is not edge" end
    ixy=max(ix,iy); idx0=[0]*(ixy+1)
    sel.each_key {|k| 
	kk = eval k
        if (!(ik=kk.eidx)) then raise k + " is not edge" end
        idx0[ik]=sel[k]
    }

    nx=x.mat.ng[ix]; ny=y.mat.ng[iy]; 
    idx=idx0.dup; for i in 0..nx-1; idx[ix]=i; xx[i]=x.val(*idx); end;
    idx=idx0.dup; for j in 0..ny-1; idx[iy]=j; yy[j]=y.val(*idx); end;
    idx=idx0.dup
    for j in 0..ny-1
      for i in 0..nx-1
        idx[ix]=i; idx[iy]=j; 
        dd[i+j*nx]=d.val(*idx)
      end
    end

    Dcl.gropn(1)
    Dcl.grfrm()
    Dcl.grswnd(xmin, xmax, ymin, ymax)
    Dcl.grsvpt(0.2, 0.8, 0.2, 0.8)
    Dcl.grstrn(1)
    Dcl.grstrf()
    Dcl.usdaxs()
    Dcl.uwsgxa(xx,nx)
    Dcl.uwsgya(yy,ny)
    Dcl.udcntr(dd,nx,nx,ny)
    Dcl.grcls()
  end
  def dat;    @dat   end
  def xdraw;  @xdraw end
  def ydraw;  @ydraw end
  def sdraw;  @sdraw end
  def dat=(d);   @dat=d   end
  def xdraw=(x); @xdraw=x end
  def ydraw=(y); @ydraw=y end
  def sdraw=(s); @sdraw=s end
end

# 4顼 A(x,y,z,t)
class Scalar4DData < ScalarData
   def initialize(*dat)
       super(*dat)
       @xdraw=@datas[1]; @ydraw=@datas[2]
   end
   def dat; @datas[0]  end
   def x;   @datas[1]  end
   def y;   @datas[2]  end
   def z;   @datas[3]  end
   def t;   @datas[4]  end
end

# 4̥顼 A(,,z,t)
class ScalarSphericalData < Scalar4DData
   def lon;  @datas[1]  end
   def lat;  @datas[2]  end
end

# utility ؿ
def max(i,j); if(i>j) then i; else j;  end; end
def min(i,j); if(i>j) then j; else i;  end; end
def abs(i);   if(i>0) then i; else -i; end; end

####################################################
#   end  of class definition
####################################################
