#! /usr/local/bin/ruby

##############################################################

GRID1=1; GRID2=2; GRID12=3;
Pi=3.141592

class Var
   def initialize(mn=0.0, mx=1.0); @min=mn; @max=mx; end
   def set_range(mn,mx);  @min=mn;  @max=mx;         end
   def min;  @min    end	
   def max;  @max    end
   def name; @name   end
end

class Grid
   def initialize(*n)
       @ng=[]; n.each_index {|i| @ng[i]=n[i]}   
       @ngall=1; for i in @ng; @ngall*=i;  end            
   end
   def ng; @ng                                  end
   def ngall; @ngall                            end
end

class Datum
   def initialize(va,ma,d=0) 
       @var=va; @mat=ma; @dim=d
   end
   def var; @var                                  end
   def mat; @mat                                  end
   def vmn(*i);   val(*i)-del(*i)/2.0             end
   def vmx(*i);   val(*i)+del(*i)/2.0             end
   def del(*i);  (@var.max-@var.min)/@mat.ngall   end
end

class RegularDatum < Datum
   def val(*i)
     case @dim
       when GRID1
          @var.min + ((@var.max-@var.min)*i[0])/@mat.ng[0]         
       when GRID2
          @var.min + ((@var.max-@var.min)*i[1])/@mat.ng[1]         
       when GRID12
          @var.min + ((@var.max-@var.min)*(i[0]+i[1]*@mat.ng[0])) \
                     /(@mat.ng[0]*@mat.ng[1])
       else
          0.0
     end
   end
end

class DataSet
   def initialize(*dat)
       @datas = Array.new(3)
       dat.each_index {|i| @datas[i]=dat[i]}   
       @main  = @datas[0]
       @xaxis = @datas[1];  @yaxis = @datas[2]
   end	
   def setmain(*dat)
       @main  = dat[0]
       @xaxis = dat[1];  @yaxis = dat[2]
   end
   def main;  @main  end   
   def xaxis; @xaxis end   
   def yaxis; @yaxis end   
end

####################################################
require "dcl"

def cont(ds) 
  d=ds.main; x=ds.xaxis; y=ds.yaxis
  xmin = x.var.min; xmax=x.var.max
  ymin = y.var.min; ymax=y.var.max
  Dcl.gropn(1)
  Dcl.grfrm()
  Dcl.grswnd(xmin, xmax, ymin, ymax)
  Dcl.grsvpt(0.2, 0.8, 0.2, 0.8)
  Dcl.grstrn(1)
  Dcl.grstrf()
  Dcl.usdaxs()
  xx=[]; nx=x.mat.ng[0]; for i in 0..nx-1; xx[i]=x.val(i,0); end
  yy=[]; ny=y.mat.ng[1]; for j in 0..ny-1; yy[j]=y.val(0,j); end
  Dcl.uwsgxa(xx,nx)
  Dcl.uwsgya(yy,ny)
  dd=[]; for j in 0..ny-1; for i in 0..nx-1; dd[i+j*nx]=d.val(i,j); end; end
  Dcl.udcntr(dd,nx,nx,ny)
  Dcl.grcls()
end

