/************************************************
  dcl.c
************************************************/

#include "ruby.h"
#include "math.h"

static VALUE
grfrm(self)
    VALUE self;     
{
  grfrm_();
  return INT2FIX(1);
}

static VALUE
grstrf(self)
    VALUE self;     
{
  grstrf_();
  return INT2FIX(1);
}

static VALUE
grcls(self)
    VALUE self;     
{
  grcls_();
  return INT2FIX(1);
}

static VALUE
usdaxs(self)
    VALUE self;     
{
  usdaxs_();
  return INT2FIX(1);
}

static VALUE
gropn(self,viws)
    VALUE self;     
    VALUE viws;     
{
  int iws;
  iws = FIX2INT(viws);
  gropn_(&iws);
  return INT2FIX(1);
}

static VALUE
grstrn(self,vitrn)
    VALUE self;     
    VALUE vitrn;     
{
  int itrn;
  itrn = FIX2INT(vitrn);
  grstrn_(&itrn);
  return INT2FIX(1);
}


static VALUE
grswnd(self,vxmin,vxmax,vymin,vymax)
    VALUE self;     
    VALUE vxmin;  VALUE vxmax;     
    VALUE vymin;  VALUE vymax;     
{
  float xmin, xmax, ymin, ymax;
  xmin = RFLOAT(vxmin)->value;
  xmax = RFLOAT(vxmax)->value;
  ymin = RFLOAT(vymin)->value;
  ymax = RFLOAT(vymax)->value;
  grswnd_(&xmin,&xmax,&ymin,&ymax);
  return INT2FIX(1);
}

static VALUE
grsvpt(self,vxmin,vxmax,vymin,vymax)
    VALUE self;     
    VALUE vxmin;  VALUE vxmax;     
    VALUE vymin;  VALUE vymax;     
{
  float xmin, xmax, ymin, ymax;
  xmin = RFLOAT(vxmin)->value;
  xmax = RFLOAT(vxmax)->value;
  ymin = RFLOAT(vymin)->value;
  ymax = RFLOAT(vymax)->value;
  grsvpt_(&xmin,&xmax,&ymin,&ymax);
  return INT2FIX(1);
}

static VALUE
udcntr(self,va,vmx,vnx,vny)
    VALUE self;     
    VALUE va;
    VALUE vmx;    VALUE vnx;    VALUE vny;
{
  float *a;
  int mx, nx, ny, i;

  mx = FIX2INT(vmx);
  nx = FIX2INT(vnx);
  ny = FIX2INT(vny);
  a = malloc(mx*ny*sizeof(float));
  for (i=0; i<mx*ny; i++) 
    a[i] = (float) RFLOAT(RARRAY(va)->ptr[i])->value;
  udcntr_(a,&mx,&nx,&ny);
  free(a);
  return INT2FIX(1);
}

static VALUE
uwsgxa(self,va,vnx)
    VALUE self;     
    VALUE va;
    VALUE vnx; 
{
  float *a;
  int nx, i;

  nx = FIX2INT(vnx);
  a = malloc(nx*sizeof(float));
  for (i=0; i<nx; i++)
    a[i] = (float) RFLOAT(RARRAY(va)->ptr[i])->value;
  uwsgxa_(a,&nx);
  free(a);
  return INT2FIX(1);
}

static VALUE
uwsgya(self,va,vny)
    VALUE self;     
    VALUE va;
    VALUE vny; 
{
  float *a;
  int ny, i;

  ny = FIX2INT(vny);
  a = malloc(ny*sizeof(float));
  for (i=0; i<ny; i++)
    a[i] = (float) RFLOAT(RARRAY(va)->ptr[i])->value;
  uwsgya_(a,&ny);
  free(a);
  return INT2FIX(1);
}

Init_dcl()
{
    VALUE mDcl = rb_define_module("Dcl");
    rb_define_module_function(mDcl, "grfrm",  grfrm,  0);
    rb_define_module_function(mDcl, "grstrf", grstrf, 0);
    rb_define_module_function(mDcl, "grcls",  grcls,  0);
    rb_define_module_function(mDcl, "usdaxs", usdaxs, 0);
    rb_define_module_function(mDcl, "gropn",  gropn,  1);
    rb_define_module_function(mDcl, "grstrn", grstrn, 1);
    rb_define_module_function(mDcl, "grswnd", grswnd, 4);
    rb_define_module_function(mDcl, "grsvpt", grsvpt, 4);
    rb_define_module_function(mDcl, "udcntr", udcntr, 4);
    rb_define_module_function(mDcl, "uwsgxa", uwsgxa, 2);
    rb_define_module_function(mDcl, "uwsgya", uwsgya, 2);
}

/* I don't know why this is neccessary */
MAIN__()
{
}
