#!/usr/bin/perl
#
# mksigen-write.pl - SIGEN ե perl ץ
#                    kitamo κä writesigen.pl β¤
#                    Ǥ writesigen2.pl θ
#
#    SIGEN եȤ mksigen Ȥ perl ǽ񤫤줿ǥ쥯ȥ
#      ǡ١ޥ͡ΤեǤ.
#      ܤ http://www.gfd-dennou.org/arch/cc-env/mksigen/desc.htm
#      򻲾ȤΤ.
#
    @MAINTAINERS = ('Kitamori Taichi   <kitamo@ep.sci.hokudia.ac.jp>',
		    'Morikawa Yasuhiro <morikawa@ep.sci.hokudai.ac.jp>',
		   );
    $UPDATE      = '2004/10/10';
    $VERSION     = '1.0';
    $URL         =
    'http://www.ep.sci.hokudai.ac.jp/~morikawa/perl/mksigen-write/SIGEN_PUB.htm';

#
#  TODO
#
#  History
#
#    - 1.0  2004/10/10 ()
#           + writesigen2.pl ̾
#

##################################################
#####                                        #####
##           ƥ桼                    ###
#####                                        #####
##################################################

# 0: gate-toroku-system ޤ passwd ޤ
#    ͡
#
# 1: ʲ $WRITER 

$FORCENAME = 0;

$WRITER = " "; # Maintainer   (˽̾)

######### ʲϽ񤭴ʤǲ. #############

##################################################
#####                                        #####
##      SIGEN եν񼰤˰¸     ###
#####                                        #####
##################################################
# ʸʸʬ˿뤫
$TABLEN = 8;
# ǥեȤΥǥȤϥʸʬ
$TABINDENT = 2;


##################################################
#####                                        #####
##                                     ###
#####                                        #####
##################################################
# ץΤ, getopts Ȥ߹.
require 'getopts.pl'
    || die "getopts.pl is not found.\n";

# h, H, v, V, f, FΤ߰Ȥ.
&Getopts('i:hHvVfm');

##################################################
#####                                        #####
##                                     ###
#####                                        #####
##################################################
# ޤϼ
@filenames = @ARGV;

# ץȤ v  V Ϳ줿ˤ
# Сɽx
if ($opt_v || $opt_V) {
    &Caution if $FORCENAME;
    &PrintVersion;
    exit 1;
}

# ̵䥪ץȤ h  H Ϳ줿
# ˤϥإפɽ
if ($#ARGV < 0 || $opt_h || $opt_H){
    &Caution if $FORCENAME;
    &Help;
    exit 1;
}

# $FORCENAME ξϲ̵Ȥɽ
&Caution if $FORCENAME;

# ץȤ f  F Ϳ줿ˤ϶Ū
# åץǡȤե饰򿿤
$UpdateForce = 0;
if ($opt_f) {
    $UpdateForce = 1;
}

# ץȤ m  M Ϳ줿ˤ
# ʣϤǽ
$MultiLine = 0;
if ($opt_m) {
    $MultiLine = 1;
}

# ץ i ξ, ȤͿ줿Τ
# Ȥ.
undef $EXAMPLE;
if ($opt_i) {
    $EXAMPLE = $opt_i;
}

##################################################
#####                                        #####
##           Help ʤɤΥ֥롼           ###
#####   (ʳΥ֥롼)     #####
##################################################
sub Help() {
    print STDOUT <<EOF;
  mksigen-write.pl:
    USAGE:
      mksigen-write.pl [-vVhHfm] [-i exam[.SIGEN]] file[.SIGEN] [file ...]

    OPTION:
      -v, -V        : Show Version Number
      -h, -H        : Show Help
      -f            : Force Update
      -i exam.SIGEN : Use existing SIGEN file for example
      -m            : Enable MultiLine Input
                      (Please Enter 2 times).

EOF
    &PrintVersion;
}
sub PrintVersion() {
    print STDOUT <<EOF;
  mksigen-write.pl Version $VERSION, Last Update: $UPDATE.

EOF
    foreach $MAINTAINER (@MAINTAINERS) {
	print STDOUT "  $MAINTAINER \n";
    }
    print STDOUT "    All Right Reserved.\n\n";
}
sub Caution(){
    print STDOUT <<EOF
  ************   CAUTION !!! *****************
    PLEASE CHANGE \"\$WRITER\" TO YOUR NAME !!!
    IF YOU WANT GET USER-NAME AUTOMATICALLY,
    CHANGE \"\$FORCENAME\" to \"0\" !!!
  ********************************************

EOF
}

##################################################
#####                                        #####
##               桼̾                  ###
#####                                        #####
##################################################
$newname = &GetUserName;

if (!$FORCENAME && $newname) {
    $WRITER = $newname
}

##################################################
#####                                        #####
##           SIGEN ե            ###
#####                                        #####
##################################################
if ($EXAMPLE) {
    # $EXAMPLE  SIGEN ե뤫?
    # ⤷ SIGEN դƤʤ .SIGEN դõ
    if ($EXAMPLE !~ /^.*SIGEN$/) {
	# ǥ쥯ȥξθΥåӽ
	$EXAMPLE =~ s|/+$||;
	#  ".SIGEN" ɲ
	$EXAMPLE = "$EXAMPLE".".SIGEN";
    }

    # $EXAMPLE ϥեȤ¸ߤ뤫?
    unless (-f $EXAMPLE) {
	die "$EXAMPLE is not found.\n" ;
    }

    print STDOUT "Input $EXAMPLE for example file ...  ";

    %exam = &ReadHeaders($EXAMPLE);

    # إåäƤ뤫å
    $exam_subject = $exam{'subject:'};
    $exam_desc    = $exam{'description:'};
    $exam_note    = $exam{'note:'};

    unless ($exam_subject) {
	die "$EXAMPLE is not correct SIGEN file.\n";
    }

    print STDOUT "done.\n";
}


##################################################
#####                                        #####
##             ᥤ롼                  ###
#####                                        #####
##################################################
#
# 11ĤΥե˴ؤƽ
#
foreach $file (@filenames){
    #
    # ¸ߤʤϥå
    #
    unless (-e $file) {
	print STDOUT "$file is not found. Skipping ...\n" ;
	next;
    }

    #
    # ǥ쥯ȥɽΥå/פ
    #
    $file =~ s|/+$||;

    #
    # SIGEN ե̾
    #
    #  .SIGEN եǽϤ.
    if ($file =~ /^.*SIGEN$/) {
	$sigenfile = "${file}";
    } else {
	$sigenfile = "${file}.SIGEN";
    }

    #
    # ʣΥեƤޤʤư.
    #
    $nextflag = 0;
    foreach $used_sigen (@used_sigens) {
	if ($sigenfile eq $used_sigen) {
	    $nextflag = 1;
	}
    }
    if ($nextflag) {
	print STDOUT "$sigenfile is already treated. Skipping ...\n" ;
	next;
    }
    push(@used_sigens, $sigenfile);

    #
    # SIGEN ե뤬¸ߤ Update 򹹿
    #
    if (-f $sigenfile){
	unless ($UpdateForce) {
	    print STDOUT "Update ${sigenfile} ? [Y/n]: " ;
	    $ans = <STDIN>;
	    if ($ans =~ /^[nN].*$/) {
		print STDOUT "Skipping $sigenfile ... \n";
		next;
	    }
	}
	print STDOUT "  History: ";
	$hist = <STDIN>;
	chomp($hist);
	print STDOUT "Updating $sigenfile ...";
	&UpdateSigen($sigenfile, $hist);
	print STDOUT " done.\n";
	
	next;
    }

    #
    # SIGEN ե뤬¸ߤʤ, 䤤碌ƿ
    #
    
    #  վ
    $today = &GetToday;
    
    #####
    #  ե
    print STDOUT "Please Input Data for $sigenfile ...\n";
    # Subject
    $subject = &InputFromSTDIN('Subject:', $MultiLine, $exam_subject);
    if (!$subject) {
	die "Please Input Something to \"Subject:\".\n";
    }
    $desc = &InputFromSTDIN('Description:', $MultiLine, $exam_desc);
    $note = &InputFromSTDIN('Note:', $MultiLine, $exam_note);
    $hist = &InputFromSTDIN('History:', 0, '');

    #  SIGEN ե 
    print STDOUT "Generating $sigenfile ...";
    open(SIGEN, ">$sigenfile");
    print SIGEN <<EOF;
Subject:	$subject
Maintainer:	$WRITER
Description:	$desc
Note:		$note
Update:		$today  $hist


	$today  $WRITER  $hist
EOF
    print STDOUT " done.\n";
}

exit 0;

##################################################
#####                                        #####
##             ֥롼                  ###
#####                                        #####
##################################################

#
# ɸϼѥ֥롼
#   (kitamo ΥǥäȲ¤).
#
#   
#           &InputFromSTDIN($header, $multi, $default)
#           &InputFromSTDIN($header, $multi)
#           &InputFromSTDIN($header)
#   
#           $header       "Subject:", "Description:" ʤ
#           $multi        ʤʣϲǽ
#           $default      ̤Ϥκݤǥե
#
sub InputFromSTDIN() {
    local($header, $multi, $default) = @_;
    local($TABLEN)    = $TABLEN;
    local($TABINDENT) = $TABINDENT;

    # إåĹ饿֤ʸʬ뤫롣
    local($tabnum) = $TABINDENT - &trunc(length($header) / $TABLEN);
    die "Header \"$header\" is too long.\n" if ($tabnum < 0);

    # ʸӥǥ
    local($tab) = "\t" x $tabnum;
    local($indent) = "\t" x $TABINDENT;

    if ($default) {
	print STDOUT "  ${header} [", "$default", "] ";
    } else {
	print STDOUT "  ${header}${tab}";
    }

    # ɸϤμ
    local($first) = 1;
    local($val)     = '';
    local($val_tmp) = '';
    while ($first || $val_tmp ne '' && $multi) {
	# ɸϼԤ̤
	if (!$first) {
	    print STDOUT "$indent";
	}
	# ɸϤμ
	$val_tmp = <STDIN>;
	chomp($val_tmp);
	# ʣԤݤη
	if ($first) {
	    $val = $val_tmp;
	} else {
	    # ԤξϷ礷ʤ
	    if ($val_tmp ne '') {
		$val .= "\n" . "$indent" . "$val_tmp";
	    }
	}
	$first = 0;
    }

    chomp($val);
    # ͤǥǥեͤϤ֤.
    if ($val eq '' && $default) {
	$val = $default;
    }
    chomp($val);
    return $val;
}


#
# ¸ߤ $sigenfile 򥢥åץǡȤ륵֥롼
#
sub UpdateSigen(){
    local($sigenfile, $hist) = @_;
    # PATH 񤫤Ƥ, ե̾ΤߤФ.
    @dir_names = split(/\//, $sigenfile);
    $sigenfilename = pop(@dir_names);
    local($sigentmp)  = "/tmp/${sigenfilename}.$$";

    local($today)  = &GetToday;
    open(ORG, "$sigenfile");
    open(UPDATE, "> $sigentmp");

    while (<ORG>){
	chomp($_);
	if ($_ =~ /^Update.*$/){
	    $_ = "Update:\t\t$today  $hist";
	}
	print UPDATE "$_\n";
    }
    # ɲ
    print UPDATE "\t$today  $WRITER  $hist\n";

    close(ORG);
    close(UPDATE);
    system "mv -f $sigentmp $sigenfile";
    system "chmod 664 $sigenfile";
}

#
# , 2004/09/28 Τ褦ʷ륵֥롼
#   kitamo  writesigen.pl 
#
sub GetToday() {
    local(@date, $year, $month, $day, $today);
    @date = localtime();
    $year = 1900 + @date[5];
    $month = 1 + @date[4];
    $day = @date[3];
    
    if ($month < 10) {
	$month = "0${month}";
    }
    if ($day < 10) {
	$day = "0${day}";
    }
    $today = "$year/$month/$day";
    return $today;
}

#
# 桼̾ѥ֥롼 (dcreal-sigen ܿΤ¤)
#   http://www.gfd-dennou.org/arch/cc-env/dcreal/SIGEN.htm
#
sub GetUserName(){
    local(@passwd)    = getpwuid($<);
    local($loginname) = $passwd[0];
    local(@userinfo)  = split(/,/, $passwd[6]);
    local($name)      = $userinfo[0];
    local($tmpfile) = "/tmp/nametmpfile.$$";
    local(@knames, $kname);
    
    # ޤ gate Υǡ١
    if (-x "/usr/local/bin/gate-user-show"){
	system ("gate-user-show $loginname > $tmpfile");
	open (GATE, "$tmpfile");
	while (<GATE>) {
	    chomp($_);
	    if ($_ =~ /^kname/){
		@knames = split(/: /, $_);
		$kname  = $knames[1];
	    }
	}
	close(GATE);
	system ("rm $tmpfile");
	return $kname;

    # gate ̵ /etc/passwd ξ
    } elsif ($name) {
	return $name;

    # ʤʤ桼̾
    } elsif ($loginname) {
	return $loginname;

    # Ǹϵ֤
    } else {
	return nil;
    }
}

#
# SIGEN եΥإåѥ֥롼 (mksigen.pl ܿƲ¤)
#   http://www.gfd-dennou.org/arch/cc-env/mksigen/desc.htm
#
sub ReadHeaders() {
    local($emlfile) = @_;
    local($name, $val, %headers);
    $name = ""; undef %headers;
    #
    open(READ, "$emlfile");
    while (<READ>) {
	# βԤ
	chomp;
	s/\r$//;
	# 񤭹ޤƤʤнλ
	last if /^$/;
	# ԤλϤ˥ڡʤΤǤȤƼ
	if (!/^\s/) {
	    # Subject: TestפΤ褦ʽ񼰤
	    if (!/^([-A-Za-z0-9]*:)\s*(.*)/) {
		warn "Error: broken header \"$_\" in $emlfile\n";
		next;
	    }
	    ($name = $1) =~ tr/A-Z/a-z/;
	    ($val = $2) =~ s/[\r]/ /g;
	    if (defined $headers{$name}) {
		$headers{$name} .= "\n$val";
	    } else {
		$headers{$name} = $val;
	    }
	} else {
	    s/[\r]/ /g;
	    s/^ */ /;
	    $headers{$name} .= "\n$_";
	}
    }
    return %headers;
}

# ڤ夲֥롼
#   http://www2u.biglobe.ne.jp/~MAS/perl/waza/menu.html
#   - http://www2u.biglobe.ne.jp/~MAS/perl/waza/ceil.html
#
#   Ȥ
#          &ceil($val, $col)
#          &ceil($val)
#   
#          $val       ڤ夲
#          $col       ʲΤɤޤǻĤ
#                     ... 1: , 0: ΰ, -1: ΰ ...
#                     Ϳʤ 0 (ΰ) Ȥʤ.
sub ceil {
    local($val, $col) = @_;
    local($r) = 10 ** $col;
    if ($val > 0) {
	local($tmp) = $val * $r;
	if ($tmp == int($tmp)) {
	    return $tmp / $r;
	} else {
	    return int($tmp + 1) / $r;
	}
    } else {
	return int($val * $r) / $r;
    }
}

# ڤΤƥ֥롼
#   http://www2u.biglobe.ne.jp/~MAS/perl/waza/menu.html
#   - http://www2u.biglobe.ne.jp/~MAS/perl/waza/trunc.html
#
#   Ȥ
#          &ceil($val, $col)
#          &ceil($val)
#   
#          $val       ڤΤƤ
#          $col       ʲΤɤޤǻĤ
#                     ... 1: , 0: ΰ, -1: ΰ ...
#                     Ϳʤ 0 (ΰ) Ȥʤ.
sub trunc {
    local($val, $col) = @_;
    local($r) = 10 ** $col;
    if ($val > 0) {
	return int($val * $r) / $r;
    } else {
	local($tmp) = $val * $r;
	if ($tmp == int($tmp)) {
	    return $tmp / $r;
	} else {
	    return int($tmp - 1) / $r;
	}
    }
}
