#**********************************************************************
#     sppackǲ򤯤Υץץ       1999/03/29
#**********************************************************************
# 05/10/04 test_sppack.rb FortranץRubyˤ R.Mizuta
#----------------------------------------------------------------------
require "narray"
require "ispack.rb"
#require "numru/dcl"
#include NumRu
include NMath

      mm=21
      lm=(mm+1)*(mm+1)
      nb=23476

#---- OPEN SUBROUTINE PACKAGE AND INITIALIZE VARIABLES -----------------

      lev=10                  #ⳬǴΥץ饷γ
      itm=10                  #ȯŸ륹ƥå׿
      ndv=10                  #Runge-KuttaǤΥƥåʬ
      dt=1.0                  #եϤλֳִ

      dnu=10.0/(1.0*mm*(mm+1))**lev  #ⳬǴη
#      dnu=0                     

#*/ 󷿤ξΥѥ᥿(ݥƥ󥷥Ϳ) /*

      da=1.0e-1     #ο
      db=10.0      #εտΥ롼Ȥѥ᥿
      x0=PI        #濴֤Φ˺ɸ
#      y0=pi/4     #濴֤Φպɸ
      y0=0.0



      jm=32; im=64
      id=im+1; jd=jm+1
      iw=im+2; jw=jd

      SQRT3=1.7320508075688772935

#*/ OMEGA=, BARPHI=δ /*

      OMEGA=2*PI; BARPHI=1.0

#*/ ȤʬΥƲ򤯤ɤΥե饰.
#*/      ISWTCH=1ʤʬΥƲ. ǤʤʬΥʤ.

      ISWTCH=1

      sn = SNPACK.new(mm,im,jm,1)
      sp = SPPACK.new(mm,im,jm)

      y = sp.y
      RN = sp.rn[0..lm-1]

      yg = NArray.float(jm)
      yg[jm/2..jm-1] = asin(y[0..jm/2-1])
      yg[jm/2-1..0] = -asin(y[0..jm/2-1])

      xg = (NArray.float(im).indgen!) *2*PI/im

      dtdnu = dnu*dt/(2*ndv)

      DRN = exp(-dtdnu*(RN.abs)**lev)

#*/ ʬۤʬΥƲ򤯺ݤɬפν      

      dom = sqrt(-RN*BARPHI)

      dtint = dt/(2*ndv)

      _cd = cos(dom*dtint)
      _sd = sin(dom*dtint)*(-RN)/dom
      _cp = cos(dom*dtint)
      _sp = -sin(dom*dtint)*BARPHI/dom
      _cd[0] = 1
      _sd[0] = 0
      _cp[0] = 1
      _sp[0] = 0
      CD = _cd; SD = _sd; CP = _cp; SP = _sp

#-----------------------------------------------------------------------
#     INITIALIZATION OF VAR
#-----------------------------------------------------------------------

      var = NArray.float(lm,3).fill!(0.0)

#*/ бپ(ץͥ꡼٤Τ)
      var[2,0] = 2*OMEGA/SQRT3

#*/ ݥƥ󥷥

      cb = cos(PI/2-y0)
      sb = sin(PI/2-y0)

      ca = cos(xg-x0).newdim!(1)
      cc = cos(PI/2-yg).newdim!(0)
      sc = sin(PI/2-yg).newdim!(0)

      cr = cb*cc+sb*sc*ca
      g = da*(exp(db*(cr-1))-(1-exp(-2*db))/(2*db))

      var[true,2] = sp.tg2s(g,0,0)
      var[0,2] = BARPHI

#-----------------------------------------------------------------------
#     CALCULATION OF d(VAR)/dt
#-----------------------------------------------------------------------
      def sbdvar(var,sp)

        dvar = var.dup.fill!(0.0)

        dvar[true,0],dvar[true,1],dvar[true,2] = sp.swnl(OMEGA, var[true,0],var[true,1],var[true,2])

        if(ISWTCH == 1)
          dvar[true,1] = dvar[true,1] + RN*var[true,2]
          dvar[true,2] = dvar[true,2] + BARPHI*var[true,1]
        end

        return dvar
      end

#-----------------------------------------------------------------------
#     CALCULATION OF THE EFFECT OF VISCOSITY
#-----------------------------------------------------------------------
      def sbdiss(var)

        rtn = var.dup

        if(ISWTCH == 1)
          rtn[true,0] = DRN*var[true,0]
          rtn[true,1] = DRN*(CD*var[true,1]+SD*var[true,2])
          rtn[true,2] = DRN*(CP*var[true,2]+SP*var[true,1])
        else
          rtn = DRN.newdim(1)*var
        end

        return rtn
      end

      alias subl sbdiss
      alias subn sbdvar

#---- 󥲥åʬ -----------------------------------------------

      def integral(dt,tim,z,sp) 
        dt = dt.to_f

        dz1 = subn(z,sp)
        dz2 = z + dz1*dt/2
        dz3 = z + dz1*dt/6

        z = subl(z)
        dz2 = subl(dz2)
        dz3 = subl(dz3)
        dz1 = subn(dz2,sp)

        dz2 = z + dz1*dt/2
        dz3 = dz3 + dz1*dt/3

        dz1 = subn(dz2,sp)

        dz2 = z + dz1*dt
        dz3 = dz3 + dz1*dt/3

        dz2 = subl(dz2)
        dz3 = subl(dz3)
        dz1 = subn(dz2,sp)

        tim = tim + dt
        z = dz3 + dz1*dt/6

        return tim,z

      end

#---- OPEN FHPACK ------------------------------------------------------

      file = File.open("output.dat","w")

#---- TIME EVOLUTION BY RUNGE-KUTTA METHOD -----------------------------

      i=0
      tim=0

      file << var[true,0].to_s + var[true,1].to_s + var[true,2].to_s
      amom,aeme,aens = sp.swck(OMEGA,var[true,0],var[true,1],var[true,2])
      p [amom,aeme,aens]

      dtim = dt/ndv
      for i in 1..itm
        ndv.times do
          tim,var = integral(dtim,tim,var,sp)
        end
        file << var[true,0].to_s + var[true,1].to_s + var[true,2].to_s
        amom,aeme,aens = sp.swck(OMEGA,var[true,0],var[true,1],var[true,2])
        p [amom,aeme,aens]
      end

#---- CLOSE FHPACK -----------------------------------------------------

      file.close

