require 'narray'
require "numru/advanceddcl"
include NumRu::AdvancedDCL
require "numru/netcdf"
require "numru/gphys/gdata_netcdf"
require "numru/gphys/gdata_mem"
require "numru/gphys/coordreg"

#require "numru/coordrect"
#require "numru/gdatamem"
#require "numru/gdatanetcdf"

=begin 
=GPhys
{Cu̓f[^`ɈˑȂvO~O\ƂA܂f[^ϐƍWϐ̉uʁvƂăf[^߂̃CułBŃf[^ϐƂ͒l߂鑽zƁAf[^ɊւtȊgłAWϐ͍Wl̐lzƍWɊւtȊgłB

NX\͎̒ʂłB\bhꗗ((<{Cu̍\>))QƂ̂ƁB
  * NX          
* NumRu
  * ((<GPhys|NumRu::GPhys>)) f[^ϐƍWϐ̉Ĉ߂̃NX
  * ((<GData|NumRu::GData>))() f[^NX
    * ((<GDataMem|NumRu::GDataMem>)) ̃f[^NX
    * ((<GDataFile|NumRu::GDataFile>))() t@Cf[^NX
      * ((<GDataNetCDF|NumRu::GDataNetCDF>)) NetCDFt@C̃f[^NX
  * ((<Coord|NumRu::Coord>))() WNX
    * ((<CoordReg|NumRu::CoordReg>)) iq_W߂̃NX
    * ((<CoordTrans|NumRu::CoordTrans>))()
    * ((<CoordScat|NumRu::CoordScat>))()
  * ((<Ggraphic|NumRu::Ggraphic>)) W[

=={Cu̎gp@
{Cu͊ɃCXg[Ă̂ƂB(CXg[@INSTALLAINSTALL.jp({)Q)

gpɂ
  require 'numru/gphys'
Ƃ΂悢B

܂A
  include NumRu
Ƃ邱ƂɂAGPhysCůeNXɂNumRuȗ\ƂȂBsȂꍇ NumRu::GPhys.new ȂǂƂĊeNX˂΂ȂȂB

=={Cuɂf[^̎舵
܂A{CuɂقȂ`̃f[^قړvOŎ舵Ƃł킯A͊et@C`ɈقȂNXpӂ邱ƂɂĂB{CuɂĂGDataxxxƂNXłB̃NXɃt@C`ɈˑȂC^[tF[X\bh`A̒Ńt@C`ɉĂяosBȂ킿AvO͓Õ\bhĂłĂV[oƂȂIuWFNg̃NXႦ΂ꂼ̃NX̃\bhĂ΂̂ŌʁAقȂ`̃f[^قړvOŎ舵킯łB

܂Af[^ϐƍWϐ̂ƂĈɂ́Af[^ϐƍWϐϐƂĎNXpӂ΂悢B{CuɂĂGPhysNX̖ʂB

==GPhys߂鑮
{Cuł́AGPhysIuWFNgGDataIuWFNgɑ΂đݒ肷邱ƂłBĂ錈܂ȎɊւĂ͖{CuIɉ߂sB{Cu߂邱Ƃ̂ł鑮͎̒ʂłB

* long_name: O -> }̃^CgŗpB
* units: ϐ̒P -> ZɔčXVB
* valid_range: ϐ͈̔ -> ͈͊O̐l͌lƂ݂ȂB
* valid_min, valid_max: ϐ̍ŏlAől -> valid_range ɕϊB
* scale_factor: -> IOxŉ߂Bz񔲂̍ہA̒l scale_factor {B
* add_offset: -> IOxŉ߂Bz񔲂̍ہA̒l add_offsetB
* missing_value: l -> zNXőΏł悤ɂB
* positive: ̌ -> }ۂɉ߂AΉsB

Ȃ킿A[Uݒ肷ꍇA̖O͏ŏqׂɂ邱Ƃ]܂BȊȎ͎Iɂ͉߂ȂB]āȀ̓[UsȂ΂ȂȂB

=end

=={Cu̍\
ɖ{Cu̍\yъeW[̃\bhB
* NumRu::AdvancedDCL

==NumRu::GPhys 
==={NXɂ
GPhysNX̓f[^ϐƍWϐ̉Ĉ߂̃NXłBGPhysNX̃IuWFNg͓Ƃăf[^(GData)IuWFNgƍW(Coord)IuWFNgB{IɃ[UGPhysIuWFNgvO~ȎΏۂƂB

===X[p[NX
    Object

===(⑫)GPhysNX̎ɂ

et@C`ƂɈقȂf[^NXpӂ邱ƂɂAGDatax
ɂf[^̎舵͍̓s邪AGPhysxɂf[
^̎舵̓s߂ɂ͍XɊKvȂƂB܂A
NetCDF`ɋƁANetCDF͊ef[^ϐɖO^ĂA
̖Oɂf[^AW̊֘A𔻒fĂB̊֘AfGPhys
xōsNetCDFf[^݂̂Ȃ炸̃f[^tH[}bgɂ̊֘A
fKpĂ܂ƂɂȂBSẴtH[}bĝ悤Ȋ֘Af
Ă킯ł͂Ȃ̂ŁAł̓f[^𓝈IɈƂłȂB
邽߂ɂ͊etH[}bgƂɊ֘A𔻒f郁\bhp
KvBÃ\bh̓[UڈȂ̂ŃW[
BB܂Af̎dlꂳĂȂf[^`ɊւĂ
O画f̂߂̃ev[gwł悤ɂA܂ύXł
ɂĂBɂΉf[^`͑SēIɈƂł
悤ȂBA݊֘Af̃W[͎ĂȂB

=end

module NumRu 
   class GPhys
      def initialize(data_new, coord_new=nil) 
	 if(coord_new) 
	    shape1 = data_new.shape 
	    shape2 = coord_new.shape 
	    data_new.shape.each_index{|i| 
	       if(shape1[i] != shape2[i]) 
		  raise ArgumentError, "shape is mismatch between GData and Coord" 
	       end 
	    } 
	 end 
	 @data = data_new 
	 @coord = coord_new 
      end

=begin
===NX\bh
---initialize(data_new, coord_new=nil)
    GPhysIuWFNg𐶐B

    
    * data_new:f[^IuWFNg(GData)
    * coord_new:WIuWFNg(Coord)

    l
      GPhysNX̑SĂ̏֐͂̃\bhĂłB

=end

     # GPhysRect.new2(narray, destination, attr=nil, coord_new=nil)
     # destination: Class
     #         GDataMem : initialize as memory data
     #      GDataNetCDF : initialize as NetCDF data (create tempfile)

     def GPhys.new2(narray, destination, attr=nil, coord_new=nil)
	if(attr.is_a?(Array))
	   coord_new = attr
	   attr = nil
	end

	data = destination.new3(narray, attr)
      
	if(coord_new != nil)
	   if(coord_new.is_a?(Array))
	      coord = NumRu::CoordRect.new(coord_new)
	   elsif(coord_new.is_a?(NumRu::CoordRect))
	      coord = coord_new
	   else
	      coord = NumRu::CoordRect.new
	   end
	else
	   coord = NumRu::CoordRect.new
	end

	GPhysRect.new(data, coord)
     end

=begin
---new2(narray, destination, attr=nil, coord_new=nil)
    zƃf[^NXw肵GPhysIuWFNg𐶐B

    
    * narray: z(NArray)
    * destination: f[^NX(Class)
    * attr: f[^̑(Attribute)
    * coord_new: WNX̃IuWFNg(Coord)

    l
      ̃\bh͓Ŏw肵f[^NX(destination)̏sĂB 

=end

     def GPhysRect.open(uri, mode="r")
       coord = Array.new
       if(/\.nc/ =~ uri)
	  var = NumRu::NetCDFVar.new(uri, mode)
	  netcdf = var.file
	  var_names = netcdf.var_names
	  dimnames = var.dims
	  dimnames.each{|i|
	      var_names.each{|j|
		 if(i.name == j)
		    dim_var = NumRu::GDataNetCDF.new(netcdf.var(j))
		    coord.push([dim_var])
		 end
	      }
	   }
	  coord_new = NumRu::CoordRect.new(coord)
	  data_new = NumRu::GDataNetCDF.new(var)
	  GPhysRect.new(data_new, coord_new)
       end
     end

=begin
---open(uri, mode="r")
    t@CJAGPhysNX̏sB

    
    * uri: t@CAϐw肷URI(String)
    * mode: t@C̓ǂݏ[h(String)

    l
    * URI"filename?var=varname"̌`ŏBfilename̓t@CAvarname͕ϐłB
    * modeRubỹt@C[hƓłB
      * r: ǂݍݐp
      * r+: ǂݏp
      * w: VK쐬ݐp
      * w+: VK쐬ǂݏp
      * a: ǉ݁Aݐp
      * a+: ǉ݁Aǂݏp 

=end

    NArray_methods=["dim", "rank", "shape", "total", "all?", "any?", "none?", "where", "where2"]

#------------- instance methods ----------------

    def set_value(narray)
       @data.set(narray)
       self
    end

=begin
===CX^X\bh
---set_value(narray)
    f[^̔zݒ肷B

    
    * narray: Vz(NArray)

    l
      ݒ肳z͌̔zƌ`łȂ΂ȂȂB

=end

    def get_value
      @data.get.clone
    end

=begin
---get_value
    f[^̔zoB

    
      Ȃ

    l
      ԂlNArrayIuWFNgłB

=end

    def set_axis_value(dim, narray)
       @coord.set_axis_value(dim, narray)
       self
    end

=begin
---set_axis_value(dim, narray)
    w肵̍Wϐ̔zݒ肷B

    
    * dim: ݒ肷鎟(Fixnum)
    * narray: ݒ肷z(NArray)

    l
    * dim͐lŎw肷Bdim=1̏ꍇA1ڂ̍WɂĐݒ肷B
    * ݒ肳z͌̔zƌ`łȂ΂ȂȂB

=end

    def get_axis_value(dim)
       @coord.get_axis_value(dim)
    end

=begin
---get_axis_value(dim)
    w肵̍Wϐ̔zoB

    
    * dim: o(Fixnum)
    
    l
    * dim͐lŎw肷Bdim=1̏ꍇA1ڂ̍W̔zoB
    * ԂlNArrayIuWFNgłB

=end

    alias :value :get_value

    def set_coord(coord)
       @coord.set_coord(coord)
       self
    end

=begin
---set_coord(coord)
    Wݒ肷B

    
    * coord: WIuWFNg(Coord)

    l
      

=end

    def [](*index)
      new_data = @data[*index]
      new_coord = @coord[*index]
      GPhysRect.new2(new_data, new_coord)
    end

=begin
---[](*index)
    IuWFNg̐؂osB

    
    * index: CfbNX(Array)

    l
    * self[0..1, 0] ̂悤ɂėpB
    * CfbNXNArraỹCfbNXwɊÂĂB

=end
 
    def []=(*index)
      val = index.pop
      @data[*index] = val
    end

=begin
---[]=(index, val)
    IuWFNgւ݂̏sB

    
    * index: CfbNX(Array)
    * val: ݒ肷l(Numeric, NArray)
    
    l
    * self[0..1, 0]=99.9  ̂悤ɂėpB
    * CfbNXNArraỹCfbNXwɊÂĂB

=end

    def set_att(name, val)
       @data.set_att(name, val)
    end

=begin
---set_att(name, val)
    f[^̑ݒ肷B

    
    * name: (String)
    * val: ̒l(Numeric, String)

    l
      ɂĂ((<GPhys߂鑮>))QƂ̂ƁB

=end

    def get_att(name)
      @data.get_att(name)
    end

=begin
---get_att(name)
    f[^̑oB

    
    * name: (String)

    l

=end

    def set_axis_att(dim, name, value)
      @coord.set_axis_att(dim, name, value)
    end

=begin
---set_axis_att(dim, name, value)
    w肵̍Wϐ̑ݒ肷B

    
    * dim: ݒ肷鎟(Fixnum)
    * name: (String)
    * value: ̒l(Numeric, NArray)
    
    l
    * dim͐lŎw肷Bdim=1̏ꍇA1ڂ̍WɂĐݒ肷B
    * ɂĂ((<GPhys߂鑮>))QƂ̂ƁB

=end

    def get_axis_att(dim, name)
      @coord.get_axis_att(dim, name)
    end

=begin
---get_axis_att(dim, name)
    w肵̍Wϐ̑oB

    
    * dim: ݒ肷鎟(Fixnum)
    * name: (String)
    
    l
    * dim͐lŎw肷Bdim=1̏ꍇA1ڂ̍WɂĐݒ肷B

=end

    def clone
      GPhysRect.new(@coord, @data)
    end

    alias :clone :dup

=begin
---clone
    IuWFNg̃Rs[sB

    
      Ȃ

    l
      ̃\bh̓fB[vȃRs[sȂBAϐłf[^IuWFNgƍWIuWFNg͋ʂŕʃIuWFNgB

=end

    def copy
      coord_new = @coord.copy
      data_new = @data.copy
      gphys = GPhysRect.new(coord_new, data_new)
      gphys
    end

=begin
---copy
    IuWFNg̃Rs[sB

    
      Ȃ

    l
      ̃\bh̓fB[vȃRs[sBAϐłf[^IuWFNgƍWIuWFNgꂼRs[ʃIuWFNgB

=end

    def process(option=nil)
       index = @coord.slicer(option)
       coord = @coord[*index.clone]
       oldshape = coord.shape
       rank = coord.rank
       if(option[:to2d])
	  coord_new = Array.new(2)
	  if(coord.rank >= 2)
	     j = 0
	     for i in 0..(rank-1)
		sup = coord.get_supl(i)
		axis = coord.get_axis(i)
		if(axis.total != 1)
		   coord_new[j] = [axis, sup]
		   j = j + 1
		end
		if(j == 2)
		   break
		end
	     end
	     coord = NumRu::CoordRect.new(coord_new)
	     j = 0
	     for i in 0..(rank-1)
		if(oldshape[i] != 1)
		   if(j == 2)
		      index[i] = 0
		   else
		      j = j + 1
		   end
		end 
	     end
	  end
       end

       data_new = @data[*index.clone].trim
       GPhysRect.new(data_new, coord)
    end

=begin
---process(option=nil)
    f[^̉HsB

    
    * option : f[^H̍ۂ̃IvV(Hash)

    l
      IvV^nbṼL[ƂĎ̂̂p邱ƂłB
      * dvn(n=1,2,....): nڂɊւCfbNXw肷BlɂFixnum܂Rangew肷B
          jdv1=>2..7
      * to2d: 2sBŏ2̎̑SĂ̗vfƎc̎̍ŏ̗vf؂oBto2d=>true ŗLƂȂB

=end

    def to2d(option=nil)
       if(option == nil)
	  option = Hash.new
       end
       option[:to2d] = true
       self.process(option)
    end

=begin
---to2d(option=nil)
    f[^2B

    
    * option: f[^H̍ۂ̃IvV(Hash)

    l
    * IvV^nbṼL[ƂĎ̂̂p邱ƂłB
      * dvn(n=1,2,....): nڂɊւCfbNXw肷BlɂFixnum܂Rangew肷B
          jdv1=>2..7
    * ̃\bh self.process(to2d=>true, option) ĂяoB

=end

    def data
       @data
    end

=begin
---data
    GPhysIuWFNg̃f[^IuWFNgoB

    
      Ȃ

    l
      Ԃl̓f[^IuWFNgłB

=end

    def att_names
       @data.att_names
    end


    def inspect
      name = @data.name.inspect
      unit = @data.units.inspect
      valid_range = @data.valid_range.inspect
      shape = @data.get.shape.inspect
      other = @other.inspect
      coord = @coord.inspect

      str = "Coordinate type:  Rectangle \n"
      str = str + "data: " + shape + "\n"
      str = str + "\t" + @data.inspect
      str = str + "coordinate: \n"
      str = str + "\t" + @coord.inspect + "\n"
    end

#------------- uncompleted instance methods -----------

    def + (other)
      coord = other.instance_eval "@coord"
      data = other.instance_eval "@data"
      if(@data.get.shape==other.get_value.shape)
	coord_new = @coord.clone
      elsif(@data.include?(data))
	coord_new = @coord.clone
      elsif(data.include?(@data))
	coord_new = coord.clone
      end
      
      data_new = @data + other.instance_eval{@data}
      GPhysRect.new(coord_new, data_new)
    end

=begin
---+(other)
    ZsB

    
    *  other: vZΏ(GPhys, Numeric)

    l
    *  GPhysIuWFNgm̓񍀉Z݂͂قȂ鎟̏ꍇɂΉłB
    *  ̏ꍇA𑼕ɊgKv邪Ags̔f͊et@C`ɗpӂĂ֘Af̃\bhɂsB
    *  قȂނ̃f[^m̌vZ\łBvZʂselfƓt@C`ƂȂB

=end

    def - (other)
       coord = other.instance_eval "@coord"
       data = other.instance_eval "@data"
       if(@data.get.shape==other.get_value.shape)
	      coord_new = @coord.clone
       elsif(@data.include?(data))
	      coord_new = @coord.clone
       elsif(data.include?(@data))
	      coord_new = coord.clone
       end
      
       data_new = @data - other.instance_eval{@data}
       GPhysRect.new(coord_new, data_new)
    end

=begin
--- -(other)
    ZsB

    
    *  other: vZΏ(GPhys, Numeric)

    l
    *  GPhysIuWFNgm̓񍀉Z݂͂قȂ鎟̏ꍇɂΉłB
    *  ̏ꍇA𑼕ɊgKv邪Ags̔f͊et@C`ɗpӂĂ֘Af̃\bhɂsB
    *  قȂނ̃f[^m̌vZ\łBvZʂselfƓt@C`ƂȂB

=end

    def * (other)
      coord = other.instance_eval "@coord"
      data = other.instance_eval "@data"
       if(@data.get.shape==other.get_value.shape)
	coord_new = @coord.clone
      elsif(@data.include?(data))
	coord_new = @coord.clone
      elsif(data.include?(@data))
	coord_new = coord.clone
      end

      data_new = @data * other.instance_eval{@data}
      GPhysRect.new(coord_new, data_new)
    end

=begin
--- *(other)
    ώZsB

    
    *  other: vZΏ(GPhys, Numeric)

    l
    *  GPhysIuWFNgm̓񍀉Z݂͂قȂ鎟̏ꍇɂΉłB
    *  ̏ꍇA𑼕ɊgKv邪Ags̔f͊et@C`ɗpӂĂ֘Af̃\bhɂsB
    *  قȂނ̃f[^m̌vZ\łBvZʂselfƓt@C`ƂȂB

=end

    def / (other)
      coord = other.instance_eval "@coord"
      data = other.instance_eval "@data"
       if(@data.get.shape==other.get_value.shape)
	coord_new = @coord.clone
      elsif(@data.include?(data))
	coord_new = @coord.clone
      elsif(data.include?(@data))
	coord_new = coord.clone
      end

      data_new = @data / other.instance_eval{@data}
      GPhysRect.new(coord_new, data_new)
    end

=begin
--- /(other)
    ZsB

    
    *  other: vZΏ(GPhys, Numeric)

    l
    *  GPhysIuWFNgm̓񍀉Z݂͂قȂ鎟̏ꍇɂΉłB
    *  ̏ꍇA𑼕ɊgKv邪Ags̔f͊et@C`ɗpӂĂ֘Af̃\bhɂsB
    *  قȂނ̃f[^m̌vZ\łBvZʂselfƓt@C`ƂȂB

=end

    def sum(dim)
      coord = @coord.delete(dim)
      data = @data.sum(dim)
      GPhysRect.new(coord, data)
    end
    
    alias :summention :sum

=begin
--- sum(dim)
    w肵ɊւaƂB

    
    *  dim: vZs(Fixnum)

    l
    *  {\bĥ悤ɌvŽʁAωꍇWXVĂB

=end

    def av(dim)
      coord = @coord.delete(dim)
      data = @data.av(dim)
      GPhysRect.new(coord, data)
    end

    alias :average :av

=begin
--- avg(dim)
    w肵Ɋւ镽ςƂB

    
    *  dim: vZs(Fixnum)

    l
    *  {\bĥ悤ɌvŽʁAωꍇWXVĂB

=end

    def var(dim)
      coord = @coord.delete(dim)
      data = @data.var(dim)
      GPhysRect.new(coord, data)
    end

    alias :variance :var

=begin
--- var(dim)
    w肵Ɋւ镪UƂB

    
    *  dim: vZs(Fixnum)

    l
    *  {\bĥ悤ɌvŽʁAωꍇWXVĂB

=end

    def stddev(dim)
      coord = @coord.delete(dim)
      data = @data.rms(dim)
      GPhysRect.new(coord, data)
    end

=begin
--- stddev(dim)
    w肵ɊւW΍ƂB

    
    *  dim: vZs(Fixnum)

    l
    *  {\bĥ悤ɌvŽʁAωꍇWXVĂB

=end

#----------- private methods --------------------
    private
    def GPhysRect.def_methods
       for f in NArray_methods
	  eval <<-EOS
	  def #{f}
	     @data.#{f}
	  end
	  EOS
       end
    end

    def_methods

=begin
---dim, rank
    ԂB

    
      Ȃ

    l
      ԂlFixnumłB

=end

=begin
---shape
    f[^̌`ԂB

    
      Ȃ

    l
      ԂlArrayłB

=end

=begin
---total
    z̑SvfԂB

    
      Ȃ

    l
      ԂlFixnumłB

=end

=begin
̑A((<GData|NumRu::GData>))NXŗpł郁\bh͑SėpłB
=end

  end
end
