require 'narray'
require 'numru/netcdf'
require 'numru/gphys/attribute'

# + Class methods
# -- create new file 
#    new2 : create GDataNetCDF from (shape, ntype, uri=nil, mode=nil, attr=nil)
#    new3 : create GDataNetCDF from (narray, uri=nil, mode=nil, attr=nil)
# -- open file which exists
#    open : create GDataNetCDF by opening file

=begin
==NumRu::GDataNetCDF
==={NXɂ
    {NXNetCDFt@C̃f[^߂̃NXłB

===X[p[NX
    GDataFile

=end

module NumRu
  class GDataNetCDF
     def initialize(netcdfvar)
	@var = netcdfvar
	@volatile_attr = NumRu::Attribute.new
	@mapper = nil
     end

=begin
===NX\bh
---initialize(netcdfvar)
    sB

    
    * netcdfvar: NetCDFVarIuWFNg(NetCDFVar)

    l
      GDataNetCDFNX̑SĂ̏֐͂̃\bhĂłB

=end

    def GDataNetCDF.new2(name, ntype, shape_ul0, dimname, filename=nil, attr=nil, mode="r+")
       if(filename == nil)
	  netcdf = NumRu::NetCDF.create_tmp(".")
       else
	  if(File.exist?(filename))
	     netcdf = NumRu::NetCDF.open(filename, mode)
	  else
	     netcdf = NumRu::NetCDF.create(filename)
	  end
       end

       new_attr = NumRu::Attribute[:name, name, :units, "1"]
       if(attr.is_a?(Hash))
	  attr.each{|key, val|
	     new_attr[key] = val
	  }
       end

       var = netcdf.def_var_with_dim(name, typeget(ntype), shape_ul0, dimname)
       new_attr.each{|key, val|
	  if(key != :name)
	     if(val)
		var.put_att(key.to_s, val)
	     end
	  end
       }

       new_data = GDataNetCDF.new(var)
    end

=begin
---new2(name, ntype, shape_ul0, dimname, filename=nil, attr=nil, mode="r+")
    f[^^Ɣž`珉sB

    
    * name: ϐ(String)
    * ntype: f[^^(String)
    * shape_ul0: ž`(Array)
    * dimname: (Array)
    * filename: t@C(String)
    * attr: ϐ̑(Hash)
    * mode: t@C̓ǂݏ[h(String)

    l
    * f[^^͎̂̂włB
      * "byte"(unsigned char): 1oCg^
      * "sint": 1oCg^
      * "int": 2oCg^
      * "long": 4oCg^
      * "float": 4oCg_^
      * "double": 8oCg_^ 
    * ɂĂ((<GPhys߂鑮>))QƂ̂ƁB
    * modeRubỹt@C[hƓłB
      * r: ǂݍݐp
      * r+: ǂݏp
      * w: VK쐬ݐp
      * w+: VK쐬ǂݏp
      * a: ǉ݁Aݐp
      * a+: ǉ݁Aǂݏp 

=end

    def GDataNetCDF.new3(name, narray, dimname, filename=nil, attr=nil, mode="r+")
       new_data = GDataNetCDF.new2(name, narray.typecode, narray.shape, dimname, filename, attr, mode)
       new_data.set(narray)
    end

=begin
---new3(name, narray, dimname, filename=nil, attr=nil, mode="r+")
    z񂩂珉sB

    
    * name: ϐ(String)
    * narray: z(NArray)
    * dimname: (Array)
    * filename: t@C(String)
    * attr: ϐ̑(Hash)
    * mode: t@C̓ǂݏ[h

    l
    * ɂĂ((<GPhys߂鑮>))QƂ̂ƁB
    * modeRubỹt@C[hƓłB
      * r: ǂݍݐp
      * r+: ǂݏp
      * w: VK쐬ݐp
      * w+: VK쐬ǂݏp
      * a: ǉ݁Aݐp
      * a+: ǉ݁Aǂݏp 

=end

    def GDataNetCDF.open(name, filename, mode="r")
       if(File.exist?(filename))
	  uri = filename + "?var=" + name
	  var = NumRu::NetCDFVar.new(uri, mode)
	  new_data = GDataNetCDF.new(var)
       else
	  raise ArgumentError, "file #{filename} doesn't exist"
       end
       new_data
    end

=begin
---open(name, filename, mode="r")
    t@CJAsB

    
    * name: ϐ(String)
    * filename: t@C(String)
    * mode: t@C̓ǂݏ[h(String)

    l
    * modeRubỹt@C[hƓłB
      * r: ǂݍݐp
      * r+: ǂݏp
      * w: VK쐬ݐp
      * w+: VK쐬ǂݏp
      * a: ǉ݁Aݐp
      * a+: ǉ݁Aǂݏp 

=end

    Singleterm_operators=["sqrt","exp","log","log10","log2","sin","cos","tan","sinh","cosh","tanh","asin","acos","atan","asinh","acosh","atanh","csc","sec","cot","csch","sech","coth","acsc","asec","acot","acsch","asech","acoth"]
    Twoterm_operators=["+","-","*","/","**","%"]
    Twoterm_operators2=["add!", "sub!", "mul!", "div!"]
    Twoterm_operators3=["add", "sub", "mul", "div"]
    Dimentional_operators=["sum", "mean", "var", "stddev"]
    NArray_methods=["typecode", "dim", "rank", "shape", "total", "all?", "any?", "none?", "where", "where2"]
    NArray_methods_return_self=["floor", "ceil", "round", "to_f", "to_i"]
    NArray_methods_with_args=["newdim", "newdim!", "reshape", "reshape!", "indgen", "indgen!", "fill", "fill!", "random", "random!"]

#-------------- instance method ---------------
    def mapper
       @mapper
    end

    def mapper=(mapper)
       @mapper = mapper
    end
       
    def create_another(ntype=nil, shape_ul0=nil, file=nil, attr=nil)
       if(shape_ul0 == nil)
	  shape_ul0 = @var.shape_ul0
       end
       
       if(ntype == nil)
	  ntype = @var.ntype
       end

       new_attr = attr_get
       if(attr.is_a?(Hash))
	  attr.each{|key, val|
	     new_attr[key] = val
	  }
       end
       new_data = GDataNetCDF.new2(@var.name, ntype, shape_ul0, @var.dim_names, file, new_attr)
    end

=begin
---create_another(shape=nil, ntype=nil, file=nil, attr=nil)
    GDataMemIuWFNgB

    
    * shape: ž`(Array)
    * ntype: f[^̌^(String)
    * file: t@C(String)
    * attr: f[^̑(Hash)

    l
      {\bh͕ʂ̃f[^IuWFNgBRs[̃NX̓Rs[ƓłB

=end

#    
# If 'copy' method does not depend on file format, following cases must be satisfied. (That's difficult.)
#   1. each data class has @var which is Var object (example NetCDFVar) 
#   2. @var has methods 'name', 'dim_names', 
#   3. new3 method takes same arguments in each format.
#
    def copy(destination=nil, file=nil)
       unless(destination)
	  destination = self.type
       end
       if(destination.is_a?(Class))
	  varname = @var.name
	  dimname = @var.dim_names
	  attr = attr_get
	  if(destination == GDataMem)
	     new_data = destination.new3(@var.scaled_get, attr)
	  else
	     new_data = destination.new3(varname, @var.scaled_get, dimname, file, attr)
	  end
       else
	  raise ArgumentError, "destination expects Class or nil"
       end
       if(@mapper)
	  new_data.mapper = @mapper.clone
       end
    end

=begin
---copy(destination=nil, filename=nil)
    IuWFNg̕sB

    
    * destination: Rs[̃NX(Class)
    * dimname: (Array)
    * filename: t@C(String)

    l
    * {\bh̓fB[vȃRs[sBAz̃Rs[sB܂ARs[̃NXw肷邱ƂoB
    
=end

    def [](*index)
       new_narray = @var[*index]
       attr = NumRu::Attribute.new
       att_names = @var.att_names
       if(att_names != nil)
	  att_names.each{|i|
	     val = @var.att(i)
	     if(val.is_a?(NArray) && val.length == 1)
		attr[i] = val[0]
	     else
		attr[i] = val
	     end
	  }
       end
       if(@mapper)
	  @mapper = @mapper.map(Mapper.new4(index, @var.shape))
       else
	  @mapper = Mapper.new4(index, @var.shape_current)
       end
    end

=begin
---[](*index)
    f[^̐؂osB

    
    * index: CfbNX(Array)

    l
    * self[0..1, 0] ̂悤ɂėpB
    * CfbNXNArraỹCfbNXwɊÂĂB
    * ̃\bh͐؂oʂVIuWFNgƂ邪AQƂ݂̂̃f[^؂omap\bhBڂ((<QƂ݂̂̃TuZbg؂o>))QƂ̂ƁB

=end

    def []=(*index)
      val = index.pop
      @var[*index] = val 
      self
    end


=begin
---[*index]=val
    IuWFNgւ݂̏sB

    
    * index: CfbNX(Array)
    * val: ݒ肷l(Numeric, NArray)
    
    l
    * self[0..1, 0]=99.9  ̂悤ɂėpB
    * CfbNXNArraỹCfbNXwɊÂĂB

=end

    def slice(mapper, destination=GDataMem)
       first, length, step = *mapper.show
       last = Array.new
       first.each_index{|i|
	  last.push(first[i] + (length[i]-1)*step[i])
       }
       index = Array.new
       first.each_index{|i|
	  if(step[i]==1)
	     index.push(first[i]..last[i])
	  else
	     index.push({first[i]..last[i], step[i]})
	  end
       }
       if(destination == GDataNetCDF)
	  new_data = self[*index]
       else
	  new_data = self[*index].copy(destination)
       end
       new_data
    end

    def slice=(*a)
       mapper = a[0][0]
       narray = a[0][1]
       first, length, step = *mapper.show
       last = Array.new
       first.each_index{|i|
	  last.push(first[i] + (length[i]-1)*step[i])
       }
       index = Array.new
       first.each_index{|i|
	  if(step[i]==1)
	     index.push(first[i]..last[i])
	  else
	     index.push({first[i]..last[i], step[i]})
	  end
       }
       self[*index] = narray
    end

    def each_slicer(forbit=nil)
       shape = self.shape
       typecode = self.typecode
       map = Mapper.divide(shape, typecode, forbit)
       map.each{|i|
	  yield(i)
       }
    end

=begin
---each_slicer(forbit=nil){|mapper|
    f[^IuWFNg̊eTuZbgwCfbNXɊւJԂsB

    
    * forbit: ֎~(Fixnum)
    * data: f[^IuWFNg̃TuZbgwCfbNX(Mapper)

    l
    * f[^͓̕ŎIɍsB
    * f[^ɂĂ((<K̓f[^̎舵>))QƂ̂

=end

    def each_subset(forbit=nil)
       shape = self.shape
       typecode = self.typecode
       map = Mapper.divide(shape, typecode, forbit)
       map.each{|i|
	  subset = self.slice(i)
	  yield(subset)
       }
    end

=begin
---each_subset(forbit=nil){|data|
    f[^IuWFNg̊eTuZbgɊւJԂsB

    
    * forbit: ֎~(Fixnum)
    * data: f[^IuWFNg̃TuZbg(GDataMem)

    l
    * f[^͓̕ŎIɍsB
    * f[^ɂĂ((<K̓f[^̎舵>))QƂ̂

=end

    def each_subset_set(forbit=nil, destination=nil, file=nil)
       if(forbit.is_a?(Class))
	  if(destination.is_a?(String))
	     file = destination
	     destination = forbit
	     forbit = nil
	  else
	     destination = forbit
	     forbit = nil
	  end
       elsif(forbit.is_a?(String))
	  file = forbit
	  forbit = nil
       end
       shape = self.shape
       typecode = self.typecode
       attr = attr_get
       if(destination == GdataMem)
	  new_data = destination.new2(shape, typecode, attr)
       elsif(destination)
	  new_data = destination.new2(shape, typecode, file, attr)
       else
	  new_data = GDataNetCDF.new2(shape, typecode, file, attr)
       end
       map = Mapper.divide(shape, typecode, forbit)
       map.each{|i|
	  subset = self.slice(i)
	  ary = yield(subset)
	  if(ary.is_a?(Array))
	  elsif(ary.is_a?(GDataMem))
	     new_data.slice=[i, subset.get]
	  end
       }
       new_data
    end

    def trim
       narray = self.get
       shape = narray.shape
       newshape = Array.new
       shape.each_index{|i|
	  if(shape[i] != 1)
	     newshape.push(shape[i])
	  end
       }
       new_narray = narray.reshape(*newshape)
       attr = attr_get
       GDataNetCDF.new3(new_narray, attr)
    end

    def set(narray)
      if(narray.is_a?(NArray))
	@var.put(narray)
      else
	raise ArgumentError, 'method set expects NArray'
      end
      self
    end

=begin
---set(ary)
    lzύXB

    
    * ary: Vz(NArray)

    l
    
=end

    def get
      @var.get
    end

=begin
---get
    ݂̐lzoB

    
      Ȃ

    l
      ԂlNArrayIuWFNgłB

=end

    def get_att(attname)
       val = @volatile_attr[attname]
       if(val == nil)
	  case(attname)
	  when "name", :name
	     @var.name
	  else
	     if(@var.att(attname.to_s))
		@var.att(attname.to_s).get
	     else
		nil
	     end
	  end
       else
	  return val
       end
    end

=begin
---get_att(attname)
    ̒lQƂB

    
    * attname: QƂ鑮(String)

    l
      
=end

    def set_att(attname, value)
      case(attname)
      when "name", :name
	@var.name = value
      else
	@var.put_att(attname, value)
      end
    end


=begin
---set_att(attname, val)
    ݒ肷B

    
    * attname: (String)
    * val: ݒ肷l(Numeric, String)

    l
      ɂĂ((<GPhys߂鑮>))QƂ̂ƁB

=end

    def set_volatile_attr(attname, val)
       @volatile[attname] = val
    end

    def attr_sync
       @volatile_attr.each{|key, val|
	  @var.put_att(key.to_s, val)
       }
    end

    def name
      @var.name
    end

=begin
---name
    f[^̖OQƂB

    
      Ȃ

    l
      get_attr("name")ƓłB

=end

    def name=(name)
      if(name.is_a?(String) || name.is_a?(NilClass))
	@var.name = name
      else
	raise ArgumentError, "method name= expects String"
      end
    end

=begin
---name=(name)
    f[^̖Oݒ肷B

    
    * name: VO(String)

    l
      set_attr("name", name)ƓłB

=end

    def valid_range
       if(@var.att("valid_range"))
	  @var.att("valid_range")
       else
	  nil
       end
    end

=begin
---valid_range
    f[^̗L͈͂QƂB

    
      Ȃ

    l
      set_attr("valid_range")ƓłB

=end

    def valid_range=(range)
      if(range.is_a?(Array) || valid_range.is_a?(NilClass))
	@var.put_att("valid_range", range)
      else
	raise ArgumentError, "method valid_range= expects Range"
      end
    end

=begin
---valid_range=(range)
    f[^̗L͈͂ݒ肷B

    
    * range: Vf[^͈̔(Range)

    l
      set_attr("valid_range", range)ƓłB

=end

    def units
       if(@var.att("units"))
	  @var.att("units")
       else
	  '1'
       end
    end

=begin
---units
    f[^̒PʂQƂB

    
      Ȃ

    l
      get_attr("units")ƓłB

=end

    def units=(units)
     if(units.is_a?(String) || units.is_a?(NilClass))
	@var.put_att("units", units)
      else
	raise ArgumentError, "method units= expects String"
      end
    end 

=begin
---units=(units)
    f[^̒Pʂݒ肷B

    
    * units: VP(String)

    l
    * set_attr("units", units)ƓłB
    * IɂUnitsNX쐬APʂ͑SUnitsNX̃IuWFNgɂB

=end

    def file
       @var.file
    end

    def dims
       @var.dims
    end

    def vartype
       @var.vartype
    end

    def att(name)
       val = @var.att(name)
       if(val.is_a?(NArray) && val.length == 1)
	  reval = val[0]
       else
	  reval = val
       end
       reval
    end

    def att_names
       @var.att_names
    end

    def inspect
       str = "GDataNetCDF: " + self.name + "\n"
       str = str + "array: \n" + @var.get.inspect + "\n"
       str = str + "attribute: " + @var.inspect + "\n"
    end
#----------- protected methods ------------------
    protected
    def GDataNetCDF.clean_tempfile(tempname)
      lambda{
	print "removing ", tempname, "..." if $DEBUG
	if(File.exist?(tempname))
	  File.unlink(tempname)
	end
	print "done\n" if $DEBUG
      }
    end

    def GDataNetCDF.typeget(typecode)
      case typecode
      when 1, "byte"
	"byte"
      when 2, "sint"
	"sint"
      when 3, "int"
	"int"
      when 4, "sfloat"
	"sfloat"
      when 5, "float"
	"float"
      when 6, "scomplex"
	"scomplex"
      when 7, "complex"
	"complex"
      when 8, "object"
	"object"
      end
    end

    def attr_get
       attr_names = @var.att_names
       attr = NumRu::Attribute.new
       attr_names.each{|i|
	  val = @var.att(i).get
	  if(val.is_a?(NArray) && val.length == 1)
	     attr[i] = val[0]
	  else
	     attr[i] = val
	  end
       }
       attr[:name] = @var.name
       attr
    end

#----------- private methods --------------------
#쐬r
    private

#    def var_clone(new_data)
#      GDataNetCDF.new(
#      new_var = @var.clone
#      new_data.instance_eval{@var = new_var}
#      new_data
#    end

    def GDataNetCDF.def_methods
       for f in Singleterm_operators
	  eval <<-EOS
	  def GDataNetCDF.#{f}(gdata)
	     new_data = gdata.create_another
	     if(gdata.set_divide?)
	     else
		new_ary = NMath.#{f}(gdata.get)
		new_data.set(new_ary)
		new_data
	     end
	     new_data
	  end
	  EOS
       end

       for f in Twoterm_operators
	  eval <<-EOS
	  def #{f}(other)
	     new_data = self.create_another
	     new_ary = @var.get #{f} other.get
	     new_data.set(new_ary)
	     new_data 
	  end
	  EOS
       end
       
       for f in Twoterm_operators2
	  eval <<-EOS
	  def #{f}(other)
	     @var.get.#{f}(other.get)
	     self
	  end
	  EOS
       end
       
       i = 0
       for f in Twoterm_operators3
	  eval <<-EOS
	  def #{f}(other, destination=nil)
	     if(destination != nil)
		attr = self.instance_eval{@attr}
		new_data = destination.new(@var.get, attr)
		new_data.#{f}!(other)
		new_data
	     else
		new_data = self.create_another
		new_ary = @var.get #{Twoterm_operators[i]} other.get
		new_data.set(new_ary)
		new_data
	     end
	  end
	  EOS
	  i = i + 1
       end
       
       for f in Dimentional_operators
	  if(f=='var')
	     eval <<-EOS
	     def #{f}(dim)
		new_data = self.create_another
		new_ary = @var.get.stddev(dim)**2
		new_data.set(new_ary)
		new_data 
	     end
	     EOS
	  else
	     eval <<-EOS
	     def #{f}(dim)
		new_data = self.create_another
		new_ary = @var.get.#{f}(dim)
		new_data.set(new_ary)
		new_data 
	     end
	     EOS
	  end
       end
       
       for f in NArray_methods
	  eval <<-EOS
	  def #{f}
	     @var.get.#{f}
	  end
	  EOS
       end
       
       for f in NArray_methods_return_self
	  eval <<-EOS
	  def #{f}
	     @var.get.#{f}
             self
	  end
	  EOS
       end
     
       for f in NArray_methods_with_args
	  eval <<-EOS
	  def #{f}(*arg)
	     narray = @var.get.#{f}(*arg)
	     @var.put(narray)
	     self
	  end
	  EOS
       end
    end
    
    def_methods

=begin
---indgen, indgen!(initial=nil, increaze=nil)
    z̗vfw肵lAʂő₷B

    
    * initial: l(Numeric)
    * increaze
    l
      indgen!͎g̕ύX\B
=end

=begin
---fill, fill!
    z𓯈̒lŖ߂B

    
      Ȃ

    l
      fill!͎g̕ύX\B
=end

=begin
---random, random!
    z̒l0w肵l܂ł̃_lɐݒ肷B

    
      Ȃ

    l

=end

=begin
---reshape, reshape!, shape=(newshape)
    ž`ύXB

    
    * newshape: Vž`(Array)

    l
      redhape!͎g̕ύX\B
=end

=begin
---newdim, newdim!(dim)
    1̎}B

    
    * dim: }鎟

    l
      newdim!͎g̕ύX\B
=end

=begin
---floor
    selfő̐ԂB

    
      Ȃ

    l

=end

=begin
---ceil
    self傫ŏ̐ԂB

    
      Ȃ

    l

=end

=begin
---round
    selfɍł߂ԂB

    
      Ȃ

    l

=end

=begin
---to_f
    l𕂓_ɕϊB

    
      Ȃ

    l

=end

=begin
---to_i
    l𐮐ɕϊB

    
      Ȃ

    l

=end

=begin
---dim, rank
    ԂB

    
      Ȃ

    l
      ԂlFixnumłB
=end

=begin
---shape
    ݂̔ž`ԂB

    
      Ȃ

    l
      ԂlArrayłB
=end

=begin
---total
    ݂̔z̗vfԂB

    
      Ȃ

    l
      ԂlFixnumłB
=end

=begin
--- +(other)
    ZsB

    
    * other: vZΏ(GData, Numeric)

    l
    *  GDataIuWFNgm̓񍀉Z݂͂قȂ鎟̏ꍇɂΉłB
    *  ̏ꍇA𑼕ɊgKv邪Ags̔f͊et@C`ɗpӂĂ֘Af̃\bhɂsB
    *  قȂނ̃f[^m̌vZ\łBvZʂselfƓt@C`ƂȂB

=end

=begin
--- -(other)
    ZsB

    
    * other: vZΏ(GData, Numeric)

    l
    *  GDataIuWFNgm̓񍀉Z݂͂قȂ鎟̏ꍇɂΉłB
    *  ̏ꍇA𑼕ɊgKv邪Ags̔f͊et@C`ɗpӂĂ֘Af̃\bhɂsB
    *  قȂނ̃f[^m̌vZ\łBvZʂselfƓt@C`ƂȂB

=end

=begin
--- *(other)
    ώZsB

    
    * other: vZΏ(GData, Numeric)

    l
    *  GDataIuWFNgm̓񍀉Z݂͂قȂ鎟̏ꍇɂΉłB
    *  ̏ꍇA𑼕ɊgKv邪Ags̔f͊et@C`ɗpӂĂ֘Af̃\bhɂsB
    *  قȂނ̃f[^m̌vZ\łBvZʂselfƓt@C`ƂȂB

=end

=begin
--- /(other)
    ZsB

    
    * other: vZΏ(GData, Numeric)

    l
    *  GDataIuWFNgm̓񍀉Z݂͂قȂ鎟̏ꍇɂΉłB
    *  ̏ꍇA𑼕ɊgKv邪Ags̔f͊et@C`ɗpӂĂ֘Af̃\bhɂsB
    *  قȂނ̃f[^m̌vZ\łBvZʂselfƓt@C`ƂȂB

=end

=begin
--- add(other, klass=nil)
    ʂʃIuWFNgƂłZ

    
    * other: vZΏ(GData, Numeric)
    * klass: ʂ̃NX(Class)

    l
    *  GDataIuWFNgm̓񍀉Z݂͂قȂ鎟̏ꍇɂΉłB
    *  ̏ꍇA𑼕ɊgKv邪Ags̔f͊et@C`ɗpӂĂ֘Af̃\bhɂsB
    *  قȂނ̃f[^m̌vZ\łBvZʂklassŎw肵NX̃IuWFNgƂȂB

=end


=begin
--- sub(other, klass=nil)
    ʂʃIuWFNgƂł錸Z

    
    * other: vZΏ(GData, Numeric)
    * klass: ʂ̃NX(Class)

    l
    *  GDataIuWFNgm̓񍀉Z݂͂قȂ鎟̏ꍇɂΉłB
    *  ̏ꍇA𑼕ɊgKv邪Ags̔f͊et@C`ɗpӂĂ֘Af̃\bhɂsB
    *  قȂނ̃f[^m̌vZ\łBvZʂklassŎw肵NX̃IuWFNgƂȂB

=end


=begin
--- mul(other, klass=nil)
    ʂʃIuWFNgƂłώZ

    
    * other: vZΏ(GData, Numeric)
    * klass: ʂ̃NX(Class)

    l
    *  GDataIuWFNgm̓񍀉Z݂͂قȂ鎟̏ꍇɂΉłB
    *  ̏ꍇA𑼕ɊgKv邪Ags̔f͊et@C`ɗpӂĂ֘Af̃\bhɂsB
    *  قȂނ̃f[^m̌vZ\łBvZʂklassŎw肵NX̃IuWFNgƂȂB

=end

=begin
--- div(other, klass=nil)
    ʂʃIuWFNgƂł鏜Z

    
    * other: vZΏ(GData, Numeric)
    * klass: ʂ̃NX(Class)

    l
    *  GDataIuWFNgm̓񍀉Z݂͂قȂ鎟̏ꍇɂΉłB
    *  ̏ꍇA𑼕ɊgKv邪Ags̔f͊et@C`ɗpӂĂ֘Af̃\bhɂsB
    *  قȂނ̃f[^m̌vZ\łBvZʂklassŎw肵NX̃IuWFNgƂȂB

=end

=begin
--- sum(dim)
    w肵Ɋւa

    
    * dim: vZs(Fixnum)

    l
    *  {\bĥ悤ɌvŽʁAωꍇWXVĂB

=end


=begin
--- avg(dim)
    w肵Ɋւ镽

    
    * dim: vZs(Fixnum)

    l
    *  {\bĥ悤ɌvŽʁAωꍇWXVĂB

=end
 
=begin
--- var(dim)
    w肵Ɋւ镪U

    
    * dim: vZs(Fixnum)

    l
    *  {\bĥ悤ɌvŽʁAωꍇWXVĂB

=end
 
=begin
--- stddev(dim)
    w肵ɊւW΍

    
    * dim: vZs(Fixnum)

    l
    *  {\bĥ悤ɌvŽʁAωꍇWXVĂB

=end

 end
end
      
