#include "extconf.h"


#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if !defined(STATIC_LINKED)
#    define SWIGEXPORT(a) __declspec(dllexport) a
#  else
#    define SWIGEXPORT(a) a
#  endif
#else
#  define SWIGEXPORT(a) a
#endif


#ifdef HAVE_NARRAY_H

#include "ruby.h"
#include "vtkCharArray.h"
#include "vtkShortArray.h"
#include "vtkIntArray.h"
#include "vtkLongArray.h"
#include "vtkFloatArray.h"
#include "vtkDoubleArray.h"


#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define PROTECTFUNC(f) ((VALUE (*)()) f)
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define PROTECTFUNC(f) ((VALUE (*)()) f)
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7+ */
#      define PROTECTFUNC(f) ((VALUE (*)(VALUE)) f)
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

#include "narray.h"
#if SIZEOF_LONG == 4
# define NA_INT_LONG
#else
# if SIZEOF_INT == 4
#  define NA_INT_INT
# else
---->> Please define int32_t manually because sizeof(long) != 4. <<----
# endif
#endif


#define NaToVaMacro(name, vtktype, datatype) \
static VALUE rb_NArray_to_##name (VALUE rna) \
{ \
  VALUE rva; \
  vtktype *va; \
  datatype *na; \
  int len; \
  vtkIdType i; \
  rva = rb_funcall(c##vtktype, rb_intern("new"), 0); \
  Data_Get_Struct(rva, vtktype, va); \
  len = NA_TOTAL(rna); \
  va->SetNumberOfValues(len); \
  na = NA_PTR_TYPE(rna,datatype*); \
  for (i=0; i<len; i++) \
  va->SetValue(i, na[i]); \
  return rva; \
}


static VALUE mVtk;
static VALUE cvtkCharArray;
static VALUE cvtkShortArray;
static VALUE cvtkIntArray;
static VALUE cvtkLongArray;
static VALUE cvtkFloatArray;
static VALUE cvtkDoubleArray;




NaToVaMacro(Byte, vtkCharArray, u_int8_t)
NaToVaMacro(SInt, vtkShortArray, int16_t)
#ifdef NA_INT_INT
NaToVaMacro(Int, vtkIntArray, u_int32_t)
#endif
#ifdef NA_INT_LONG
NaToVaMacro(Int, vtkLongArray, u_int32_t)
#endif
NaToVaMacro(SFloat, vtkFloatArray, float)
NaToVaMacro(Float, vtkDoubleArray, double)

static VALUE rb_NArray_to_vtkDataArray(VALUE na)
{

  if (NA_RANK(na)!=1) \
  rb_raise(rb_eArgError, "rank must be 1\\n");
  switch (NA_TYPE(na)) {
  case NA_BYTE:
    return rb_NArray_to_Byte(na);
  case NA_SINT:
    return rb_NArray_to_SInt(na);
  case NA_LINT:
    return rb_NArray_to_Int(na);
  case NA_SFLOAT:
    return rb_NArray_to_SFloat(na);
  case NA_DFLOAT:
    return rb_NArray_to_Float(na);
  default:
    rb_raise(rb_eArgError,"type must be byte, sint, int, sfloat, or float\\n");
  }
}


static VALUE get_class(const char *name)
{
  VALUE klass;
  ID id;

  id = rb_intern(name);
  if (rb_const_defined(rb_cObject, id)) {
    klass = rb_const_get(rb_cObject, id);
    if (TYPE(klass) != T_CLASS)
      rb_raise(rb_eTypeError, "%s is not a class", name);
    return klass;
  } else
    rb_name_error(id, "%s is not defined", name);
  return Qnil;
}

static VALUE get_class_under(VALUE outer, const char *name)
{
 VALUE klass;
  ID id;

  id = rb_intern(name);
  if (rb_const_defined_at(outer, id)) {
    klass = rb_const_get_at(outer, id);
    if (TYPE(klass) != T_CLASS)
      rb_raise(rb_eTypeError, "%s is not a class", name);
    return klass;
  } else
    rb_name_error(id, "%s is not defined", name);
  return Qnil;
}

#endif


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) Init_vtkNArray(void){

#ifdef HAVE_NARRAY_H
  mVtk = rb_define_module("Vtk");
  cvtkCharArray = get_class_under(mVtk, "CharArray");
#ifdef NA_INT_INT
  cvtkIntArray = get_class_under(mVtk, "IntArray");
#endif
#ifdef NA_INT_LONG
  cvtkLongArray = get_class_under(mVtk, "LongArray");
#endif
  cvtkFloatArray = get_class_under(mVtk, "FloatArray");
  cvtkDoubleArray = get_class_under(mVtk, "DoubleArray");


  rb_define_method(cNArray, "to_va", VALUEFUNC(rb_NArray_to_vtkDataArray), 0);

#endif

}
