%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkImaging_typemaps.i


%{
#include "vtkImageReslice.h"
#include "vtkImageStencilData.h"
%}

%import vtkImageToImageFilter.h


%{
extern void vtkImageReslice_freefunc(void *ptr)
{
    vtkImageReslice *obj;
    obj = (vtkImageReslice*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) float value[4] {
  int i;
  $result = rb_ary_new2(4);
  for (i=0; i<4; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[4]{
   float *GetBackgroundColor()
}
%ignore GetBackgroundColor(float data[4]);
%ignore GetBackgroundColor(float _arg[4]);
%ignore GetBackgroundColor(float &_arg1,float &_arg2,float &_arg3,float &_arg4);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetOutputSpacing()
}
%ignore GetOutputSpacing(float data[3]);
%ignore GetOutputSpacing(float _arg[3]);
%ignore GetOutputSpacing(float &_arg1,float &_arg2,float &_arg3);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetOutputOrigin()
}
%ignore GetOutputOrigin(float data[3]);
%ignore GetOutputOrigin(float _arg[3]);
%ignore GetOutputOrigin(float &_arg1,float &_arg2,float &_arg3);

%typemap(ruby,out) int value[6] {
  int i;
  $result = rb_ary_new2(6);
  for (i=0; i<6; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[6]{
   int *GetOutputExtent()
}
%ignore GetOutputExtent(int data[6]);
%ignore GetOutputExtent(int _arg[6]);
%ignore GetOutputExtent(int &_arg1,int &_arg2,int &_arg3,int &_arg4,int &_arg5,int &_arg6);

%include vtkImageReslice.h
