%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkImaging_typemaps.i


%{
#include "vtkImageAccumulate.h"
#include "vtkImageStencilData.h"
%}

%import vtkImageToImageFilter.h


%{
extern void vtkImageAccumulate_freefunc(void *ptr)
{
    vtkImageAccumulate *obj;
    obj = (vtkImageAccumulate*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetComponentSpacing()
}
%ignore GetComponentSpacing(float data[3]);
%ignore GetComponentSpacing(float _arg[3]);
%ignore GetComponentSpacing(float &_arg1,float &_arg2,float &_arg3);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetComponentOrigin()
}
%ignore GetComponentOrigin(float data[3]);
%ignore GetComponentOrigin(float _arg[3]);
%ignore GetComponentOrigin(float &_arg1,float &_arg2,float &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetMin()
}
%ignore GetMin(double data[3]);
%ignore GetMin(double _arg[3]);
%ignore GetMin(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetMax()
}
%ignore GetMax(double data[3]);
%ignore GetMax(double _arg[3]);
%ignore GetMax(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetMean()
}
%ignore GetMean(double data[3]);
%ignore GetMean(double _arg[3]);
%ignore GetMean(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetStandardDeviation()
}
%ignore GetStandardDeviation(double data[3]);
%ignore GetStandardDeviation(double _arg[3]);
%ignore GetStandardDeviation(double &_arg1,double &_arg2,double &_arg3);

%include vtkImageAccumulate.h
