%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkIO_typemaps.i


%{
#include "vtkVolumeReader.h"
%}

%import vtkImageSource.h


%{
extern void vtkVolumeReader_freefunc(void *ptr)
{
    vtkVolumeReader *obj;
    obj = (vtkVolumeReader*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) int value[2] {
  int i;
  $result = rb_ary_new2(2);
  for (i=0; i<2; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[2]{
   int *GetImageRange()
}
%ignore GetImageRange(int data[2]);
%ignore GetImageRange(int _arg[2]);
%ignore GetImageRange(int &_arg1,int &_arg2);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetDataSpacing()
}
%ignore GetDataSpacing(float data[3]);
%ignore GetDataSpacing(float _arg[3]);
%ignore GetDataSpacing(float &_arg1,float &_arg2,float &_arg3);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetDataOrigin()
}
%ignore GetDataOrigin(float data[3]);
%ignore GetDataOrigin(float _arg[3]);
%ignore GetDataOrigin(float &_arg1,float &_arg2,float &_arg3);

%include vtkVolumeReader.h
