%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkHybrid_typemaps.i


%{
#include "vtkTransformToGrid.h"
%}

%import vtkImageSource.h


%{
extern void vtkTransformToGrid_freefunc(void *ptr)
{
    vtkTransformToGrid *obj;
    obj = (vtkTransformToGrid*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) int value[6] {
  int i;
  $result = rb_ary_new2(6);
  for (i=0; i<6; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[6]{
   int *GetGridExtent()
}
%ignore GetGridExtent(int data[6]);
%ignore GetGridExtent(int _arg[6]);
%ignore GetGridExtent(int &_arg1,int &_arg2,int &_arg3,int &_arg4,int &_arg5,int &_arg6);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetGridOrigin()
}
%ignore GetGridOrigin(float data[3]);
%ignore GetGridOrigin(float _arg[3]);
%ignore GetGridOrigin(float &_arg1,float &_arg2,float &_arg3);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetGridSpacing()
}
%ignore GetGridSpacing(float data[3]);
%ignore GetGridSpacing(float _arg[3]);
%ignore GetGridSpacing(float &_arg1,float &_arg2,float &_arg3);

%include vtkTransformToGrid.h
