%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkCommon_typemaps.i


%{
#include "vtkViewport.h"
#include "vtkActor2DCollection.h"
#include "vtkAssemblyPath.h"
#include "vtkProp.h"
#include "vtkPropCollection.h"
#include "vtkWindow.h"
%}

%import vtkObject.h


%{
extern void vtkViewport_freefunc(void *ptr)
{
    vtkViewport *obj;
    obj = (vtkViewport*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetBackground()
}
%ignore GetBackground(float data[3]);
%ignore GetBackground(float _arg[3]);
%ignore GetBackground(float &_arg1,float &_arg2,float &_arg3);

%typemap(ruby,out) float value[2] {
  int i;
  $result = rb_ary_new2(2);
  for (i=0; i<2; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[2]{
   float *GetAspect()
}
%ignore GetAspect(float data[2]);
%ignore GetAspect(float _arg[2]);
%ignore GetAspect(float &_arg1,float &_arg2);

%typemap(ruby,out) float value[2] {
  int i;
  $result = rb_ary_new2(2);
  for (i=0; i<2; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[2]{
   float *GetPixelAspect()
}
%ignore GetPixelAspect(float data[2]);
%ignore GetPixelAspect(float _arg[2]);
%ignore GetPixelAspect(float &_arg1,float &_arg2);

%typemap(ruby,out) float value[4] {
  int i;
  $result = rb_ary_new2(4);
  for (i=0; i<4; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[4]{
   float *GetViewport()
}
%ignore GetViewport(float data[4]);
%ignore GetViewport(float _arg[4]);
%ignore GetViewport(float &_arg1,float &_arg2,float &_arg3,float &_arg4);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetDisplayPoint()
}
%ignore GetDisplayPoint(float data[3]);
%ignore GetDisplayPoint(float _arg[3]);
%ignore GetDisplayPoint(float &_arg1,float &_arg2,float &_arg3);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetViewPoint()
}
%ignore GetViewPoint(float data[3]);
%ignore GetViewPoint(float _arg[3]);
%ignore GetViewPoint(float &_arg1,float &_arg2,float &_arg3);

%typemap(ruby,out) float value[4] {
  int i;
  $result = rb_ary_new2(4);
  for (i=0; i<4; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[4]{
   float *GetWorldPoint()
}
%ignore GetWorldPoint(float data[4]);
%ignore GetWorldPoint(float _arg[4]);
%ignore GetWorldPoint(float &_arg1,float &_arg2,float &_arg3,float &_arg4);

%include vtkViewport.h
