#
# color3.rb
#   $Id: color3.rb,v 1.1 2000/11/18 19:03:31 keiko Exp $
#


require "narray"
require "numru/dcl"
include NumRu
include Math


nx = 21
ny = 21
xmin = -10
xmax = 10
ymin = -10
ymax = 10
dx1 = 1
dx2 = 5
dy1 = 1
dy2 = 5
kmax = 56
pmin = 0
pmax = 1
p = NArray.sfloat(nx, ny)
pi = NArray.sfloat(2, kmax+1)

#-- data ---
for j in 0..ny-1
  for i in 0..nx-1
    x = xmin + (xmax-xmin)*i/(nx-1).to_f
    y = ymin + (ymax-ymin)*j/(ny-1).to_f
    p[i,j] = exp(-x**2/64 -y**2/25)
  end
end

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm

DCL::grswnd(xmin, xmax, ymin, ymax)
DCL::grsvpt(0.2, 0.8, 0.2, 0.8)
DCL::grstrn(1)
DCL::grstrf

dp = (pmax-pmin)/kmax.to_f
for k in 1..kmax
  tlev1 = (k-1)*dp
  tlev2 = tlev1 + dp
  ipat  = (29+k)*1000 + 999
  DCL::uestlv(tlev1, tlev2, ipat)
end

DCL::uetone(p)
DCL::usdaxs

#-- ȡС ----
DCL::grswnd(0.0, 1.0, pmin, pmax)
DCL::grsvpt(0.85, 0.9, 0.2, 0.8)
DCL::grstrn(1)
DCL::grstrf

for k in 0..kmax
  pi[0,k] = pmin + k*dp
  pi[1,k] = pmin + k*dp
end

DCL::uetone(pi)

DCL::slpvpr(3)
DCL::uzlset('LABELYR', true)

DCL::uzfact(0.8)
DCL::uysfmt('(F4.1)')
DCL::uyaxdv('R', 0.1, 0.2)

DCL::grcls

