require "narray"
if /cygwin|mingw|darwin/ =~ RUBY_PLATFORM
  begin
    require "glib2"
  rescue LoadError
  end
end

require "numru/dcl_raw"
module NumRu
    module DCL
      init_arg($0,ARGV) if DCLVERSION >= "5.3.2"

      #<<< private functions >>>

      def not_nary( na )
	if defined?(NArrayMiss)
	  !na.is_a?(NArray) && !na.is_a?(NArrayMiss)
	else
	  !na.is_a?(NArray)
	end
      end
      module_function :not_nary
      private_class_method :not_nary

      #<<< ??p(set|stx|get) >>>

      %w!gl sl sg uc ud ue ug ul um uu uz!.each do |pkg|
	 %w!set stx!.each do |set|
	    eval <<-EOS
	       def #{pkg}p#{set}( name, value )
		  case name
		  when /^l/i
		     DCL.#{pkg}l#{set}(name,value)
		  when /^[i-n]/i
		     DCL.#{pkg}i#{set}(name,value)
		  else
		     DCL.#{pkg}r#{set}(name,value)
		  end
	       end
	       module_function :#{pkg}p#{set}
	    EOS
	 end
	 eval <<-EOS
	    def #{pkg}pget( name )
	       case name
	       when /^l/i
		  DCL.#{pkg}lget(name)
	       when /^[i-n]/i
		  DCL.#{pkg}iget(name)
	       else
		  DCL.#{pkg}rget(name)
	       end
	    end
	    module_function :#{pkg}pget
	 EOS
      end

      %w!us!.each do |pkg|
	 %w!set stx!.each do |set|
	    eval <<-EOS
	       def #{pkg}p#{set}( name, value )
		  case name
		  when /^c/i
		     DCL.#{pkg}c#{set}(name,value)
		  when /^l/i
		     DCL.#{pkg}l#{set}(name,value)
		  when /^[i-n]/i
		     DCL.#{pkg}i#{set}(name,value)
		  else
		     DCL.#{pkg}r#{set}(name,value)
		  end
	       end
	       module_function :#{pkg}p#{set}
	    EOS
	 end
	 eval <<-EOS
	    def #{pkg}pget( name )
	       case name
	       when /^c/i
		  DCL.#{pkg}cget(name)
	       when /^l/i
		  DCL.#{pkg}lget(name)
	       when /^[i-n]/i
		  DCL.#{pkg}iget(name)
	       else
		  DCL.#{pkg}rget(name)
	       end
	    end
	    module_function :#{pkg}pget
	 EOS
      end

      @@sw_char_params = [/^WSNAME/i,/^FONT/i,/^CL2TN$/i,/^FNAME$/i,/^TITLE$/i,
	    /^CLRMAP$/i,/^LPR$/i]
      %w!set stx!.each do |set|
         eval <<-EOS
	    def swp#{set}(name, value)
	       case name
	       when *@@sw_char_params
		  DCL.swl#{set}(name,value)
	       when /^l/i
		  DCL.swl#{set}(name,value)
	       when /^[i-n]/i
		  DCL.swi#{set}(name,value)
	       else
		  DCL.swr#{set}(name,value)
	       end
	    end
	    module_function :swp#{set}
	 EOS
      end
      def swpget( name )
	 case name
	 when *@@sw_char_params
	    DCL.swcget(name)
	 when /^l/i
	    DCL.swlget(name)
	 when /^[i-n]/i
	    DCL.swiget(name)
	 else
	    DCL.swrget(name)
	 end
      end
      module_function :swpget


      #<<< to eliminate array length arguments >>>

      alias __scplu scplu 
      def scplu( upx,upy,upz )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_upx_0 = upx.length
        n = len_upx_0

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if upx.length != (n)
        raise "Invalid array length: upy.length != n" if upy.length != (n)
        raise "Invalid array length: upz.length != n" if upz.length != (n)

        #< call the original method >
        __scplu( n,upx,upy,upz )
      end
      module_function :scplu, :__scplu 
      private_class_method :__scplu

      alias __scplv scplv 
      def scplv( vpx,vpy,vpz )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_vpx_0 = vpx.length
        n = len_vpx_0

        #< check array size(s) >
        raise "Invalid array length: vpx.length != n" if vpx.length != (n)
        raise "Invalid array length: vpy.length != n" if vpy.length != (n)
        raise "Invalid array length: vpz.length != n" if vpz.length != (n)

        #< call the original method >
        __scplv( n,vpx,vpy,vpz )
      end
      module_function :scplv, :__scplv 
      private_class_method :__scplv

      alias __scplzu scplzu 
      def scplzu( upx,upy,upz,index )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_upx_0 = upx.length
        n = len_upx_0

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if upx.length != (n)
        raise "Invalid array length: upy.length != n" if upy.length != (n)
        raise "Invalid array length: upz.length != n" if upz.length != (n)

        #< call the original method >
        __scplzu( n,upx,upy,upz,index )
      end
      module_function :scplzu, :__scplzu 
      private_class_method :__scplzu

      alias __scplzv scplzv 
      def scplzv( vpx,vpy,vpz,index )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_vpx_0 = vpx.length
        n = len_vpx_0

        #< check array size(s) >
        raise "Invalid array length: vpx.length != n" if vpx.length != (n)
        raise "Invalid array length: vpy.length != n" if vpy.length != (n)
        raise "Invalid array length: vpz.length != n" if vpz.length != (n)

        #< call the original method >
        __scplzv( n,vpx,vpy,vpz,index )
      end
      module_function :scplzv, :__scplzv 
      private_class_method :__scplzv

      alias __scpmu scpmu 
      def scpmu( upx,upy,upz )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_upx_0 = upx.length
        n = len_upx_0

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if upx.length != (n)
        raise "Invalid array length: upy.length != n" if upy.length != (n)
        raise "Invalid array length: upz.length != n" if upz.length != (n)

        #< call the original method >
        __scpmu( n,upx,upy,upz )
      end
      module_function :scpmu, :__scpmu 
      private_class_method :__scpmu

      alias __scpmv scpmv 
      def scpmv( vpx,vpy,vpz )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_vpx_0 = vpx.length
        n = len_vpx_0

        #< check array size(s) >
        raise "Invalid array length: vpx.length != n" if vpx.length != (n)
        raise "Invalid array length: vpy.length != n" if vpy.length != (n)
        raise "Invalid array length: vpz.length != n" if vpz.length != (n)

        #< call the original method >
        __scpmv( n,vpx,vpy,vpz )
      end
      module_function :scpmv, :__scpmv 
      private_class_method :__scpmv

      alias __scpmzu scpmzu 
      def scpmzu( upx,upy,upz,itype,index,rsize )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_upx_0 = upx.length
        n = len_upx_0

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if upx.length != (n)
        raise "Invalid array length: upy.length != n" if upy.length != (n)
        raise "Invalid array length: upz.length != n" if upz.length != (n)

        #< call the original method >
        __scpmzu( n,upx,upy,upz,itype,index,rsize )
      end
      module_function :scpmzu, :__scpmzu 
      private_class_method :__scpmzu

      alias __scpmzv scpmzv 
      def scpmzv( vpx,vpy,vpz,itype,index,rsize )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_vpx_0 = vpx.length
        n = len_vpx_0

        #< check array size(s) >
        raise "Invalid array length: vpx.length != n" if vpx.length != (n)
        raise "Invalid array length: vpy.length != n" if vpy.length != (n)
        raise "Invalid array length: vpz.length != n" if vpz.length != (n)

        #< call the original method >
        __scpmzv( n,vpx,vpy,vpz,itype,index,rsize )
      end
      module_function :scpmzv, :__scpmzv 
      private_class_method :__scpmzv

      alias __sctnu sctnu 
      def sctnu( upx,upy,upz )

        #< check array size(s) >
        raise "Invalid array length: upx.length != 3" if upx.length != (3)
        raise "Invalid array length: upy.length != 3" if upy.length != (3)
        raise "Invalid array length: upz.length != 3" if upz.length != (3)

        #< call the original method >
        __sctnu( upx,upy,upz )
      end
      module_function :sctnu, :__sctnu 
      private_class_method :__sctnu

      alias __sctnv sctnv 
      def sctnv( vpx,vpy,vpz )

        #< check array size(s) >
        raise "Invalid array length: vpx.length != 3" if vpx.length != (3)
        raise "Invalid array length: vpy.length != 3" if vpy.length != (3)
        raise "Invalid array length: vpz.length != 3" if vpz.length != (3)

        #< call the original method >
        __sctnv( vpx,vpy,vpz )
      end
      module_function :sctnv, :__sctnv 
      private_class_method :__sctnv

      alias __sctnzu sctnzu 
      def sctnzu( upx,upy,upz,itpat1,itpat2 )

        #< check array size(s) >
        raise "Invalid array length: upx.length != 3" if upx.length != (3)
        raise "Invalid array length: upy.length != 3" if upy.length != (3)
        raise "Invalid array length: upz.length != 3" if upz.length != (3)

        #< call the original method >
        __sctnzu( upx,upy,upz,itpat1,itpat2 )
      end
      module_function :sctnzu, :__sctnzu 
      private_class_method :__sctnzu

      alias __sctnzv sctnzv 
      def sctnzv( vpx,vpy,vpz,itpat1,itpat2 )

        #< check array size(s) >
        raise "Invalid array length: vpx.length != 3" if vpx.length != (3)
        raise "Invalid array length: vpy.length != 3" if vpy.length != (3)
        raise "Invalid array length: vpz.length != 3" if vpz.length != (3)

        #< call the original method >
        __sctnzv( vpx,vpy,vpz,itpat1,itpat2 )
      end
      module_function :sctnzv, :__sctnzv 
      private_class_method :__sctnzv

      alias __sgplu sgplu 
      def sgplu( upx,upy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_upx_0 = upx.length
        n = len_upx_0

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if upx.length != (n)
        raise "Invalid array length: upy.length != n" if upy.length != (n)

        #< call the original method >
        __sgplu( n,upx,upy )
      end
      module_function :sgplu, :__sgplu 
      private_class_method :__sgplu

      alias __sgplv sgplv 
      def sgplv( vpx,vpy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_vpx_0 = vpx.length
        n = len_vpx_0

        #< check array size(s) >
        raise "Invalid array length: vpx.length != n" if vpx.length != (n)
        raise "Invalid array length: vpy.length != n" if vpy.length != (n)

        #< call the original method >
        __sgplv( n,vpx,vpy )
      end
      module_function :sgplv, :__sgplv 
      private_class_method :__sgplv

      alias __sgplr sgplr 
      def sgplr( rpx,rpy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_rpx_0 = rpx.length
        n = len_rpx_0

        #< check array size(s) >
        raise "Invalid array length: rpx.length != n" if rpx.length != (n)
        raise "Invalid array length: rpy.length != n" if rpy.length != (n)

        #< call the original method >
        __sgplr( n,rpx,rpy )
      end
      module_function :sgplr, :__sgplr 
      private_class_method :__sgplr

      alias __sgplzu sgplzu 
      def sgplzu( upx,upy,itype,index )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_upx_0 = upx.length
        n = len_upx_0

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if upx.length != (n)
        raise "Invalid array length: upy.length != n" if upy.length != (n)

        #< call the original method >
        __sgplzu( n,upx,upy,itype,index )
      end
      module_function :sgplzu, :__sgplzu 
      private_class_method :__sgplzu

      alias __sgplzv sgplzv 
      def sgplzv( vpx,vpy,itype,index )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_vpx_0 = vpx.length
        n = len_vpx_0

        #< check array size(s) >
        raise "Invalid array length: vpx.length != n" if vpx.length != (n)
        raise "Invalid array length: vpy.length != n" if vpy.length != (n)

        #< call the original method >
        __sgplzv( n,vpx,vpy,itype,index )
      end
      module_function :sgplzv, :__sgplzv 
      private_class_method :__sgplzv

      alias __sgplzr sgplzr 
      def sgplzr( rpx,rpy,itype,index )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_rpx_0 = rpx.length
        n = len_rpx_0

        #< check array size(s) >
        raise "Invalid array length: rpx.length != n" if rpx.length != (n)
        raise "Invalid array length: rpy.length != n" if rpy.length != (n)

        #< call the original method >
        __sgplzr( n,rpx,rpy,itype,index )
      end
      module_function :sgplzr, :__sgplzr 
      private_class_method :__sgplzr

      alias __sgpmu sgpmu 
      def sgpmu( upx,upy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_upx_0 = upx.length
        n = len_upx_0

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if upx.length != (n)
        raise "Invalid array length: upy.length != n" if upy.length != (n)

        #< call the original method >
        __sgpmu( n,upx,upy )
      end
      module_function :sgpmu, :__sgpmu 
      private_class_method :__sgpmu

      alias __sgpmv sgpmv 
      def sgpmv( vpx,vpy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_vpx_0 = vpx.length
        n = len_vpx_0

        #< check array size(s) >
        raise "Invalid array length: vpx.length != n" if vpx.length != (n)
        raise "Invalid array length: vpy.length != n" if vpy.length != (n)

        #< call the original method >
        __sgpmv( n,vpx,vpy )
      end
      module_function :sgpmv, :__sgpmv 
      private_class_method :__sgpmv

      alias __sgpmr sgpmr 
      def sgpmr( rpx,rpy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_rpx_0 = rpx.length
        n = len_rpx_0

        #< check array size(s) >
        raise "Invalid array length: rpx.length != n" if rpx.length != (n)
        raise "Invalid array length: rpy.length != n" if rpy.length != (n)

        #< call the original method >
        __sgpmr( n,rpx,rpy )
      end
      module_function :sgpmr, :__sgpmr 
      private_class_method :__sgpmr

      alias __sgpmzu sgpmzu 
      def sgpmzu( upx,upy,itype,index,rsize )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_upx_0 = upx.length
        n = len_upx_0

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if upx.length != (n)
        raise "Invalid array length: upy.length != n" if upy.length != (n)

        #< call the original method >
        __sgpmzu( n,upx,upy,itype,index,rsize )
      end
      module_function :sgpmzu, :__sgpmzu 
      private_class_method :__sgpmzu

      alias __sgpmzv sgpmzv 
      def sgpmzv( vpx,vpy,itype,index,rsize )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_vpx_0 = vpx.length
        n = len_vpx_0

        #< check array size(s) >
        raise "Invalid array length: vpx.length != n" if vpx.length != (n)
        raise "Invalid array length: vpy.length != n" if vpy.length != (n)

        #< call the original method >
        __sgpmzv( n,vpx,vpy,itype,index,rsize )
      end
      module_function :sgpmzv, :__sgpmzv 
      private_class_method :__sgpmzv

      alias __sgpmzr sgpmzr 
      def sgpmzr( rpx,rpy,itype,index,rsize )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_rpx_0 = rpx.length
        n = len_rpx_0

        #< check array size(s) >
        raise "Invalid array length: rpx.length != n" if rpx.length != (n)
        raise "Invalid array length: rpy.length != n" if rpy.length != (n)

        #< call the original method >
        __sgpmzr( n,rpx,rpy,itype,index,rsize )
      end
      module_function :sgpmzr, :__sgpmzr 
      private_class_method :__sgpmzr

      alias __sgtnu sgtnu 
      def sgtnu( upx,upy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_upx_0 = upx.length
        n = len_upx_0

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if upx.length != (n)
        raise "Invalid array length: upy.length != n" if upy.length != (n)

        #< call the original method >
        __sgtnu( n,upx,upy )
      end
      module_function :sgtnu, :__sgtnu 
      private_class_method :__sgtnu

      alias __sgtnv sgtnv 
      def sgtnv( vpx,vpy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_vpx_0 = vpx.length
        n = len_vpx_0

        #< check array size(s) >
        raise "Invalid array length: vpx.length != n" if vpx.length != (n)
        raise "Invalid array length: vpy.length != n" if vpy.length != (n)

        #< call the original method >
        __sgtnv( n,vpx,vpy )
      end
      module_function :sgtnv, :__sgtnv 
      private_class_method :__sgtnv

      alias __sgtnr sgtnr 
      def sgtnr( rpx,rpy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_rpx_0 = rpx.length
        n = len_rpx_0

        #< check array size(s) >
        raise "Invalid array length: rpx.length != n" if rpx.length != (n)
        raise "Invalid array length: rpy.length != n" if rpy.length != (n)

        #< call the original method >
        __sgtnr( n,rpx,rpy )
      end
      module_function :sgtnr, :__sgtnr 
      private_class_method :__sgtnr

      alias __sgtnzu sgtnzu 
      def sgtnzu( upx,upy,itpat )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_upx_0 = upx.length
        n = len_upx_0

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if upx.length != (n)
        raise "Invalid array length: upy.length != n" if upy.length != (n)

        #< call the original method >
        __sgtnzu( n,upx,upy,itpat )
      end
      module_function :sgtnzu, :__sgtnzu 
      private_class_method :__sgtnzu

      alias __sgtnzv sgtnzv 
      def sgtnzv( vpx,vpy,itpat )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_vpx_0 = vpx.length
        n = len_vpx_0

        #< check array size(s) >
        raise "Invalid array length: vpx.length != n" if vpx.length != (n)
        raise "Invalid array length: vpy.length != n" if vpy.length != (n)

        #< call the original method >
        __sgtnzv( n,vpx,vpy,itpat )
      end
      module_function :sgtnzv, :__sgtnzv 
      private_class_method :__sgtnzv

      alias __sgtnzr sgtnzr 
      def sgtnzr( rpx,rpy,itpat )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_rpx_0 = rpx.length
        n = len_rpx_0

        #< check array size(s) >
        raise "Invalid array length: rpx.length != n" if rpx.length != (n)
        raise "Invalid array length: rpy.length != n" if rpy.length != (n)

        #< call the original method >
        __sgtnzr( n,rpx,rpy,itpat )
      end
      module_function :sgtnzr, :__sgtnzr 
      private_class_method :__sgtnzr

      if DCLVERSION >= '5.3'
      end

      if DCLVERSION >= '5.3'
      end

      if DCLVERSION >= '5.3'
      end

      if DCLVERSION >= '5.3'
      end

      if DCLVERSION >= '5.3'
      end

      if DCLVERSION >= '5.3'
      end

      if DCLVERSION >= '5.3'
      end

      alias __swgton swgton 
      def swgton( wpx,wpy,itpat )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_wpx_0 = wpx.length
        np = len_wpx_0

        #< check array size(s) >
        raise "Invalid array length: wpx.length != np" if wpx.length != (np)
        raise "Invalid array length: wpy.length != np" if wpy.length != (np)

        #< call the original method >
        __swgton( np,wpx,wpy,itpat )
      end
      module_function :swgton, :__swgton 
      private_class_method :__swgton

      alias __swidat swidat 
      def swidat( image )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_image_0 = image.length
        nlen = len_image_0

        #< check array size(s) >
        raise "Invalid array length: image.length != nlen" if image.length != (nlen)

        #< call the original method >
        __swidat( image,nlen )
      end
      module_function :swidat, :__swidat 
      private_class_method :__swidat

      if DCLVERSION >= '5.3'
      end

      if DCLVERSION >= '5.3'
      end

      if DCLVERSION >= '5.3'
      end

      if DCLVERSION >= '5.3'
      end

      if DCLVERSION >= '5.3'
      end

      alias __udcntr udcntr 
      def udcntr( z )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ( not_nary(z) || (z.rank < 1) )
          raise "z must be a NArray of rank == 2"
        end
        len_z_0 = z.shape[0]
        nx = len_z_0
        if ( not_nary(z) || (z.rank < 2) )
          raise "z must be a NArray of rank == 2"
        end
        len_z_1 = z.shape[1]
        ny = len_z_1

        #< check array size(s) >
        raise "Invalid array shape: z.shape[0] != nx" if z.shape[0] != (nx)
        raise "Invalid array shape: z.shape[1] != ny" if z.shape[1] != (ny)

        #< call the original method >
        __udcntr( z,nx,nx,ny )
      end
      module_function :udcntr, :__udcntr 
      private_class_method :__udcntr

      alias __udcntz udcntz 
      def udcntz( z )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ( not_nary(z) || (z.rank < 1) )
          raise "z must be a NArray of rank == 2"
        end
        len_z_0 = z.shape[0]
        nx = len_z_0
        if ( not_nary(z) || (z.rank < 2) )
          raise "z must be a NArray of rank == 2"
        end
        len_z_1 = z.shape[1]
        ny = len_z_1

        # derivation of nbr2 is provied aditionally in the method post_filter:
        nbr2 = (nx+2)*(ny+2)*6/32+4

        #< check array size(s) >
        raise "Invalid array shape: z.shape[0] != nx" if z.shape[0] != (nx)
        raise "Invalid array shape: z.shape[1] != ny" if z.shape[1] != (ny)

        #< call the original method >
        __udcntz( z,nx,nx,ny,nbr2 )
      end
      module_function :udcntz, :__udcntz 
      private_class_method :__udcntz

      alias __udgclb udgclb 
      def udgclb( z,dx )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ( not_nary(z) || (z.rank < 1) )
          raise "z must be a NArray of rank == 2"
        end
        len_z_0 = z.shape[0]
        nx = len_z_0
        if ( not_nary(z) || (z.rank < 2) )
          raise "z must be a NArray of rank == 2"
        end
        len_z_1 = z.shape[1]
        ny = len_z_1

        #< check array size(s) >
        raise "Invalid array shape: z.shape[0] != nx" if z.shape[0] != (nx)
        raise "Invalid array shape: z.shape[1] != ny" if z.shape[1] != (ny)

        #< call the original method >
        __udgclb( z,nx,nx,ny,dx )
      end
      module_function :udgclb, :__udgclb 
      private_class_method :__udgclb

      alias __uetone uetone 
      def uetone( z )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ( not_nary(z) || (z.rank < 1) )
          raise "z must be a NArray of rank == 2"
        end
        len_z_0 = z.shape[0]
        nx = len_z_0
        if ( not_nary(z) || (z.rank < 2) )
          raise "z must be a NArray of rank == 2"
        end
        len_z_1 = z.shape[1]
        ny = len_z_1

        #< check array size(s) >
        raise "Invalid array shape: z.shape[0] != nx" if z.shape[0] != (nx)
        raise "Invalid array shape: z.shape[1] != ny" if z.shape[1] != (ny)

        #< call the original method >
        __uetone( z,nx,nx,ny )
      end
      module_function :uetone, :__uetone 
      private_class_method :__uetone

      alias __uetonf uetonf 
      def uetonf( z )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ( not_nary(z) || (z.rank < 1) )
          raise "z must be a NArray of rank == 2"
        end
        len_z_0 = z.shape[0]
        nx = len_z_0
        if ( not_nary(z) || (z.rank < 2) )
          raise "z must be a NArray of rank == 2"
        end
        len_z_1 = z.shape[1]
        ny = len_z_1

        #< check array size(s) >
        raise "Invalid array shape: z.shape[0] != nx" if z.shape[0] != (nx)
        raise "Invalid array shape: z.shape[1] != ny" if z.shape[1] != (ny)

        #< call the original method >
        __uetonf( z,nx,nx,ny )
      end
      module_function :uetonf, :__uetonf 
      private_class_method :__uetonf

      alias __uetonc uetonc 
      def uetonc( z )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ( not_nary(z) || (z.rank < 1) )
          raise "z must be a NArray of rank == 2"
        end
        len_z_0 = z.shape[0]
        nx = len_z_0
        if ( not_nary(z) || (z.rank < 2) )
          raise "z must be a NArray of rank == 2"
        end
        len_z_1 = z.shape[1]
        ny = len_z_1

        #< check array size(s) >
        raise "Invalid array shape: z.shape[0] != nx" if z.shape[0] != (nx)
        raise "Invalid array shape: z.shape[1] != ny" if z.shape[1] != (ny)

        #< call the original method >
        __uetonc( z,nx,nx,ny )
      end
      module_function :uetonc, :__uetonc 
      private_class_method :__uetonc

      alias __uezchk uezchk 
      def uezchk( z,cname )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ( not_nary(z) || (z.rank < 1) )
          raise "z must be a NArray of rank == 2"
        end
        len_z_0 = z.shape[0]
        nx = len_z_0
        if ( not_nary(z) || (z.rank < 2) )
          raise "z must be a NArray of rank == 2"
        end
        len_z_1 = z.shape[1]
        ny = len_z_1

        #< check array size(s) >
        raise "Invalid array shape: z.shape[0] != nx" if z.shape[0] != (nx)
        raise "Invalid array shape: z.shape[1] != ny" if z.shape[1] != (ny)

        #< call the original method >
        __uezchk( z,nx,nx,ny,cname )
      end
      module_function :uezchk, :__uezchk 
      private_class_method :__uezchk

      alias __uegtlb uegtlb 
      def uegtlb( z,dx )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ( not_nary(z) || (z.rank < 1) )
          raise "z must be a NArray of rank == 2"
        end
        len_z_0 = z.shape[0]
        nx = len_z_0
        if ( not_nary(z) || (z.rank < 2) )
          raise "z must be a NArray of rank == 2"
        end
        len_z_1 = z.shape[1]
        ny = len_z_1

        #< check array size(s) >
        raise "Invalid array shape: z.shape[0] != nx" if z.shape[0] != (nx)
        raise "Invalid array shape: z.shape[1] != ny" if z.shape[1] != (ny)

        #< call the original method >
        __uegtlb( z,nx,nx,ny,dx )
      end
      module_function :uegtlb, :__uegtlb 
      private_class_method :__uegtlb

      alias __uestln uestln 
      def uestln( tlevn,ipatn )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_tlevn_0 = tlevn.length
        nton = len_tlevn_0 - 1

        #< check array size(s) >
        raise "Invalid array length: tlevn.length != nton+1" if tlevn.length != (nton+1)
        raise "Invalid array length: ipatn.length != nton" if ipatn.length != (nton)

        #< call the original method >
        __uestln( tlevn,ipatn,nton )
      end
      module_function :uestln, :__uestln 
      private_class_method :__uestln

      alias __ugvect ugvect 
      def ugvect( u,v )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ( not_nary(u) || (u.rank < 1) )
          raise "u must be a NArray of rank == 2"
        end
        len_u_0 = u.shape[0]
        nx = len_u_0
        if ( not_nary(u) || (u.rank < 2) )
          raise "u must be a NArray of rank == 2"
        end
        len_u_1 = u.shape[1]
        ny = len_u_1

        #< check array size(s) >
        raise "Invalid array shape: u.shape[0] != nx" if u.shape[0] != (nx)
        raise "Invalid array shape: u.shape[1] != ny" if u.shape[1] != (ny)
        raise "Invalid array shape: v.shape[0] != nx" if v.shape[0] != (nx)
        raise "Invalid array shape: v.shape[1] != ny" if v.shape[1] != (ny)

        #< call the original method >
        __ugvect( u,nx,v,nx,nx,ny )
      end
      module_function :ugvect, :__ugvect 
      private_class_method :__ugvect

      alias __uherb uherb 
      def uherb( upx1,upx2,upy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx1 == nil || upx1.is_a?(Float) && lreq( upx1, glrget("RUNDEF") ) )
          len_upx1_0 = upx1.length
          n = len_upx1_0
        else
          upx1 = glrget("RUNDEF") if ( upx1 == nil )
          if ! ( upx2 == nil || upx2.is_a?(Float) && lreq( upx2, glrget("RUNDEF") ) )
            len_upx2_0 = upx2.length
            n = len_upx2_0
          else
            upx2 = glrget("RUNDEF") if ( upx2 == nil )
            len_upy_0 = upy.length
            n = len_upy_0
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx1.length != n" if \
            upx1!=nil && !( upx1.is_a?(Float) && lreq(upx1,glrget("RUNDEF")) ) && upx1.length != (n)
        raise "Invalid array length: upx2.length != n" if \
            upx2!=nil && !( upx2.is_a?(Float) && lreq(upx2,glrget("RUNDEF")) ) && upx2.length != (n)
        raise "Invalid array length: upy.length != n" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n)

        #< call the original method >
        __uherb( n,upx1,upx2,upy )
      end
      module_function :uherb, :__uherb 
      private_class_method :__uherb

      alias __uherbz uherbz 
      def uherbz( upx1,upx2,upy,itype,index,rsize )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx1 == nil || upx1.is_a?(Float) && lreq( upx1, glrget("RUNDEF") ) )
          len_upx1_0 = upx1.length
          n = len_upx1_0
        else
          upx1 = glrget("RUNDEF") if ( upx1 == nil )
          if ! ( upx2 == nil || upx2.is_a?(Float) && lreq( upx2, glrget("RUNDEF") ) )
            len_upx2_0 = upx2.length
            n = len_upx2_0
          else
            upx2 = glrget("RUNDEF") if ( upx2 == nil )
            len_upy_0 = upy.length
            n = len_upy_0
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx1.length != n" if \
            upx1!=nil && !( upx1.is_a?(Float) && lreq(upx1,glrget("RUNDEF")) ) && upx1.length != (n)
        raise "Invalid array length: upx2.length != n" if \
            upx2!=nil && !( upx2.is_a?(Float) && lreq(upx2,glrget("RUNDEF")) ) && upx2.length != (n)
        raise "Invalid array length: upy.length != n" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n)

        #< call the original method >
        __uherbz( n,upx1,upx2,upy,itype,index,rsize )
      end
      module_function :uherbz, :__uherbz 
      private_class_method :__uherbz

      alias __uhdif uhdif 
      def uhdif( upx1,upx2,upy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx1 == nil || upx1.is_a?(Float) && lreq( upx1, glrget("RUNDEF") ) )
          len_upx1_0 = upx1.length
          n = len_upx1_0
        else
          upx1 = glrget("RUNDEF") if ( upx1 == nil )
          if ! ( upx2 == nil || upx2.is_a?(Float) && lreq( upx2, glrget("RUNDEF") ) )
            len_upx2_0 = upx2.length
            n = len_upx2_0
          else
            upx2 = glrget("RUNDEF") if ( upx2 == nil )
            len_upy_0 = upy.length
            n = len_upy_0
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx1.length != n" if \
            upx1!=nil && !( upx1.is_a?(Float) && lreq(upx1,glrget("RUNDEF")) ) && upx1.length != (n)
        raise "Invalid array length: upx2.length != n" if \
            upx2!=nil && !( upx2.is_a?(Float) && lreq(upx2,glrget("RUNDEF")) ) && upx2.length != (n)
        raise "Invalid array length: upy.length != n" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n)

        #< call the original method >
        __uhdif( n,upx1,upx2,upy )
      end
      module_function :uhdif, :__uhdif 
      private_class_method :__uhdif

      alias __uhdifz uhdifz 
      def uhdifz( upx1,upx2,upy,itpat1,itpat2 )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx1 == nil || upx1.is_a?(Float) && lreq( upx1, glrget("RUNDEF") ) )
          len_upx1_0 = upx1.length
          n = len_upx1_0
        else
          upx1 = glrget("RUNDEF") if ( upx1 == nil )
          if ! ( upx2 == nil || upx2.is_a?(Float) && lreq( upx2, glrget("RUNDEF") ) )
            len_upx2_0 = upx2.length
            n = len_upx2_0
          else
            upx2 = glrget("RUNDEF") if ( upx2 == nil )
            len_upy_0 = upy.length
            n = len_upy_0
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx1.length != n" if \
            upx1!=nil && !( upx1.is_a?(Float) && lreq(upx1,glrget("RUNDEF")) ) && upx1.length != (n)
        raise "Invalid array length: upx2.length != n" if \
            upx2!=nil && !( upx2.is_a?(Float) && lreq(upx2,glrget("RUNDEF")) ) && upx2.length != (n)
        raise "Invalid array length: upy.length != n" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n)

        #< call the original method >
        __uhdifz( n,upx1,upx2,upy,itpat1,itpat2 )
      end
      module_function :uhdifz, :__uhdifz 
      private_class_method :__uhdifz

      alias __uhbrf uhbrf 
      def uhbrf( upx1,upx2,upy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx1 == nil || upx1.is_a?(Float) && lreq( upx1, glrget("RUNDEF") ) )
          len_upx1_0 = upx1.length
          n = len_upx1_0
        else
          upx1 = glrget("RUNDEF") if ( upx1 == nil )
          if ! ( upx2 == nil || upx2.is_a?(Float) && lreq( upx2, glrget("RUNDEF") ) )
            len_upx2_0 = upx2.length
            n = len_upx2_0
          else
            upx2 = glrget("RUNDEF") if ( upx2 == nil )
            len_upy_0 = upy.length
            n = len_upy_0
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx1.length != n" if \
            upx1!=nil && !( upx1.is_a?(Float) && lreq(upx1,glrget("RUNDEF")) ) && upx1.length != (n)
        raise "Invalid array length: upx2.length != n" if \
            upx2!=nil && !( upx2.is_a?(Float) && lreq(upx2,glrget("RUNDEF")) ) && upx2.length != (n)
        raise "Invalid array length: upy.length != n" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n)

        #< call the original method >
        __uhbrf( n,upx1,upx2,upy )
      end
      module_function :uhbrf, :__uhbrf 
      private_class_method :__uhbrf

      alias __uhbrfz uhbrfz 
      def uhbrfz( upx1,upx2,upy,itype,index,rsize )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx1 == nil || upx1.is_a?(Float) && lreq( upx1, glrget("RUNDEF") ) )
          len_upx1_0 = upx1.length
          n = len_upx1_0
        else
          upx1 = glrget("RUNDEF") if ( upx1 == nil )
          if ! ( upx2 == nil || upx2.is_a?(Float) && lreq( upx2, glrget("RUNDEF") ) )
            len_upx2_0 = upx2.length
            n = len_upx2_0
          else
            upx2 = glrget("RUNDEF") if ( upx2 == nil )
            len_upy_0 = upy.length
            n = len_upy_0
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx1.length != n" if \
            upx1!=nil && !( upx1.is_a?(Float) && lreq(upx1,glrget("RUNDEF")) ) && upx1.length != (n)
        raise "Invalid array length: upx2.length != n" if \
            upx2!=nil && !( upx2.is_a?(Float) && lreq(upx2,glrget("RUNDEF")) ) && upx2.length != (n)
        raise "Invalid array length: upy.length != n" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n)

        #< call the original method >
        __uhbrfz( n,upx1,upx2,upy,itype,index,rsize )
      end
      module_function :uhbrfz, :__uhbrfz 
      private_class_method :__uhbrfz

      alias __uhbra uhbra 
      def uhbra( upx1,upx2,upy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx1 == nil || upx1.is_a?(Float) && lreq( upx1, glrget("RUNDEF") ) )
          len_upx1_0 = upx1.length
          n = len_upx1_0
        else
          upx1 = glrget("RUNDEF") if ( upx1 == nil )
          if ! ( upx2 == nil || upx2.is_a?(Float) && lreq( upx2, glrget("RUNDEF") ) )
            len_upx2_0 = upx2.length
            n = len_upx2_0
          else
            upx2 = glrget("RUNDEF") if ( upx2 == nil )
            len_upy_0 = upy.length
            n = len_upy_0
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx1.length != n" if \
            upx1!=nil && !( upx1.is_a?(Float) && lreq(upx1,glrget("RUNDEF")) ) && upx1.length != (n)
        raise "Invalid array length: upx2.length != n" if \
            upx2!=nil && !( upx2.is_a?(Float) && lreq(upx2,glrget("RUNDEF")) ) && upx2.length != (n)
        raise "Invalid array length: upy.length != n" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n)

        #< call the original method >
        __uhbra( n,upx1,upx2,upy )
      end
      module_function :uhbra, :__uhbra 
      private_class_method :__uhbra

      alias __uhbraz uhbraz 
      def uhbraz( upx1,upx2,upy,itpat1,itpat2,rsize )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx1 == nil || upx1.is_a?(Float) && lreq( upx1, glrget("RUNDEF") ) )
          len_upx1_0 = upx1.length
          n = len_upx1_0
        else
          upx1 = glrget("RUNDEF") if ( upx1 == nil )
          if ! ( upx2 == nil || upx2.is_a?(Float) && lreq( upx2, glrget("RUNDEF") ) )
            len_upx2_0 = upx2.length
            n = len_upx2_0
          else
            upx2 = glrget("RUNDEF") if ( upx2 == nil )
            len_upy_0 = upy.length
            n = len_upy_0
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx1.length != n" if \
            upx1!=nil && !( upx1.is_a?(Float) && lreq(upx1,glrget("RUNDEF")) ) && upx1.length != (n)
        raise "Invalid array length: upx2.length != n" if \
            upx2!=nil && !( upx2.is_a?(Float) && lreq(upx2,glrget("RUNDEF")) ) && upx2.length != (n)
        raise "Invalid array length: upy.length != n" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n)

        #< call the original method >
        __uhbraz( n,upx1,upx2,upy,itpat1,itpat2,rsize )
      end
      module_function :uhbraz, :__uhbraz 
      private_class_method :__uhbraz

      alias __uhbrl uhbrl 
      def uhbrl( upx,upy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          len_upy_0 = upy.length
          n = len_upy_0
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n)
        raise "Invalid array length: upy.length != n" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n)

        #< call the original method >
        __uhbrl( n,upx,upy )
      end
      module_function :uhbrl, :__uhbrl 
      private_class_method :__uhbrl

      alias __uhbrlz uhbrlz 
      def uhbrlz( upx,upy,itype,index,rsize )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          len_upy_0 = upy.length
          n = len_upy_0
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n)
        raise "Invalid array length: upy.length != n" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n)

        #< call the original method >
        __uhbrlz( n,upx,upy,itype,index,rsize )
      end
      module_function :uhbrlz, :__uhbrlz 
      private_class_method :__uhbrlz

      alias __uhbxf uhbxf 
      def uhbxf( upx1,upx2,upy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx1 == nil || upx1.is_a?(Float) && lreq( upx1, glrget("RUNDEF") ) )
          len_upx1_0 = upx1.length
          n = len_upx1_0
        else
          upx1 = glrget("RUNDEF") if ( upx1 == nil )
          if ! ( upx2 == nil || upx2.is_a?(Float) && lreq( upx2, glrget("RUNDEF") ) )
            len_upx2_0 = upx2.length
            n = len_upx2_0
          else
            upx2 = glrget("RUNDEF") if ( upx2 == nil )
            len_upy_0 = upy.length
            n = len_upy_0 - 1
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx1.length != n" if \
            upx1!=nil && !( upx1.is_a?(Float) && lreq(upx1,glrget("RUNDEF")) ) && upx1.length != (n)
        raise "Invalid array length: upx2.length != n" if \
            upx2!=nil && !( upx2.is_a?(Float) && lreq(upx2,glrget("RUNDEF")) ) && upx2.length != (n)
        raise "Invalid array length: upy.length != n+1" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n+1)

        #< call the original method >
        __uhbxf( n,upx1,upx2,upy )
      end
      module_function :uhbxf, :__uhbxf 
      private_class_method :__uhbxf

      alias __uhbxfz uhbxfz 
      def uhbxfz( upx1,upx2,upy,itype,index )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx1 == nil || upx1.is_a?(Float) && lreq( upx1, glrget("RUNDEF") ) )
          len_upx1_0 = upx1.length
          n = len_upx1_0
        else
          upx1 = glrget("RUNDEF") if ( upx1 == nil )
          if ! ( upx2 == nil || upx2.is_a?(Float) && lreq( upx2, glrget("RUNDEF") ) )
            len_upx2_0 = upx2.length
            n = len_upx2_0
          else
            upx2 = glrget("RUNDEF") if ( upx2 == nil )
            len_upy_0 = upy.length
            n = len_upy_0 - 1
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx1.length != n" if \
            upx1!=nil && !( upx1.is_a?(Float) && lreq(upx1,glrget("RUNDEF")) ) && upx1.length != (n)
        raise "Invalid array length: upx2.length != n" if \
            upx2!=nil && !( upx2.is_a?(Float) && lreq(upx2,glrget("RUNDEF")) ) && upx2.length != (n)
        raise "Invalid array length: upy.length != n+1" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n+1)

        #< call the original method >
        __uhbxfz( n,upx1,upx2,upy,itype,index )
      end
      module_function :uhbxfz, :__uhbxfz 
      private_class_method :__uhbxfz

      alias __uhbxa uhbxa 
      def uhbxa( upx1,upx2,upy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx1 == nil || upx1.is_a?(Float) && lreq( upx1, glrget("RUNDEF") ) )
          len_upx1_0 = upx1.length
          n = len_upx1_0
        else
          upx1 = glrget("RUNDEF") if ( upx1 == nil )
          if ! ( upx2 == nil || upx2.is_a?(Float) && lreq( upx2, glrget("RUNDEF") ) )
            len_upx2_0 = upx2.length
            n = len_upx2_0
          else
            upx2 = glrget("RUNDEF") if ( upx2 == nil )
            len_upy_0 = upy.length
            n = len_upy_0 - 1
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx1.length != n" if \
            upx1!=nil && !( upx1.is_a?(Float) && lreq(upx1,glrget("RUNDEF")) ) && upx1.length != (n)
        raise "Invalid array length: upx2.length != n" if \
            upx2!=nil && !( upx2.is_a?(Float) && lreq(upx2,glrget("RUNDEF")) ) && upx2.length != (n)
        raise "Invalid array length: upy.length != n+1" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n+1)

        #< call the original method >
        __uhbxa( n,upx1,upx2,upy )
      end
      module_function :uhbxa, :__uhbxa 
      private_class_method :__uhbxa

      alias __uhbxl uhbxl 
      def uhbxl( upx,upy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          len_upy_0 = upy.length
          n = len_upy_0 - 1
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n)
        raise "Invalid array length: upy.length != n+1" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n+1)

        #< call the original method >
        __uhbxl( n,upx,upy )
      end
      module_function :uhbxl, :__uhbxl 
      private_class_method :__uhbxl

      alias __uhbxaz uhbxaz 
      def uhbxaz( upx1,upx2,upy,itpat1,itpat2 )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx1 == nil || upx1.is_a?(Float) && lreq( upx1, glrget("RUNDEF") ) )
          len_upx1_0 = upx1.length
          n = len_upx1_0
        else
          upx1 = glrget("RUNDEF") if ( upx1 == nil )
          if ! ( upx2 == nil || upx2.is_a?(Float) && lreq( upx2, glrget("RUNDEF") ) )
            len_upx2_0 = upx2.length
            n = len_upx2_0
          else
            upx2 = glrget("RUNDEF") if ( upx2 == nil )
            len_upy_0 = upy.length
            n = len_upy_0 - 1
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx1.length != n" if \
            upx1!=nil && !( upx1.is_a?(Float) && lreq(upx1,glrget("RUNDEF")) ) && upx1.length != (n)
        raise "Invalid array length: upx2.length != n" if \
            upx2!=nil && !( upx2.is_a?(Float) && lreq(upx2,glrget("RUNDEF")) ) && upx2.length != (n)
        raise "Invalid array length: upy.length != n+1" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n+1)

        #< call the original method >
        __uhbxaz( n,upx1,upx2,upy,itpat1,itpat2 )
      end
      module_function :uhbxaz, :__uhbxaz 
      private_class_method :__uhbxaz

      alias __uhbxlz uhbxlz 
      def uhbxlz( upx,upy,itype,index )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          len_upy_0 = upy.length
          n = len_upy_0 - 1
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n)
        raise "Invalid array length: upy.length != n+1" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n+1)

        #< call the original method >
        __uhbxlz( n,upx,upy,itype,index )
      end
      module_function :uhbxlz, :__uhbxlz 
      private_class_method :__uhbxlz

      alias __ulsxbl ulsxbl 
      def ulsxbl( bl )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_bl_0 = bl.length
        nbl = len_bl_0

        #< check array size(s) >
        raise "Invalid array length: bl.length != nbl" if bl.length != (nbl)

        #< call the original method >
        __ulsxbl( bl,nbl )
      end
      module_function :ulsxbl, :__ulsxbl 
      private_class_method :__ulsxbl

      alias __ulsybl ulsybl 
      def ulsybl( bl )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_bl_0 = bl.length
        nbl = len_bl_0

        #< check array size(s) >
        raise "Invalid array length: bl.length != nbl" if bl.length != (nbl)

        #< call the original method >
        __ulsybl( bl,nbl )
      end
      module_function :ulsybl, :__ulsybl 
      private_class_method :__ulsybl

      alias __umspnt umspnt 
      def umspnt( ux,uy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_ux_0 = ux.length
        n = len_ux_0

        #< check array size(s) >
        raise "Invalid array length: ux.length != n" if ux.length != (n)
        raise "Invalid array length: uy.length != n" if uy.length != (n)

        #< call the original method >
        __umspnt( n,ux,uy )
      end
      module_function :umspnt, :__umspnt 
      private_class_method :__umspnt

      if DCLVERSION >= '5.3'
      end

      alias __usgrph usgrph 
      def usgrph( x,y )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( x == nil || x.is_a?(Float) && lreq( x, glrget("RUNDEF") ) )
          len_x_0 = x.length
          n = len_x_0
        else
          x = glrget("RUNDEF") if ( x == nil )
          len_y_0 = y.length
          n = len_y_0
        end

        #< check array size(s) >
        raise "Invalid array length: x.length != n" if \
            x!=nil && !( x.is_a?(Float) && lreq(x,glrget("RUNDEF")) ) && x.length != (n)
        raise "Invalid array length: y.length != n" if \
            y!=nil && !( y.is_a?(Float) && lreq(y,glrget("RUNDEF")) ) && y.length != (n)

        #< call the original method >
        __usgrph( n,x,y )
      end
      module_function :usgrph, :__usgrph 
      private_class_method :__usgrph

      alias __usspnt usspnt 
      def usspnt( x,y )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( x == nil || x.is_a?(Float) && lreq( x, glrget("RUNDEF") ) )
          len_x_0 = x.length
          n = len_x_0
        else
          x = glrget("RUNDEF") if ( x == nil )
          len_y_0 = y.length
          n = len_y_0
        end

        #< check array size(s) >
        raise "Invalid array length: x.length != n" if \
            x!=nil && !( x.is_a?(Float) && lreq(x,glrget("RUNDEF")) ) && x.length != (n)
        raise "Invalid array length: y.length != n" if \
            y!=nil && !( y.is_a?(Float) && lreq(y,glrget("RUNDEF")) ) && y.length != (n)

        #< call the original method >
        __usspnt( n,x,y )
      end
      module_function :usspnt, :__usspnt 
      private_class_method :__usspnt

      alias __uswapz uswapz 
      def uswapz( x1,x2 )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_x1_0 = x1.length
        n = len_x1_0

        #< check array size(s) >
        raise "Invalid array length: x1.length != n" if x1.length != (n)
        raise "Invalid array length: x2.length != n" if x2.length != (n)

        #< call the original method >
        __uswapz( x1,x2,n )
      end
      module_function :uswapz, :__uswapz 
      private_class_method :__uswapz

      alias __usaxlb usaxlb 
      def usaxlb( cside,dtick,dlabel,ch,nc )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_dtick_0 = dtick.length
        n1 = len_dtick_0
        len_dlabel_0 = dlabel.length
        n2 = len_dlabel_0

        #< check array size(s) >
        raise "Invalid array length: dtick.length != n1" if dtick.length != (n1)
        raise "Invalid array length: dlabel.length != n2" if dlabel.length != (n2)
        raise "Invalid array length: ch.length != n2" if ch.length != (n2)

        #< call the original method >
        __usaxlb( cside,dtick,n1,dlabel,ch,nc,n2 )
      end
      module_function :usaxlb, :__usaxlb 
      private_class_method :__usaxlb

      alias __usaxnm usaxnm 
      def usaxnm( cside,dtick,dlabel )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_dtick_0 = dtick.length
        n1 = len_dtick_0
        len_dlabel_0 = dlabel.length
        n2 = len_dlabel_0

        #< check array size(s) >
        raise "Invalid array length: dtick.length != n1" if dtick.length != (n1)
        raise "Invalid array length: dlabel.length != n2" if dlabel.length != (n2)

        #< call the original method >
        __usaxnm( cside,dtick,n1,dlabel,n2 )
      end
      module_function :usaxnm, :__usaxnm 
      private_class_method :__usaxnm

      alias __usplbl usplbl 
      def usplbl( cside,islct,pos,ch,nc )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_pos_0 = pos.length
        n = len_pos_0

        #< check array size(s) >
        raise "Invalid array length: pos.length != n" if pos.length != (n)
        raise "Invalid array length: ch.length != n" if ch.length != (n)

        #< call the original method >
        __usplbl( cside,islct,pos,ch,nc,n )
      end
      module_function :usplbl, :__usplbl 
      private_class_method :__usplbl

      alias __uspnum uspnum 
      def uspnum( cside,islct,pos )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_pos_0 = pos.length
        n = len_pos_0

        #< check array size(s) >
        raise "Invalid array length: pos.length != n" if pos.length != (n)

        #< call the original method >
        __uspnum( cside,islct,pos,n )
      end
      module_function :uspnum, :__uspnum 
      private_class_method :__uspnum

      alias __usptmk usptmk 
      def usptmk( cside,islct,pos )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_pos_0 = pos.length
        n = len_pos_0

        #< check array size(s) >
        raise "Invalid array length: pos.length != n" if pos.length != (n)

        #< call the original method >
        __usptmk( cside,islct,pos,n )
      end
      module_function :usptmk, :__usptmk 
      private_class_method :__usptmk

      alias __uulin uulin 
      def uulin( upx,upy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          len_upy_0 = upy.length
          n = len_upy_0
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n)
        raise "Invalid array length: upy.length != n" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n)

        #< call the original method >
        __uulin( n,upx,upy )
      end
      module_function :uulin, :__uulin 
      private_class_method :__uulin

      alias __uulinz uulinz 
      def uulinz( upx,upy,itype,index )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          len_upy_0 = upy.length
          n = len_upy_0
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n)
        raise "Invalid array length: upy.length != n" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n)

        #< call the original method >
        __uulinz( n,upx,upy,itype,index )
      end
      module_function :uulinz, :__uulinz 
      private_class_method :__uulinz

      alias __uumrk uumrk 
      def uumrk( upx,upy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          len_upy_0 = upy.length
          n = len_upy_0
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n)
        raise "Invalid array length: upy.length != n" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n)

        #< call the original method >
        __uumrk( n,upx,upy )
      end
      module_function :uumrk, :__uumrk 
      private_class_method :__uumrk

      alias __uumrkz uumrkz 
      def uumrkz( upx,upy,itype,index,rsize )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          len_upy_0 = upy.length
          n = len_upy_0
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n)
        raise "Invalid array length: upy.length != n" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n)

        #< call the original method >
        __uumrkz( n,upx,upy,itype,index,rsize )
      end
      module_function :uumrkz, :__uumrkz 
      private_class_method :__uumrkz

      alias __uverb uverb 
      def uverb( upx,upy1,upy2 )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          if ! ( upy1 == nil || upy1.is_a?(Float) && lreq( upy1, glrget("RUNDEF") ) )
            len_upy1_0 = upy1.length
            n = len_upy1_0
          else
            upy1 = glrget("RUNDEF") if ( upy1 == nil )
            len_upy2_0 = upy2.length
            n = len_upy2_0
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n)
        raise "Invalid array length: upy1.length != n" if \
            upy1!=nil && !( upy1.is_a?(Float) && lreq(upy1,glrget("RUNDEF")) ) && upy1.length != (n)
        raise "Invalid array length: upy2.length != n" if \
            upy2!=nil && !( upy2.is_a?(Float) && lreq(upy2,glrget("RUNDEF")) ) && upy2.length != (n)

        #< call the original method >
        __uverb( n,upx,upy1,upy2 )
      end
      module_function :uverb, :__uverb 
      private_class_method :__uverb

      alias __uverbz uverbz 
      def uverbz( upx,upy1,upy2,itype,index,rsize )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          if ! ( upy1 == nil || upy1.is_a?(Float) && lreq( upy1, glrget("RUNDEF") ) )
            len_upy1_0 = upy1.length
            n = len_upy1_0
          else
            upy1 = glrget("RUNDEF") if ( upy1 == nil )
            len_upy2_0 = upy2.length
            n = len_upy2_0
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n)
        raise "Invalid array length: upy1.length != n" if \
            upy1!=nil && !( upy1.is_a?(Float) && lreq(upy1,glrget("RUNDEF")) ) && upy1.length != (n)
        raise "Invalid array length: upy2.length != n" if \
            upy2!=nil && !( upy2.is_a?(Float) && lreq(upy2,glrget("RUNDEF")) ) && upy2.length != (n)

        #< call the original method >
        __uverbz( n,upx,upy1,upy2,itype,index,rsize )
      end
      module_function :uverbz, :__uverbz 
      private_class_method :__uverbz

      alias __uvdif uvdif 
      def uvdif( upx,upy1,upy2 )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          if ! ( upy1 == nil || upy1.is_a?(Float) && lreq( upy1, glrget("RUNDEF") ) )
            len_upy1_0 = upy1.length
            n = len_upy1_0
          else
            upy1 = glrget("RUNDEF") if ( upy1 == nil )
            len_upy2_0 = upy2.length
            n = len_upy2_0
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n)
        raise "Invalid array length: upy1.length != n" if \
            upy1!=nil && !( upy1.is_a?(Float) && lreq(upy1,glrget("RUNDEF")) ) && upy1.length != (n)
        raise "Invalid array length: upy2.length != n" if \
            upy2!=nil && !( upy2.is_a?(Float) && lreq(upy2,glrget("RUNDEF")) ) && upy2.length != (n)

        #< call the original method >
        __uvdif( n,upx,upy1,upy2 )
      end
      module_function :uvdif, :__uvdif 
      private_class_method :__uvdif

      alias __uvdifz uvdifz 
      def uvdifz( upx,upy1,upy2,itpat1,itpat2 )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          if ! ( upy1 == nil || upy1.is_a?(Float) && lreq( upy1, glrget("RUNDEF") ) )
            len_upy1_0 = upy1.length
            n = len_upy1_0
          else
            upy1 = glrget("RUNDEF") if ( upy1 == nil )
            len_upy2_0 = upy2.length
            n = len_upy2_0
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n)
        raise "Invalid array length: upy1.length != n" if \
            upy1!=nil && !( upy1.is_a?(Float) && lreq(upy1,glrget("RUNDEF")) ) && upy1.length != (n)
        raise "Invalid array length: upy2.length != n" if \
            upy2!=nil && !( upy2.is_a?(Float) && lreq(upy2,glrget("RUNDEF")) ) && upy2.length != (n)

        #< call the original method >
        __uvdifz( n,upx,upy1,upy2,itpat1,itpat2 )
      end
      module_function :uvdifz, :__uvdifz 
      private_class_method :__uvdifz

      alias __uvbrf uvbrf 
      def uvbrf( upx,upy1,upy2 )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          if ! ( upy1 == nil || upy1.is_a?(Float) && lreq( upy1, glrget("RUNDEF") ) )
            len_upy1_0 = upy1.length
            n = len_upy1_0
          else
            upy1 = glrget("RUNDEF") if ( upy1 == nil )
            len_upy2_0 = upy2.length
            n = len_upy2_0
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n)
        raise "Invalid array length: upy1.length != n" if \
            upy1!=nil && !( upy1.is_a?(Float) && lreq(upy1,glrget("RUNDEF")) ) && upy1.length != (n)
        raise "Invalid array length: upy2.length != n" if \
            upy2!=nil && !( upy2.is_a?(Float) && lreq(upy2,glrget("RUNDEF")) ) && upy2.length != (n)

        #< call the original method >
        __uvbrf( n,upx,upy1,upy2 )
      end
      module_function :uvbrf, :__uvbrf 
      private_class_method :__uvbrf

      alias __uvbrfz uvbrfz 
      def uvbrfz( upx,upy1,upy2,itype,index,rsize )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          if ! ( upy1 == nil || upy1.is_a?(Float) && lreq( upy1, glrget("RUNDEF") ) )
            len_upy1_0 = upy1.length
            n = len_upy1_0
          else
            upy1 = glrget("RUNDEF") if ( upy1 == nil )
            len_upy2_0 = upy2.length
            n = len_upy2_0
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n)
        raise "Invalid array length: upy1.length != n" if \
            upy1!=nil && !( upy1.is_a?(Float) && lreq(upy1,glrget("RUNDEF")) ) && upy1.length != (n)
        raise "Invalid array length: upy2.length != n" if \
            upy2!=nil && !( upy2.is_a?(Float) && lreq(upy2,glrget("RUNDEF")) ) && upy2.length != (n)

        #< call the original method >
        __uvbrfz( n,upx,upy1,upy2,itype,index,rsize )
      end
      module_function :uvbrfz, :__uvbrfz 
      private_class_method :__uvbrfz

      alias __uvbra uvbra 
      def uvbra( upx,upy1,upy2 )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          if ! ( upy1 == nil || upy1.is_a?(Float) && lreq( upy1, glrget("RUNDEF") ) )
            len_upy1_0 = upy1.length
            n = len_upy1_0
          else
            upy1 = glrget("RUNDEF") if ( upy1 == nil )
            len_upy2_0 = upy2.length
            n = len_upy2_0
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n)
        raise "Invalid array length: upy1.length != n" if \
            upy1!=nil && !( upy1.is_a?(Float) && lreq(upy1,glrget("RUNDEF")) ) && upy1.length != (n)
        raise "Invalid array length: upy2.length != n" if \
            upy2!=nil && !( upy2.is_a?(Float) && lreq(upy2,glrget("RUNDEF")) ) && upy2.length != (n)

        #< call the original method >
        __uvbra( n,upx,upy1,upy2 )
      end
      module_function :uvbra, :__uvbra 
      private_class_method :__uvbra

      alias __uvbraz uvbraz 
      def uvbraz( upx,upy1,upy2,itpat1,itpat2,rsize )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          if ! ( upy1 == nil || upy1.is_a?(Float) && lreq( upy1, glrget("RUNDEF") ) )
            len_upy1_0 = upy1.length
            n = len_upy1_0
          else
            upy1 = glrget("RUNDEF") if ( upy1 == nil )
            len_upy2_0 = upy2.length
            n = len_upy2_0
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n)
        raise "Invalid array length: upy1.length != n" if \
            upy1!=nil && !( upy1.is_a?(Float) && lreq(upy1,glrget("RUNDEF")) ) && upy1.length != (n)
        raise "Invalid array length: upy2.length != n" if \
            upy2!=nil && !( upy2.is_a?(Float) && lreq(upy2,glrget("RUNDEF")) ) && upy2.length != (n)

        #< call the original method >
        __uvbraz( n,upx,upy1,upy2,itpat1,itpat2,rsize )
      end
      module_function :uvbraz, :__uvbraz 
      private_class_method :__uvbraz

      alias __uvbrl uvbrl 
      def uvbrl( upx,upy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          len_upy_0 = upy.length
          n = len_upy_0
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n)
        raise "Invalid array length: upy.length != n" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n)

        #< call the original method >
        __uvbrl( n,upx,upy )
      end
      module_function :uvbrl, :__uvbrl 
      private_class_method :__uvbrl

      alias __uvbrlz uvbrlz 
      def uvbrlz( upx,upy,itype,index,rsize )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          len_upy_0 = upy.length
          n = len_upy_0
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n)
        raise "Invalid array length: upy.length != n" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n)

        #< call the original method >
        __uvbrlz( n,upx,upy,itype,index,rsize )
      end
      module_function :uvbrlz, :__uvbrlz 
      private_class_method :__uvbrlz

      alias __uvbxf uvbxf 
      def uvbxf( upx,upy1,upy2 )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0 - 1
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          if ! ( upy1 == nil || upy1.is_a?(Float) && lreq( upy1, glrget("RUNDEF") ) )
            len_upy1_0 = upy1.length
            n = len_upy1_0
          else
            upy1 = glrget("RUNDEF") if ( upy1 == nil )
            len_upy2_0 = upy2.length
            n = len_upy2_0
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n+1" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n+1)
        raise "Invalid array length: upy1.length != n" if \
            upy1!=nil && !( upy1.is_a?(Float) && lreq(upy1,glrget("RUNDEF")) ) && upy1.length != (n)
        raise "Invalid array length: upy2.length != n" if \
            upy2!=nil && !( upy2.is_a?(Float) && lreq(upy2,glrget("RUNDEF")) ) && upy2.length != (n)

        #< call the original method >
        __uvbxf( n,upx,upy1,upy2 )
      end
      module_function :uvbxf, :__uvbxf 
      private_class_method :__uvbxf

      alias __uvbxfz uvbxfz 
      def uvbxfz( upx,upy1,upy2,itype,index )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0 - 1
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          if ! ( upy1 == nil || upy1.is_a?(Float) && lreq( upy1, glrget("RUNDEF") ) )
            len_upy1_0 = upy1.length
            n = len_upy1_0
          else
            upy1 = glrget("RUNDEF") if ( upy1 == nil )
            len_upy2_0 = upy2.length
            n = len_upy2_0
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n+1" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n+1)
        raise "Invalid array length: upy1.length != n" if \
            upy1!=nil && !( upy1.is_a?(Float) && lreq(upy1,glrget("RUNDEF")) ) && upy1.length != (n)
        raise "Invalid array length: upy2.length != n" if \
            upy2!=nil && !( upy2.is_a?(Float) && lreq(upy2,glrget("RUNDEF")) ) && upy2.length != (n)

        #< call the original method >
        __uvbxfz( n,upx,upy1,upy2,itype,index )
      end
      module_function :uvbxfz, :__uvbxfz 
      private_class_method :__uvbxfz

      alias __uvbxa uvbxa 
      def uvbxa( upx,upy1,upy2 )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0 - 1
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          if ! ( upy1 == nil || upy1.is_a?(Float) && lreq( upy1, glrget("RUNDEF") ) )
            len_upy1_0 = upy1.length
            n = len_upy1_0
          else
            upy1 = glrget("RUNDEF") if ( upy1 == nil )
            len_upy2_0 = upy2.length
            n = len_upy2_0
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n+1" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n+1)
        raise "Invalid array length: upy1.length != n" if \
            upy1!=nil && !( upy1.is_a?(Float) && lreq(upy1,glrget("RUNDEF")) ) && upy1.length != (n)
        raise "Invalid array length: upy2.length != n" if \
            upy2!=nil && !( upy2.is_a?(Float) && lreq(upy2,glrget("RUNDEF")) ) && upy2.length != (n)

        #< call the original method >
        __uvbxa( n,upx,upy1,upy2 )
      end
      module_function :uvbxa, :__uvbxa 
      private_class_method :__uvbxa

      alias __uvbxaz uvbxaz 
      def uvbxaz( upx,upy1,upy2,itpat1,itpat2 )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0 - 1
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          if ! ( upy1 == nil || upy1.is_a?(Float) && lreq( upy1, glrget("RUNDEF") ) )
            len_upy1_0 = upy1.length
            n = len_upy1_0
          else
            upy1 = glrget("RUNDEF") if ( upy1 == nil )
            len_upy2_0 = upy2.length
            n = len_upy2_0
          end
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n+1" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n+1)
        raise "Invalid array length: upy1.length != n" if \
            upy1!=nil && !( upy1.is_a?(Float) && lreq(upy1,glrget("RUNDEF")) ) && upy1.length != (n)
        raise "Invalid array length: upy2.length != n" if \
            upy2!=nil && !( upy2.is_a?(Float) && lreq(upy2,glrget("RUNDEF")) ) && upy2.length != (n)

        #< call the original method >
        __uvbxaz( n,upx,upy1,upy2,itpat1,itpat2 )
      end
      module_function :uvbxaz, :__uvbxaz 
      private_class_method :__uvbxaz

      alias __uvbxl uvbxl 
      def uvbxl( upx,upy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0 - 1
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          len_upy_0 = upy.length
          n = len_upy_0
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n+1" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n+1)
        raise "Invalid array length: upy.length != n" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n)

        #< call the original method >
        __uvbxl( n,upx,upy )
      end
      module_function :uvbxl, :__uvbxl 
      private_class_method :__uvbxl

      alias __uvbxlz uvbxlz 
      def uvbxlz( upx,upy,itype,index )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ! ( upx == nil || upx.is_a?(Float) && lreq( upx, glrget("RUNDEF") ) )
          len_upx_0 = upx.length
          n = len_upx_0 - 1
        else
          upx = glrget("RUNDEF") if ( upx == nil )
          len_upy_0 = upy.length
          n = len_upy_0
        end

        #< check array size(s) >
        raise "Invalid array length: upx.length != n+1" if \
            upx!=nil && !( upx.is_a?(Float) && lreq(upx,glrget("RUNDEF")) ) && upx.length != (n+1)
        raise "Invalid array length: upy.length != n" if \
            upy!=nil && !( upy.is_a?(Float) && lreq(upy,glrget("RUNDEF")) ) && upy.length != (n)

        #< call the original method >
        __uvbxlz( n,upx,upy,itype,index )
      end
      module_function :uvbxlz, :__uvbxlz 
      private_class_method :__uvbxlz

      alias __uwsgxa uwsgxa 
      def uwsgxa( xp )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_xp_0 = xp.length
        nx = len_xp_0

        #< check array size(s) >
        raise "Invalid array length: xp.length != nx" if xp.length != (nx)

        #< call the original method >
        __uwsgxa( xp,nx )
      end
      module_function :uwsgxa, :__uwsgxa 
      private_class_method :__uwsgxa

      alias __uwsgya uwsgya 
      def uwsgya( yp )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_yp_0 = yp.length
        ny = len_yp_0

        #< check array size(s) >
        raise "Invalid array length: yp.length != ny" if yp.length != (ny)

        #< call the original method >
        __uwsgya( yp,ny )
      end
      module_function :uwsgya, :__uwsgya 
      private_class_method :__uwsgya

      alias __uxptmk uxptmk 
      def uxptmk( cside,islct,ux )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_ux_0 = ux.length
        n = len_ux_0

        #< check array size(s) >
        raise "Invalid array length: ux.length != n" if ux.length != (n)

        #< call the original method >
        __uxptmk( cside,islct,ux,n )
      end
      module_function :uxptmk, :__uxptmk 
      private_class_method :__uxptmk

      alias __uxplbl uxplbl 
      def uxplbl( cside,islct,ux,ch,nc )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_ux_0 = ux.length
        n = len_ux_0

        #< check array size(s) >
        raise "Invalid array length: ux.length != n" if ux.length != (n)
        raise "Invalid array length: ch.length != n" if ch.length != (n)

        #< call the original method >
        __uxplbl( cside,islct,ux,ch,nc,n )
      end
      module_function :uxplbl, :__uxplbl 
      private_class_method :__uxplbl

      alias __uxpnum uxpnum 
      def uxpnum( cside,islct,ux )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_ux_0 = ux.length
        n = len_ux_0

        #< check array size(s) >
        raise "Invalid array length: ux.length != n" if ux.length != (n)

        #< call the original method >
        __uxpnum( cside,islct,ux,n )
      end
      module_function :uxpnum, :__uxpnum 
      private_class_method :__uxpnum

      alias __uxaxlb uxaxlb 
      def uxaxlb( cside,ux1,ux2,ch,nc )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_ux1_0 = ux1.length
        n1 = len_ux1_0
        len_ux2_0 = ux2.length
        n2 = len_ux2_0

        #< check array size(s) >
        raise "Invalid array length: ux1.length != n1" if ux1.length != (n1)
        raise "Invalid array length: ux2.length != n2" if ux2.length != (n2)
        raise "Invalid array length: ch.length != n2" if ch.length != (n2)

        #< call the original method >
        __uxaxlb( cside,ux1,n1,ux2,ch,nc,n2 )
      end
      module_function :uxaxlb, :__uxaxlb 
      private_class_method :__uxaxlb

      alias __uxaxnm uxaxnm 
      def uxaxnm( cside,ux1,ux2 )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_ux1_0 = ux1.length
        n1 = len_ux1_0
        len_ux2_0 = ux2.length
        n2 = len_ux2_0

        #< check array size(s) >
        raise "Invalid array length: ux1.length != n1" if ux1.length != (n1)
        raise "Invalid array length: ux2.length != n2" if ux2.length != (n2)

        #< call the original method >
        __uxaxnm( cside,ux1,n1,ux2,n2 )
      end
      module_function :uxaxnm, :__uxaxnm 
      private_class_method :__uxaxnm

      alias __uyptmk uyptmk 
      def uyptmk( cside,islct,uy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_uy_0 = uy.length
        n = len_uy_0

        #< check array size(s) >
        raise "Invalid array length: uy.length != n" if uy.length != (n)

        #< call the original method >
        __uyptmk( cside,islct,uy,n )
      end
      module_function :uyptmk, :__uyptmk 
      private_class_method :__uyptmk

      alias __uyplbl uyplbl 
      def uyplbl( cside,islct,uy,ch,nc )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_uy_0 = uy.length
        n = len_uy_0

        #< check array size(s) >
        raise "Invalid array length: uy.length != n" if uy.length != (n)
        raise "Invalid array length: ch.length != n" if ch.length != (n)

        #< call the original method >
        __uyplbl( cside,islct,uy,ch,nc,n )
      end
      module_function :uyplbl, :__uyplbl 
      private_class_method :__uyplbl

      alias __uypnum uypnum 
      def uypnum( cside,islct,uy )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_uy_0 = uy.length
        n = len_uy_0

        #< check array size(s) >
        raise "Invalid array length: uy.length != n" if uy.length != (n)

        #< call the original method >
        __uypnum( cside,islct,uy,n )
      end
      module_function :uypnum, :__uypnum 
      private_class_method :__uypnum

      alias __uyaxlb uyaxlb 
      def uyaxlb( cside,uy1,uy2,ch,nc )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_uy1_0 = uy1.length
        n1 = len_uy1_0
        len_uy2_0 = uy2.length
        n2 = len_uy2_0

        #< check array size(s) >
        raise "Invalid array length: uy1.length != n1" if uy1.length != (n1)
        raise "Invalid array length: uy2.length != n2" if uy2.length != (n2)
        raise "Invalid array length: ch.length != n2" if ch.length != (n2)

        #< call the original method >
        __uyaxlb( cside,uy1,n1,uy2,ch,nc,n2 )
      end
      module_function :uyaxlb, :__uyaxlb 
      private_class_method :__uyaxlb

      alias __uyaxnm uyaxnm 
      def uyaxnm( cside,uy1,uy2 )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_uy1_0 = uy1.length
        n1 = len_uy1_0
        len_uy2_0 = uy2.length
        n2 = len_uy2_0

        #< check array size(s) >
        raise "Invalid array length: uy1.length != n1" if uy1.length != (n1)
        raise "Invalid array length: uy2.length != n2" if uy2.length != (n2)

        #< call the original method >
        __uyaxnm( cside,uy1,n1,uy2,n2 )
      end
      module_function :uyaxnm, :__uyaxnm 
      private_class_method :__uyaxnm

      alias __iblklt iblklt 
      def iblklt( rx,rr )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_rx_0 = rx.length
        n = len_rx_0

        #< check array size(s) >
        raise "Invalid array length: rx.length != n" if rx.length != (n)

        #< call the original method >
        __iblklt( rx,n,rr )
      end
      module_function :iblklt, :__iblklt 
      private_class_method :__iblklt

      alias __iblkle iblkle 
      def iblkle( rx,rr )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_rx_0 = rx.length
        n = len_rx_0

        #< check array size(s) >
        raise "Invalid array length: rx.length != n" if rx.length != (n)

        #< call the original method >
        __iblkle( rx,n,rr )
      end
      module_function :iblkle, :__iblkle 
      private_class_method :__iblkle

      alias __iblkgt iblkgt 
      def iblkgt( rx,rr )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_rx_0 = rx.length
        n = len_rx_0

        #< check array size(s) >
        raise "Invalid array length: rx.length != n" if rx.length != (n)

        #< call the original method >
        __iblkgt( rx,n,rr )
      end
      module_function :iblkgt, :__iblkgt 
      private_class_method :__iblkgt

      alias __iblkge iblkge 
      def iblkge( rx,rr )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_rx_0 = rx.length
        n = len_rx_0

        #< check array size(s) >
        raise "Invalid array length: rx.length != n" if rx.length != (n)

        #< call the original method >
        __iblkge( rx,n,rr )
      end
      module_function :iblkge, :__iblkge 
      private_class_method :__iblkge

      alias __gnsblk gnsblk 
      def gnsblk( xb )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_xb_0 = xb.length
        nb = len_xb_0

        #< check array size(s) >
        raise "Invalid array length: xb.length != nb" if xb.length != (nb)

        #< call the original method >
        __gnsblk( xb,nb )
      end
      module_function :gnsblk, :__gnsblk 
      private_class_method :__gnsblk

      if DCLVERSION >= '5.3'
      alias __g2sctr g2sctr 
      def g2sctr( uxa,uya,cxa,cya )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_uxa_0 = uxa.length
        nx = len_uxa_0
        len_uya_0 = uya.length
        ny = len_uya_0

        #< check array size(s) >
        raise "Invalid array length: uxa.length != nx" if uxa.length != (nx)
        raise "Invalid array length: uya.length != ny" if uya.length != (ny)
        raise "Invalid array shape: cxa.shape[0] != nx" if cxa.shape[0] != (nx)
        raise "Invalid array shape: cxa.shape[1] != ny" if cxa.shape[1] != (ny)
        raise "Invalid array shape: cya.shape[0] != nx" if cya.shape[0] != (nx)
        raise "Invalid array shape: cya.shape[1] != ny" if cya.shape[1] != (ny)

        #< call the original method >
        __g2sctr( nx,ny,uxa,uya,cxa,cya )
      end
      module_function :g2sctr, :__g2sctr 
      private_class_method :__g2sctr

      end

      alias __imax imax 
      def imax( ix,n,jx )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __imax( ix,n,jx )
      end
      module_function :imax, :__imax 
      private_class_method :__imax

      alias __imax0 imax0 
      def imax0( ix,n,jx )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __imax0( ix,n,jx )
      end
      module_function :imax0, :__imax0 
      private_class_method :__imax0

      alias __imax1 imax1 
      def imax1( ix,n,jx )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __imax1( ix,n,jx )
      end
      module_function :imax1, :__imax1 
      private_class_method :__imax1

      alias __imin imin 
      def imin( ix,n,jx )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __imin( ix,n,jx )
      end
      module_function :imin, :__imin 
      private_class_method :__imin

      alias __imin0 imin0 
      def imin0( ix,n,jx )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __imin0( ix,n,jx )
      end
      module_function :imin0, :__imin0 
      private_class_method :__imin0

      alias __imin1 imin1 
      def imin1( ix,n,jx )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __imin1( ix,n,jx )
      end
      module_function :imin1, :__imin1 
      private_class_method :__imin1

      alias __isum isum 
      def isum( ix,n,jx )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __isum( ix,n,jx )
      end
      module_function :isum, :__isum 
      private_class_method :__isum

      alias __isum0 isum0 
      def isum0( ix,n,jx )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __isum0( ix,n,jx )
      end
      module_function :isum0, :__isum0 
      private_class_method :__isum0

      alias __isum1 isum1 
      def isum1( ix,n,jx )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __isum1( ix,n,jx )
      end
      module_function :isum1, :__isum1 
      private_class_method :__isum1

      alias __indxcf indxcf 
      def indxcf( cx,n,jd,ch )

        #< check array size(s) >
        raise "Invalid array length: cx.length != jd*(n-1)+1" if cx.length != (jd*(n-1)+1)

        #< call the original method >
        __indxcf( cx,n,jd,ch )
      end
      module_function :indxcf, :__indxcf 
      private_class_method :__indxcf

      alias __indxcl indxcl 
      def indxcl( cx,n,jd,ch )

        #< check array size(s) >
        raise "Invalid array length: cx.length != jd*(n-1)+1" if cx.length != (jd*(n-1)+1)

        #< call the original method >
        __indxcl( cx,n,jd,ch )
      end
      module_function :indxcl, :__indxcl 
      private_class_method :__indxcl

      alias __indxif indxif 
      def indxif( ix,n,jd,ii )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jd*(n-1)+1" if ix.length != (jd*(n-1)+1)

        #< call the original method >
        __indxif( ix,n,jd,ii )
      end
      module_function :indxif, :__indxif 
      private_class_method :__indxif

      alias __indxil indxil 
      def indxil( ix,n,jd,ii )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jd*(n-1)+1" if ix.length != (jd*(n-1)+1)

        #< call the original method >
        __indxil( ix,n,jd,ii )
      end
      module_function :indxil, :__indxil 
      private_class_method :__indxil

      alias __indxrf indxrf 
      def indxrf( rx,n,jd,rr )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jd*(n-1)+1" if rx.length != (jd*(n-1)+1)

        #< call the original method >
        __indxrf( rx,n,jd,rr )
      end
      module_function :indxrf, :__indxrf 
      private_class_method :__indxrf

      alias __indxrl indxrl 
      def indxrl( rx,n,jd,rr )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jd*(n-1)+1" if rx.length != (jd*(n-1)+1)

        #< call the original method >
        __indxrl( rx,n,jd,rr )
      end
      module_function :indxrl, :__indxrl 
      private_class_method :__indxrl

      alias __nindxc nindxc 
      def nindxc( cx,n,jd,ch )

        #< check array size(s) >
        raise "Invalid array length: cx.length != jd*(n-1)+1" if cx.length != (jd*(n-1)+1)

        #< call the original method >
        __nindxc( cx,n,jd,ch )
      end
      module_function :nindxc, :__nindxc 
      private_class_method :__nindxc

      alias __nindxi nindxi 
      def nindxi( ix,n,jd,ii )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jd*(n-1)+1" if ix.length != (jd*(n-1)+1)

        #< call the original method >
        __nindxi( ix,n,jd,ii )
      end
      module_function :nindxi, :__nindxi 
      private_class_method :__nindxi

      alias __nindxr nindxr 
      def nindxr( rx,n,jd,rr )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jd*(n-1)+1" if rx.length != (jd*(n-1)+1)

        #< call the original method >
        __nindxr( rx,n,jd,rr )
      end
      module_function :nindxr, :__nindxr 
      private_class_method :__nindxr

      alias __rmax rmax 
      def rmax( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rmax( rx,n,jx )
      end
      module_function :rmax, :__rmax 
      private_class_method :__rmax

      alias __rmax0 rmax0 
      def rmax0( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rmax0( rx,n,jx )
      end
      module_function :rmax0, :__rmax0 
      private_class_method :__rmax0

      alias __rmax1 rmax1 
      def rmax1( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rmax1( rx,n,jx )
      end
      module_function :rmax1, :__rmax1 
      private_class_method :__rmax1

      alias __rmin rmin 
      def rmin( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rmin( rx,n,jx )
      end
      module_function :rmin, :__rmin 
      private_class_method :__rmin

      alias __rmin0 rmin0 
      def rmin0( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rmin0( rx,n,jx )
      end
      module_function :rmin0, :__rmin0 
      private_class_method :__rmin0

      alias __rmin1 rmin1 
      def rmin1( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rmin1( rx,n,jx )
      end
      module_function :rmin1, :__rmin1 
      private_class_method :__rmin1

      alias __rsum rsum 
      def rsum( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rsum( rx,n,jx )
      end
      module_function :rsum, :__rsum 
      private_class_method :__rsum

      alias __rsum0 rsum0 
      def rsum0( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rsum0( rx,n,jx )
      end
      module_function :rsum0, :__rsum0 
      private_class_method :__rsum0

      alias __rsum1 rsum1 
      def rsum1( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rsum1( rx,n,jx )
      end
      module_function :rsum1, :__rsum1 
      private_class_method :__rsum1

      alias __rave rave 
      def rave( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rave( rx,n,jx )
      end
      module_function :rave, :__rave 
      private_class_method :__rave

      alias __rave0 rave0 
      def rave0( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rave0( rx,n,jx )
      end
      module_function :rave0, :__rave0 
      private_class_method :__rave0

      alias __rave1 rave1 
      def rave1( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rave1( rx,n,jx )
      end
      module_function :rave1, :__rave1 
      private_class_method :__rave1

      alias __rvar rvar 
      def rvar( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rvar( rx,n,jx )
      end
      module_function :rvar, :__rvar 
      private_class_method :__rvar

      alias __rvar0 rvar0 
      def rvar0( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rvar0( rx,n,jx )
      end
      module_function :rvar0, :__rvar0 
      private_class_method :__rvar0

      alias __rvar1 rvar1 
      def rvar1( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rvar1( rx,n,jx )
      end
      module_function :rvar1, :__rvar1 
      private_class_method :__rvar1

      alias __rstd rstd 
      def rstd( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rstd( rx,n,jx )
      end
      module_function :rstd, :__rstd 
      private_class_method :__rstd

      alias __rstd0 rstd0 
      def rstd0( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rstd0( rx,n,jx )
      end
      module_function :rstd0, :__rstd0 
      private_class_method :__rstd0

      alias __rstd1 rstd1 
      def rstd1( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rstd1( rx,n,jx )
      end
      module_function :rstd1, :__rstd1 
      private_class_method :__rstd1

      alias __rrms rrms 
      def rrms( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rrms( rx,n,jx )
      end
      module_function :rrms, :__rrms 
      private_class_method :__rrms

      alias __rrms0 rrms0 
      def rrms0( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rrms0( rx,n,jx )
      end
      module_function :rrms0, :__rrms0 
      private_class_method :__rrms0

      alias __rrms1 rrms1 
      def rrms1( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rrms1( rx,n,jx )
      end
      module_function :rrms1, :__rrms1 
      private_class_method :__rrms1

      alias __ramp ramp 
      def ramp( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __ramp( rx,n,jx )
      end
      module_function :ramp, :__ramp 
      private_class_method :__ramp

      alias __ramp0 ramp0 
      def ramp0( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __ramp0( rx,n,jx )
      end
      module_function :ramp0, :__ramp0 
      private_class_method :__ramp0

      alias __ramp1 ramp1 
      def ramp1( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __ramp1( rx,n,jx )
      end
      module_function :ramp1, :__ramp1 
      private_class_method :__ramp1

      alias __rvmax rvmax 
      def rvmax( rx,ns,np,nq )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_ns_0 = ns.length
        nd = len_ns_0

        #< check array size(s) >
        raise "Invalid array length: rx.length != (len=1; ns.each{|i| len*=i}; len)" if rx.length != ((len=1; ns.each{|i| len*=i}; len))
        raise "Invalid array length: ns.length != nd" if ns.length != (nd)
        raise "Invalid array length: np.length != nd" if np.length != (nd)
        raise "Invalid array length: nq.length != nd" if nq.length != (nd)

        #< call the original method >
        __rvmax( rx,ns,np,nq,nd )
      end
      module_function :rvmax, :__rvmax 
      private_class_method :__rvmax

      alias __rvmax0 rvmax0 
      def rvmax0( rx,ns,np,nq )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_ns_0 = ns.length
        nd = len_ns_0

        #< check array size(s) >
        raise "Invalid array length: rx.length != (len=1; ns.each{|i| len*=i}; len)" if rx.length != ((len=1; ns.each{|i| len*=i}; len))
        raise "Invalid array length: ns.length != nd" if ns.length != (nd)
        raise "Invalid array length: np.length != nd" if np.length != (nd)
        raise "Invalid array length: nq.length != nd" if nq.length != (nd)

        #< call the original method >
        __rvmax0( rx,ns,np,nq,nd )
      end
      module_function :rvmax0, :__rvmax0 
      private_class_method :__rvmax0

      alias __rvmin rvmin 
      def rvmin( rx,ns,np,nq )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_ns_0 = ns.length
        nd = len_ns_0

        #< check array size(s) >
        raise "Invalid array length: rx.length != (len=1; ns.each{|i| len*=i}; len)" if rx.length != ((len=1; ns.each{|i| len*=i}; len))
        raise "Invalid array length: ns.length != nd" if ns.length != (nd)
        raise "Invalid array length: np.length != nd" if np.length != (nd)
        raise "Invalid array length: nq.length != nd" if nq.length != (nd)

        #< call the original method >
        __rvmin( rx,ns,np,nq,nd )
      end
      module_function :rvmin, :__rvmin 
      private_class_method :__rvmin

      alias __rvmax1 rvmax1 
      def rvmax1( rx,ns,np,nq )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_ns_0 = ns.length
        nd = len_ns_0

        #< check array size(s) >
        raise "Invalid array length: rx.length != (len=1; ns.each{|i| len*=i}; len)" if rx.length != ((len=1; ns.each{|i| len*=i}; len))
        raise "Invalid array length: ns.length != nd" if ns.length != (nd)
        raise "Invalid array length: np.length != nd" if np.length != (nd)
        raise "Invalid array length: nq.length != nd" if nq.length != (nd)

        #< call the original method >
        __rvmax1( rx,ns,np,nq,nd )
      end
      module_function :rvmax1, :__rvmax1 
      private_class_method :__rvmax1

      alias __rvmin1 rvmin1 
      def rvmin1( rx,ns,np,nq )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_ns_0 = ns.length
        nd = len_ns_0

        #< check array size(s) >
        raise "Invalid array length: rx.length != (len=1; ns.each{|i| len*=i}; len)" if rx.length != ((len=1; ns.each{|i| len*=i}; len))
        raise "Invalid array length: ns.length != nd" if ns.length != (nd)
        raise "Invalid array length: np.length != nd" if np.length != (nd)
        raise "Invalid array length: nq.length != nd" if nq.length != (nd)

        #< call the original method >
        __rvmin1( rx,ns,np,nq,nd )
      end
      module_function :rvmin1, :__rvmin1 
      private_class_method :__rvmin1

      alias __rvmin0 rvmin0 
      def rvmin0( rx,ns,np,nq )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_ns_0 = ns.length
        nd = len_ns_0

        #< check array size(s) >
        raise "Invalid array length: rx.length != (len=1; ns.each{|i| len*=i}; len)" if rx.length != ((len=1; ns.each{|i| len*=i}; len))
        raise "Invalid array length: ns.length != nd" if ns.length != (nd)
        raise "Invalid array length: np.length != nd" if np.length != (nd)
        raise "Invalid array length: nq.length != nd" if nq.length != (nd)

        #< call the original method >
        __rvmin0( rx,ns,np,nq,nd )
      end
      module_function :rvmin0, :__rvmin0 
      private_class_method :__rvmin0

      alias __rprd rprd 
      def rprd( rx,ry,n,jx,jy )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)
        raise "Invalid array length: ry.length != jy*(n-1)+1" if ry.length != (jy*(n-1)+1)

        #< call the original method >
        __rprd( rx,ry,n,jx,jy )
      end
      module_function :rprd, :__rprd 
      private_class_method :__rprd

      alias __rcov rcov 
      def rcov( rx,ry,n,jx,jy )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)
        raise "Invalid array length: ry.length != jy*(n-1)+1" if ry.length != (jy*(n-1)+1)

        #< call the original method >
        __rcov( rx,ry,n,jx,jy )
      end
      module_function :rcov, :__rcov 
      private_class_method :__rcov

      alias __rcor rcor 
      def rcor( rx,ry,n,jx,jy )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)
        raise "Invalid array length: ry.length != jx*(n-1)+1" if ry.length != (jx*(n-1)+1)

        #< call the original method >
        __rcor( rx,ry,n,jx,jy )
      end
      module_function :rcor, :__rcor 
      private_class_method :__rcor

      alias __dxfloc dxfloc 
      def dxfloc( ns,np )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_ns_0 = ns.length
        nd = len_ns_0

        #< check array size(s) >
        raise "Invalid array length: ns.length != nd" if ns.length != (nd)
        raise "Invalid array length: np.length != nd" if np.length != (nd)

        #< call the original method >
        __dxfloc( nd,ns,np )
      end
      module_function :dxfloc, :__dxfloc 
      private_class_method :__dxfloc

      alias __dxiloc dxiloc 
      def dxiloc( ns,ncp )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_ns_0 = ns.length
        nd = len_ns_0

        #< check array size(s) >
        raise "Invalid array length: ns.length != nd" if ns.length != (nd)

        #< call the original method >
        __dxiloc( nd,ns,ncp )
      end
      module_function :dxiloc, :__dxiloc 
      private_class_method :__dxiloc

      alias __cfsrch cfsrch 
      def cfsrch( cplist,cflist,nf )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_cplist_0 = cplist.length
        np = len_cplist_0

        #< check array size(s) >
        raise "Invalid array length: cplist.length != np" if cplist.length != (np)
        raise "Invalid array length: cflist.length != np" if cflist.length != (np)

        #< call the original method >
        __cfsrch( cplist,np,cflist,nf )
      end
      module_function :cfsrch, :__cfsrch 
      private_class_method :__cfsrch

      alias __rtiget rtiget 
      def rtiget( cpfix,cps )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_cps_0 = cps.length
        max = len_cps_0

        #< check array size(s) >
        raise "Invalid array length: cps.length != max" if cps.length != (max)

        #< call the original method >
        __rtiget( cpfix,cps,max )
      end
      module_function :rtiget, :__rtiget 
      private_class_method :__rtiget

      alias __rtlget rtlget 
      def rtlget( cpfix,cps )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_cps_0 = cps.length
        max = len_cps_0

        #< check array size(s) >
        raise "Invalid array length: cps.length != max" if cps.length != (max)

        #< call the original method >
        __rtlget( cpfix,cps,max )
      end
      module_function :rtlget, :__rtlget 
      private_class_method :__rtlget

      alias __rtrget rtrget 
      def rtrget( cpfix,cps )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_cps_0 = cps.length
        max = len_cps_0

        #< check array size(s) >
        raise "Invalid array length: cps.length != max" if cps.length != (max)

        #< call the original method >
        __rtrget( cpfix,cps,max )
      end
      module_function :rtrget, :__rtrget 
      private_class_method :__rtrget

      alias __rtcget rtcget 
      def rtcget( cpfix,cps )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_cps_0 = cps.length
        max = len_cps_0

        #< check array size(s) >
        raise "Invalid array length: cps.length != max" if cps.length != (max)

        #< call the original method >
        __rtcget( cpfix,cps,max )
      end
      module_function :rtcget, :__rtcget 
      private_class_method :__rtcget

      alias __rliget rliget 
      def rliget( cpl )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_cpl_0 = cpl.length
        max = len_cpl_0

        #< check array size(s) >
        raise "Invalid array length: cpl.length != max" if cpl.length != (max)

        #< call the original method >
        __rliget( cpl,max )
      end
      module_function :rliget, :__rliget 
      private_class_method :__rliget

      alias __rllget rllget 
      def rllget( cpl )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_cpl_0 = cpl.length
        max = len_cpl_0

        #< check array size(s) >
        raise "Invalid array length: cpl.length != max" if cpl.length != (max)

        #< call the original method >
        __rllget( cpl,max )
      end
      module_function :rllget, :__rllget 
      private_class_method :__rllget

      alias __rlrget rlrget 
      def rlrget( cpl )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_cpl_0 = cpl.length
        max = len_cpl_0

        #< check array size(s) >
        raise "Invalid array length: cpl.length != max" if cpl.length != (max)

        #< call the original method >
        __rlrget( cpl,max )
      end
      module_function :rlrget, :__rlrget 
      private_class_method :__rlrget

      alias __rlcget rlcget 
      def rlcget( cpl )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_cpl_0 = cpl.length
        max = len_cpl_0

        #< check array size(s) >
        raise "Invalid array length: cpl.length != max" if cpl.length != (max)

        #< call the original method >
        __rlcget( cpl,max )
      end
      module_function :rlcget, :__rlcget 
      private_class_method :__rlcget

      alias __vifna vifna 
      def vifna( ix,n,jx,jy,ifna )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __vifna( ix,n,jx,jy,ifna )
      end
      module_function :vifna, :__vifna 
      private_class_method :__vifna

      alias __vifna0 vifna0 
      def vifna0( ix,n,jx,jy,ifna )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __vifna0( ix,n,jx,jy,ifna )
      end
      module_function :vifna0, :__vifna0 
      private_class_method :__vifna0

      alias __vifna1 vifna1 
      def vifna1( ix,n,jx,jy,ifna )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __vifna1( ix,n,jx,jy,ifna )
      end
      module_function :vifna1, :__vifna1 
      private_class_method :__vifna1

      alias __viinc viinc 
      def viinc( ix,n,jx,jy,ii )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __viinc( ix,n,jx,jy,ii )
      end
      module_function :viinc, :__viinc 
      private_class_method :__viinc

      alias __viinc0 viinc0 
      def viinc0( ix,n,jx,jy,ii )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __viinc0( ix,n,jx,jy,ii )
      end
      module_function :viinc0, :__viinc0 
      private_class_method :__viinc0

      alias __viinc1 viinc1 
      def viinc1( ix,n,jx,jy,ii )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __viinc1( ix,n,jx,jy,ii )
      end
      module_function :viinc1, :__viinc1 
      private_class_method :__viinc1

      alias __vifct vifct 
      def vifct( ix,n,jx,jy,ii )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __vifct( ix,n,jx,jy,ii )
      end
      module_function :vifct, :__vifct 
      private_class_method :__vifct

      alias __vifct0 vifct0 
      def vifct0( ix,n,jx,jy,ii )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __vifct0( ix,n,jx,jy,ii )
      end
      module_function :vifct0, :__vifct0 
      private_class_method :__vifct0

      alias __vifct1 vifct1 
      def vifct1( ix,n,jx,jy,ii )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __vifct1( ix,n,jx,jy,ii )
      end
      module_function :vifct1, :__vifct1 
      private_class_method :__vifct1

      alias __vicon vicon 
      def vicon( ix,n,jx,jy,ii )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __vicon( ix,n,jx,jy,ii )
      end
      module_function :vicon, :__vicon 
      private_class_method :__vicon

      alias __vicon0 vicon0 
      def vicon0( ix,n,jx,jy,ii )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __vicon0( ix,n,jx,jy,ii )
      end
      module_function :vicon0, :__vicon0 
      private_class_method :__vicon0

      alias __vicon1 vicon1 
      def vicon1( ix,n,jx,jy,ii )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __vicon1( ix,n,jx,jy,ii )
      end
      module_function :vicon1, :__vicon1 
      private_class_method :__vicon1

      alias __viset viset 
      def viset( ix,n,jx,jy )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __viset( ix,n,jx,jy )
      end
      module_function :viset, :__viset 
      private_class_method :__viset

      alias __iadd iadd 
      def iadd( ix,n,jx,ii )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __iadd( ix,n,jx,ii )
      end
      module_function :iadd, :__iadd 
      private_class_method :__iadd

      alias __iadd0 iadd0 
      def iadd0( ix,n,jx,ii )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __iadd0( ix,n,jx,ii )
      end
      module_function :iadd0, :__iadd0 
      private_class_method :__iadd0

      alias __iadd1 iadd1 
      def iadd1( ix,n,jx,ii )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __iadd1( ix,n,jx,ii )
      end
      module_function :iadd1, :__iadd1 
      private_class_method :__iadd1

      alias __imlt imlt 
      def imlt( ix,n,jx,ii )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __imlt( ix,n,jx,ii )
      end
      module_function :imlt, :__imlt 
      private_class_method :__imlt

      alias __imlt0 imlt0 
      def imlt0( ix,n,jx,ii )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __imlt0( ix,n,jx,ii )
      end
      module_function :imlt0, :__imlt0 
      private_class_method :__imlt0

      alias __imlt1 imlt1 
      def imlt1( ix,n,jx,ii )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __imlt1( ix,n,jx,ii )
      end
      module_function :imlt1, :__imlt1 
      private_class_method :__imlt1

      alias __iset iset 
      def iset( ix,n,jx,ii )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __iset( ix,n,jx,ii )
      end
      module_function :iset, :__iset 
      private_class_method :__iset

      alias __iset0 iset0 
      def iset0( ix,n,jx,ii )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __iset0( ix,n,jx,ii )
      end
      module_function :iset0, :__iset0 
      private_class_method :__iset0

      alias __iset1 iset1 
      def iset1( ix,n,jx,ii )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)

        #< call the original method >
        __iset1( ix,n,jx,ii )
      end
      module_function :iset1, :__iset1 
      private_class_method :__iset1

      alias __vifnb vifnb 
      def vifnb( ix,iy,n,jx,jy,jz,ifnb )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)
        raise "Invalid array length: iy.length != jy*(n-1)+1" if iy.length != (jy*(n-1)+1)

        #< call the original method >
        __vifnb( ix,iy,n,jx,jy,jz,ifnb )
      end
      module_function :vifnb, :__vifnb 
      private_class_method :__vifnb

      alias __vifnb0 vifnb0 
      def vifnb0( ix,iy,n,jx,jy,jz,ifnb )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)
        raise "Invalid array length: iy.length != jy*(n-1)+1" if iy.length != (jy*(n-1)+1)

        #< call the original method >
        __vifnb0( ix,iy,n,jx,jy,jz,ifnb )
      end
      module_function :vifnb0, :__vifnb0 
      private_class_method :__vifnb0

      alias __vifnb1 vifnb1 
      def vifnb1( ix,iy,n,jx,jy,jz,ifnb )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)
        raise "Invalid array length: iy.length != jy*(n-1)+1" if iy.length != (jy*(n-1)+1)

        #< call the original method >
        __vifnb1( ix,iy,n,jx,jy,jz,ifnb )
      end
      module_function :vifnb1, :__vifnb1 
      private_class_method :__vifnb1

      alias __viadd viadd 
      def viadd( ix,iy,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)
        raise "Invalid array length: iy.length != jy*(n-1)+1" if iy.length != (jy*(n-1)+1)

        #< call the original method >
        __viadd( ix,iy,n,jx,jy,jz )
      end
      module_function :viadd, :__viadd 
      private_class_method :__viadd

      alias __viadd0 viadd0 
      def viadd0( ix,iy,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)
        raise "Invalid array length: iy.length != jy*(n-1)+1" if iy.length != (jy*(n-1)+1)

        #< call the original method >
        __viadd0( ix,iy,n,jx,jy,jz )
      end
      module_function :viadd0, :__viadd0 
      private_class_method :__viadd0

      alias __viadd1 viadd1 
      def viadd1( ix,iy,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)
        raise "Invalid array length: iy.length != jy*(n-1)+1" if iy.length != (jy*(n-1)+1)

        #< call the original method >
        __viadd1( ix,iy,n,jx,jy,jz )
      end
      module_function :viadd1, :__viadd1 
      private_class_method :__viadd1

      alias __visub visub 
      def visub( ix,iy,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)
        raise "Invalid array length: iy.length != jy*(n-1)+1" if iy.length != (jy*(n-1)+1)

        #< call the original method >
        __visub( ix,iy,n,jx,jy,jz )
      end
      module_function :visub, :__visub 
      private_class_method :__visub

      alias __visub0 visub0 
      def visub0( ix,iy,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)
        raise "Invalid array length: iy.length != jy*(n-1)+1" if iy.length != (jy*(n-1)+1)

        #< call the original method >
        __visub0( ix,iy,n,jx,jy,jz )
      end
      module_function :visub0, :__visub0 
      private_class_method :__visub0

      alias __visub1 visub1 
      def visub1( ix,iy,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)
        raise "Invalid array length: iy.length != jy*(n-1)+1" if iy.length != (jy*(n-1)+1)

        #< call the original method >
        __visub1( ix,iy,n,jx,jy,jz )
      end
      module_function :visub1, :__visub1 
      private_class_method :__visub1

      alias __vimlt vimlt 
      def vimlt( ix,iy,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)
        raise "Invalid array length: iy.length != jy*(n-1)+1" if iy.length != (jy*(n-1)+1)

        #< call the original method >
        __vimlt( ix,iy,n,jx,jy,jz )
      end
      module_function :vimlt, :__vimlt 
      private_class_method :__vimlt

      alias __vimlt0 vimlt0 
      def vimlt0( ix,iy,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)
        raise "Invalid array length: iy.length != jy*(n-1)+1" if iy.length != (jy*(n-1)+1)

        #< call the original method >
        __vimlt0( ix,iy,n,jx,jy,jz )
      end
      module_function :vimlt0, :__vimlt0 
      private_class_method :__vimlt0

      alias __vimlt1 vimlt1 
      def vimlt1( ix,iy,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)
        raise "Invalid array length: iy.length != jy*(n-1)+1" if iy.length != (jy*(n-1)+1)

        #< call the original method >
        __vimlt1( ix,iy,n,jx,jy,jz )
      end
      module_function :vimlt1, :__vimlt1 
      private_class_method :__vimlt1

      alias __vidiv vidiv 
      def vidiv( ix,iy,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)
        raise "Invalid array length: iy.length != jy*(n-1)+1" if iy.length != (jy*(n-1)+1)

        #< call the original method >
        __vidiv( ix,iy,n,jx,jy,jz )
      end
      module_function :vidiv, :__vidiv 
      private_class_method :__vidiv

      alias __vidiv0 vidiv0 
      def vidiv0( ix,iy,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)
        raise "Invalid array length: iy.length != jy*(n-1)+1" if iy.length != (jy*(n-1)+1)

        #< call the original method >
        __vidiv0( ix,iy,n,jx,jy,jz )
      end
      module_function :vidiv0, :__vidiv0 
      private_class_method :__vidiv0

      alias __vidiv1 vidiv1 
      def vidiv1( ix,iy,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: ix.length != jx*(n-1)+1" if ix.length != (jx*(n-1)+1)
        raise "Invalid array length: iy.length != jy*(n-1)+1" if iy.length != (jy*(n-1)+1)

        #< call the original method >
        __vidiv1( ix,iy,n,jx,jy,jz )
      end
      module_function :vidiv1, :__vidiv1 
      private_class_method :__vidiv1

      alias __vrfna vrfna 
      def vrfna( rx,n,jx,jy,rfna )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __vrfna( rx,n,jx,jy,rfna )
      end
      module_function :vrfna, :__vrfna 
      private_class_method :__vrfna

      alias __vrfna0 vrfna0 
      def vrfna0( rx,n,jx,jy,rfna )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __vrfna0( rx,n,jx,jy,rfna )
      end
      module_function :vrfna0, :__vrfna0 
      private_class_method :__vrfna0

      alias __vrfna1 vrfna1 
      def vrfna1( rx,n,jx,jy,rfna )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __vrfna1( rx,n,jx,jy,rfna )
      end
      module_function :vrfna1, :__vrfna1 
      private_class_method :__vrfna1

      alias __vrinc vrinc 
      def vrinc( rx,n,jx,jy,rr )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __vrinc( rx,n,jx,jy,rr )
      end
      module_function :vrinc, :__vrinc 
      private_class_method :__vrinc

      alias __vrinc0 vrinc0 
      def vrinc0( rx,n,jx,jy,rr )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __vrinc0( rx,n,jx,jy,rr )
      end
      module_function :vrinc0, :__vrinc0 
      private_class_method :__vrinc0

      alias __vrinc1 vrinc1 
      def vrinc1( rx,n,jx,jy,rr )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __vrinc1( rx,n,jx,jy,rr )
      end
      module_function :vrinc1, :__vrinc1 
      private_class_method :__vrinc1

      alias __vrfct vrfct 
      def vrfct( rx,n,jx,jy,rr )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __vrfct( rx,n,jx,jy,rr )
      end
      module_function :vrfct, :__vrfct 
      private_class_method :__vrfct

      alias __vrfct0 vrfct0 
      def vrfct0( rx,n,jx,jy,rr )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __vrfct0( rx,n,jx,jy,rr )
      end
      module_function :vrfct0, :__vrfct0 
      private_class_method :__vrfct0

      alias __vrfct1 vrfct1 
      def vrfct1( rx,n,jx,jy,rr )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __vrfct1( rx,n,jx,jy,rr )
      end
      module_function :vrfct1, :__vrfct1 
      private_class_method :__vrfct1

      alias __vrcon vrcon 
      def vrcon( rx,n,jx,jy,rr )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __vrcon( rx,n,jx,jy,rr )
      end
      module_function :vrcon, :__vrcon 
      private_class_method :__vrcon

      alias __vrcon0 vrcon0 
      def vrcon0( rx,n,jx,jy,rr )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __vrcon0( rx,n,jx,jy,rr )
      end
      module_function :vrcon0, :__vrcon0 
      private_class_method :__vrcon0

      alias __vrcon1 vrcon1 
      def vrcon1( rx,n,jx,jy,rr )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __vrcon1( rx,n,jx,jy,rr )
      end
      module_function :vrcon1, :__vrcon1 
      private_class_method :__vrcon1

      alias __vrset vrset 
      def vrset( rx,n,jx,jy )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __vrset( rx,n,jx,jy )
      end
      module_function :vrset, :__vrset 
      private_class_method :__vrset

      alias __radd radd 
      def radd( rx,n,jx,rr )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __radd( rx,n,jx,rr )
      end
      module_function :radd, :__radd 
      private_class_method :__radd

      alias __radd0 radd0 
      def radd0( rx,n,jx,rr )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __radd0( rx,n,jx,rr )
      end
      module_function :radd0, :__radd0 
      private_class_method :__radd0

      alias __radd1 radd1 
      def radd1( rx,n,jx,rr )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __radd1( rx,n,jx,rr )
      end
      module_function :radd1, :__radd1 
      private_class_method :__radd1

      alias __rmlt rmlt 
      def rmlt( rx,n,jx,rr )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rmlt( rx,n,jx,rr )
      end
      module_function :rmlt, :__rmlt 
      private_class_method :__rmlt

      alias __rmlt0 rmlt0 
      def rmlt0( rx,n,jx,rr )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rmlt0( rx,n,jx,rr )
      end
      module_function :rmlt0, :__rmlt0 
      private_class_method :__rmlt0

      alias __rmlt1 rmlt1 
      def rmlt1( rx,n,jx,rr )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rmlt1( rx,n,jx,rr )
      end
      module_function :rmlt1, :__rmlt1 
      private_class_method :__rmlt1

      alias __rset rset 
      def rset( rx,n,jx,rr )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rset( rx,n,jx,rr )
      end
      module_function :rset, :__rset 
      private_class_method :__rset

      alias __rset0 rset0 
      def rset0( rx,n,jx,rr )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rset0( rx,n,jx,rr )
      end
      module_function :rset0, :__rset0 
      private_class_method :__rset0

      alias __rset1 rset1 
      def rset1( rx,n,jx,rr )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __rset1( rx,n,jx,rr )
      end
      module_function :rset1, :__rset1 
      private_class_method :__rset1

      alias __vrfnb vrfnb 
      def vrfnb( rx,ry,n,jx,jy,jz,rfnb )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)
        raise "Invalid array length: ry.length != jy*(n-1)+1" if ry.length != (jy*(n-1)+1)

        #< call the original method >
        __vrfnb( rx,ry,n,jx,jy,jz,rfnb )
      end
      module_function :vrfnb, :__vrfnb 
      private_class_method :__vrfnb

      alias __vrfnb0 vrfnb0 
      def vrfnb0( rx,ry,n,jx,jy,jz,rfnb )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)
        raise "Invalid array length: ry.length != jy*(n-1)+1" if ry.length != (jy*(n-1)+1)

        #< call the original method >
        __vrfnb0( rx,ry,n,jx,jy,jz,rfnb )
      end
      module_function :vrfnb0, :__vrfnb0 
      private_class_method :__vrfnb0

      alias __vrfnb1 vrfnb1 
      def vrfnb1( rx,ry,n,jx,jy,jz,rfnb )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)
        raise "Invalid array length: ry.length != jy*(n-1)+1" if ry.length != (jy*(n-1)+1)

        #< call the original method >
        __vrfnb1( rx,ry,n,jx,jy,jz,rfnb )
      end
      module_function :vrfnb1, :__vrfnb1 
      private_class_method :__vrfnb1

      alias __vradd vradd 
      def vradd( rx,ry,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)
        raise "Invalid array length: ry.length != jy*(n-1)+1" if ry.length != (jy*(n-1)+1)

        #< call the original method >
        __vradd( rx,ry,n,jx,jy,jz )
      end
      module_function :vradd, :__vradd 
      private_class_method :__vradd

      alias __vradd0 vradd0 
      def vradd0( rx,ry,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)
        raise "Invalid array length: ry.length != jy*(n-1)+1" if ry.length != (jy*(n-1)+1)

        #< call the original method >
        __vradd0( rx,ry,n,jx,jy,jz )
      end
      module_function :vradd0, :__vradd0 
      private_class_method :__vradd0

      alias __vradd1 vradd1 
      def vradd1( rx,ry,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)
        raise "Invalid array length: ry.length != jy*(n-1)+1" if ry.length != (jy*(n-1)+1)

        #< call the original method >
        __vradd1( rx,ry,n,jx,jy,jz )
      end
      module_function :vradd1, :__vradd1 
      private_class_method :__vradd1

      alias __vrsub vrsub 
      def vrsub( rx,ry,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)
        raise "Invalid array length: ry.length != jy*(n-1)+1" if ry.length != (jy*(n-1)+1)

        #< call the original method >
        __vrsub( rx,ry,n,jx,jy,jz )
      end
      module_function :vrsub, :__vrsub 
      private_class_method :__vrsub

      alias __vrsub0 vrsub0 
      def vrsub0( rx,ry,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)
        raise "Invalid array length: ry.length != jy*(n-1)+1" if ry.length != (jy*(n-1)+1)

        #< call the original method >
        __vrsub0( rx,ry,n,jx,jy,jz )
      end
      module_function :vrsub0, :__vrsub0 
      private_class_method :__vrsub0

      alias __vrsub1 vrsub1 
      def vrsub1( rx,ry,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)
        raise "Invalid array length: ry.length != jy*(n-1)+1" if ry.length != (jy*(n-1)+1)

        #< call the original method >
        __vrsub1( rx,ry,n,jx,jy,jz )
      end
      module_function :vrsub1, :__vrsub1 
      private_class_method :__vrsub1

      alias __vrmlt vrmlt 
      def vrmlt( rx,ry,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)
        raise "Invalid array length: ry.length != jy*(n-1)+1" if ry.length != (jy*(n-1)+1)

        #< call the original method >
        __vrmlt( rx,ry,n,jx,jy,jz )
      end
      module_function :vrmlt, :__vrmlt 
      private_class_method :__vrmlt

      alias __vrmlt0 vrmlt0 
      def vrmlt0( rx,ry,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)
        raise "Invalid array length: ry.length != jy*(n-1)+1" if ry.length != (jy*(n-1)+1)

        #< call the original method >
        __vrmlt0( rx,ry,n,jx,jy,jz )
      end
      module_function :vrmlt0, :__vrmlt0 
      private_class_method :__vrmlt0

      alias __vrmlt1 vrmlt1 
      def vrmlt1( rx,ry,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)
        raise "Invalid array length: ry.length != jy*(n-1)+1" if ry.length != (jy*(n-1)+1)

        #< call the original method >
        __vrmlt1( rx,ry,n,jx,jy,jz )
      end
      module_function :vrmlt1, :__vrmlt1 
      private_class_method :__vrmlt1

      alias __vrdiv vrdiv 
      def vrdiv( rx,ry,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)
        raise "Invalid array length: ry.length != jy*(n-1)+1" if ry.length != (jy*(n-1)+1)

        #< call the original method >
        __vrdiv( rx,ry,n,jx,jy,jz )
      end
      module_function :vrdiv, :__vrdiv 
      private_class_method :__vrdiv

      alias __vrdiv0 vrdiv0 
      def vrdiv0( rx,ry,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)
        raise "Invalid array length: ry.length != jy*(n-1)+1" if ry.length != (jy*(n-1)+1)

        #< call the original method >
        __vrdiv0( rx,ry,n,jx,jy,jz )
      end
      module_function :vrdiv0, :__vrdiv0 
      private_class_method :__vrdiv0

      alias __vrdiv1 vrdiv1 
      def vrdiv1( rx,ry,n,jx,jy,jz )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)
        raise "Invalid array length: ry.length != jy*(n-1)+1" if ry.length != (jy*(n-1)+1)

        #< call the original method >
        __vrdiv1( rx,ry,n,jx,jy,jz )
      end
      module_function :vrdiv1, :__vrdiv1 
      private_class_method :__vrdiv1

      alias __cfftb cfftb 
      def cfftb( c,wsave )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_c_0 = c.length
        n = len_c_0 / 2

        #< check array size(s) >
        raise "Invalid array length: c.length != 2*n" if c.length != (2*n)
        raise "Invalid array length: wsave.length != 4*n+15" if wsave.length != (4*n+15)

        #< call the original method >
        __cfftb( n,c,wsave )
      end
      module_function :cfftb, :__cfftb 
      private_class_method :__cfftb

      alias __cfftf cfftf 
      def cfftf( c,wsave )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_c_0 = c.length
        n = len_c_0 / 2

        #< check array size(s) >
        raise "Invalid array length: c.length != 2*n" if c.length != (2*n)
        raise "Invalid array length: wsave.length != 4*n+15" if wsave.length != (4*n+15)

        #< call the original method >
        __cfftf( n,c,wsave )
      end
      module_function :cfftf, :__cfftf 
      private_class_method :__cfftf

      alias __cosqb cosqb 
      def cosqb( x,wsave )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_x_0 = x.length
        n = len_x_0

        #< check array size(s) >
        raise "Invalid array length: x.length != n" if x.length != (n)
        raise "Invalid array length: wsave.length != 3*n+15" if wsave.length != (3*n+15)

        #< call the original method >
        __cosqb( n,x,wsave )
      end
      module_function :cosqb, :__cosqb 
      private_class_method :__cosqb

      alias __cosqf cosqf 
      def cosqf( x,wsave )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_x_0 = x.length
        n = len_x_0

        #< check array size(s) >
        raise "Invalid array length: x.length != n" if x.length != (n)
        raise "Invalid array length: wsave.length != 3*n+15" if wsave.length != (3*n+15)

        #< call the original method >
        __cosqf( n,x,wsave )
      end
      module_function :cosqf, :__cosqf 
      private_class_method :__cosqf

      alias __cost cost 
      def cost( x,wsave )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_x_0 = x.length
        n = len_x_0

        #< check array size(s) >
        raise "Invalid array length: x.length != n" if x.length != (n)
        raise "Invalid array length: wsave.length != 3*n+15" if wsave.length != (3*n+15)

        #< call the original method >
        __cost( n,x,wsave )
      end
      module_function :cost, :__cost 
      private_class_method :__cost

      alias __ezfftb ezfftb 
      def ezfftb( azero,a,b,wsave )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_a_0 = a.length
        n = len_a_0 * 2

        #< check array size(s) >
        raise "Invalid array length: a.length != n/2" if a.length != (n/2)
        raise "Invalid array length: b.length != n/2" if b.length != (n/2)
        raise "Invalid array length: wsave.length != 3*n+15" if wsave.length != (3*n+15)

        #< call the original method >
        __ezfftb( n,azero,a,b,wsave )
      end
      module_function :ezfftb, :__ezfftb 
      private_class_method :__ezfftb

      alias __ezfftf ezfftf 
      def ezfftf( r,wsave )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_r_0 = r.length
        n = len_r_0

        #< check array size(s) >
        raise "Invalid array length: r.length != n" if r.length != (n)
        raise "Invalid array length: wsave.length != 3*n+15" if wsave.length != (3*n+15)

        #< call the original method >
        __ezfftf( n,r,wsave )
      end
      module_function :ezfftf, :__ezfftf 
      private_class_method :__ezfftf

      alias __rfftb rfftb 
      def rfftb( r,wsave )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_r_0 = r.length
        n = len_r_0

        #< check array size(s) >
        raise "Invalid array length: r.length != n" if r.length != (n)
        raise "Invalid array length: wsave.length != 2*n+15" if wsave.length != (2*n+15)

        #< call the original method >
        __rfftb( n,r,wsave )
      end
      module_function :rfftb, :__rfftb 
      private_class_method :__rfftb

      alias __rfftf rfftf 
      def rfftf( r,wsave )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_r_0 = r.length
        n = len_r_0

        #< check array size(s) >
        raise "Invalid array length: r.length != n" if r.length != (n)
        raise "Invalid array length: wsave.length != 2*n+15" if wsave.length != (2*n+15)

        #< call the original method >
        __rfftf( n,r,wsave )
      end
      module_function :rfftf, :__rfftf 
      private_class_method :__rfftf

      alias __sinqb sinqb 
      def sinqb( x,wsave )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_x_0 = x.length
        n = len_x_0

        #< check array size(s) >
        raise "Invalid array length: x.length != n" if x.length != (n)
        raise "Invalid array length: wsave.length != 3*n+15" if wsave.length != (3*n+15)

        #< call the original method >
        __sinqb( n,x,wsave )
      end
      module_function :sinqb, :__sinqb 
      private_class_method :__sinqb

      alias __sinqf sinqf 
      def sinqf( x,wsave )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_x_0 = x.length
        n = len_x_0

        #< check array size(s) >
        raise "Invalid array length: x.length != n" if x.length != (n)
        raise "Invalid array length: wsave.length != 3*n+15" if wsave.length != (3*n+15)

        #< call the original method >
        __sinqf( n,x,wsave )
      end
      module_function :sinqf, :__sinqf 
      private_class_method :__sinqf

      alias __sint sint 
      def sint( x,wsave )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_x_0 = x.length
        n = len_x_0

        #< check array size(s) >
        raise "Invalid array length: x.length != n" if x.length != (n)
        raise "Invalid array length: wsave.length != 2*n+n/2+15" if wsave.length != (2*n+n/2+15)

        #< call the original method >
        __sint( n,x,wsave )
      end
      module_function :sint, :__sint 
      private_class_method :__sint

      alias __vrintr vrintr 
      def vrintr( rx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __vrintr( rx,n,jx )
      end
      module_function :vrintr, :__vrintr 
      private_class_method :__vrintr

      alias __vcintr vcintr 
      def vcintr( cx,n,jx )

        #< check array size(s) >
        raise "Invalid array length: cx.length != jx*(n-1)+1" if cx.length != (jx*(n-1)+1)

        #< call the original method >
        __vcintr( cx,n,jx )
      end
      module_function :vcintr, :__vcintr 
      private_class_method :__vcintr

      alias __vrrnm vrrnm 
      def vrrnm( rx,n,jx,jy,nb )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __vrrnm( rx,n,jx,jy,nb )
      end
      module_function :vrrnm, :__vrrnm 
      private_class_method :__vrrnm

      alias __vrrnm0 vrrnm0 
      def vrrnm0( rx,n,jx,jy,nb )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __vrrnm0( rx,n,jx,jy,nb )
      end
      module_function :vrrnm0, :__vrrnm0 
      private_class_method :__vrrnm0

      alias __vrrnm1 vrrnm1 
      def vrrnm1( rx,n,jx,jy,nb )

        #< check array size(s) >
        raise "Invalid array length: rx.length != jx*(n-1)+1" if rx.length != (jx*(n-1)+1)

        #< call the original method >
        __vrrnm1( rx,n,jx,jy,nb )
      end
      module_function :vrrnm1, :__vrrnm1 
      private_class_method :__vrrnm1

      alias __shtlap shtlap 
      def shtlap( mm,ind,a )

        #< check array size(s) >
        raise "Invalid array length: a.length != (mm+1)*(mm+1)" if a.length != ((mm+1)*(mm+1))

        #< call the original method >
        __shtlap( mm,ind,a )
      end
      module_function :shtlap, :__shtlap 
      private_class_method :__shtlap

      alias __shtfun shtfun 
      def shtfun( mm,jm,m,work )

        #< check array size(s) >

        #< call the original method >
        __shtfun( mm,jm,m,work )
      end
      module_function :shtfun, :__shtfun 
      private_class_method :__shtfun

      alias __shtlfw shtlfw 
      def shtlfw( mm,m,isw,wm,work )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_wm_0 = wm.length
        jm = ( len_wm_0 - 1 ) / 2

        #< check array size(s) >
        raise "Invalid array length: wm.length != 2*jm+1" if wm.length != (2*jm+1)

        #< call the original method >
        __shtlfw( mm,jm,m,isw,wm,work )
      end
      module_function :shtlfw, :__shtlfw 
      private_class_method :__shtlfw

      alias __shtlbw shtlbw 
      def shtlbw( mm,jm,m,isw,sm,work )

        #< check array size(s) >
        raise "Invalid array length: sm.length != mm-m+1" if sm.length != (mm-m+1)

        #< call the original method >
        __shtlbw( mm,jm,m,isw,sm,work )
      end
      module_function :shtlbw, :__shtlbw 
      private_class_method :__shtlbw

      alias __shts2w shts2w 
      def shts2w( mm,jm,isw,s,work )

        #< check array size(s) >
        raise "Invalid array length: s.length != (mm+1)*(mm+1)" if s.length != ((mm+1)*(mm+1))

        #< call the original method >
        __shts2w( mm,jm,isw,s,work )
      end
      module_function :shts2w, :__shts2w 
      private_class_method :__shts2w

      alias __shtswa shtswa 
      def shtswa( mm,jm,isw,m1,m2,s,work )

        #< check array size(s) >
        raise "Invalid array length: s.length != (mm+1)*(mm+1)" if s.length != ((mm+1)*(mm+1))

        #< call the original method >
        __shtswa( mm,jm,isw,m1,m2,s,work )
      end
      module_function :shtswa, :__shtswa 
      private_class_method :__shtswa

      alias __shtswz shtswz 
      def shtswz( mm,jm,isw,s,work )

        #< check array size(s) >
        raise "Invalid array length: s.length != (mm+1)*(mm+1)" if s.length != ((mm+1)*(mm+1))

        #< call the original method >
        __shtswz( mm,jm,isw,s,work )
      end
      module_function :shtswz, :__shtswz 
      private_class_method :__shtswz

      alias __shtswm shtswm 
      def shtswm( mm,jm,m,isw,s,work )

        #< check array size(s) >
        raise "Invalid array length: s.length != (mm+1)*(mm+1)" if s.length != ((mm+1)*(mm+1))

        #< call the original method >
        __shtswm( mm,jm,m,isw,s,work )
      end
      module_function :shtswm, :__shtswm 
      private_class_method :__shtswm

      alias __shtswj shtswj 
      def shtswj( mm,jm,isw,j,m1,m2,s,work )

        #< check array size(s) >
        raise "Invalid array length: s.length != (mm+1)*(mm+1)" if s.length != ((mm+1)*(mm+1))

        #< call the original method >
        __shtswj( mm,jm,isw,j,m1,m2,s,work )
      end
      module_function :shtswj, :__shtswj 
      private_class_method :__shtswj

      alias __shtw2s shtw2s 
      def shtw2s( mm,jm,isw,s,work )

        #< check array size(s) >
        raise "Invalid array length: s.length != (2*jm+1)*(2*mm+1)" if s.length != ((2*jm+1)*(2*mm+1))

        #< call the original method >
        __shtw2s( mm,jm,isw,s,work )
      end
      module_function :shtw2s, :__shtw2s 
      private_class_method :__shtw2s

      alias __shtw2g shtw2g 
      def shtw2g( im,w,work )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ( not_nary(w) || (w.rank < 1) )
          raise "w must be a NArray of rank == 2"
        end
        len_w_0 = w.shape[0]
        jm = ( len_w_0 - 1 ) / 2
        if ( not_nary(w) || (w.rank < 2) )
          raise "w must be a NArray of rank == 2"
        end
        len_w_1 = w.shape[1]
        mm = ( len_w_1 - 1 ) / 2

        #< check array size(s) >
        raise "Invalid array shape: w.shape[0] != (2*jm+1)" if w.shape[0] != ((2*jm+1))
        raise "Invalid array shape: w.shape[1] != (2*mm+1)" if w.shape[1] != ((2*mm+1))
        raise "Invalid array length: work.length != (jm+1)*(4*jm+5*mm+14)+(mm+1)*(mm+1)+mm+2+6*im+15" if work.length != ((jm+1)*(4*jm+5*mm+14)+(mm+1)*(mm+1)+mm+2+6*im+15)

        #< call the original method >
        __shtw2g( mm,jm,im,w,work )
      end
      module_function :shtw2g, :__shtw2g 
      private_class_method :__shtw2g

      alias __shtwga shtwga 
      def shtwga( im,m1,m2,w,work )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ( not_nary(w) || (w.rank < 1) )
          raise "w must be a NArray of rank == 2"
        end
        len_w_0 = w.shape[0]
        jm = ( len_w_0 - 1 ) / 2
        if ( not_nary(w) || (w.rank < 2) )
          raise "w must be a NArray of rank == 2"
        end
        len_w_1 = w.shape[1]
        mm = ( len_w_1 - 1 ) / 2

        #< check array size(s) >
        raise "Invalid array shape: w.shape[0] != (2*jm+1)" if w.shape[0] != ((2*jm+1))
        raise "Invalid array shape: w.shape[1] != (2*mm+1)" if w.shape[1] != ((2*mm+1))
        raise "Invalid array length: work.length != (jm+1)*(4*jm+5*mm+14)+(mm+1)*(mm+1)+mm+2+6*im+15" if work.length != ((jm+1)*(4*jm+5*mm+14)+(mm+1)*(mm+1)+mm+2+6*im+15)

        #< call the original method >
        __shtwga( mm,jm,im,m1,m2,w,work )
      end
      module_function :shtwga, :__shtwga 
      private_class_method :__shtwga

      alias __shtwgm shtwgm 
      def shtwgm( mm,im,m,wr,wi,work )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_wr_0 = wr.length
        jm = ( len_wr_0 - 1 ) / 2

        #< check array size(s) >
        raise "Invalid array length: wr.length != 2*jm+1" if wr.length != (2*jm+1)
        raise "Invalid array length: wi.length != 2*jm+1" if wi.length != (2*jm+1)
        raise "Invalid array length: work.length != (jm+1)*(4*jm+5*mm+14)+(mm+1)*(mm+1)+mm+2+6*im+15" if work.length != ((jm+1)*(4*jm+5*mm+14)+(mm+1)*(mm+1)+mm+2+6*im+15)

        #< call the original method >
        __shtwgm( mm,jm,im,m,wr,wi,work )
      end
      module_function :shtwgm, :__shtwgm 
      private_class_method :__shtwgm

      alias __shtwgz shtwgz 
      def shtwgz( im,wz )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_wz_0 = wz.length
        jm = ( len_wz_0 - 1 ) / 2

        #< check array size(s) >
        raise "Invalid array length: wz.length != 2*jm+1" if wz.length != (2*jm+1)

        #< call the original method >
        __shtwgz( jm,im,wz )
      end
      module_function :shtwgz, :__shtwgz 
      private_class_method :__shtwgz

      alias __shtwgj shtwgj 
      def shtwgj( im,m1,m2,wj,work )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        len_wj_0 = wj.length
        mm = ( len_wj_0 - 1 ) / 2

        #< check array size(s) >
        raise "Invalid array length: wj.length != 2*mm+1" if wj.length != (2*mm+1)

        #< call the original method >
        __shtwgj( mm,im,m1,m2,wj,work )
      end
      module_function :shtwgj, :__shtwgj 
      private_class_method :__shtwgj

      alias __shtg2w shtg2w 
      def shtg2w( mm,g,work )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ( not_nary(g) || (g.rank < 1) )
          raise "g must be a NArray of rank == 2"
        end
        len_g_0 = g.shape[0]
        im = ( len_g_0 - 1 ) / 2
        if ( not_nary(g) || (g.rank < 2) )
          raise "g must be a NArray of rank == 2"
        end
        len_g_1 = g.shape[1]
        jm = ( len_g_1 - 1 ) / 2

        #< check array size(s) >
        raise "Invalid array shape: g.shape[0] != (2*im+1)" if g.shape[0] != ((2*im+1))
        raise "Invalid array shape: g.shape[1] != (2*jm+1)" if g.shape[1] != ((2*jm+1))
        raise "Invalid array length: work.length != (jm+1)*(4*jm+5*mm+14)+(mm+1)*(mm+1)+mm+2+6*im+15" if work.length != ((jm+1)*(4*jm+5*mm+14)+(mm+1)*(mm+1)+mm+2+6*im+15)

        #< call the original method >
        __shtg2w( mm,jm,im,g,work )
      end
      module_function :shtg2w, :__shtg2w 
      private_class_method :__shtg2w

      alias __shts2g shts2g 
      def shts2g( mm,jm,im,isw,s,work )

        #< check array size(s) >
        raise "Invalid array length: s.length != (mm+1)*(mm+1)" if s.length != ((mm+1)*(mm+1))
        raise "Invalid array length: work.length != (jm+1)*(4*jm+5*mm+14)+(mm+1)*(mm+1)+mm+2+6*im+15" if work.length != ((jm+1)*(4*jm+5*mm+14)+(mm+1)*(mm+1)+mm+2+6*im+15)

        #< call the original method >
        __shts2g( mm,jm,im,isw,s,work )
      end
      module_function :shts2g, :__shts2g 
      private_class_method :__shts2g

      alias __shtsga shtsga 
      def shtsga( mm,jm,im,isw,m1,m2,s,work )

        #< check array size(s) >
        raise "Invalid array length: s.length != (mm+1)*(mm+1)" if s.length != ((mm+1)*(mm+1))
        raise "Invalid array length: work.length != (jm+1)*(4*jm+5*mm+14)+(mm+1)*(mm+1)+mm+2+6*im+15" if work.length != ((jm+1)*(4*jm+5*mm+14)+(mm+1)*(mm+1)+mm+2+6*im+15)

        #< call the original method >
        __shtsga( mm,jm,im,isw,m1,m2,s,work )
      end
      module_function :shtsga, :__shtsga 
      private_class_method :__shtsga

      alias __shtsgz shtsgz 
      def shtsgz( mm,jm,im,isw,s,work )

        #< check array size(s) >
        raise "Invalid array length: s.length != (mm+1)*(mm+1)" if s.length != ((mm+1)*(mm+1))
        raise "Invalid array length: work.length != (jm+1)*(4*jm+5*mm+14)+(mm+1)*(mm+1)+mm+2+6*im+15" if work.length != ((jm+1)*(4*jm+5*mm+14)+(mm+1)*(mm+1)+mm+2+6*im+15)

        #< call the original method >
        __shtsgz( mm,jm,im,isw,s,work )
      end
      module_function :shtsgz, :__shtsgz 
      private_class_method :__shtsgz

      alias __shtsgm shtsgm 
      def shtsgm( mm,jm,im,m,isw,s,work )

        #< check array size(s) >
        raise "Invalid array length: s.length != (mm+1)*(mm+1)" if s.length != ((mm+1)*(mm+1))
        raise "Invalid array length: work.length != (jm+1)*(4*jm+5*mm+14)+(mm+1)*(mm+1)+mm+2+6*im+15" if work.length != ((jm+1)*(4*jm+5*mm+14)+(mm+1)*(mm+1)+mm+2+6*im+15)

        #< call the original method >
        __shtsgm( mm,jm,im,m,isw,s,work )
      end
      module_function :shtsgm, :__shtsgm 
      private_class_method :__shtsgm

      alias __shtsgj shtsgj 
      def shtsgj( mm,jm,im,isw,j,m1,m2,s,work )

        #< check array size(s) >
        raise "Invalid array length: s.length != (mm+1)*(mm+1)" if s.length != ((mm+1)*(mm+1))
        raise "Invalid array length: work.length != (jm+1)*(4*jm+5*mm+14)+(mm+1)*(mm+1)+mm+2+6*im+15" if work.length != ((jm+1)*(4*jm+5*mm+14)+(mm+1)*(mm+1)+mm+2+6*im+15)

        #< call the original method >
        __shtsgj( mm,jm,im,isw,j,m1,m2,s,work )
      end
      module_function :shtsgj, :__shtsgj 
      private_class_method :__shtsgj

      alias __shtg2s shtg2s 
      def shtg2s( mm,isw,g,work )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ( not_nary(g) || (g.rank < 1) )
          raise "g must be a NArray of rank == 2"
        end
        len_g_0 = g.shape[0]
        im = ( len_g_0 - 1 ) / 2
        if ( not_nary(g) || (g.rank < 2) )
          raise "g must be a NArray of rank == 2"
        end
        len_g_1 = g.shape[1]
        jm = ( len_g_1 - 1 ) / 2

        #< check array size(s) >
        raise "Invalid array shape: g.shape[0] != (2*im+1)" if g.shape[0] != ((2*im+1))
        raise "Invalid array shape: g.shape[1] != (2*jm+1)" if g.shape[1] != ((2*jm+1))
        raise "Invalid array length: work.length != (jm+1)*(4*jm+5*mm+14)+(mm+1)*(mm+1)+mm+2+6*im+15" if work.length != ((jm+1)*(4*jm+5*mm+14)+(mm+1)*(mm+1)+mm+2+6*im+15)

        #< call the original method >
        __shtg2s( mm,jm,im,isw,g,work )
      end
      module_function :shtg2s, :__shtg2s 
      private_class_method :__shtg2s

      alias __vs1din vs1din 
      def vs1din( wz,nw,x )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ( not_nary(wz) || (wz.rank < 1) )
          raise "wz must be a NArray of rank == 2"
        end
        len_wz_0 = wz.shape[0]
        ix = len_wz_0

        #< check array size(s) >
        raise "Invalid array shape: wz.shape[0] != ix" if wz.shape[0] != (ix)
        raise "Invalid array shape: wz.shape[1] != 2" if wz.shape[1] != (2)
        raise "Invalid array length: nw.length != ix" if nw.length != (ix)
        raise "Invalid array length: x.length != ix" if x.length != (ix)

        #< call the original method >
        __vs1din( wz,nw,ix,x )
      end
      module_function :vs1din, :__vs1din 
      private_class_method :__vs1din

      alias __vs1out vs1out 
      def vs1out( wz,nw )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ( not_nary(wz) || (wz.rank < 1) )
          raise "wz must be a NArray of rank == 2"
        end
        len_wz_0 = wz.shape[0]
        ix = len_wz_0

        #< check array size(s) >
        raise "Invalid array shape: wz.shape[0] != ix" if wz.shape[0] != (ix)
        raise "Invalid array shape: wz.shape[1] != 2" if wz.shape[1] != (2)
        raise "Invalid array length: nw.length != ix" if nw.length != (ix)

        #< call the original method >
        __vs1out( wz,nw,ix )
      end
      module_function :vs1out, :__vs1out 
      private_class_method :__vs1out

      alias __vs2din vs2din 
      def vs2din( wz,nw,x,y )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ( not_nary(wz) || (wz.rank < 1) )
          raise "wz must be a NArray of rank == 3"
        end
        len_wz_0 = wz.shape[0]
        ix = len_wz_0
        if ( not_nary(wz) || (wz.rank < 2) )
          raise "wz must be a NArray of rank == 3"
        end
        len_wz_1 = wz.shape[1]
        iy = len_wz_1

        #< check array size(s) >
        raise "Invalid array shape: wz.shape[0] != ix" if wz.shape[0] != (ix)
        raise "Invalid array shape: wz.shape[1] != iy" if wz.shape[1] != (iy)
        raise "Invalid array shape: wz.shape[2] != 5" if wz.shape[2] != (5)
        raise "Invalid array shape: nw.shape[0] != ix" if nw.shape[0] != (ix)
        raise "Invalid array shape: nw.shape[1] != iy" if nw.shape[1] != (iy)
        raise "Invalid array length: x.length != ix" if x.length != (ix)
        raise "Invalid array length: y.length != ix" if y.length != (ix)

        #< call the original method >
        __vs2din( wz,nw,ix,iy,x,y )
      end
      module_function :vs2din, :__vs2din 
      private_class_method :__vs2din

      alias __vs2out vs2out 
      def vs2out( wz,nw )

        #< extract array size(s) (which was(were) formerly an argument(s)) >
        if ( not_nary(wz) || (wz.rank < 1) )
          raise "wz must be a NArray of rank == 3"
        end
        len_wz_0 = wz.shape[0]
        ix = len_wz_0
        if ( not_nary(wz) || (wz.rank < 2) )
          raise "wz must be a NArray of rank == 3"
        end
        len_wz_1 = wz.shape[1]
        iy = len_wz_1

        #< check array size(s) >
        raise "Invalid array shape: wz.shape[0] != ix" if wz.shape[0] != (ix)
        raise "Invalid array shape: wz.shape[1] != iy" if wz.shape[1] != (iy)
        raise "Invalid array shape: wz.shape[2] != 5" if wz.shape[2] != (5)
        raise "Invalid array shape: nw.shape[0] != ix" if nw.shape[0] != (ix)
        raise "Invalid array shape: nw.shape[1] != iy" if nw.shape[1] != (iy)

        #< call the original method >
        __vs2out( wz,nw,ix,iy )
      end
      module_function :vs2out, :__vs2out 
      private_class_method :__vs2out

    end
end
