#
# vstl01.rb
#
# $Id: vstl01.rb,v 1.2 2000/11/27 01:54:00 keiko Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math


IX = 3
NN = 4

x = NArray[1, 3,-1, 2,-4, 0, 2, 1, 3, 2, 1, 0]
x.reshape!(IX, NN)

print " *** TEST FOR VS1INT / VS1DIN / VS1OUT\n"
wz1, nw1 = DCL::vs1int(IX)
for j in 0..NN-1
  printf " INPUT = %s\n", sprintf("%6.1f"*IX, x[0,j], x[1,j], x[2,j])
  wz1, nw1 = DCL::vs1din(wz1, nw1, x[true,j])
end
wz1 = DCL::vs1out(wz1, nw1)
printf " AVE.  = %s\n", "%6.1f"*IX % wz1[0..IX-1].to_a
printf " VAR.  = %s\n", "%6.1f"*IX % wz1[IX..2*IX-1].to_a

