#!/usr/bin/env ruby

=begin
=Command gdir_server.rb 

A stand-alone server program to provide a directory service of GPHys
objects by using GDir.

==Usage

At the  command line,

   % gdir_service.rb top_dir [port]

where top_dir can be ., /, or whatever directory in your files system,
and port is the prot number you want to assign (internally determined
if not specified). A complete URI is printed if the server is started.

=end

require "drb/drb"
require "numru/gdir"

module NumRu
  class GDir
    include DRbUndumped
  end
end

class NArray
  def self._load(o) to_na(*Marshal::load(o)).ntoh end
  def _dump(limit) 
    Marshal::dump([hton.to_s, typecode, *shape]) 
  end
end

include NumRu

def usage
return <<EOS
USAGE: % #{$0} top_dir [port]
(where top_dir can be ., /, or whatever directory in your files system).
EOS
end

# <interpret comman-line arguments>
top = ARGV.shift || raise(usage)
port = ARGV.shift
print usage if port && port.to_i.to_s != port    # make sure it is an integer

# <set the top & direcotry>
begin
  GDir.top = top
  rootdir = GDir.new('/')
rescue
  raise($!.to_s+"\n"+usage)
end

# <start the server>
uri_seed = ( port ? 'druby://:'+port : nil )
DRb.start_service(uri_seed, rootdir)
puts 'URI: '+DRb.uri
puts '[return] to exit'
gets
