require "rbconfig"
require "ftools"
require "getopts"
include Config

package = "gave"

bindir = "/usr/local/bin"
sitelibdir = CONFIG["sitelibdir"]+"/numru"
localedir = "/usr/share/locale/"


def usage()
  print "Usage: ruby #$0 [-h|--help] [--bindir=] [--sitelibdir=] [--localedir=]\n"
  exit 1
end

if !getopts("h","help",
                "bindir:#{bindir}",
                "sitelibdir:#{sitelibdir}",
                "localedir:#{localedir}")
   usage()
end

if $OPT_h || $OPT_help
   usage()
end

bindir = $OPT_bindir
sitelibdir = $OPT_sitelibdir
localedir = $OPT_localedir

subdir = sitelibdir+"/"+package

bin_file = [package]
sub_files = %w(draw.rb)
locale = %w(ja)


File.makedirs(bindir)
bin_file.each{|f|
  File.install(f,bindir)
}

File.makedirs(subdir)
sub_files.each{|f|
  File.install(f,subdir)
}

locale.each{|l|
  message_dir = "#{localedir}#{l}/LC_MESSAGES/"
  File.makedirs(message_dir)
  File.install("po/#{l}.mo","#{message_dir}#{package}.mo")
}


