require 'easy_vtk'
require 'narray'

dim = 10

dx = 1.0/dim
x = NArray.sfloat( dim ).indgen * dx
y = NArray.sfloat( dim ).indgen * dx
z = NArray.sfloat( dim ).indgen * dx

data = NArray.sfloat( dim, dim, dim )
for k in 0...dim
  for j in 0...dim
    for i in 0...dim
      val = 2.0*(i.to_f/(dim-1)-0.5)**2 + 1.0*(j.to_f/(dim-1)-0.5)**2 + 0.5*(k.to_f/(dim-1)-0.5)**2
      data[ i, j, k ] = val
    end
  end
end
data.reshape!( dim*dim*dim )


EasyVtk::init
EasyVtk::set_axes( x, y, z )
EasyVtk::set_data( data )
EasyVtk::plane( [0.5, 0.5, 0.5], [0, 0, 1] )
EasyVtk::plane( [0.5, 0.5, 0.5], [0, 1, 0] )
EasyVtk::plane( [0.5, 0.5, 0.5], [1, 0, 0] )
EasyVtk::colorbar( 'orientation' => 'horizontal',
                   'height' => 0.17,
                   'width' => 0.5,
                   'position' => [ 0.25, 0.05 ]
                  )
EasyVtk::gui_start
