!= Matthews Υǡ˴Ťɽ̥٥
!
!= set surface albedo based on data by Matthews
!
! Authors::   Yoshiyuki O. Takahashi, Satoshi Noda
! Version::   $Id: albedo_Matthews.f90,v 1.7 2011-07-29 07:25:23 noda Exp $
! Tag Name::  $Name: dcpam5-20110926 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module albedo_Matthews

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision.
    &                 STRING     ! ʸ.       Strings.

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʻ
  ! Grid points settings

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: SetAlbedoMatthews
  public:: AlbedoMatthewsInit

  ! ѿ
  ! Public variables
  !

  ! ѿ
  ! Private variables
  !
  logical, save :: albedo_matthews_inited = .false.
                              ! ե饰.
                              ! Initialization flag
  logical   , save      :: flag_annual_mean
                              ! ǯʿѥե饰.
                              ! Flag of annual mean
  real(DP)  , save      :: OceanAlbedo
                              ! ΤΥ٥.
                              ! Albedo of ocean.

  integer , parameter :: NAlbType = 32
                              ! μο.
                              ! Number of vegetation type.
  integer , parameter :: NSeason = 4
                              ! ο.
                              ! Number of season.
  real(DP), save      :: a_Data_DOY( NSeason )
                              ! Ƶγ.
                              ! Start date of each season.
  real(DP), save      :: aa_Data_Albedo( NSeason, 0:NAlbType )
                              ! ƿ, Ƶˤ륢٥.
                              ! Albedo of each vegetation type, each season.

  !    win.  spr.  sum.  fall
  data a_Data_DOY / 0.0d0, 90.0d0, 181.0d0, 273.0d0 /

  !
  ! Matthews, 1985, NASA Technical memorandum #86199 
  ! ATLAS, OF ARCHIVED VEGETATION, LAND-USE AND SEASONAL ALBEDO DATA SET
  ! http://ntrs.nasa.gov/archive/nasa/casi.ntrs.nasa.gov/19850016197_1985016197.pdf
  ! 
  ! Notice: The unit of the following values is percent.
  !         0.01 is multiplied in initialization.
  !
  !    win.  spr.  sum.  fall
  !    Jan.  Apr.  Jul.  Oct.   for nothern hemisphere
  !    Jul.  Oct.  Jan.  Apr.   for southern hemisphere
  data aa_Data_Albedo / &
    10,   10,   10,   10, & !  0  The values for 0 are not included in Matthes compilation.
    11,   11,   11,   11, & !  1
    11,   11,   11,   11, & !  2
    11,   11,   11,   11, & !  3
    12,   12,   12,   12, & !  4
    12,   13,   14,   13, & !  5
    17,   14,   13,   14, & !  6
    13,   14,   16,   13, & !  7
    11,   12,   15,   12, & !  8
    18,   16,   15,   16, & !  9
    12,   15,   18,   13, & ! 10
    12,   15,   18,   13, & ! 11
    28,   32,   28,   28, & ! 12
    15,   13,   12,   13, & ! 13
    14,   14,   16,   14, & ! 14
    20,   18,   17,   18, & ! 15
    14,   14,   17,   14, & ! 16
    15,   15,   18,   15, & ! 17
    15,   15,   18,   15, & ! 18
    17,   20,   20,   17, & ! 19
    17,   20,   20,   17, & ! 20
    28,   32,   28,   28, & ! 21
    12,   12,   17,   15, & ! 22
    14,   15,   17,   15, & ! 23
    14,   15,   16,   14, & ! 24
    16,   18,   25,   20, & ! 25
    17,   17,   20,   17, & ! 26
    16,   20,   20,   18, & ! 27
    16,   20,   20,   18, & ! 28
    16,   20,   20,   18, & ! 29
    30,   30,   30,   30, & ! 30
    75,   75,   75,   75, & ! 31
    16,   18,   20,   18  & ! 32
    /


  character(*), parameter:: module_name = 'albedo_Matthews'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20110926 $' // &
    & '$Id: albedo_Matthews.f90,v 1.7 2011-07-29 07:25:23 noda Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !

contains

  !--------------------------------------------------------------------------------------

  subroutine SetAlbedoMatthews( xy_SurfCond, xy_SurfAlbedo )

    ! ⥸塼 ; USE statements
    !

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: imax, & ! ٳʻ.
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ.
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ.
                               ! Number of vertical level

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_calendar, only: DCCalInquire, DCCalDateEvalSecOfYear

    ! 
    ! Time control
    !
    use timeset, only: TimeN, InitialDate

    ! ʸ ; Declaration statements
    !
    integer , intent(in ) :: xy_SurfCond  ( 0:imax-1, 1:jmax )
                              ! Υǥå
                              ! Index of vegetation
    real(DP), intent(out) :: xy_SurfAlbedo( 0:imax-1, 1:jmax )
                              ! ɽ٥.
                              ! Surface albedo

    ! ѿ
    ! Work variables
    !
    real(DP):: SecOfYear
    real(DP):: a_Data_SOY_Ex( 0:nseason+1 )
                              ! Ƶγϻ (ޤΤ˳ĥ).
                              ! Start time of each season (extended for interpolation).
    real(DP):: xya_SurfAlbedoLocal( 0:imax-1, 1:jmax, 1:2 )
    integer :: i              ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer :: j              ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer :: l              ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in season
    integer :: t
    integer :: tindex
    integer :: a_tindex(1:2)

    integer:: hour_in_day, min_in_hour, day_in_year
    integer, pointer:: day_in_month_ptr(:) => null()
    real(DP):: sec_in_min, sec_in_day

    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. albedo_matthews_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    if ( flag_annual_mean ) then

      !
      ! Now, annual mean value is used, temporarily.
      !
      xy_SurfAlbedo = 0.0d0

      do l = 1, nseason
        do j = 1, jmax
          do i = 0, imax-1
            xy_SurfAlbedo(i,j) = xy_SurfAlbedo(i,j) + aa_Data_Albedo( l, xy_SurfCond(i,j) )
          end do
        end do
      end do

      xy_SurfAlbedo = xy_SurfAlbedo / dble( nseason )

    else

      SecOfYear = DCCalDateEvalSecOfYear( TimeN, date = InitialDate )

      call DCCalInquire( &
        & day_in_month_ptr = day_in_month_ptr , & ! (out)
        & hour_in_day      = hour_in_day  , &     ! (out)
        & min_in_hour      = min_in_hour  , &     ! (out)
        & sec_in_min       = sec_in_min )         ! (out)

      day_in_year = sum( day_in_month_ptr )
      deallocate( day_in_month_ptr )
      sec_in_day  = hour_in_day * min_in_hour * sec_in_min


      if ( SecOfYear > day_in_year * sec_in_day ) SecOfYear = day_in_year * sec_in_day

      a_Data_SOY_Ex(0) = ( 0.0d0 - ( day_in_year - a_Data_DOY(nseason) ) ) * sec_in_day
      do t = 1, nseason
        a_Data_SOY_Ex(t) = a_Data_DOY(t) * sec_in_day
      end do
      a_Data_SOY_Ex(nseason+1) = ( day_in_year + a_Data_DOY(1) ) * sec_in_day


      a_tindex(1) = 0
      a_tindex(2) = 1
      do t = 1, nseason
        if ( a_Data_DOY(t) * sec_in_day <= SecOfYear ) then
          a_tindex(1) = t
          a_tindex(2) = t+1
        end if
      end do

      do t = 1, 2
        ! for northern hemisphere
        tindex = a_tindex(t)
        if ( tindex == 0 ) then
          tindex = nseason
        else if ( tindex == nseason+1 ) then
          tindex = 1
        else
          tindex = tindex
        end if
        do j = jmax/2+1, jmax
          do i = 0, imax-1
            xya_SurfAlbedoLocal(i,j,t) = aa_Data_Albedo( tindex, xy_SurfCond(i,j) )
          end do
        end do
        ! for southern hemisphere
        tindex = a_tindex(t) + nseason / 2
        if ( tindex > nseason ) tindex = tindex - nseason
        if ( tindex == 0 ) then
          tindex = nseason
        else if ( tindex == nseason+1 ) then
          tindex = 1
        else
          tindex = tindex
        end if
        do j = 1, jmax/2
          do i = 0, imax-1
            xya_SurfAlbedoLocal(i,j,t) = aa_Data_Albedo( tindex, xy_SurfCond(i,j) )
          end do
        end do
      end do

      xy_SurfAlbedo =                                                   &
        &   ( xya_SurfAlbedoLocal(:,:,2) - xya_SurfAlbedoLocal(:,:,1) ) &
        & / ( a_Data_SOY_Ex(a_tindex(2)) - a_Data_SOY_Ex(a_tindex(1)) ) &
        & * ( SecOfYear                  - a_Data_SOY_Ex(a_tindex(1)) ) &
        & + xya_SurfAlbedoLocal(:,:,1)

    end if


  end subroutine SetAlbedoMatthews

  !--------------------------------------------------------------------------------------

  subroutine AlbedoMatthewsInit

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ѿ
    ! Work variables
    !
    integer:: unit_nml        ! NAMELIST ե륪ץֹ.
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT.
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /albedo_Matthews_nml/ &
      & flag_annual_mean, &
      & OceanAlbedo
          !
          ! ǥեͤˤĤƤϽ³ "surface_flux_bulk#SurfFluxInit"
          ! Υɤ򻲾ȤΤ.
          !
          ! Refer to source codes in the initialization procedure
          ! "surface_flux_bulk#SurfFluxInit" for the default values.
          !

    if ( albedo_matthews_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
    flag_annual_mean = .false.
    OceanAlbedo      = 0.1d0


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                ! (in)
        & nml = albedo_Matthews_nml, &  ! (out)
        & iostat = iostat_nml )        ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if



    aa_Data_Albedo = aa_Data_Albedo * 1.0d-2


    aa_Data_Albedo(:,0) = OceanAlbedo



    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  flag_annual_mean = %b', l = (/ flag_annual_mean /) )
    call MessageNotify( 'M', module_name, '  OceanAlbedo      = %f', d = (/ OceanAlbedo      /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    albedo_matthews_inited = .true.

  end subroutine AlbedoMatthewsInit

  !--------------------------------------------------------------------------------------

end module albedo_Matthews
