########################################################################
# ISPACK FORTRAN SUBROUTINE LIBRARY FOR SCIENTIFIC COMPUTING
# Copyright (C) 1998--2017 Keiichi Ishioka <ishioka@gfd-dennou.org>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301 USA.
########################################################################
.text
.globl fvrqbp_
.globl _fvrqbp_	
fvrqbp_:
_fvrqbp_:	
	movl   (%rdi), %edi  # N  rdi 	
      # X Ƭɥ쥹 rsi 
      # T Ƭɥ쥹 rdx 

	shlq $4,%rdi # rdi  16*N

	vbroadcastsd C2(%rip),%ymm11 # ư 2  ymm11 4ս
	
	vmovapd   (%rsi), %ymm0 # X(I,1,0)
	vmovapd 32(%rsi), %ymm1 # X(I,2,0)	
	vaddpd %ymm1,%ymm0,%ymm2
	vsubpd %ymm1,%ymm0,%ymm0
	vmovapd %ymm2,(%rsi)
	vmovapd %ymm0,32(%rsi)

	vsubpd %ymm2,%ymm2,%ymm2
	vmovapd   (%rsi,%rdi), %ymm0 # X(I,1,N/4)
	vmovapd 32(%rsi,%rdi), %ymm1 # X(I,2,N/4)	
	vmulpd  %ymm11,%ymm0,%ymm0
	vmovapd  %ymm0,(%rsi,%rdi)  # X(I,1,N/4)
	vmulpd  %ymm11,%ymm1,%ymm1
	vsubpd %ymm1,%ymm2,%ymm2
	vmovapd %ymm2,32(%rsi,%rdi)  # X(I,2,N/4)

	cmpq $64,%rdi
	je LE # N=4 ξϤǽλ

	shrq $2,%rdi # rdi  4*N	
	movq %rdx,%r8
        addq %rdi,%r8	# r8 ϽλȽ˻Ȥ

	shlq $3,%rdi # rdi  32*N
	addq %rsi,%rdi # rdi  rsi + 32*N

	addq $16,%rdx
	addq $64,%rsi
	subq $64,%rdi
	
L1:
	vbroadcastsd (%rdx), %ymm8 # T(1,K)
	vbroadcastsd 8(%rdx), %ymm9 # T(2,K)
	
	vmovapd   (%rsi), %ymm0 # X(I,1,K)
	vmovapd 32(%rsi), %ymm1 # X(I,2,K)	
	vmovapd   (%rdi), %ymm2 # X(I,1,N/2-K)
	vmovapd 32(%rdi), %ymm3 # X(I,2,N/2-K)

	vaddpd %ymm2,%ymm0,%ymm4 # p1
	vsubpd %ymm2,%ymm0,%ymm0 # m1
	vaddpd %ymm3,%ymm1,%ymm5 # p2
	vsubpd %ymm3,%ymm1,%ymm1 # m2

#	vmulpd %ymm9,%ymm0,%ymm2 #m1*tr2
#	vsubpd %ymm2,%ymm4,%ymm2 #p1-m1*tr2
	vmovapd %ymm0,%ymm2
        vfnmadd132pd %ymm9,%ymm4,%ymm2 # ymm2 = - ymm2 * ymm9 + ymm4
#	vmulpd %ymm8,%ymm5,%ymm3 #p2*tr1
#	vsubpd %ymm3,%ymm2,%ymm2 #p1-m1*tr2-p2*tr1
	vfnmadd231pd %ymm8,%ymm5,%ymm2 # ymm2 = - ymm5 * ymm8 + ymm2
	vmovapd %ymm2,  (%rsi) # X(I,1,K)

#	vmulpd %ymm9,%ymm5,%ymm5 #p2*tr2
#	vsubpd %ymm5,%ymm1,%ymm5 #m2-p2*tr2
        vfnmadd132pd %ymm9,%ymm1,%ymm5 # ymm5 = - ymm5 * ymm9 + ymm1
	
#	vmulpd %ymm8,%ymm0,%ymm7 #m1*tr1
#	vaddpd %ymm7,%ymm5,%ymm5 #m2-p2*tr2+m1*tr1
	vfmadd231pd %ymm8,%ymm0,%ymm5 # ymm5 = ymm0 * ymm8 + ymm5
	vmovapd %ymm5,  32(%rsi) # X(I,2,K)

#	vmulpd %ymm11,%ymm4,%ymm4
#	vsubpd %ymm2,%ymm4,%ymm4
        vfmsub132pd %ymm11,%ymm2,%ymm4 # ymm4 = ymm4 * ymm11 - ymm2
	vmovapd %ymm4,(%rdi) # X(I,1,N/2-K)	

#	vmulpd %ymm11,%ymm1,%ymm1
#	vsubpd %ymm1,%ymm5,%ymm1
        vfnmadd132pd %ymm11,%ymm5,%ymm1 # ymm1 = - ymm1 * ymm11 + ymm5
	vmovapd %ymm1,32(%rdi) # X(I,2,N/2-K)	

	addq $16,%rdx
	addq $64,%rsi
	subq $64,%rdi
	cmpq %rdx,%r8
	jne L1
	
LE:
	
	ret

C2: # ư 2
	.long   0x00000000,0x40000000
	
