def dependency(path)
    begin
		fpDepOrg = open(path + "/depend","r")
		fpDepWin = open(path + "/Makefile.win","a")
		while line = fpDepOrg.gets
			fpDepWin.puts(line.gsub(".o",".obj"))
		end
		fpDepOrg.close
		fpDepWin.close
		print( "Making depend.win in " , path , "\n")
	rescue
		print( "W: There is no depend File in " , path , "\n" )
	end
end

def objs(path)
	objs = ""
    begin
		fpDepOrg = open(path + "/Makefile","r")
		fpDepWin = open(path + "/makefile.win","a")
		fObjs = false
		while line = fpDepOrg.gets
			if /^OBJS/ =~ line
				if /\\$/ =~ line
					fObjs = true
				else
					fObjs = false
					objs += " "
					objs += line.gsub(".o",".obj").chomp.strip
					objs.strip!
				end
			end
			if fObjs == true
					objs += " "
					objs += line.gsub(".o",".obj").chomp.strip
					objs.strip!
				if /\\$/ =~ line
				else
					fObjs = false
				end
			end
		end
		fpDepOrg.close

		fpDepWin.puts(objs.gsub("\\",""))
		fpDepWin.puts("\n")
		fpDepWin.close
		print( "Output OBJS in " , path , "\n")
	rescue
		print( "W: There is no Makefile in " , path , "\n" )
	end
end

def dirdepth(path)
    begin
		fpDepOrg = open(path + "/Makefile","r")
		fpDepWin = open(path + "/makefile.win","a")
		while line = fpDepOrg.gets
			if /^DIRDEPTH/ =~ line
				fpDepWin.puts(line)
			end
		end
		fpDepOrg.close

		fpDepWin.close
		print( "Output DIRDEPTH in " , path , "\n")
	rescue
		print( "W: There is no Makefile in " , path , "\n" )
	end
end

def subdirs(path)
    sdir = Dir.pwd
	Dir.chdir(path)
	cpath = "."
	dir =Dir.open(cpath)
	subdirs = "SUBDIRS ="
	while name = dir.read
		FileTest.directory?(name)
		next if name == "."
		next if name == ".."
		next if name == "Module"
		if FileTest.directory?(name)
			subdirs += " "
			subdirs += name
		end
	end
	Dir.chdir(sdir)
	begin
 		fpDepWin = open(path + "/Makefile.win","a")
		fpDepWin.puts(subdirs)
		fpDepWin.puts("\n")
		fpDepWin.close
	rescue
		print( "W: There is no Makefile in " , path , "\n" )
	end
end

def includes(path)
	begin
		fpDepWin = open(path + "/Makefile.win","a")
		fpDepWin.puts("INCLUDEFILE = $(DIRDEPTH)/Config.mk.Win")
		fpDepWin.puts("\n")
		fpDepWin.close
		print( "Output Includes in " , path , "\n")
	rescue
		print( "W: There is no Makefile in " , path , "\n" )
	end
end

def makefile_header(path)
	fpDepWin = open(path + "/Makefile.win","w")
	fpDepWin.puts( <<END_OF_HEADER
######################################################################
#
#= Makefile for build of gtool5 library in Windows
#
# Authors::   Naohito OTOBE (otobe), Yasuhiro MORIKAWA (morikawa)
# Version::   2009-11-10 configure-win.rb
# Name::      gtool5-20090809 
# Copyright:: Copyright (C) GFD Dennou Club, 2007-. All rights reserved.
# License::   See COPYRIGHT[COPYRIGHT]
#
#This "Makefile.win" was auto-generated by "configure-win.rb".
#Original files are "Makefile,depend".
#
######################################################################

END_OF_HEADER
)
	fpDepWin.close
	print( "Making Makefile.win in " , path , "\n")
end

def makefile_footer(path)
	begin
		fpDepWin = open(path + "/Makefile.win","a")
		fpDepWin.puts( "!include $(INCLUDEFILE)" )
		fpDepWin.close
		print( "closing Makefile.win in " , path , "\n")
	rescue
		print( "W: There is no Makefile in " , path , "\n" )
	end
end

def traverse(path)
	if FileTest.directory?(path)
p path
		if path == "src"
			Dir.mkdir(path + "/Module")
		end
		makefile_header(path)
		dirdepth(path)
		includes(path)
		subdirs(path)
		objs(path)
		dependency(path)
		makefile_footer(path)
		dir = Dir.open(path)
		while name = dir.read
			next if name == "."
			next if name == ".."
			traverse(path + "/" + name)
		end
	else
	end
end

rootdir = "src"
traverse(rootdir)
