=begin JA

= ӻ

# *  (morikawa)
#   * $Id: dc_date.rd,v 1.1 2009-02-28 16:07:56 morikawa Exp $

=end JA

=begin EN

= Date and Time Management

# *  (morikawa)
#   * $Id: dc_date.rd,v 1.1 2009-02-28 16:07:56 morikawa Exp $

=end EN


=begin JA

== 

gtool5 Ǥδưפˤ뤿Υ⥸塼Ȥ
((<dc_date|URL:../code_reference/classes/dc_date.html>)) 
ѰդƤޤ. 
Υ⥸塼λѤˤ˺ݤƤ
ǯ, , , , ʬ, äѴưפ˹ԤȤǽȤʤޤ.

ʲǤ, ʬ롼פ˴ؤ, dc_date
λˡҲ𤷤ޤ. 

== dc_date Ѥץ

Ȥ, 
((<"Fortran 90/95 ѥ⥸塼: ̷ѥ᥿"|URL:dc_types.htm>)) 
Ѥ ((<ץץ|URL:dc_types/diffusion_3.f90>)) 
 dc_date Ѥץ򼨤ޤ
(Ȼ֥ƥå¿ѹƤޤ). 
ɤ((<|URL:dc_date/diffusion_date.f90>)). 
ֻ(顼Ǥʤϥܡ) dc_date ˴طƤսǤ. 

=end JA
=begin EN

Under construction. 

=end EN


=begin HTML
<pre style="background-color: #FFFFFF; color: blue; border-style: groove; border-width: 2">
!= Sample program for gtool_history/gtool5
!
! * 2009/02/28 Y.Morikawa
! * 2007/06/25 M.Odaka
! * 2006/10/25 Y.Morikawa
! * 2003/08/21 M.Odaka
! * 2001/02/27 S.Takehiro
!
! Solving diffusion equation
! \[
!     du/dt = \kappa d^2 u/dx^2
! \]
! for giving values of $u$ at $x=[0,1]$.
!
program diffusion_date

  use gtool_history                                 ! Access module (⥸塼)
  <b><font color="red">use dc_date                                       ! Access module (⥸塼)</font></b>
  use dc_types                                      ! Access module (⥸塼)

  integer, parameter     :: nx=30                   ! Grid number (åɿ)
  real(DP), parameter    :: dx=1.0/(nx-1)           ! Grid interval (åɴֳ)
  real(DP), parameter    :: dt=1.                   ! Time step [s] (ֳִ [])
  <b><font color="red">type(DC_DIFFTIME)      :: deltime                 ! Time step (ֳִ)</font></b>
  <b><font color="red">type(DC_DIFFTIME)      :: endtime                 ! End time (λ)</font></b>
  <b><font color="red">type(DC_DIFFTIME)      :: dsptime                 ! Output interval (ϴֳ)</font></b>
  <b><font color="red">type(DC_DIFFTIME)      :: curtime                 ! Current time (߻)</font></b>
  real(DP), dimension(nx):: x=(/(dx*(i-1),i=1,nx)/) ! X coordinate (ɸѿ)
  real(DP), dimension(nx):: temp                    ! Temperature ()
  real(DP), parameter    :: kappa=0.0001            ! Diffusion coefficient (ǮȻ)

  <b><font color="red">type(DC_DATETIME):: date                          ! Date ()</font></b>
  character(256):: date_str
<b><font color="red">
  call DCDateTimeCreate(date, year=2009, mon=2, day=28, hour=23, min=59)
                                                    ! Set date
                                                    ! ()

  call DCDiffTimeCreate(curtime, 0., 'sec')         ! Set initial time 
                                                    ! ()
  call DCDiffTimeCreate(deltime, dt, 'sec')         ! Set time step
                                                    ! (ֳִ)
  call DCDiffTimeCreate(endtime, 10., 'min')        ! Set end time 
                                                    ! (λ)
  call DCDiffTimeCreate(dsptime, 0.1, 'min')        ! Set output interval
                                                    ! (ϴֳ)
</font></b>
  temp = exp(-((x-0.5)/0.1)**2)                     ! Set initial value 
                                                    ! ()

  call HistoryCreate( &                             ! Create output file 
    & file='diffusion_date.nc', &                   ! (ҥȥ꡼)
    & title='Diffusion equation',                        &
    & source='Sample program of gtool_history/gtool5',   &
    & institution='GFD_Dennou Club davis project',       &
    & dims=(/'x','t'/), dimsizes=(/nx,0/),               &
    & longnames=(/'X-coordinate','time        '/),       &
    & units=(/'m  ','min'/),                             &
    & origin=<b><font color="red">curtime</font></b>, interval=<b><font color="red">dsptime</font></b> )

  call HistoryPut('x',x)                            ! Output 'x' (ѿ)

  call HistoryAddVariable( &                        ! Set output variable 
    & varname='temp', dims=(/'x','t'/), &           ! (ѿ) 
    & longname='temperature', units='K', xtype='double')

  call HistoryAddAttr('temp','gt_graph_tick_all',1)
  call HistoryAddAttr('temp','gt_graph_contour_spacing',(/0.0,1.0,0.01/))
  call HistoryAddAttr('temp','+gt_user_davis_kappa',kappa)

  call HistoryPut('temp',temp)                      ! Output 'temp' (ѿ)

  date_str = toChar(date)
  write(6,*) "Start: ", trim(date_str)              ! Display start date () 

  do while ( <b><font color="red">curtime <= endtime</font></b> )                   <b><font color="red">! Check termination (λȽ)</font></b>

    temp(2:nx-1) = temp(2:nx-1) &                   ! Time integration (ʬ)
      & + kappa*(temp(3:nx)-2*temp(2:nx-1)+temp(1:nx-2))/dx**2*dt

    if ( <b><font color="red">mod( curtime, dsptime ) == 0</font></b> ) then        <b><font color="red">! Check output timing (ϥߥȽ)</font></b>
      call HistoryPut('temp',temp)                  ! Output 'temp' (ѿ)
    endif

    <b><font color="red">curtime = curtime + deltime                     ! Progress model time (ǥʹ)</font></b>
  enddo

  <b><font color="red">date = date + curtime                             ! Evaluate end date (λ) </font></b>
  date_str = <b><font color="red">toChar(date)</font></b>                           ! Convert date into characters (ʸѿѴ)
  write(6,*) "End:   ", trim(date_str)              ! Display end date (λ) 

  call HistoryClose
  stop
end program diffusion_date
</pre>
=end HTML

=begin JA

== ץΥѥȼ¹

((<嵭Υץ|URL:dc_date/diffusion_date.f90>)) ɤ,
ʲΤ褦˥ѥ뤷Ƥ. 

    $ gt5frt diffusion_date.f90

ƺ줿 a.out ʲΤ褦˼¹ԤƤ. 

    $ ./a.out

¹ԤȰʲΥåɽȤȤ,
diffusion_date.nc ե뤬ޤ.

   
   *** MESSAGE [HistoryCreate3] ***  "diffusion_date.nc" is created (origin=0. [min])
   Start: 2009-02-28T23:59:00+09:00
   End:   2009-03-01T00:09:01+09:00
   *** MESSAGE [HistoryClose] ***  "diffusion_date.nc" is closed

=end JA
=begin EN

=end EN

=begin JA

== ɤβ

ʲǤ dc_date ⥸塼γƥ֥롼󤬹ԤäƤ뤳Ȥޤޤ.
ܤ
((<ե󥹥ޥ˥奢|URL:../code_reference/classes/dc_date.html>)) 򻲾ȤƤ.

: use dc_date

  ⥸塼λѤޤ. Fortran 90/95 ᥤץƬˤ
  ޤ礦. 

: type(DC_DIFFTIME)

  ¤ DC_DIFFTIME ѿʸǤ.
  ηѿˤϡפ˴ؤ󤬳Ǽޤ.
  嵭ΥץǤϥǥȤƻѤƤޤ. 

: type(DC_DATETIME)

  ¤ DC_DATETIME ѿʸǤ. 
  ηѿˤϡפ˴ؤ󤬳Ǽޤ. 

: DCDiffTimeCreate(diff, value, unit)

  DC_DIFFTIME ѿԤޤ.

  * ((*diff*)) ˤ DC_DIFFTIME ѿꤷޤ.

  * ((*value*)) ˤ () ɽͤꤷޤ. 

  * ((*unit*)) ˤ () ɽñ̤ꤷޤ. 

: DCDateTimeCreate(date, [year], [mon], [day], [hour], [min], [sec])

  DC_DATETIME ѿԤޤ.

  * ((*date*)) ˤ DC_DATETIME ѿꤷޤ.

  * ((*year*)), ((*mon*)), ((*day*)), ((*hour*)), ((*min*)), ((*sec*)) ˤ,
    줾ǯ, , , , ʬ, äͿޤ.
    ((*sec*)) Τ٤μ¿Ϳޤ.
    ¾Ϳޤ. 

: HistoryCreate( ..., origin, interval, ... )

  HistoryCreate  ((*origin*)) (ϳϻ) 
   ((*interval*)) (ϴֳ) ˤ DC_DIFFTIME 
  ѿͿ뤳ȤǽǤ. 

: curtime <= endtime

  DC_DIFFTIME ѿƱΤӱ黻Ҥ羮ӤԤȤǽǤ.
  Ǥ, ((*curtime*)) (߻)  ((*endtime*)) (λ)
   () ⤷Ʊ () ˿֤פȤԤäƤޤ.

  Ѳǽӱ黻Ҥ, ((*==*)) ((*<=*)), ((*<*)), ((*>=*)), ((*>*))
  Ǥ. 

: mod( curtime, dsptime )

  DC_DIFFTIME ѿƱΤα黻ǽǤ.
  Ǥ, ((*curtime*))  ((*dsptime*)) ǽݤ;֤Ƥޤ.
  
  Τ褦ѲǽʴؿȤ ((*mod*)), ((*max*)), ((*min*)) ѰդƤޤ. 

: curtime = curtime + deltime

  DC_DIFFTIME ѿƱΤ黻ҤѤƱ黻뤳ȤǽǤ.
  Ǥ, ((*curtime*))  ((*deltime*)) äΤ ((*curtime*))
  Ƥޤ.

  Τ褦Ѳǽʱ黻ҤȤ, ((*+*)), ((*-*)), ((* * *)), ((* / *))
  ѰդƤޤ. 


: date = date + curtime

  DC_DATETIME ѿФ DC_DIFFTIME ѿѤ뤳ȤǽǤ.
  Ǥ ((*date*))  ((*deltime*)) äΤ ((*date*))
  Ƥޤ.

  Τ褦Ѳǽʱ黻ҤȤ, ((*+*)), ((*-*))
  ѰդƤޤ.

: toChar(date)

  DC_DATETIME ѿ, DC_DIFFTIME ѿΤɤȤ, ((*toChar*))
  ؿʸѿѴ뤳ȤǽǤ.
  嵭ץΤ褦, ɽʤɤ˻Ѥޤ. 


=end JA
=begin EN

=end EN



=begin HTML
<hr /> <small>
  $Id: dc_date.rd,v 1.1 2009-02-28 16:07:56 morikawa Exp $
</small>
=end HTML
