!= NAMELIST λѤꤷҥȥǡϾѥ桼ƥƥ
!
!= Utilities for history data output information management assuming use of NAMELIST
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: gtool_history_nmlinfo.f90,v 1.1.1.1 2008-09-23 09:56:26 morikawa Exp $
! Tag Name::  $Name: gtool5-20081005 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!

module gtool_history_nmlinfo
  !
  != NAMELIST λѤꤷҥȥǡϾѥ桼ƥƥ
  !
  != Utilities for history data output information management assuming use of NAMELIST
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! Ū絬Ϥʿͥǥˤ, ǡϤξ
  ! ٱ礹뤿Υ⥸塼Ǥ. 
  ! ̤Υ⥸塼뤬줾Ω˥ǡϤԤȤ, 
  ! NAMELIST Ѥƽϥեϴֳ֤ʤɤѹ뤳
  ! ꤷ߷פƤޤ. 
  ! , Υ⥸塼뼫ΤμŪϾδǤ, 
  ! ºݤΥǡϤˤ gtool_history ⥸塼
  ! Ѥ뤳ȤդƤ. 
  !
  ! This module supports information management of data output 
  ! in a comparatively large-scale numerical model. 
  ! This module is designed expecting that individual modules 
  ! perform data output independently, and output filename or 
  ! output interval is changed from NAMELIST. 
  ! Note that the purpose of this module is information management, 
  ! therefore actual data output is performed by "gtool_history" module.
  !
  !== Procedures List
  !
  ! HstNmlInfoCreate            :: GTHST_NMLINFO ѿν
  ! HstNmlInfoClose             :: GTHST_NMLINFO ѿνλ
  ! HstNmlInfoPutLine           :: GTHST_NMLINFO ѿ˳ǼƤΰ
  ! HstNmlInfoInitialized       :: GTHST_NMLINFO ѿꤵƤ뤫ݤ
  ! HstNmlInfoDefineMode        :: ⡼ɤξ˿֤
  ! HstNmlInfoEndDefine         :: ѿ⡼ɤϥ⡼ɤѹ
  ! HstNmlInfoReDefine          :: ϥ⡼ɤѿ⡼ɤѹ
  ! HstNmlInfoAdd               :: ѿɲ
  ! HstNmlInfoDelete            :: ѿκ
  ! HstNmlInfoResetDefault      :: ǥեΤߤ᤹
  ! HstNmlInfoInquire           :: ѿ䤤碌
  ! HstNmlInfoAssocGtHist       :: ѿ˱ gtool_history#GT_HISTORY ѿ֤
  ! HstNmlInfoOutputStepDisable :: output_step  .false. ֤褦ꤹ
  ! HstNmlInfoOutputStep        :: Ϥ꤬ͭǤ˿֤
  ! HstNmlInfoOutputValid       :: ߤλ郎ϤΥߥ󥰤ξ˿֤
  ! HstNmlInfoNames             :: ϿƤѿ̾ꥹȤ֤ (ؿ) 
  ! HstNmlInfoGetNames          :: ϿƤѿ̾ꥹȤ֤ (֥롼) 
  ! HstNmlInfoAllVarIniCheck    :: ꤵƤʤѿ̾Υå
  ! HstNmlInfoSetValidName      :: ѿ̾ͭ
  ! HstNmlInfoAllNameValid      :: ̵ѿ̾Υå
  ! ------------      :: ------------
  ! HstNmlInfoCreate            :: Constructor of "GTHST_NMLINFO"
  ! HstNmlInfoClose             :: Deconstructor of "GTHST_NMLINFO"
  ! HstNmlInfoPutLine           :: Print information of "GTHST_NMLINFO"
  ! HstNmlInfoInitialized       :: Check initialization of "GTHST_NMLINFO"
  ! HstNmlInfoDefineMode        :: True is returned if current state is define mode
  ! HstNmlInfoEndDefine         :: Transit define mode about information of variables to output mode
  ! HstNmlInfoReDefine          :: Transit output mode to define mode about information of variables
  ! HstNmlInfoAdd               :: Add information of variables
  ! HstNmlInfoDelete            :: Delete information of variables
  ! HstNmlInfoResetDefault      :: Reset to default settings
  ! HstNmlInfoInquire           :: Inquire information of variables
  ! HstNmlInfoAssocGtHist       :: "gtool_history#GT_HISTORY" correspond to variable is returned
  ! HstNmlInfoOutputStepDisable :: Configure that "output_step" returns .false. already
  ! HstNmlInfoOutputStep        :: True is returned when a configuration of output is valid
  ! HstNmlInfoOutputValid       :: True is returned when current time is output timing
  ! HstNmlInfoNames             :: Return list of registerd variable identifiers (function)
  ! HstNmlInfoGetNames          :: Return list of registerd variable identifiers (subroutine)
  ! HstNmlInfoAllVarIniCheck    :: Check uninitialized variable names
  ! HstNmlInfoSetValidName      :: Set validation to variable names
  ! HstNmlInfoAllNameValid      :: Check invalid variable names
  !
  !== Usage
  !
  ! Υ⥸塼ϰʲΤ褦ʼѤƤ. 
  !
  ! Υ⥸塼Ѥץ Fortran ץ
  ! ץȤ
  ! http://www.gfd-dennou.org/library/dcpam/dcpam4/dcpam4_current/script/f90/dcmodel_f90sample_maker.rb
  ! Ǥޤ. Ruby ǵҤƤ, ¹Ԥ뤳Ȥ
  ! ץȤʤ Fortran ץबޤ. 
  ! βΤߤǤϼºݤˡ䤴פʬˤ, 
  ! ץ Fortran ץºݤ˸Ƥߤ뤳Ȥ򥪥ᤷޤ. 
  ! 
  ! 0. ⥸塼, GTHST_NMLINFO ѿƤޤ. 
  !
  ! 1. HstNmlInfoCreate Ѥ, GTHST_NMLINFO ѿνԤޤ. 
  !    κݤ˥ǥեȤνϴֳ *interval_value*, 
  !    *interval_unit*,  *precision*, ֤ʿѲ *time_average*, 
  !    ϥե̾Ƭ *fileprefix* ꤷޤ. 
  !
  ! 2. ץबǥեȤǽϤѿ, Add 
  !    ѤϿƤ. 
  !    *name* ˤѿ̾Ϳޤ. *name* ѿ̤뤿Υ
  !    Ѥ뤿, ۤʤѿФƱ *name* ꤷʤ
  !    . 
  !    *file* ˤϽϥե̾Ϳޤ. Ϳʤ, 
  !    Ŭʥե̾ꤵޤ. 
  !    ¾ξϾ嵭ƱͤǤ. 
  !
  ! 3. NAMELIST 줿ѿξ, 
  !    HstNmlInfoAdd ѤϿƤ. 
  !    HstNmlInfoAdd ǴϿѤߤ *name* Ͽ뤳Ȥ, 
  !    ꤬񤭤ޤ. 
  !
  ! 4. Ͽλ, HstNmlInfoEndDefine Ѥ, 
  !    ⡼ɤϥ⡼ɤذܹԤƤ. 
  !
  ! 5. gtool_history#HistoryCreate, gtool_history#HistoryAddVariable
  !    gtool_history#HistoryPut ǽꤪӥǡϤԤݤˤ, 
  !    HstNmlInfoAssocGtHist Ф, ѿ̾ *name* 
  !    gtool_history#GT_HISTORY Υݥ *history* ϤƤ. 
  !    GTHST_NMLINFO ѿϿƤ
  !    *name* ˴ؤ gtool_history#GT_HISTORY ѿ˷礵줿
  !    *history* ֤ޤ.  *history* 
  !    嵭 gtool_history Υ֥롼󷲤ΰ *history* Ϥ
  !    ꤪӥǡϤԤäƤ. 
  !    gtool_history#HistoryCreate ɬפ
  !    ϴֳ֤٤ HstNmlInfoInquire Ѥ뤳ȤǤޤ. 
  !    Ѹ, NULLIFY ˤä *history* ֤ˤƤ. 
  !    (DEALLOCATE ѤȽϤ˴ؤ󤬼뤿, 
  !    ѤʤǤ). 
  !
  !    줾ѿ˴ؤ, ꤬ͭɤˤĤƤ, 
  !    HstNmlInfoOutputValid Τ뤳ȤǽǤ. 
  !
  !    ޤ, ʬ gtool_history#HistoryPut Ѥ
  !    , ߻郎ϥߥ󥰤ɤˤĤƤ, 
  !    HstNmlInfoOutputStep Τ뤳ȤǽǤ. 
  !
  ! 6. եνϤλ, 嵭μƱͤ
  !    gtool_history#GT_HISTORY  *history* , 
  !    gtool_history#HistoryClose ˤäƽλԤäƤ. 
  !
  ! 7. Ǹ, HstNmlInfoClose ˤä, GTHST_NMLINFO ѿ
  !    λԤޤ.
  !
  !
  ! Use this module as follows. 
  !
  ! Sample Fortran programs generator (Ruby script) is available from 
  ! http://www.gfd-dennou.org/library/dcpam/dcpam4/dcpam4_current/script/f90/dcmodel_f90sample_maker.rb .
  ! Sample Fortran programs are created by executing this script. 
  ! Because neither actual usage nor the profit are understood 
  ! easily only from the following explanations, 
  ! It is recommended to see sample Fortran programs actually.
  ! 
  ! 0. Declare "GTHST_NMLINFO" variable in the module. 
  !
  ! 1. Initialize "GTHST_NMLINFO" variable by "HstNmlInfoCreate". 
  !    On this occasion, configure default 
  !    *interval_value*, *interval_unit*, 
  !    *precision*, *time_average*, *fileprefix* (prefix of output file). 
  !
  ! 2. Register by using "HstNmlInfoAdd" when there are variables that 
  !    the program outputs by default. 
  !    variable identifier is given to *name*. Do not specify same *name* 
  !    for different variables because *name* is used as a key to 
  !    identify the variable. The output file name is given to *file*. 
  !    A suitable file name is set when not giving it. 
  !    The extra information is similar to the above-mentioned. 
  !
  ! 3. Register information of output variables obtained from NAMELIST
  !    by using "HstNmlInfoAdd". When registered *name* is registered again, 
  !    the setting concerning the *name* has been overwritten. 
  !
  ! 4. Shift from the define mode to output mode by using "HstNmlInfoEndDefine"
  !    when registration is completed. 
  !
  ! 5. Pass "HstNmlInfoAssocGtHist" variable identifier *name* and 
  !    *history* of "gtool_history#GT_HISTORY" pointer when 
  !    setting output and data output is performed with 
  !    "gtool_history#HistoryCreate", "gtool_history#HistoryAddVariable" 
  !    "gtool_history#HistoryPut" etc. 
  !    *history* is associated to "gtool_history#GT_HISTORY" correspond 
  !    to *name* stored in "GTHST_NMLINFO" variable. 
  !    Pass the *history* to subroutines in "gtool_history" above-mentioned, 
  !    and configure output setting and output data. 
  !    Necessary output interval and precision for 
  !    "gtool_history#HistoryCreate" can be obtained by using 
  !    "HstNmlInfoInquire". 
  !    Please put *history* into a null state by NULLIFY after use. 
  !    (Information of output is lost when DEALLOCATE is used, 
  !    so do not use it). 
  !
  !    It can know whether the output setting is effective 
  !    for each variable with "output_valid". 
  !
  !    Moreover, it can know time now to be whether output timing 
  !    when "gtool_history#HistoryPut" is used 
  !    while integrating time with "output_step". 
  !
  ! 6. Acquire *history* of "gtool_history#GT_HISTORY" type as well as
  !    the above-mentioned procedure, and terminate that by 
  !    "gtool_history#HistoryClose" when the output of the file ends. 
  !
  ! 7. Finally, the termination of the variable of "GTHST_NMLINFO" 
  !    type is done by "Close". 
  !

  use dc_types, only: TOKEN, STRING
  use gtool_history, only: GT_HISTORY
  use dc_hash, only: HASH
  use netcdf_f77, only: NF_MAX_DIMS
  implicit none
  private
  public:: GTHST_NMLINFO
  public:: HstNmlInfoCreate, HstNmlInfoClose
  public:: HstNmlInfoPutLine, HstNmlInfoInitialized
  public:: HstNmlInfoDefineMode, HstNmlInfoEndDefine, HstNmlInfoReDefine
  public:: HstNmlInfoAdd, HstNmlInfoDelete
  public:: HstNmlInfoResetDefault
  public:: HstNmlInfoInquire
  public:: HstNmlInfoAssocGtHist
  public:: HstNmlInfoOutputStepDisable
  public:: HstNmlInfoOutputStep
  public:: HstNmlInfoOutputValid
  public:: HstNmlInfoNames, HstNmlInfoGetNames
  public:: HstNmlInfoAllVarIniCheck
  public:: HstNmlInfoSetValidName
  public:: HstNmlInfoAllNameValid

  type GTHST_NMLINFO
    !
    ! NAMELIST ҥȥǡνϾ
    ! Ǽ뤿ι¤ǡǤ. 
    ! ޤ, HstNmlInfoCreate  "GTHST_NMLINFO" ѿꤷƲ.
    ! ꤵ줿 "GTHST_NMLINFO" ѿѤݤˤ,
    ! HstNmlInfoClose ˤäƽλԤäƤ.
    !
    ! This derived type is worked in order to store information about 
    ! data output from NAMELIST. 
    ! Initialize "GTHST_NMLINFO" variable by "HstNmlInfoCreate" before usage.
    ! If you reuse "GTHST_NMLINFO" variable again for another application, 
    ! terminate by "HstNmlInfoClose".
    !
    private
    logical:: initialized = .false.
                              ! ե饰. 
                              ! Initialization flag
    logical:: define_mode = .true.
                              ! ֤ɽե饰. 
                              ! Flag that represents define mode
    type(GTHST_NMLINFO_ENTRY), pointer:: gthstnml_list =>null()
                              ! ѿȤξꥹ. 
                              ! ǼˤĤƤ
                              ! GTHST_NMLINFO_ENTRY 򻲾ȤΤ. 
                              !
                              ! Information list about individual variable 
                              ! See "GTHST_NMLINFO_ENTRY" 
                              ! about stored information. 
  end type GTHST_NMLINFO

  type GTHST_NMLINFO_ENTRY
    !
    ! ѿȤξǼ뤿ι¤ΤǤ. 
    ! ι¤Τϥ⥸塼ǻѤ뤳ȤꤷƤ뤿, 
    ! ⥸塼볰ϻѤʤǤ. 
    !
    ! Information about individual output variable is stored in
    ! this derived type.
    ! It is expected that this derived type is used
    ! internally, so do not refer from the outside.
    !
    character(TOKEN):: name
                              ! ѿ̾. Variable identifier
    character(STRING):: file
                              ! ҥȥǡΥե̾. 
                              ! History data filenames
    real, pointer:: interval_value =>null()
                              ! ҥȥǡνϴֳ֤ο. 
                              ! ͤͿ, Ϥ޻ߤޤ. 
                              ! 
                              ! Numerical value for interval of history data output. 
                              ! Negative values suppresses output.
    character(TOKEN), pointer:: interval_unit =>null()
                              ! ҥȥǡνϴֳ֤ñ. 
                              ! Unit for interval of history data output
    character(TOKEN), pointer:: precision =>null()
                              ! ҥȥǡ. 
                              ! Precision of history data
    logical, pointer:: time_average =>null()
                              ! ϥǡλʿѲե饰. 
                              ! Flag for time average of output data.
    character(STRING), pointer:: fileprefix =>null()
                              ! ҥȥǡΥե̾Ƭ. 
                              ! Prefixes of history data filenames

    real, pointer:: origin_value =>null()
                              ! ϳϻ. 
                              ! Start time of output. 
    character(TOKEN), pointer:: origin_unit =>null()
                              ! ϳϻñ. 
                              ! Unit of start time of output. 
    real, pointer:: terminus_value =>null()
                              ! Ͻλ. 
                              ! End time of output. 
    character(TOKEN), pointer:: terminus_unit =>null()
                              ! Ͻλñ. 
                              ! Unit of end time of output. 
    integer, pointer:: slice_start(:) =>null()
                              ! γ. 
                              ! Start points of spaces. 
    integer, pointer:: slice_end(:) =>null()
                              ! νλ. 
                              ! End points of spaces. 
    integer, pointer:: slice_stride(:) =>null()
                              ! ι. 
                              ! Strides of spaces. 
    logical, pointer:: space_average(:) =>null()
                              ! ʿѲΥե饰. 
                              ! Flag of average. 
    integer, pointer:: newfile_intvalue =>null()
                              ! եʬֳִ. 
                              ! Interval of time of separation of a file. 
    character(TOKEN), pointer:: newfile_intunit =>null()
                              ! եʬֳִ֤ñ. 
                              ! Unit of interval of time of separation of a file. 

    logical:: output_step_disable = .false.
                              ! output_step ̵ե饰. 
                              ! "output_step" disable flag
    logical:: name_invalid = .true.
                              ! ̵ѿ̾Τ뤿Υե饰.
                              ! A flag for detection of invalid variable names
    type(GT_HISTORY), pointer:: history =>null()
                              ! gtool_history ⥸塼ѹ¤. 
                              ! Derived type for "gtool_history" module
    type(GTHST_NMLINFO_ENTRY), pointer:: next =>null()
                              ! ꥹȹ¤Τѿ. 
                              ! A variable for a list structure
  end type GTHST_NMLINFO_ENTRY

  character(1), parameter:: name_delimiter = ','
                              ! ʣѿ̾ζڤʸ
                              ! Delimiter for multiple variable names

  !-----------------------------------
  !  ʣѿĤΥեؽϤ뤿Υåѿ
  !  Variables for checking for output multiple variables to one file
  type(HASH), save:: opened_files
 
  character(*), parameter:: version = &
    & '$Name: gtool5-20081005 $' // &
    & '$Id: gtool_history_nmlinfo.f90,v 1.1.1.1 2008-09-23 09:56:26 morikawa Exp $'

  !-----------------------------------------------------------------
  !  ³
  !  Public procedures
  !-----------------------------------------------------------------

  interface HstNmlInfoCreate
    module procedure HstNmlInfoCreate
  end interface

  interface HstNmlInfoClose
    module procedure HstNmlInfoClose
  end interface

  interface HstNmlInfoPutLine
    module procedure HstNmlInfoPutLine
  end interface

  interface HstNmlInfoInitialized
    module procedure HstNmlInfoInitialized
  end interface

  interface HstNmlInfoDefineMode
    module procedure HstNmlInfoDefineMode
  end interface

  interface HstNmlInfoEndDefine
    module procedure HstNmlInfoEndDefine
  end interface

  interface HstNmlInfoReDefine
    module procedure HstNmlInfoReDefine
  end interface

  interface HstNmlInfoAdd
    module procedure HstNmlInfoAdd
  end interface

  interface HstNmlInfoDelete
    module procedure HstNmlInfoDelete
  end interface

  interface HstNmlInfoResetDefault
    module procedure HstNmlInfoResetDefault
  end interface

  interface HstNmlInfoInquire
    module procedure HstNmlInfoInquire
  end interface

  interface HstNmlInfoAssocGtHist
    module procedure HstNmlInfoAssocGtHist
  end interface

  interface HstNmlInfoOutputStepDisable
    module procedure HstNmlInfoOutputStepDisable
  end interface

  interface HstNmlInfoOutputStep
    module procedure HstNmlInfoOutputStep
  end interface

  interface HstNmlInfoOutputValid
    module procedure HstNmlInfoOutputValid
  end interface

  interface HstNmlInfoNames
    module procedure HstNmlInfoNames
  end interface

  interface HstNmlInfoAllVarIniCheck
    module procedure HstNmlInfoAllVarIniCheck
  end interface

  interface HstNmlInfoSetValidName
    module procedure HstNmlInfoSetValidName
  end interface

  interface HstNmlInfoAllNameValid
    module procedure HstNmlInfoAllNameValid
  end interface

  !-----------------------------------------------------------------
  !  ³
  !  Private procedures
  !-----------------------------------------------------------------

  interface ListNext
    module procedure HstNmlInfoListNext
  end interface

  interface ListLast
    module procedure HstNmlInfoListLast
  end interface

  interface ListSearch
    module procedure HstNmlInfoListSearch
  end interface

!!$  interface Sample
!!$    module procedure HstNmlInfoSample
!!$  end interface

contains

  subroutine HstNmlInfoCreate( gthstnml, &
    & interval_value, &
    & interval_unit, &
    & precision, &
    & time_average, average, &
    & fileprefix, &
    & origin_value, origin_unit, &
    & terminus_value, terminus_unit, &
    & slice_start, slice_end, slice_stride, &
    & space_average, &
    & newfile_intvalue, newfile_intunit, &
    & err )
    !
    ! GTHST_NMLINFO ѿνԤޤ. 
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä 
    ! GTHST_NMLINFO ѿꤷƤ. 
    !
    ! *interval_value*, 
    ! *interval_unit*, 
    ! *precision*, 
    ! *time_average* ( *average*) ʤɤѿ
    ! ϥǥեͤȤꤵޤ. 
    ! *fileprefix* ϳѿνϥե̾ƬȤ
    ! Ѥޤ. 
    !
    ! ʤ, Ϳ줿 *gthstnml* ˽ꤵƤ, 
    ! ץϥ顼ȯޤ. 
    !
    ! Constructor of "GTHST_NMLINFO". 
    ! Initialize *gthstnml* by this subroutine, 
    ! before other procedures are used, 
    !
    ! *interval_value*, 
    ! *interval_unit*, 
    ! *precision*, 
    ! *time_average* (now-defunct *average*), etc. 
    ! are set as default values. 
    ! *fileprefix* is used as prefixes of output filenames of 
    ! each variable. 
    !
    ! Note that if *gthstnml* is already initialized 
    ! by this procedure, error is occurred. 
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_not_empty, present_and_true, present_select
    use dc_message, only: MessageNotify
    use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, &
      & DC_EARGLACK, DC_ENEGATIVE, DC_ENOFILEREAD, USR_ERRNO
    use dc_date_types, only: DC_DIFFTIME
    use dc_date, only: DCDiffTimeCreate
    implicit none
    type(GTHST_NMLINFO), intent(inout):: gthstnml
    real, intent(in), optional:: interval_value
                              ! ҥȥǡνϴֳ֤ο. 
                              ! ͤͿ, Ϥ޻ߤޤ. 
                              ! 
                              ! Numerical value for interval of history data output. 
                              ! Negative values suppresses output.
    character(*), intent(in), optional:: interval_unit
                              ! ҥȥǡνϴֳ֤ñ. 
                              ! Unit for interval of history data output
    character(*), intent(in), optional:: precision
                              ! ҥȥǡ. 
                              ! Precision of history data
    logical, intent(in), optional:: time_average
                              ! ϥǡλʿѲե饰. 
                              ! Flag for time average of output data.
    logical, intent(in), optional:: average
                              ! time_average ε. 
                              ! Old version of "time_average"
    character(*), intent(in), optional:: fileprefix
                              ! ҥȥǡΥե̾Ƭ. 
                              ! Prefixes of history data filenames
    real, intent(in), optional:: origin_value
                              ! ϳϻ. 
                              ! Start time of output. 
    character(*), intent(in), optional:: origin_unit
                              ! ϳϻñ. 
                              ! Unit of start time of output. 
    real, intent(in), optional:: terminus_value
                              ! Ͻλ. 
                              ! End time of output. 
    character(*), intent(in), optional:: terminus_unit
                              ! Ͻλñ. 
                              ! Unit of end time of output. 
    integer, intent(in), optional:: slice_start(:)
                              ! γ. 
                              ! Start points of spaces. 
    integer, intent(in), optional:: slice_end(:)
                              ! νλ. 
                              ! End points of spaces. 
    integer, intent(in), optional:: slice_stride(:)
                              ! ι. 
                              ! Strides of spaces. 
    logical, intent(in), optional:: space_average(:)
                              ! ʿѲΥե饰. 
                              ! Flag of average. 
    integer, intent(in), optional:: newfile_intvalue
                              ! եʬֳִ. 
                              ! Interval of time of separation of a file. 
    character(*), intent(in), optional:: newfile_intunit
                              ! եʬֳִ֤ñ. 
                              ! Unit of interval of time of separation of a file. 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    type(DC_DIFFTIME):: interval_time
    integer:: stat, ary_size
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoCreate'
  continue
    call BeginSub( subname, &
      & fmt = '@interval_value=%r @interval_unit=%c @precision=%c @time_average=%y @fileprefix=%c', &
      & r  = (/ present_select(.true., -1.0, interval_value) /), &
      & c1 = trim( present_select(.true., '<no>', interval_unit) ), &
      & c2 = trim( present_select(.true., '<no>', precision) ), &
      & l  = (/ present_and_true(time_average) /), &
      & c3 = trim( present_select(.true., '<no>', fileprefix) ), &
      & version = version )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( gthstnml % initialized ) then
      stat = DC_EALREADYINIT
      cause_c = 'GTHST_NMLINFO'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  
    !  Allocate
    !-----------------------------------------------------------------
    allocate( gthstnml % gthstnml_list )
    nullify( gthstnml % gthstnml_list % next )

    !-----------------------------------------------------------------
    !  ǥեͤ
    !  Configure default values
    !-----------------------------------------------------------------
    gthstnml % gthstnml_list % name = ''
    gthstnml % gthstnml_list % file = ''

    allocate( gthstnml % gthstnml_list % interval_value )
    allocate( gthstnml % gthstnml_list % interval_unit  )
    allocate( gthstnml % gthstnml_list % precision      )
    allocate( gthstnml % gthstnml_list % time_average   )
    allocate( gthstnml % gthstnml_list % fileprefix     )

    allocate( gthstnml % gthstnml_list % origin_value                  )
    allocate( gthstnml % gthstnml_list % origin_unit                   )
    allocate( gthstnml % gthstnml_list % terminus_value                )
    allocate( gthstnml % gthstnml_list % terminus_unit                 )
    allocate( gthstnml % gthstnml_list % slice_start   (1:NF_MAX_DIMS) )
    allocate( gthstnml % gthstnml_list % slice_end     (1:NF_MAX_DIMS) )
    allocate( gthstnml % gthstnml_list % slice_stride  (1:NF_MAX_DIMS) )
    allocate( gthstnml % gthstnml_list % space_average (1:NF_MAX_DIMS) )
    allocate( gthstnml % gthstnml_list % newfile_intvalue              )
    allocate( gthstnml % gthstnml_list % newfile_intunit               )


    gthstnml % gthstnml_list % interval_value = -1.0
    gthstnml % gthstnml_list % interval_unit  = 'sec'
    gthstnml % gthstnml_list % precision      = 'float'
    gthstnml % gthstnml_list % time_average   = .false.
    gthstnml % gthstnml_list % fileprefix     = ''

    gthstnml % gthstnml_list % origin_value     = -1.0 
    gthstnml % gthstnml_list % origin_unit      = 'sec'
    gthstnml % gthstnml_list % terminus_value   = -1.0 
    gthstnml % gthstnml_list % terminus_unit    = 'sec'
    gthstnml % gthstnml_list % slice_start      =  1
    gthstnml % gthstnml_list % slice_end        = -1
    gthstnml % gthstnml_list % slice_stride     =  1
    gthstnml % gthstnml_list % space_average    = .false.
    gthstnml % gthstnml_list % newfile_intvalue = -1
    gthstnml % gthstnml_list % newfile_intunit  = 'sec'

    if ( present(interval_value) ) gthstnml % gthstnml_list % interval_value = interval_value
    if ( present(interval_unit)  ) gthstnml % gthstnml_list % interval_unit  = interval_unit 
    if ( present(precision)      ) gthstnml % gthstnml_list % precision      = precision     

    if ( present(average)        ) gthstnml % gthstnml_list % time_average        = average       
    if ( present(time_average)   ) gthstnml % gthstnml_list % time_average        = time_average       
    if ( present(fileprefix)     ) gthstnml % gthstnml_list % fileprefix     = fileprefix    

    if ( present(origin_value    ) ) gthstnml % gthstnml_list % origin_value     = origin_value    
    if ( present(origin_unit     ) ) gthstnml % gthstnml_list % origin_unit      = origin_unit     
    if ( present(terminus_value  ) ) gthstnml % gthstnml_list % terminus_value   = terminus_value  
    if ( present(terminus_unit   ) ) gthstnml % gthstnml_list % terminus_unit    = terminus_unit   
    if ( present(slice_start     ) ) then
      ary_size = size(slice_start)
      gthstnml % gthstnml_list % slice_start(1:ary_size)  = slice_start     
    end if
    if ( present(slice_end      ) ) then
      ary_size = size(slice_end)
      gthstnml % gthstnml_list % slice_end(1:ary_size)    = slice_end     
    end if
    if ( present(slice_stride   ) ) then
      ary_size = size(slice_stride)
      gthstnml % gthstnml_list % slice_stride(1:ary_size) = slice_stride     
    end if
    if ( present(space_average   ) ) then
      ary_size = size(space_average)
      gthstnml % gthstnml_list % space_average(1:ary_size) = space_average
    end if
    if ( present(newfile_intvalue) ) gthstnml % gthstnml_list % newfile_intvalue = newfile_intvalue
    if ( present(newfile_intunit ) ) gthstnml % gthstnml_list % newfile_intunit  = newfile_intunit 

    !-----------------------------------------------------------------
    !  ֤ñ̤Υå
    !  Check unit of time
    !-----------------------------------------------------------------
    call DCDiffTimeCreate( &
      & diff = interval_time, &                                    ! (out)
      & value = &
      &   real( gthstnml % gthstnml_list % interval_value, DP ), & ! (in)
      & unit = gthstnml % gthstnml_list % interval_unit, &         ! (in)
      & err = err )                                                ! (out)
    if ( present_and_true( err ) ) then
      stat = USR_ERRNO
      goto 999
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    gthstnml % initialized = .true.
    gthstnml % define_mode = .true.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine HstNmlInfoCreate

  subroutine HstNmlInfoClose( gthstnml, err )
    !
    ! GTHST_NMLINFO ѿνλԤޤ. 
    !
    ! Υ֥롼Ѥ, *gthstnml* ˳ǼƤ
    ! gtool_history#GT_HISTORY ƤѿФ, 
    ! gtool_history#HistoryClose ѤƽλԤäƤ. 
    ! λƤʤΤ, 
    ! ץϥ顼ȯޤ. 
    !
    ! ʤ, Ϳ줿 *gthstnml*  HstNmlInfoCreate ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ. 
    !
    ! Deconstructor of "GTHST_NMLINFO". 
    !
    ! Terminate all "gtool_history#GT_HISTORY" variables in *gthstnml*
    ! by "gtool_history#HistoryClose" before this subroutine is used. 
    ! If unterminated variables remain, 
    ! error is occurred. 
    !
    ! Note that if *gthstnml* is not initialized by "HstNmlInfoCreate" yet, 
    ! error is occurred. 
    !
    use dc_trace, only: BeginSub, EndSub, DbgMessage
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT, HST_ENOTTERMGTHIST
    use gtool_history, only: HistoryInitialized
    implicit none
    type(GTHST_NMLINFO), intent(inout):: gthstnml
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr =>null()
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr_prev =>null()
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoClose'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. gthstnml % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'GTHST_NMLINFO'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "GTHST_NMLINFO" ξõ
    !  Clear the settings for "GTHST_NMLINFO"
    !-----------------------------------------------------------------
    do 
      hptr => gthstnml % gthstnml_list
      call ListLast( gthstnml_list = hptr, & ! (inout)
        & previous = hptr_prev )             ! (out)
      call DbgMessage( 'remove entry (%c)', c1 = trim(hptr % name) )
      if ( trim( hptr % name ) == '' ) exit
      if ( .not. gthstnml % define_mode ) then
        if ( HistoryInitialized( hptr % history ) ) then
          stat = HST_ENOTTERMGTHIST
          cause_c = hptr % name
          goto 999
        end if
      end if
      deallocate( hptr )
      nullify( hptr_prev % next )
    end do
    deallocate( gthstnml % gthstnml_list )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    gthstnml % initialized = .false.
    gthstnml % define_mode = .true.
999 continue
    nullify( hptr )
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine HstNmlInfoClose

  subroutine HstNmlInfoPutLine( gthstnml, unit, indent, err )
    !
    !  *gthstnml* ꤵƤޤ. 
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ. 
    !
    ! Print information of *gthstnml*. 
    ! By default messages are output to standard output. 
    ! Unit number for output can be changed by *unit* argument. 
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use gtool_history, only: HistoryPutLine
    implicit none
    type(GTHST_NMLINFO), intent(in):: gthstnml
    integer, intent(in), optional:: unit
                              ! ֹ. 
                              ! ǥեȤνɸ. 
                              !
                              ! Unit number for output. 
                              ! Default value is standard output. 
    character(*), intent(in), optional:: indent
                              ! ɽåλ. 
                              !
                              ! Indent of displayed messages. 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr =>null()
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'HstNmlInfoPutLine'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( present(unit) ) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if ( present(indent) ) then
      if ( len(indent) /= 0 ) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if

    !-----------------------------------------------------------------
    !  "GTHST_NMLINFO" ΰ
    !  Print the settings for "GTHST_NMLINFO"
    !-----------------------------------------------------------------
    if ( gthstnml % initialized ) then
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<GTHST_NMLINFO:: @initialized=%y define_mode=%y', &
        & l = (/gthstnml % initialized, gthstnml % define_mode/) )

      hptr => gthstnml % gthstnml_list

      do while ( associated( hptr ) )

        call Printf( out_unit, &
          & indent_str(1:indent_len) // &
          & ' #<GTHST_NMLINFO_ENTRY:: @name=%c @file=%c', &
          & c1 = trim(hptr % name), &
          & c2 = trim(hptr % file) )

        call Printf( out_unit, &
          & indent_str(1:indent_len) // &
          & '  @interval_value=%r @interval_unit=%c', &
          & r = (/hptr % interval_value/), &
          & c1 = trim(hptr % interval_unit) )

        call Printf( out_unit, &
          & indent_str(1:indent_len) // &
          & '  @output_step_disable=%y', &
          & l = (/hptr % output_step_disable/) )

        call Printf( out_unit, &
          & indent_str(1:indent_len) // &
          & '  @precision=%c @time_average=%y', &
          & c1 = trim(hptr % precision), &
          & l = (/ hptr % time_average /) )

        call Printf( out_unit, &
          & indent_str(1:indent_len) // &
          & '  @fileprefix=%c', &
          & c1 = trim(hptr % fileprefix) )

        call Printf( out_unit, &
          & indent_str(1:indent_len) // &
          & '  @origin_value=%r @origin_unit=%c', &
          & r = (/hptr % origin_value/), &
          & c1 = trim(hptr % origin_unit) )

        call Printf( out_unit, &
          & indent_str(1:indent_len) // &
          & '  @terminus_value=%r @terminus_unit=%c', &
          & r = (/hptr % terminus_value/), &
          & c1 = trim(hptr % terminus_unit) )

        call Printf( out_unit, &
          & indent_str(1:indent_len) // &
          & '  @slice_start=%*d ...', &
          & i = (/hptr % slice_start(1:10)/), n = (/ 10 /) )

        call Printf( out_unit, &
          & indent_str(1:indent_len) // &
          & '  @slice_end=%*d ...', &
          & i = (/hptr % slice_end(1:10)/), n = (/ 10 /) )

        call Printf( out_unit, &
          & indent_str(1:indent_len) // &
          & '  @slice_stride=%*d ...', &
          & i = (/hptr % slice_stride(1:10)/), n = (/ 10 /) )

        call Printf( out_unit, &
          & indent_str(1:indent_len) // &
          & '  @space_average=%*b ...', &
          & l = (/hptr % space_average(1:10)/), n =(/ 10 /) )

        call Printf( out_unit, &
          & indent_str(1:indent_len) // &
          & '  @newfile_intvalue=%d @newfile_intunit=%c', &
          & i = (/hptr % newfile_intvalue/), &
          & c1 = trim(hptr % newfile_intunit) )

        if ( .not. gthstnml % define_mode ) then
          call Printf( out_unit, &
            & indent_str(1:indent_len) // &
            & '  @history=' )

          call HistoryPutLine( hptr % history, &
            & unit = out_unit, &
            & indent = indent_str(1:indent_len) // &
            & '   ' )
        end if

        call ListNext( gthstnml_list = hptr ) ! (inout)
      end do

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' >' )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '>' )
    else
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<GTHST_NMLINFO:: @initialized=%y>', &
        & l = (/gthstnml % initialized/) )
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine HstNmlInfoPutLine

  logical function HstNmlInfoInitialized( gthstnml ) result(result)
    !
    ! *gthstnml* ꤵƤˤ .true. , 
    ! ꤵƤʤˤ .false. ֤ޤ. 
    !
    ! If *gthstnml* is initialized, .true. is returned. 
    ! If *gthstnml* is not initialized, .false. is returned. 
    !
    implicit none
    type(GTHST_NMLINFO), intent(in):: gthstnml
  continue
    result = gthstnml % initialized
  end function HstNmlInfoInitialized

  logical function HstNmlInfoDefineMode( gthstnml ) result(result)
    !
    ! *gthstnml* ⡼ɤǤ .true. , 
    ! ⡼ɤǤʤ .false. ֤ޤ. 
    !
    ! If *gthstnml* is define mode, .true. is returned. 
    ! If *gthstnml* is not define mode, .false. is returned. 
    !
    implicit none
    type(GTHST_NMLINFO), intent(in):: gthstnml
  continue
    result = gthstnml % define_mode
  end function HstNmlInfoDefineMode

  subroutine HstNmlInfoEndDefine( gthstnml, err )
    !
    ! ⡼ɤϥ⡼ɤ˰ܹԤ, 
    ! *gthstnml* ꤷꤷޤ. 
    ! HstNmlInfoAssocGTHist ֥롼ƤӽФ, 
    ! ɬΥ֥롼ƤӽФƤ. 
    ! Υ֥롼Ƥ 
    ! HstNmlInfoAdd, HstNmlInfoDelete, HstNmlInfoResetDefault 
    ! Ƥ֤ȥץϥ顼ȯޤ. 
    !
    ! ʤ, Ϳ줿 *gthstnml*  HstNmlInfoCreate ˤäƽ
    ! Ƥʤˤ, ץϥ顼ȯޤ. 
    !
    ! Transit from define mode to output mode, 
    ! and determine information configured in *gthstnml*. 
    ! Use this subroutine before "HstNmlInfoAssocGTHist" is used. 
    ! If "HstNmlInfoAdd", "HstNmlInfoDelete", "HstNmlInfoResetDefault" 
    ! are used after 
    ! this subroutine is used, error is occurred. 
    !
    ! If *gthstnml* is not initialized by "HstNmlInfoCreate" yet, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_hash, only: HASH, DCHashPut, DCHashGet, DCHashRewind, DCHashNext, DCHashNumber
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT, &
      & HST_ENOTINDEFINE, HST_EINTFILE, HST_EBADORIGIN, HST_EBADTERMINUS, &
      & HST_EBADSLICE, HST_EBADNEWFILEINT
    use dc_message, only: MessageNotify
    implicit none
    type(GTHST_NMLINFO), intent(inout):: gthstnml
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ʣѿĤΥեؽϤ뤿Υåѿ
    !  Variables for checking for output multiple variables to one file
    character(STRING):: opname, opfile
    logical:: end

    !-----------------------------------
    !  ѿ
    !  Work variables
    character(STRING):: fullfilename
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr =>null()
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr_prev =>null()
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoEndDefine'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. gthstnml % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'GTHST_NMLINFO'
      goto 999
    end if

    if ( .not. gthstnml % define_mode ) then
      stat = HST_ENOTINDEFINE
      cause_c = 'EndDefine'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  gtool_history#GT_HISTORY ѿγ
    !  Allocate "gtool_history#GT_HISTORY" variables
    !-----------------------------------------------------------------
    hptr => gthstnml % gthstnml_list
    if ( .not. associated( hptr % history ) ) then
      allocate( hptr % history )
    end if
    WholeLoop : do while ( associated( hptr % next ) )
      call ListNext( gthstnml_list = hptr ) ! (inout)
      if ( trim(hptr % name) == '' .or. trim(hptr % file) == '' ) &
        & cycle WholeLoop

      fullfilename = trim( hptr % fileprefix ) // hptr % file

      !---------------------------------------------------------------
      !  Ʊե̾ gtool_history#GT_HISTORY ѿ, ˷
      !  If "gtool_history#GT_HISTORY" that has same filename exist already, associate to it
      !---------------------------------------------------------------
      nullify( hptr_prev )
      call DCHashRewind(opened_files) ! (inout)
      SearchLoop : do
        call DCHashNext( opened_files, & ! (inout)
          & opname, opfile, end )  ! (out)
        if ( end ) exit SearchLoop
        if ( trim(opfile) /= trim(fullfilename) ) cycle SearchLoop
        hptr_prev => gthstnml % gthstnml_list

        call ListSearch( gthstnml_list = hptr_prev, & ! (inout)
          &              name = opname )              ! (in)
        if ( .not. associated( hptr_prev ) ) cycle SearchLoop
        if ( trim(hptr % name) == trim(hptr_prev % name) ) cycle SearchLoop

        ! interval_value, interval_unit Ʊå
        ! Check consistency of "interval_value", "interval_unit"
        !
        if ( hptr % interval_value /= hptr_prev % interval_value ) then
          call MessageNotify( 'W', subname, &
            & '@interval_value=%r (var=%a) and @interval_value=%r (var=%a) are applied to a file "%a"', &
            & r = (/hptr % interval_value, hptr_prev % interval_value/), &
            & ca = StoA(hptr % name, hptr_prev % name, fullfilename) )
          stat = HST_EINTFILE
          cause_c = fullfilename
          goto 999
        elseif ( hptr % interval_unit /= hptr_prev % interval_unit ) then
          call MessageNotify( 'W', subname, &
            & '@interval_unit=%a (var=%a) and @interval_unit=%a (var=%a) are applied to a file "%a"', &
            & ca = StoA(hptr % interval_unit, hptr % name, &
            &           hptr_prev % interval_unit, hptr_prev % name, &
            &           fullfilename) )
          stat = HST_EINTFILE
          cause_c = fullfilename
          goto 999
        end if

        ! origin_value, origin_unit Ʊå
        ! Check consistency of "origin_value", "origin_unit"
        !
        if ( hptr % origin_value /= hptr_prev % origin_value ) then
          call MessageNotify( 'W', subname, &
            & '@origin_value=%r (var=%a) and @origin_value=%r (var=%a) are applied to a file "%a"', &
            & r = (/hptr % origin_value, hptr_prev % origin_value/), &
            & ca = StoA(hptr % name, hptr_prev % name, fullfilename) )
          stat = HST_EBADORIGIN
          cause_c = fullfilename
          goto 999
        elseif ( hptr % origin_unit /= hptr_prev % origin_unit ) then
          call MessageNotify( 'W', subname, &
            & '@origin_unit=%a (var=%a) and @origin_unit=%a (var=%a) are applied to a file "%a"', &
            & ca = StoA(hptr % origin_unit, hptr % name, &
            &           hptr_prev % origin_unit, hptr_prev % name, &
            &           fullfilename) )
          stat = HST_EBADORIGIN
          cause_c = fullfilename
          goto 999
        end if

        ! terminus_value, terminus_unit Ʊå
        ! Check consistency of "terminus_value", "terminus_unit"
        !
        if ( hptr % terminus_value /= hptr_prev % terminus_value ) then
          call MessageNotify( 'W', subname, &
            & '@terminus_value=%r (var=%a) and @terminus_value=%r (var=%a) are applied to a file "%a"', &
            & r = (/hptr % terminus_value, hptr_prev % terminus_value/), &
            & ca = StoA(hptr % name, hptr_prev % name, fullfilename) )
          stat = HST_EBADTERMINUS
          cause_c = fullfilename
          goto 999
        elseif ( hptr % terminus_unit /= hptr_prev % terminus_unit ) then
          call MessageNotify( 'W', subname, &
            & '@terminus_unit=%a (var=%a) and @terminus_unit=%a (var=%a) are applied to a file "%a"', &
            & ca = StoA(hptr % terminus_unit, hptr % name, &
            &           hptr_prev % terminus_unit, hptr_prev % name, &
            &           fullfilename) )
          stat = HST_EBADTERMINUS
          cause_c = fullfilename
          goto 999
        end if

        ! newfile_intvalue ͭʾϥ顼֤. 
        ! Error is occurred when "newfile_intvalue" is valid
        !
        if (      ( hptr % newfile_intvalue > 0.0 ) &
          &  .or. ( hptr_prev % newfile_intvalue > 0.0 ) ) then
          call MessageNotify( 'W', subname, &
            & 'when @newfile_intvalue=%d (var=%a) > 0 or' // &
            & ' @newfile_intvalue=%d (var=%a) > 0, multiple variables can not be output to one file "%a"', &
            & i = (/hptr % newfile_intvalue, hptr_prev % newfile_intvalue/), &
            & ca = StoA(hptr % name, hptr_prev % name, fullfilename) )
          stat = HST_EBADNEWFILEINT
          cause_c = fullfilename
          goto 999
        end if

        ! newfile_intvalue, newfile_intunit Ʊå
        ! Check consistency of "newfile_intvalue", "newfile_intunit"
        !
        if ( hptr % newfile_intvalue /= hptr_prev % newfile_intvalue ) then
          call MessageNotify( 'W', subname, &
            & '@newfile_intvalue=%d (var=%a) and @newfile_intvalue=%d (var=%a) are applied to a file "%a"', &
            & i = (/hptr % newfile_intvalue, hptr_prev % newfile_intvalue/), &
            & ca = StoA(hptr % name, hptr_prev % name, fullfilename) )
          stat = HST_EBADNEWFILEINT
          cause_c = fullfilename
          goto 999
        elseif ( hptr % newfile_intunit /= hptr_prev % newfile_intunit ) then
          call MessageNotify( 'W', subname, &
            & '@newfile_intunit=%a (var=%a) and @newfile_intunit=%a (var=%a) are applied to a file "%a"', &
            & ca = StoA(hptr % newfile_intunit, hptr % name, &
            &           hptr_prev % newfile_intunit, hptr_prev % name, &
            &           fullfilename) )
          stat = HST_EBADNEWFILEINT
          cause_c = fullfilename
          goto 999
        end if


        ! slice_start, slice_end, slice_stride, space_average Ʊå
        ! Check consistency of "slice_start", "slice_end", "slice_stride", "space_average"
        !
        if ( any( hptr % slice_start /= hptr_prev % slice_start ) ) then
          call MessageNotify( 'W', subname, &
            & '@slice_start=%*d (var=%a) and @slice_start=%*d (var=%a) are applied to a file "%a"', &
            & i = (/hptr % slice_start(1:10), hptr_prev % slice_start(1:10)/), &
            & n = (/10, 10/), &
            & ca = StoA(hptr % name, hptr_prev % name, fullfilename) )
          stat = HST_EBADSLICE
          cause_c = fullfilename
          goto 999
        elseif ( any( hptr % slice_end /= hptr_prev % slice_end ) ) then
          call MessageNotify( 'W', subname, &
            & '@slice_end=%*d (var=%a) and @slice_end=%*d (var=%a) are applied to a file "%a"', &
            & i = (/hptr % slice_end(1:10), hptr_prev % slice_end(1:10)/), &
            & n = (/10, 10/), &
            & ca = StoA(hptr % name, hptr_prev % name, fullfilename) )
          stat = HST_EBADSLICE
          cause_c = fullfilename
          goto 999
        elseif ( any( hptr % slice_stride /= hptr_prev % slice_stride ) ) then
          call MessageNotify( 'W', subname, &
            & '@slice_stride=%*d (var=%a) and @slice_stride=%*d (var=%a) are applied to a file "%a"', &
            & i = (/hptr % slice_stride(1:10), hptr_prev % slice_stride(1:10)/), &
            & n = (/10, 10/), &
            & ca = StoA(hptr % name, hptr_prev % name, fullfilename) )
          stat = HST_EBADSLICE
          cause_c = fullfilename
          goto 999
        end if

        !
        ! GT_HISTORY ѿη
        ! Associate "GT_HISTORY" variable
        !
        hptr % history => hptr_prev % history
        exit SearchLoop
      end do SearchLoop

      !---------------------------------------------------------------
      !  ˳
      !  Allocate newly
      !---------------------------------------------------------------
      if ( .not. associated( hptr % history ) ) then
        allocate( hptr % history )
      end if

      !---------------------------------------------------------------
      !  դ줿̾ȥե̾Ͽ
      !  Regist allocated name and filename
      !---------------------------------------------------------------
      call DCHashPut( opened_files, &       ! (inout)
        & hptr % name, fullfilename ) ! (in)

    end do WholeLoop

    nullify( hptr )
    nullify( hptr_prev )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    gthstnml % define_mode = .false.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine HstNmlInfoEndDefine

  subroutine HstNmlInfoReDefine( gthstnml, err )
    !
    ! ϥ⡼ɤ⡼ɤ, 
    ! ƤӾǽˤޤ. 
    ! HstNmlInfoAssocGTHist ֥롼ƤӽФˤ, 
    !  HstNmlInfoEndDefine ƤӽФ⡼ɤؤȰܹԤƤ. 
    ! Υ֥롼ƤǤʤ, 
    ! HstNmlInfoAdd, HstNmlInfoDelete, HstNmlInfoResetDefault 
    ! Ƥ֤ȤǽǤ. 
    !
    ! ʤ, Ϳ줿 *gthstnml*  HstNmlInfoCreate ˤäƽ
    ! Ƥʤˤ, ץϥ顼ȯޤ. 
    !
    ! Return from output mode to define mode, 
    ! information can be configured again. 
    ! Use "HstNmlInfoEndDefine" again and 
    ! transit from define mode to output mode, 
    ! before "HstNmlInfoAssocGTHist" is used. 
    ! "HstNmlInfoAdd", "HstNmlInfoDelete", "HstNmlInfoResetDefault" 
    ! can be are used again after 
    ! this subroutine is used. 
    !
    ! If *gthstnml* is not initialized by "HstNmlInfoCreate" yet, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_hash, only: HASH, DCHashPut, DCHashGet, DCHashRewind, DCHashNext, DCHashNumber
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT, HST_ENOTINDEFINE, HST_EINTFILE, HST_EINDEFINE
    use dc_message, only: MessageNotify
    implicit none
    type(GTHST_NMLINFO), intent(inout):: gthstnml
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoReDefine'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. gthstnml % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'GTHST_NMLINFO'
      goto 999
    end if

    if ( gthstnml % define_mode ) then
      stat = HST_EINDEFINE
      cause_c = 'ReDefine'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ⡼ɤؤ
    !  Return to define mode
    !-----------------------------------------------------------------
    gthstnml % define_mode = .true.

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine HstNmlInfoReDefine

  recursive subroutine HstNmlInfoAdd( gthstnml, &
    & name, file, &
    & interval_value, interval_unit, &
    & precision, &
    & time_average, average, &
    & fileprefix, &
    & origin_value, origin_unit, &
    & terminus_value, terminus_unit, &
    & slice_start, slice_end, slice_stride, &
    & space_average, &
    & newfile_intvalue, newfile_intunit, &
    & err )
    !
    ! ѿνϾäޤ. 
    !
    ! ǥեͤꤹˤ, *name* Ϳʤ, ޤ
    ! *name* ˶ͿƤ. 
    ! ǥեͤͿ, *file* Ϳ̵뤵ޤ. 
    ! *fileprefix* ϥǥեͤͿΤͭǤ. 
    !
    ! *name* ѿ̾ꤵ, κݤ *file* Ϳʤ, 
    ! ޤ϶Ϳ, *file* ˤ 
    ! "<i><*name* Ϳ줿ʸ></i>.nc" ꤵޤ. 
    !
    ! ʤ, Ϳ줿 *gthstnml*  HstNmlInfoCreate ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ. 
    !
    ! Add output information of a variable.
    ! 
    ! In order to set default values, specify blank to *name* or
    ! do not specify *name*.
    ! When default values are specified, *file* is ignored. 
    ! *fileprefix* is valid only when default values are specified. 
    !
    ! When a variable identifier is specified to *name* and 
    ! *file* is not specified or blanks are specified to *file*,
    ! "<i><string given to *name*></i>.nc" is specified to *file*.
    !
    ! If *gthstnml* is not initialized by "HstNmlInfoCreate" yet, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub, DbgMessage
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar, CPrintf
    use dc_present, only: present_and_not_empty, present_and_true, present_select
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_date_types, only: DC_DIFFTIME
    use dc_date, only: DCDiffTimeCreate, operator(>), operator(<)
    use dc_message, only: MessageNotify
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT, DC_EARGLACK, &
      & USR_ERRNO, HST_ENOTINDEFINE, HST_EBADNEWFILEINT
    implicit none
    type(GTHST_NMLINFO), intent(inout):: gthstnml
    character(*), intent(in), optional:: name
                              ! ѿ̾. 
                              ! 
                              ! Ƭζ̵뤵ޤ. 
                              ! 
                              ! "Data1,Data2" Τ褦˥ޤǶڤäʣ
                              ! ѿꤹ뤳ȤǽǤ. 
                              !--
                              ! , 
                              ! κݤˤ, *file* Ϳ
                              ! ̵뤵ޤ. ¾ξϤ줾
                              ! ѿξȤꤵޤ. 
                              !++
                              ! 
                              ! Variable identifier. 
                              ! 
                              ! Blanks at the head of the name are ignored. 
                              ! 
                              ! Multiple variables can be specified 
                              ! as "Data1,Data2" too. Delimiter is comma. 
                              !--
                              ! In this case, *file* is ignored, and 
                              ! other information is set to each variable.
                              !++
                              ! 
    character(*), intent(in), optional:: file
                              ! ҥȥǡΥե̾. 
                              ! History data filenames
    real, intent(in), optional:: interval_value
                              ! ҥȥǡνϴֳ֤ο. 
                              ! ͤͿ, Ϥ޻ߤޤ. 
                              ! 
                              ! Numerical value for interval of history data output. 
                              ! Negative values suppresses output.
    character(*), intent(in), optional:: interval_unit
                              ! ҥȥǡνϴֳ֤ñ. 
                              ! Unit for interval of history data output
    character(*), intent(in), optional:: precision
                              ! ҥȥǡ. 
                              ! Precision of history data
    logical, intent(in), optional:: time_average
                              ! ϥǡλʿѲե饰. 
                              ! Flag for time average of output data.
    logical, intent(in), optional:: average
                              ! time_average ε. 
                              ! Old version of "time_average"
    character(*), intent(in), optional:: fileprefix
                              ! ҥȥǡΥե̾Ƭ. 
                              ! Prefixes of history data filenames
    real, intent(in), optional:: origin_value
                              ! ϳϻ. 
                              ! Start time of output. 
    character(*), intent(in), optional:: origin_unit
                              ! ϳϻñ. 
                              ! Unit of start time of output. 
    real, intent(in), optional:: terminus_value
                              ! Ͻλ. 
                              ! End time of output. 
    character(*), intent(in), optional:: terminus_unit
                              ! Ͻλñ. 
                              ! Unit of end time of output. 
    integer, intent(in), optional:: slice_start(:)
                              ! γ. 
                              ! Start points of spaces. 
    integer, intent(in), optional:: slice_end(:)
                              ! νλ. 
                              ! End points of spaces. 
    integer, intent(in), optional:: slice_stride(:)
                              ! ι. 
                              ! Strides of spaces. 
    logical, intent(in), optional:: space_average(:)
                              ! ʿѲΥե饰. 
                              ! Flag of average. 
    integer, intent(in), optional:: newfile_intvalue
                              ! եʬֳִ. 
                              ! Interval of time of separation of a file. 
    character(*), intent(in), optional:: newfile_intunit
                              ! եʬֳִ֤ñ. 
                              ! Unit of interval of time of separation of a file. 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr =>null()
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr_last =>null()
    type(DC_DIFFTIME):: interval_time, newfileint_time
    character(TOKEN), pointer:: varnames_array(:) =>null()
    integer:: i, vnmax, ary_size
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoAdd'
  continue
    call BeginSub( subname, &
      & fmt = '@name=%a @file=%a @interval_value=%r @interval_unit=%a @precision=%a @time_average=%y @fileprefix=%a', &
      & r  = (/ present_select(.true., -1.0, interval_value) /), &
      & l  = (/ present_and_true(time_average) /), &
      & ca = StoA( present_select(.true., '<no>', name), &
      &            present_select(.true., '<no>', file), &
      &            present_select(.true., '<no>', interval_unit), &
      &            present_select(.true., '<no>', precision), &
      &            present_select(.true., '<no>', fileprefix) ) &
      & )

    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. gthstnml % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'GTHST_NMLINFO'
      goto 999
    end if

    if ( .not. gthstnml % define_mode ) then
      stat = HST_ENOTINDEFINE
      cause_c = 'Add'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ʣѿꤹ
    !  Configure multiple variables
    !-----------------------------------------------------------------
    if ( present_and_not_empty(name) ) then
      if ( index(name, name_delimiter) > 0 ) then
        call DbgMessage( 'multiple entries (%c) will be created', c1 = trim(name) )
!!$        if ( present(file) ) call DbgMessage( 'argument @file=%c is ignored', c1 = trim(file) )

        call Split( str = name, sep = name_delimiter, & ! (in)
          & carray = varnames_array )                   ! (out)
        vnmax = size( varnames_array )

        do i = 1, vnmax
          call HstNmlInfoAdd( &
            & gthstnml = gthstnml, &             ! (inout)
            & name = varnames_array(i), &        ! (in)
            & file = file, &                     ! (in)
            & interval_value = interval_value, & ! (in)
            & interval_unit = interval_unit, &   ! (in)
            & precision = precision, &           ! (in)
            & time_average = time_average, &     ! (in)
            & average = average, &               ! (in)
            & origin_value = origin_value, &         ! (in)
            & origin_unit = origin_unit, &           ! (in)
            & terminus_value = terminus_value, &     ! (in)
            & terminus_unit = terminus_unit, &       ! (in)
            & slice_start = slice_start, &           ! (in)
            & slice_end = slice_end, &               ! (in)
            & slice_stride = slice_stride, &         ! (in)
            & space_average = space_average, &       ! (in)
            & newfile_intvalue = newfile_intvalue, & ! (in)
            & newfile_intunit = newfile_intunit, &   ! (in)
            & err = err )                        ! (out)
          if ( present_and_true( err ) ) then
            deallocate( varnames_array )
            stat = USR_ERRNO
            goto 999
          end if
        end do
        deallocate( varnames_array )
        goto 999
      end if
    end if

    !-----------------------------------------------------------------
    !  *gthstnml* ؾɲ.
    !  Add information to *gthstnml*
    !-----------------------------------------------------------------
    if ( .not. present_and_not_empty(name) ) then
      if ( present(interval_value) ) gthstnml % gthstnml_list % interval_value = interval_value
      if ( present(interval_unit)  ) gthstnml % gthstnml_list % interval_unit  = interval_unit 
      if ( present(precision)      ) gthstnml % gthstnml_list % precision      = precision     
      if ( present(average)        ) gthstnml % gthstnml_list % time_average   = average       
      if ( present(time_average)   ) gthstnml % gthstnml_list % time_average   = time_average       
      if ( present(fileprefix)     ) gthstnml % gthstnml_list % fileprefix     = fileprefix    

      if ( present(origin_value    ) ) gthstnml % gthstnml_list % origin_value     = origin_value    
      if ( present(origin_unit     ) ) gthstnml % gthstnml_list % origin_unit      = origin_unit     
      if ( present(terminus_value  ) ) gthstnml % gthstnml_list % terminus_value   = terminus_value  
      if ( present(terminus_unit   ) ) gthstnml % gthstnml_list % terminus_unit    = terminus_unit   
      if ( present(slice_start     ) ) then
        ary_size = size(slice_start)
        gthstnml % gthstnml_list % slice_start(1:ary_size)  = slice_start     
      end if
      if ( present(slice_end      ) ) then
        ary_size = size(slice_end)
        gthstnml % gthstnml_list % slice_end(1:ary_size)    = slice_end     
      end if
      if ( present(slice_stride   ) ) then
        ary_size = size(slice_stride)
        gthstnml % gthstnml_list % slice_stride(1:ary_size) = slice_stride     
      end if
      if ( present(space_average   ) ) then
        ary_size = size(space_average)
        gthstnml % gthstnml_list % space_average(1:ary_size) = space_average
      end if
      if ( present(newfile_intvalue) ) gthstnml % gthstnml_list % newfile_intvalue = newfile_intvalue
      if ( present(newfile_intunit ) ) gthstnml % gthstnml_list % newfile_intunit  = newfile_intunit 


      hptr => gthstnml % gthstnml_list

    else
      hptr => gthstnml % gthstnml_list
      call ListSearch( gthstnml_list = hptr, & ! (inout)
        &              name = name )           ! (in)
      if ( .not. associated(hptr) ) then
        call DbgMessage( 'new entry (%c) is created', c1 = trim( adjustl( name ) ) )

        hptr_last => gthstnml % gthstnml_list
        call ListLast( gthstnml_list = hptr_last ) ! (inout)
        allocate( hptr )

        nullify( hptr % next )

        hptr % interval_value => gthstnml % gthstnml_list % interval_value 
        hptr % interval_unit  => gthstnml % gthstnml_list % interval_unit  
        hptr % precision      => gthstnml % gthstnml_list % precision      
        hptr % time_average   => gthstnml % gthstnml_list % time_average   
        hptr % fileprefix     => gthstnml % gthstnml_list % fileprefix     

        hptr % origin_value     => gthstnml % gthstnml_list % origin_value    
        hptr % origin_unit      => gthstnml % gthstnml_list % origin_unit     
        hptr % terminus_value   => gthstnml % gthstnml_list % terminus_value  
        hptr % terminus_unit    => gthstnml % gthstnml_list % terminus_unit   
        hptr % slice_start      => gthstnml % gthstnml_list % slice_start     
        hptr % slice_end        => gthstnml % gthstnml_list % slice_end       
        hptr % slice_stride     => gthstnml % gthstnml_list % slice_stride    
        hptr % space_average    => gthstnml % gthstnml_list % space_average   
        hptr % newfile_intvalue => gthstnml % gthstnml_list % newfile_intvalue
        hptr % newfile_intunit  => gthstnml % gthstnml_list % newfile_intunit 

        hptr_last % next => hptr
      else
        call DbgMessage( 'entry (%c) is overwritten', c1 = trim( adjustl( name ) ) )
      end if

      hptr % name  = adjustl( name )
      if ( present_and_not_empty(file) ) then
        hptr % file = file
        nullify(  hptr % fileprefix )
        allocate( hptr % fileprefix )
        hptr % fileprefix = ''
      else
        hptr % file = trim( adjustl(name) ) // '.nc'
      end if

      if ( present(interval_value) ) then
        nullify(  hptr % interval_value )
        allocate( hptr % interval_value )
        hptr % interval_value = interval_value 
      end if
      if ( present(interval_unit)  ) then
        nullify(  hptr % interval_unit  )
        allocate( hptr % interval_unit  )
        hptr % interval_unit  = interval_unit  
      end if
      if ( present(precision)      ) then
        nullify(  hptr % precision      )
        allocate( hptr % precision      )
        hptr % precision      = precision      
      end if
      if ( present(average)        ) then
        nullify(  hptr % time_average        )
        allocate( hptr % time_average        )
        hptr % time_average   = average        
      end if
      if ( present(time_average)   ) then
        nullify(  hptr % time_average   )
        allocate( hptr % time_average   )
        hptr % time_average   = time_average        
      end if

      if ( present(origin_value)   ) then
        nullify(  hptr % origin_value   )
        allocate( hptr % origin_value   )
        hptr % origin_value   = origin_value        
      end if
      if ( present(origin_unit)   ) then
        nullify(  hptr % origin_unit   )
        allocate( hptr % origin_unit   )
        hptr % origin_unit   = origin_unit        
      end if
      if ( present(terminus_value)   ) then
        nullify(  hptr % terminus_value   )
        allocate( hptr % terminus_value   )
        hptr % terminus_value   = terminus_value        
      end if
      if ( present(terminus_unit)   ) then
        nullify(  hptr % terminus_unit   )
        allocate( hptr % terminus_unit   )
        hptr % terminus_unit   = terminus_unit        
      end if
      if ( present(slice_start)   ) then
        ary_size = size( slice_start )
        nullify(  hptr % slice_start   )
        allocate( hptr % slice_start(1:NF_MAX_DIMS)   )
        hptr % slice_start = 1
        hptr % slice_start(1:ary_size) = slice_start
      end if
      if ( present(slice_end)   ) then
        ary_size = size( slice_end )
        nullify(  hptr % slice_end   )
        allocate( hptr % slice_end(1:NF_MAX_DIMS)   )
        hptr % slice_end = -1
        hptr % slice_end(1:ary_size) = slice_end
      end if
      if ( present(slice_stride)   ) then
        ary_size = size( slice_stride )
        nullify(  hptr % slice_stride   )
        allocate( hptr % slice_stride(1:NF_MAX_DIMS)   )
        hptr % slice_stride = 1
        hptr % slice_stride(1:ary_size) = slice_stride
      end if
      if ( present(space_average)   ) then
        ary_size = size( space_average )
        nullify(  hptr % space_average   )
        allocate( hptr % space_average(1:NF_MAX_DIMS)   )
        hptr % space_average = .false.
        hptr % space_average(1:ary_size) = space_average
      end if
      if ( present(newfile_intvalue)   ) then
        nullify(  hptr % newfile_intvalue   )
        allocate( hptr % newfile_intvalue   )
        hptr % newfile_intvalue   = newfile_intvalue        
      end if
      if ( present(newfile_intunit)   ) then
        nullify(  hptr % newfile_intunit   )
        allocate( hptr % newfile_intunit   )
        hptr % newfile_intunit   = newfile_intunit        
      end if

    end if

    !---------------------------------------------------------------
    !  ֤ñ̤Υå
    !  Check unit of time
    !---------------------------------------------------------------
    call DCDiffTimeCreate( &
      & diff = interval_time, &          ! (out)
      & value = hptr % interval_value, & ! (in)
      & unit = hptr % interval_unit, &   ! (in)
      & err = err )                      ! (out)
    if ( present_and_true( err ) ) then
      call HstNmlInfoDelete( &
        & gthstnml = gthstnml, & ! (inout)
        & name = name )          ! (in)
      stat = USR_ERRNO
      goto 999
    end if

    !---------------------------------------------------------------
    !  եʬֳִ֤Υå
    !  Check interval of time of separation of a file
    !---------------------------------------------------------------
    call DCDiffTimeCreate( &
      & diff = newfileint_time, &                  ! (out)
      & value = real( hptr % newfile_intvalue ), & ! (in)
      & unit = hptr % newfile_intunit, &           ! (in)
      & err = err )                                ! (out)
    if ( present_and_true( err ) ) then
      call HstNmlInfoDelete( &
        & gthstnml = gthstnml, & ! (inout)
        & name = name )          ! (in)
      stat = USR_ERRNO
      goto 999
    end if

    if (             ( hptr % newfile_intvalue > 0     )   &
      &  .and. .not. ( newfileint_time > interval_time ) ) then
      call MessageNotify( 'W', subname, &
        & 'newfile_int=%d [%c] must be greater than interval=%r [%c]', &
        & i = (/ hptr % newfile_intvalue /), &
        & r = (/ hptr % interval_value /), &
        & c1 = trim( hptr % newfile_intunit ), &
        & c2 = trim( hptr % interval_unit ) )

      call HstNmlInfoDelete( &
        & gthstnml = gthstnml, & ! (inout)
        & name = name )          ! (in)
      stat = HST_EBADNEWFILEINT
      cause_c = CPrintf( '%d [%c]', &
        & i = (/ hptr % newfile_intvalue /), c1 = trim( hptr % newfile_intunit ) )
      goto 999
    end if

    nullify( hptr )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine HstNmlInfoAdd

  recursive subroutine HstNmlInfoDelete( gthstnml, &
    & name, &
    & err )
    !
    ! ѿνϾޤ. 
    !
    ! ʤ, Ϳ줿 *gthstnml*  HstNmlInfoCreate ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ. 
    !
    ! Delete output information of a variable.
    ! 
    ! If *gthstnml* is not initialized by "HstNmlInfoCreate" yet, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub, DbgMessage
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT, DC_EARGLACK, USR_ERRNO, HST_ENOTINDEFINE
    implicit none
    type(GTHST_NMLINFO), intent(inout):: gthstnml
    character(*), intent(in):: name
                              ! ѿ̾. 
                              ! 
                              ! Ƭζ̵뤵ޤ. 
                              ! 
                              ! "Data1,Data2" Τ褦˥ޤǶڤäʣ
                              ! ѿꤹ뤳ȤǽǤ. 
                              ! 
                              ! Variable identifier. 
                              ! 
                              ! Blanks at the head of the name are ignored. 
                              ! 
                              ! Multiple variables can be specified 
                              ! as "Data1,Data2". Delimiter is comma. 
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr =>null()
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr_prev =>null()
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr_next =>null()
    character(TOKEN), pointer:: varnames_array(:) =>null()
    integer:: i, vnmax
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoDelete'
  continue
    call BeginSub( subname, &
      & fmt = '@name=%c', &
      & c1 = trim( name ) )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. gthstnml % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'GTHST_NMLINFO'
      goto 999
    end if

    if ( .not. gthstnml % define_mode ) then
      stat = HST_ENOTINDEFINE
      cause_c = 'Delete'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ʣѿ
    !  Delete multiple variables
    !-----------------------------------------------------------------
    if ( present_and_not_empty(name) ) then
      if ( index(name, name_delimiter) > 0 ) then
        call DbgMessage( 'multiple entries (%c) will be deleted', c1 = trim(name) )
        call Split( str = name, sep = name_delimiter, & ! (in)
          & carray = varnames_array )                   ! (out)
        vnmax = size( varnames_array )

        do i = 1, vnmax
          call HstNmlInfoDelete( &
            & gthstnml = gthstnml, &      ! (inout)
            & name = varnames_array(i), & ! (in)
            & err = err )                 ! (out)
          if ( present_and_true( err ) ) then
            deallocate( varnames_array )
            stat = USR_ERRNO
            goto 999
          end if
        end do
        deallocate( varnames_array )
        goto 999
      end if
    end if

    !-----------------------------------------------------------------
    !  *gthstnml* ξ.
    !  Delete information in *gthstnml*
    !-----------------------------------------------------------------
    hptr => gthstnml % gthstnml_list
    call ListSearch( gthstnml_list = hptr, & ! (inout)
      &              name = name, &          ! (in)
      &              previous = hptr_prev, & ! (out)
      &              next = hptr_next )      ! (out)

    if ( .not. associated( hptr ) ) goto 999
    if ( ( trim(hptr % name) /= '' ) .and. associated( hptr_prev ) ) then
      call DbgMessage( 'entry (%c) is deleted', c1 = trim( adjustl( name ) ) )
      hptr_prev % next => hptr_next
      deallocate( hptr )
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine HstNmlInfoDelete

  subroutine HstNmlInfoResetDefault( gthstnml, err )
    !
    ! ǥեͤĤ, Ͽǡޤ.
    !
    ! ʤ, Ϳ줿 *gthstnml*  HstNmlInfoCreate ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ. 
    !
    ! Stored data is deleted without default settings. 
    !
    ! If *gthstnml* is not initialized by "HstNmlInfoCreate" yet, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT, HST_ENOTINDEFINE
    implicit none
    type(GTHST_NMLINFO), intent(inout):: gthstnml
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    character(TOKEN), pointer:: varnames_array(:) =>null()
    integer:: i, vnmax
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoResetDefault'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. gthstnml % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'GTHST_NMLINFO'
      goto 999
    end if

    if ( .not. gthstnml % define_mode ) then
      stat = HST_ENOTINDEFINE
      cause_c = 'ResetDefault'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ѿ̾ꥹȤμ
    !  Get varnames list
    !-----------------------------------------------------------------
    call HstNmlInfoGetNames( gthstnml, & ! (in)
      & varnames_array )                 ! (out)
    vnmax = size( varnames_array )

    do i = 1, vnmax
      call HstNmlInfoDelete( &
        & gthstnml = gthstnml, &     ! (inout)
        & name = varnames_array(i) ) ! (in)
    end do

    deallocate( varnames_array )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine HstNmlInfoResetDefault

  subroutine HstNmlInfoInquire( gthstnml, &
    & name, &
    & file, &
    & interval_value, &
    & interval_unit, &
    & precision, &
    & time_average, average, &
    & fileprefix, &
    & origin_value, origin_unit, &
    & terminus_value, terminus_unit, &
    & slice_start, slice_end, slice_stride, &
    & space_average, &
    & newfile_intvalue, newfile_intunit, &
    & err )
    !
    ! ѿνϾޤ. 
    !
    ! ǥեͤˤ, *name* Ϳʤ, ޤ
    ! *name* ˶ͿƤ. 
    !
    ! *name* ˴ؤǡ¸ߤʤ, 顼ȯޤ. 
    !
    ! ʤ, Ϳ줿 *gthstnml*  HstNmlInfoCreate ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ. 
    !
    ! Inquire output information of a variable.
    ! 
    ! If data correspond to *name* is not found, 
    ! error is occurred. 
    !
    ! If *gthstnml* is not initialized by "HstNmlInfoCreate" yet, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT, DC_EARGLACK, DC_ENOENTRY
    implicit none
    type(GTHST_NMLINFO), intent(in):: gthstnml
    character(*), intent(in), optional:: name
                              ! ѿ̾. 
                              ! Ƭζ̵뤵ޤ. 
                              ! 
                              ! Variable identifier. 
                              ! Blanks at the head of the name are ignored. 
    character(*), intent(out), optional:: file
                              ! ҥȥǡΥե̾. 
                              ! History data filenames
    real, intent(out), optional:: interval_value
                              ! ҥȥǡνϴֳ֤ο. 
                              ! ͤͿ, Ϥ޻ߤޤ. 
                              ! 
                              ! Numerical value for interval of history data output. 
                              ! Negative values suppresses output.
    character(*), intent(out), optional:: interval_unit
                              ! ҥȥǡνϴֳ֤ñ. 
                              ! Unit for interval of history data output
    character(*), intent(out), optional:: precision
                              ! ҥȥǡ. 
                              ! Precision of history data
    logical, intent(out), optional:: time_average
                              ! ϥǡλʿѲե饰. 
                              ! Flag for time average of output data.
    logical, intent(out), optional:: average
                              ! time_average ε. 
                              ! Old version of "time_average"
    character(*), intent(out), optional:: fileprefix
                              ! ҥȥǡΥե̾Ƭ. 
                              ! Prefixes of history data filenames
    real, intent(out), optional:: origin_value
                              ! ϳϻ. 
                              ! Start time of output. 
    character(*), intent(out), optional:: origin_unit
                              ! ϳϻñ. 
                              ! Unit of start time of output. 
    real, intent(out), optional:: terminus_value
                              ! Ͻλ. 
                              ! End time of output. 
    character(*), intent(out), optional:: terminus_unit
                              ! Ͻλñ. 
                              ! Unit of end time of output. 
    integer, intent(out), optional:: slice_start(:)
                              ! γ. 
                              ! Start points of spaces. 
    integer, intent(out), optional:: slice_end(:)
                              ! νλ. 
                              ! End points of spaces. 
    integer, intent(out), optional:: slice_stride(:)
                              ! ι. 
                              ! Strides of spaces. 
    logical, intent(out), optional:: space_average(:)
                              ! ʿѲΥե饰. 
                              ! Flag of average. 
    integer, intent(out), optional:: newfile_intvalue
                              ! եʬֳִ. 
                              ! Interval of time of separation of a file. 
    character(*), intent(out), optional:: newfile_intunit
                              ! եʬֳִ֤ñ. 
                              ! Unit of interval of time of separation of a file. 

    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr =>null()
    character(STRING):: name_work
    integer:: stat, ary_size
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoInquire'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. gthstnml % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'GTHST_NMLINFO'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *gthstnml* ⤫, *name* ˴ؤõ.
    !  Search information correspond to *name* in *gthstnml*
    !-----------------------------------------------------------------
    if ( present(name) ) then
      name_work = name
    else
      name_work = ''
    end if
    hptr => gthstnml % gthstnml_list
    call ListSearch( gthstnml_list = hptr, & ! (inout)
      &              name = name_work )      ! (in)

    if ( .not. associated( hptr ) ) then
      stat = DC_ENOENTRY
      cause_c = adjustl( name_work )
      goto 999
    end if

    if ( hptr % name == '' ) then
      if ( present(file)           ) file           = ''
    else
      if ( present(file)           ) file           = trim( hptr % fileprefix ) // hptr % file
    end if
    if ( present(interval_value) ) interval_value = hptr % interval_value
    if ( present(interval_unit)  ) interval_unit  = hptr % interval_unit 
    if ( present(precision)      ) precision      = hptr % precision     
    if ( present(average)        ) average        = hptr % time_average  
    if ( present(time_average)   ) time_average   = hptr % time_average  
    if ( present(fileprefix)     ) fileprefix     = hptr % fileprefix    

    if ( present(origin_value    ) ) origin_value     = hptr % origin_value    
    if ( present(origin_unit     ) ) origin_unit      = hptr % origin_unit     
    if ( present(terminus_value  ) ) terminus_value   = hptr % terminus_value  
    if ( present(terminus_unit   ) ) terminus_unit    = hptr % terminus_unit   
    if ( present(slice_start     ) ) then
      ary_size = size(slice_start)
      slice_start  = hptr % slice_start(1:ary_size)
    end if
    if ( present(slice_end     ) ) then
      ary_size = size(slice_end)
      slice_end  = hptr % slice_end(1:ary_size)
    end if
    if ( present(slice_stride     ) ) then
      ary_size = size(slice_stride)
      slice_stride  = hptr % slice_stride(1:ary_size)
    end if
    if ( present(space_average     ) ) then
      ary_size = size(space_average)
      space_average  = hptr % space_average(1:ary_size)
    end if
    if ( present(newfile_intvalue) ) newfile_intvalue = hptr % newfile_intvalue
    if ( present(newfile_intunit ) ) newfile_intunit  = hptr % newfile_intunit 

    nullify( hptr )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine HstNmlInfoInquire

  subroutine HstNmlInfoAssocGtHist( gthstnml, &
    & name, history, err )
    !
    ! Ϳ줿 gtool_history#GT_HISTORY Υݥ *history* Ф, 
    ! *gthstnml*  *name* ˴ؤ gtool_history#GT_HISTORY ѿ
    ! 礷ޤ. 
    ! ֤ *history* ͿƤ. 
    !
    ! HstNmlInfoEndDefine ⡼ɤϥ⡼ɤ
    ! ܹԤ˸ƤӽФƤ. 
    ! HstNmlInfoEndDefine ƤˤΥ֥롼Ѥ, 
    ! ץϥ顼ȯޤ. 
    !
    ! *name* ˴ؤ󤬸ʤ, 
    ! ץϥ顼ȯޤ. 
    ! *name* ʸξˤ, 
    ! ץϥ顼ȯޤ. 
    !
    ! ʤ, Ϳ줿 *gthstnml*  HstNmlInfoCreate ˤäƽ
    ! Ƥʤˤ, ץϥ顼ȯޤ. 
    !
    ! This subroutine associates given "gtool_history#GT_HISTORY" 
    ! pointer *history* to 
    ! "gtool_history#GT_HISTORY" correspond to *name* in *gthstnml*. 
    ! Give null *history*. 
    !
    ! Use after state is changed from define mode to
    ! output mode by "HstNmlInfoEndDefine". 
    ! If this subroutine is used before 
    ! "HstNmlInfoEndDefine" is used, error is occurred. 
    !
    ! When data correspond to *name* is not found, 
    ! error is occurred.
    ! When *name* is blank, 
    ! error is occurred too.
    ! 
    ! If *gthstnml* is not initialized by "HstNmlInfoCreate" yet, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT, DC_ENOENTRY, HST_EBADNAME, HST_EINDEFINE
    implicit none
    type(GTHST_NMLINFO), intent(in):: gthstnml
    character(*), intent(in):: name
                              ! ѿ̾. 
                              ! Ƭζ̵뤵ޤ. 
                              ! 
                              ! Variable identifier. 
                              ! Blanks at the head of the name are ignored. 
    type(GT_HISTORY), pointer:: history
                              ! (out)
                              ! 
                              ! gtool_history ⥸塼ѹ¤. 
                              ! Derived type for "gtool_history" module
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr =>null()
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoAssocGtHist'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. gthstnml % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'GTHST_NMLINFO'
      goto 999
    end if

    if ( trim( name ) == '' ) then
      stat = HST_EBADNAME
      cause_c = ''
      goto 999
    end if

    if ( gthstnml % define_mode ) then
      stat = HST_EINDEFINE
      cause_c = 'AssocGtHist'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *gthstnml* ⤫, *name* ˴ؤ history õ.
    !  Search "history" correspond to *name* in *gthstnml*
    !-----------------------------------------------------------------
    hptr => gthstnml % gthstnml_list
    call ListSearch( gthstnml_list = hptr, & ! (inout)
      &              name = name )           ! (in)

    if ( .not. associated( hptr ) ) then
      stat = DC_ENOENTRY
      cause_c = adjustl( name )
      goto 999
    end if

    nullify( history )
    history => hptr % history

    nullify( hptr )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine HstNmlInfoAssocGtHist

  subroutine HstNmlInfoOutputStepDisable( gthstnml, &
    & name, err )
    !
    ! Υ֥롼Ѥ, *name* ˴ؤ, 
    ! ʹߤ HstNmlInfoOutputStep  .false. ֤褦ˤʤޤ. 
    !
    ! ǡϴֳ֤Ϥν꤫ѹ, 
    ! ǡϤ뤿Ӥ˻Ū˻ꤹѤ뤳Ȥ
    ! ꤷƤޤ. 
    !
    ! HstNmlInfoEndDefine ⡼ɤϥ⡼ɤ
    ! ܹԤ˸ƤӽФƤ. 
    ! HstNmlInfoEndDefine ƤˤΥ֥롼Ѥ, 
    ! ץϥ顼ȯޤ. 
    !
    ! *name* ˴ؤ󤬸ʤ, 
    ! ץϥ顼ȯޤ. 
    ! *name* ʸξˤ, 
    ! ץϥ顼ȯޤ. 
    !
    ! ʤ, Ϳ줿 *gthstnml*  HstNmlInfoCreate ˤäƽ
    ! Ƥʤˤ, ץϥ顼ȯޤ. 
    !
    ! After this subroutine is used, 
    ! "HstNmlInfoOutputStep" returns .false. already 
    ! corresponding to the *name*. 
    !
    ! This subroutine expected to use when 
    ! interval of data output is changed from initialization of output, 
    ! and time is specified explicitly whenever data is output. 
    !
    ! Use after state is changed from define mode to
    ! output mode by "HstNmlInfoEndDefine". 
    ! If this subroutine is used before 
    ! "HstNmlInfoEndDefine" is used, error is occurred. 
    !
    ! When data correspond to *name* is not found, error is occurred.
    ! When *name* is blank, error is occurred too.
    !
    ! If *gthstnml* is not initialized by "HstNmlInfoCreate" yet, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT, DC_ENOENTRY, HST_EBADNAME, HST_EINDEFINE
    implicit none
    type(GTHST_NMLINFO), intent(in):: gthstnml
    character(*), intent(in):: name
                              ! ѿ̾. 
                              ! Ƭζ̵뤵ޤ. 
                              ! 
                              ! Variable identifier. 
                              ! Blanks at the head of the name are ignored. 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr =>null()
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoOutputStepDisable'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. gthstnml % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'GTHST_NMLINFO'
      goto 999
    end if

    if ( trim( name ) == '' ) then
      stat = HST_EBADNAME
      cause_c = ''
      goto 999
    end if

    if ( gthstnml % define_mode ) then
      stat = HST_EINDEFINE
      cause_c = 'OutputStepDisable'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *gthstnml* ⤫, *name* ˴ؤ history õ.
    !  Search "history" correspond to *name* in *gthstnml*
    !-----------------------------------------------------------------
    hptr => gthstnml % gthstnml_list
    call ListSearch( gthstnml_list = hptr, & ! (inout)
      &              name = name )           ! (in)

    if ( .not. associated( hptr ) ) then
      stat = DC_ENOENTRY
      cause_c = adjustl( name )
      goto 999
    end if

    hptr % output_step_disable = .true.

    nullify( hptr )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine HstNmlInfoOutputStepDisable

  logical function HstNmlInfoOutputStep( gthstnml, &
    & name, time ) result(result)
    !
    ! *time* ѿ *name* νϤ륿ߥ󥰤Ǥ
    ! .true. , Ǥʤ .false. ֤ޤ. 
    ! *gthstnml* ꤵƤʤˤ .false. ֤ޤ. 
    ! *name* ˴ؤǡ¸ߤʤˤ .false. ֤ޤ. 
    !
    ! ʤ, Ϳ줿 *gthstnml*  HstNmlInfoCreate ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ. 
    !
    ! If *time* is the time that a variable *name* is output,
    ! .true. is returned, otherwise .false. is returned
    ! When *gthstnml* is not initialized, .false. is returned too.
    ! When data correspond to *name* is not found, .false. is returned too.
    ! 
    ! If *gthstnml* is not initialized by "HstNmlInfoCreate" yet, 
    ! error is occurred.
    !
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_date_types, only: DC_DIFFTIME
    use dc_date, only: DCDiffTimeCreate, mod, operator(==), toChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    implicit none
    type(GTHST_NMLINFO), intent(in):: gthstnml
    character(*), intent(in):: name
                              ! ѿ̾. 
                              ! Ƭζ̵뤵ޤ. 
                              ! 
                              ! Variable identifier. 
                              ! Blanks at the head of the name are ignored. 
    type(DC_DIFFTIME), intent(in):: time
                              ! ߻. Current time

    !-----------------------------------
    !  ѿ
    !  Work variables
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr =>null()
    type(DC_DIFFTIME):: interval_time
!!$    character(*), parameter:: subname = 'HstNmlInfoOutputStep'
  continue

    result = .false.

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. gthstnml % initialized ) goto 999

    !-----------------------------------------------------------------
    !  Ǽѿؤη
    !  Associate a variable storing information
    !-----------------------------------------------------------------
    hptr => gthstnml % gthstnml_list
    call ListSearch( gthstnml_list = hptr, & ! (inout)
      &              name = name )           ! (in)

    if ( .not. associated( hptr ) ) goto 999
    if ( hptr % output_step_disable ) goto 999

    !-----------------------------------------------------------------
    !  Υå
    !  Check time
    !-----------------------------------------------------------------
    if ( .not. hptr % interval_value > 0.0 ) goto 999

    call DCDiffTimeCreate( &
      & diff = interval_time, &                      ! (out)
      & value = real( hptr % interval_value, DP ), & ! (in)
      & unit = hptr % interval_unit )                ! (in)

    if ( mod( time, interval_time ) == 0 ) then
      result = .true.
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    nullify( hptr )
  end function HstNmlInfoOutputStep

  logical function HstNmlInfoOutputValid( gthstnml, &
    & name ) result(result)
    !
    ! ѿ *name* νϤͭǤ, 
    ! .true. , Ǥʤ .false. ֤ޤ. 
    ! ϤͭǤ뤫ɤ, ϴֳ *interval_value* 
    ! ˤäȽꤵޤ. ξ礬ͭ, ξ礬̵Ǥ. 
    ! *gthstnml* ꤵƤʤˤ .false. ֤ޤ. 
    ! *name* ˴ؤǡ¸ߤʤˤ .false. ֤ޤ. 
    !
    ! ʤ, Ϳ줿 *gthstnml*  HstNmlInfoCreate ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ. 
    !
    ! If output of a variable *name* is valid, 
    ! .true. is returned, otherwise .false. is returned. 
    ! Whether output is valid or not is judged with positive or negative 
    ! of *interval_value*. Positive is valid, and negative is invalid. 
    ! When *gthstnml* is not initialized, .false. is returned too. 
    ! When data correspond to *name* is not found, .false. is returned too. 
    ! 
    ! If *gthstnml* is not initialized by "HstNmlInfoCreate" yet, 
    ! error is occurred.
    !
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_date_types, only: DC_DIFFTIME
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    implicit none
    type(GTHST_NMLINFO), intent(in):: gthstnml
    character(*), intent(in):: name
                              ! ѿ̾. 
                              ! Ƭζ̵뤵ޤ. 
                              ! 
                              ! Variable identifier. 
                              ! Blanks at the head of the name are ignored. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr =>null()
!!$    character(*), parameter:: subname = 'HstNmlInfoOutputValid'
  continue

    result = .false.

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. gthstnml % initialized ) goto 999

    !-----------------------------------------------------------------
    !  Ǽѿؤη
    !  Associate a variable storing information
    !-----------------------------------------------------------------
    hptr => gthstnml % gthstnml_list
    call ListSearch( gthstnml_list = hptr, & ! (inout)
      &              name = name )           ! (in)

    if ( .not. associated( hptr ) ) goto 999

    !-----------------------------------------------------------------
    !  ϤͭΥå
    !  Check validity of output
    !-----------------------------------------------------------------
    if ( hptr % interval_value > 0.0 ) then
      result = .true.
      goto 999
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    nullify( hptr )
  end function HstNmlInfoOutputValid

  character(STRING) function HstNmlInfoNames( gthstnml ) result(result)
    !
    ! *gthstnml* ꤵƤѿꥹȤ򥫥ޤǤĤʤ
    ! ֤ޤ. 
    !
    ! ʤ, Ϳ줿 *gthstnml*  HstNmlInfoCreate ˤäƽ
    ! Ƥʤ, ʸ֤ޤ. 
    !
    ! List of variables registered in *gthstnml* is join with camma, 
    ! and returned. 
    ! 
    ! If *gthstnml* is not initialized by "HstNmlInfoCreate" yet, 
    ! blank is returned. 
    !
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    implicit none
    type(GTHST_NMLINFO), intent(in):: gthstnml

    !-----------------------------------
    !  ѿ
    !  Work variables
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr =>null()
    logical:: first
!!$    character(*), parameter:: subname = 'HstNmlInfoNames'
  continue

    result = ''
    first = .true.

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. gthstnml % initialized ) goto 999

    !-----------------------------------------------------------------
    !  μФ
    !  Fetch information
    !-----------------------------------------------------------------
    hptr => gthstnml % gthstnml_list
    do while ( associated( hptr % next ) )
      call ListNext( gthstnml_list = hptr ) ! (inout)
      if ( first ) then
        result = adjustl( hptr % name )
        first = .false.
      else
        result = trim( result ) // name_delimiter // adjustl( hptr % name )
      end if
    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    nullify( hptr )
  end function HstNmlInfoNames

  subroutine HstNmlInfoGetNames( gthstnml, varnames_ary, err )
    !
    ! *gthstnml* ꤵƤѿꥹȤʸݥ󥿤
    ! ֤ޤ. varnames_ary ϶֤ˤͿƤ. 
    !
    ! ʤ, Ϳ줿 *gthstnml*  HstNmlInfoCreate ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ. 
    !
    ! List of variables registered in *gthstnml* is returned to
    ! character array pointer. 
    ! Nullify "varnames_ary" before it is given to this subroutine. 
    !
    ! If *gthstnml* is not initialized by "HstNmlInfoCreate" yet, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use netcdf_f77, only: NF_MAX_VARS
    implicit none
    type(GTHST_NMLINFO), intent(in):: gthstnml
    character(TOKEN), pointer:: varnames_ary(:) ! (out)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr =>null()
    integer:: varnums, ary_size
    character(TOKEN), allocatable:: varnames_ary_tmp1(:), varnames_ary_tmp2(:)
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoNames'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    varnums = 0

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. gthstnml % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'GTHST_NMLINFO'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  դ
    !  Allocate
    !-----------------------------------------------------------------
    if ( associated(varnames_ary) ) deallocate(varnames_ary)
    allocate( varnames_ary_tmp1(1:NF_MAX_VARS) )

    !-----------------------------------------------------------------
    !  μФ
    !  Fetch information
    !-----------------------------------------------------------------
    hptr => gthstnml % gthstnml_list
    do while ( associated( hptr % next ) )
      call ListNext( gthstnml_list = hptr ) ! (inout)
      varnums = varnums + 1
      ary_size = size( varnames_ary_tmp1 )
      if ( varnums > ary_size ) then
        allocate( varnames_ary_tmp2(1:ary_size) )
        varnames_ary_tmp2(1:ary_size) = varnames_ary_tmp1(1:ary_size)
        deallocate( varnames_ary_tmp1 )
        allocate( varnames_ary_tmp1(1:varnums*2) )
        varnames_ary_tmp1(1:ary_size) = varnames_ary_tmp2(1:ary_size)
        deallocate( varnames_ary_tmp2 )
      end if

      varnames_ary_tmp1(varnums) = adjustl( hptr % name )
    end do

    if ( varnums > 0 ) then
      allocate( varnames_ary(1:varnums) )
      varnames_ary(1:varnums) = varnames_ary_tmp1(1:varnums)
    else
      allocate( varnames_ary(1:1) )
      varnames_ary = ''
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    nullify( hptr )
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine HstNmlInfoGetNames

  subroutine HstNmlInfoAllVarIniCheck( gthstnml, &
    & invalid, &
    & names, &
    & err )
    !
    ! ꤵƤʤѿ̾Υå
    !
    ! ꤵƤʤѿ̾, 
    ! *invalid*  .true. ֤, *names* ˤϽꤵƤʤ
    ! ѿ̾򥫥ޤǶڤäʸ֤ޤ. 
    ! 
    ! ʤ, Ϳ줿 *gthstnml*  HstNmlInfoCreate ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ. 
    !
    ! Check uninitialized variable names
    ! 
    ! If uninitialized variable names are exist, 
    ! .true. is set to *invalid*, and uninitialized variable names
    ! are joined with comma, and set to *names*. 
    !
    ! If *gthstnml* is not initialized by "HstNmlInfoCreate" yet, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT, DC_EARGLACK, DC_ENOENTRY
    use gtool_history, only: HistoryInitialized
    implicit none
    type(GTHST_NMLINFO), intent(in):: gthstnml
    logical, intent(out):: invalid
                              ! ꤵƤʤѿ̾¸ߤ
                              ! ˤ .true. ֤. 
                              ! 
                              ! If uninitialized variable names are exist, 
                              ! .true. is returned. 
                              ! 
    character(*), intent(out):: names
                              ! ꤵƤʤѿ̾Υꥹ. 
                              ! 
                              ! List of uninitialized variable names. 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr =>null()
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoAllVarIniCheck'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    names = ''
    invalid = .false.

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. gthstnml % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'GTHST_NMLINFO'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *gthstnml* ⤫, *name* ˴ؤõ.
    !  Search information correspond to *name* in *gthstnml*
    !-----------------------------------------------------------------
    hptr => gthstnml % gthstnml_list
    do while ( associated( hptr % next ) )
      call ListNext( gthstnml_list = hptr ) ! (inout)

      if ( .not. HistoryInitialized( hptr % history ) ) then
        invalid = .true.
        if ( trim(names) /= '' ) names = trim(names) // name_delimiter
        names = trim(names) // adjustl( hptr % name )
      end if
    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname, fmt = '@invalid=%y @names=%c', &
      & l = (/ invalid /), c1 = trim(names) )
  end subroutine HstNmlInfoAllVarIniCheck

  subroutine HstNmlInfoSetValidName( gthstnml, &
    & name, &
    & err )
    !
    ! ѿ̾ͭ. 
    !
    ! ̵ѿ̾Τ뤿, Υ֥롼
    ! ͭѿФƤŪԤޤ. 
    ! 
    ! ʤ, Ϳ줿 *gthstnml*  HstNmlInfoCreate ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ. 
    !
    ! Set validation to variable names. 
    ! 
    ! For detection of invalid variable names, 
    ! Set validation to variable names explicitly by this 
    ! subroutine. 
    !
    ! If *gthstnml* is not initialized by "HstNmlInfoCreate" yet, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT, DC_EARGLACK, DC_ENOENTRY
    use gtool_history, only: HistoryInitialized
    implicit none
    type(GTHST_NMLINFO), intent(in):: gthstnml
    character(*), intent(in):: name
                              ! ͭǤ뤳Ȥꤹѿ̾. 
                              ! 
                              ! "Data1,Data2" Τ褦˥ޤǶڤäʣ
                              ! ѿꤹ뤳ȤǽǤ. 
                              ! 
                              ! A variable name that is set validation. 
                              ! 
                              ! Multiple variables can be specified 
                              ! as "Data1,Data2" too. Delimiter is comma. 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr =>null()
    character(TOKEN), pointer:: varnames_array(:) =>null()
    integer:: i, vnmax
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoSetValidName'
  continue
    call BeginSub( subname, fmt = '@name=%c', c1 = trim(name) )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. gthstnml % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'GTHST_NMLINFO'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ʣѿ̾μ갷
    !  Handle multiple variables
    !-----------------------------------------------------------------
    call Split( str = name, sep = name_delimiter, & ! (in)
      & carray = varnames_array )                   ! (out)
    vnmax = size( varnames_array )

    !-----------------------------------------------------------------
    !  *gthstnml* ⤫, *name* ˴ؤõ.
    !  Search information correspond to *name* in *gthstnml*
    !-----------------------------------------------------------------
    do i = 1, vnmax
      hptr => gthstnml % gthstnml_list
      call ListSearch( gthstnml_list = hptr, &    ! (inout)
        &              name = varnames_array(i) ) ! (in)
      if ( associated( hptr ) ) then
        hptr % name_invalid = .false.
      end if
    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine HstNmlInfoSetValidName

  subroutine HstNmlInfoAllNameValid( gthstnml, &
    & invalid, &
    & names, &
    & err )
    !
    ! ̵ѿ̾Υå
    !
    ! HstNmlInfoSetValidName ˤä, ͭꤵƤʤѿ
    ! , 
    ! *invalid*  .true. ֤, *names* ˤ̵
    ! ѿ̾򥫥ޤǶڤäʸ֤ޤ. 
    ! 
    ! ʤ, Ϳ줿 *gthstnml*  HstNmlInfoCreate ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ. 
    !
    ! Check invalid variable names
    ! 
    ! If variable names that are not set validation by 
    ! "HstNmlInfoSetValidName" are exist, 
    ! .true. is set to *invalid*, and invalid variable names
    ! are joined with comma, and set to *names*. 
    !
    ! If *gthstnml* is not initialized by "HstNmlInfoCreate" yet, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT, DC_EARGLACK, DC_ENOENTRY
    use gtool_history, only: HistoryInitialized
    implicit none
    type(GTHST_NMLINFO), intent(in):: gthstnml
    logical, intent(out):: invalid
                              ! ̵ѿ̾¸ߤ
                              ! ˤ .true. ֤. 
                              ! 
                              ! If invalid variable names are exist, 
                              ! .true. is returned. 
                              ! 
    character(*), intent(out):: names
                              ! ̵ѿ̾Υꥹ. 
                              ! 
                              ! List of invalid variable names. 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr =>null()
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoAllNameValid'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    names = ''
    invalid = .false.

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. gthstnml % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'GTHST_NMLINFO'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *gthstnml* ⤫, *name* ˴ؤõ.
    !  Search information correspond to *name* in *gthstnml*
    !-----------------------------------------------------------------
    hptr => gthstnml % gthstnml_list
    do while ( associated( hptr % next ) )
      call ListNext( gthstnml_list = hptr ) ! (inout)

      if ( hptr % name_invalid ) then
        invalid = .true.
        if ( trim(names) /= '' ) names = trim(names) // name_delimiter
        names = trim(names) // adjustl( hptr % name )
      end if
    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname, fmt = '@invalid=%y @names=%c', &
      & l = (/ invalid /), c1 = trim(names) )
  end subroutine HstNmlInfoAllNameValid

  subroutine HstNmlInfoListNext( &
    & gthstnml_list, err )
    !
    ! ꥹȹ¤Ǥ *gthstnml_list* (GTHST_NMLINFO_ENTRY ) , 
    ! Υȥ *gthstnml_list* ˺Ʒ礷֤ޤ. 
    ! Υȥ̵꤬, *gthstnml_list* κǸΥȥ 
    ! *next* () ³֤ޤ. 
    ! *gthstnml_list* Ϥᤫξˤ϶֤֤ޤ. 
    !
    ! *gthstnml_list* (type "GTHST_NMLINFO_ENTRY") that is a list structure 
    ! is recieved, and *gthstnml_list* is reassociated to next entry, and
    ! is returned. 
    ! If next entry is not found, *gthstnml_list* is associated to 
    ! *next* in last entry (null), and returned. 
    ! If *gthstnml_list* is null from the beginning, null is returned.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_error, only: StoreError, DC_NOERR
    implicit none
    type(GTHST_NMLINFO_ENTRY), pointer:: gthstnml_list
                              ! (inout)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoListNext'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  ֤ξϲ⤷ʤ֤
    !  If null, return without change
    !-----------------------------------------------------------------
    if ( .not. associated( gthstnml_list ) ) goto 999

    !-----------------------------------------------------------------
    !  Υȥ˷礷֤
    !  Next entry is associated, and returned
    !-----------------------------------------------------------------
    gthstnml_list => gthstnml_list % next

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine HstNmlInfoListNext

  subroutine HstNmlInfoListLast( &
    & gthstnml_list, previous, err )
    !
    ! ꥹȹ¤Ǥ *gthstnml_list* (GTHST_NMLINFO_ENTRY ) , 
    ! ǸΥȥ˺Ʒ礷֤ޤ. 
    ! *gthstnml_list* Ϥᤫξˤ϶֤֤ޤ. 
    !
    ! *previous* Ϳ, ȥΰ
    ! ȥ˷礷ޤ. 
    !
    ! *gthstnml_list* (type "GTHST_NMLINFO_ENTRY") that is a list structure 
    ! is recieved, and *gthstnml_list* is reassociated to 
    ! last entry, and returned. 
    ! If *gthstnml_list* is null from the beginning, null is returned.
    !
    ! If *previous* is given, an entry previous to the above entry
    ! is associated. 
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_error, only: StoreError, DC_NOERR
    implicit none
    type(GTHST_NMLINFO_ENTRY), pointer:: gthstnml_list
                              ! (inout)
    type(GTHST_NMLINFO_ENTRY), pointer, optional:: previous
                              ! (out)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoListLast'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    if ( present( previous ) ) nullify( previous )

    !-----------------------------------------------------------------
    !  ֤ξϲ⤷ʤ֤
    !  If null, return without change
    !-----------------------------------------------------------------
    if ( .not. associated( gthstnml_list ) ) goto 999

    !-----------------------------------------------------------------
    !  ǸΥȥ *next* ˷礷֤
    !  "*next*" in last entry is associated, and returned
    !-----------------------------------------------------------------
    do while ( associated( gthstnml_list % next ) )
      if ( present( previous ) ) previous => gthstnml_list
      call ListNext( gthstnml_list = gthstnml_list ) ! (inout)
    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine HstNmlInfoListLast

  subroutine HstNmlInfoListSearch( &
    & gthstnml_list, name, &
    & previous, next, err )
    !
    ! ꥹȹ¤Ǥ *gthstnml_list* (GTHST_NMLINFO_ENTRY ) , 
    !  *name* Ʊͤĥȥ˺Ʒ礷֤ޤ. 
    ! Ĥʤ϶֤֤ޤ.
    ! *gthstnml_list* Ϥᤫξˤ϶֤֤ޤ. 
    ! 
    ! *previous* Ϳ, ȥΰ
    ! ȥ˷礷ޤ. Υȥ̵꤬ˤ
    ! ֤֤ޤ. 
    !
    ! *next* Ϳ, ȥΰĸ
    ! ȥ˷礷ޤ. Υȥ̵꤬ˤ
    ! ֤֤ޤ. 
    ! 
    ! *gthstnml_list* (type "GTHST_NMLINFO_ENTRY") that is a list structure 
    ! is recieved, and *gthstnml_list* is reassociated to 
    ! the entry that has a value that is same as argument *name*, 
    ! and returned. 
    ! If the entry is not found, null is returned. 
    ! If *gthstnml_list* is null from the beginning, null is returned. 
    !
    ! If *previous* is given, an entry previous to the above entry
    ! is associated. If previous entries are not found, 
    ! null is returned.
    !
    ! If *next* is given, an entry next to the above entry
    ! is associated. If next entries are not found, 
    ! null is returned.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_error, only: StoreError, DC_NOERR
    implicit none
    type(GTHST_NMLINFO_ENTRY), pointer:: gthstnml_list
                              ! (inout)
    character(*), intent(in):: name
                              ! ѿ̾. 
                              ! Ƭζ̵뤵ޤ. 
                              ! 
                              ! Variable identifier. 
                              ! Blanks at the head of the name are ignored. 
    type(GTHST_NMLINFO_ENTRY), pointer, optional:: previous
                              ! (out)
    type(GTHST_NMLINFO_ENTRY), pointer, optional:: next
                              ! (out)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoListSearch'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  ֤ξϲ⤷ʤ֤
    !  If null, return without change
    !-----------------------------------------------------------------
    if ( .not. associated( gthstnml_list ) ) goto 999

    !-----------------------------------------------------------------
    !   *name* Ʊ *name* ĥȥõ
    !  The entry that has *name* that is same as argument *name* is searched
    !-----------------------------------------------------------------
    if ( present( previous ) ) nullify( previous )
    if ( present( next ) ) nullify( next )
    if ( trim( adjustl( gthstnml_list % name ) ) == trim( adjustl( name ) ) ) then
      if ( present( next ) ) then
        next => gthstnml_list % next
      end if
      goto 999
    end if

    do while ( associated( gthstnml_list ) )
      if ( present( previous ) ) previous => gthstnml_list
      call ListNext( gthstnml_list = gthstnml_list ) ! (inout)
      if ( .not. associated( gthstnml_list ) ) goto 999
      if ( trim( adjustl( gthstnml_list % name ) ) == trim( adjustl( name ) ) ) then
        if ( present( next ) ) then
          next => gthstnml_list % next
        end if
        goto 999
      end if
    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine HstNmlInfoListSearch

!!$  subroutine HstNmlInfoSample( gthstnml, err )
!!$    !--
!!$    ! HstNmlInfoSample 򵭽ҤƤ. 
!!$    !++
!!$    ! ʤ, Ϳ줿 *gthstnml*  HstNmlInfoCreate ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ. 
!!$    !--
!!$    ! Describe brief of "HstNmlInfoSample". 
!!$    !++
!!$    ! If *gthstnml* is not initialized by "HstNmlInfoCreate" yet, 
!!$    ! error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
!!$    use dc_types, only: DP, STRING, TOKEN, STDOUT
!!$    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
!!$    implicit none
!!$    type(GTHST_NMLINFO), intent(inout):: gthstnml
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰. 
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ. 
!!$                              !  *err* Ϳ, 
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ. 
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$
!!$    !-----------------------------------
!!$    !  *gthstnml* Ф
!!$    !  Setting values fetched from *gthstnml*
!!$!!$    real(DP):: CoefAlpha      ! $ \alpha $ . . Coefficient
!!$!!$    real(DP):: DelTime        ! $ \Delta t $ . ॹƥå. Time step
!!$
!!$    !-----------------------------------
!!$    !  ѿ
!!$    !  Work variables
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'HstNmlInfoSample'
!!$  continue
!!$    call BeginSub( subname )
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if ( .not. gthstnml % initialized ) then
!!$      stat = DC_ENOTINIT
!!$      cause_c = 'GTHST_NMLINFO'
!!$      goto 999
!!$    end if
!!$
!!$    !-----------------------------------------------------------------
!!$    !  *gthstnml* ˳ǼƤͤμФ
!!$    !  Fetch setting values stored in *gthstnml*
!!$    !-----------------------------------------------------------------
!!$!!$    CoefAlpha = gthstnml % CoefAlpha
!!$!!$    DelTime   = gthstnml % DelTime
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError( stat, subname, err, cause_c )
!!$    call EndSub( subname )
!!$  end subroutine HstNmlInfoSample

end module gtool_history_nmlinfo
