! ǥ󥰥ե뤫뤿Υ֥롼
!
! Authors::   SUGIYAMA Koichiro, ODAKA Masatsugu
! Version::   $Id: initialdata_sounding.f90,v 1.8 2014/07/08 00:59:09 sugiyama Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!

module initialdata_sounding
  !
  ! ǥ󥰥ե뤫뤿Υ֥롼
  ! ǥ󥰥եϥƥȥեǽ񤫤Ƥ. 
  ! Ūˤ netCDF ѹͽ.
  !

  !⥸塼ɤ߹
  use dc_types,    only: STRING, DP
  use dc_iounit,   only : FileOpen      
  use dc_message,  only: MessageNotify
  use mpi_wrapper, only: myrank         
  use namelist_util, only: namelist_filename
  use gridset,  only: imin,       &! X β
    &                 imax,       &! X ξ
    &                 jmin,       &! Y β
    &                 jmax,       &! Y ξ
    &                 kmin,       &! Z β
    &                 kmax,       &! Z ξ
    &                 nz           !ʻֳ
  use axesset, only:  r_Z, z_Z, dz     !
  use constants, only : Grav, TempSfc, gasrdry, CpDry
 
  !ۤηػ
  implicit none

  !ǥեȤ private
  private

  real(DP), save :: r_tmpAlt(10000)
  real(DP), save :: r_tmpTemp(10000)
  real(DP), save :: r_tmpPress(10000)
  real(DP), save :: r_tmpPTemp(10000)
  real(DP), save :: r_tmpVelX(10000)
  real(DP), save :: r_tmpVelY(10000)
  real(DP), save :: r_tmpQrad(10000)
  real(DP), save :: AltTr  = 0.0d0
  real(DP), save :: DelAlt = 4.0d3
  integer,  save :: NumRec = 0

  !
  public  initialdata_sounding_init
  public  initialdata_sounding_basic
  public  initialdata_sounding_wind

contains

!!!------------------------------------------------------------------------------!!!
  subroutine initialdata_sounding_init
    !
    !ե뤫ϥե˵ܤɤ߹
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    integer             :: AltCol = 0
    integer             :: TempCol = 0
    integer             :: PressCol = 0
    integer             :: VelXCol = 0
    integer             :: VelYCol = 0
    integer             :: unit     !եֹ  
    integer             :: io
    character(30)       :: SoundingFile    
    
    integer, parameter  :: maxch=12
    character(len=100)  :: buf, eachcol(maxch)
    integer             :: num, MaxCol
    
    !ե뤫ɤ߹ϥե
    !
    NAMELIST /initialdata_sounding_nml/ SoundingFile, AltCol, TempCol, PressCol, VelXCol, VelYCol, AltTr, DelAlt
    
    !ե뤫ϥե˵ܤɤ߹
    !
    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=initialdata_sounding_nml)
    close(unit)

!    write(*,*) SoundingFile, AltCol, TempCol, PressCol

    ! 
    !
    io = 0
    NumRec = 0
    MaxCol = max( AltCol, max( TempCol, PressCol ) )
!    write(*,*) "MaxCol", MaxCol
    r_tmpAlt  = 0.0d0; r_tmpTemp = 0.0d0; r_tmpPress = 0.0d0; 
    r_tmpVelX = 0.0d0; r_tmpVelY = 0.0d0

    ! եΥץ
    !
    open (17, file=SoundingFile, status='old')
    
    ! եƤӽФ
    !
    do while ( io == 0 ) 
      ! 1 ʬɤ߽Ф
      !
      read (17, '(a)', IOSTAT=io) buf
      
      ! Ԥ򥫥޶ڤʬ
      !
      call devidecsv( buf, eachcol, maxch, num )
      
      ! ǧ
      !
!      write(*,*) num
!      do i=1, num
!        write(*,*) i, eachcol(i)(1:len_trim(eachcol(i)))
!      end do

      ! num ͤΤϥإåȤߤʤ. 
      !
      if (num >= MaxCol) then 
        ! Կη׻
        !
        NumRec = NumRec + 1        

        ! ͤ
        !
        if (AltCol > 0)   read( eachcol(AltCol)(1:len_trim(eachcol(AltCol))), *)    r_tmpAlt(NumRec) 
        if (TempCol > 0)  read( eachcol(TempCol)(1:len_trim(eachcol(TempCol))), *)   r_tmpTemp(NumRec)   
        if (PressCol > 0) read( eachcol(PressCol)(1:len_trim(eachcol(PressCol))), *) r_tmpPress(NumRec) 
        if (VelXCol > 0)  read( eachcol(VelXCol)(1:len_trim(eachcol(VelXCol))), *)   r_tmpVelX(NumRec)   
        if (VelYCol > 0)  read( eachcol(VelYCol)(1:len_trim(eachcol(VelYCol))), *)   r_tmpVelY(NumRec) 

      end if

    end do

    ! ǧ
    !
!    write(*,*) z_tmpAlt(1:NumRec)

    ! եΥ
    !
    close (17)    

  end subroutine initialdata_sounding_init


!!!------------------------------------------------------------------------------!!!
  subroutine  initialdata_sounding_basic( z_Temp, z_Press )
    !
    !
    
    implicit none

    real(DP), intent(out):: z_Press(kmin:kmax)           !
    real(DP), intent(out):: z_Temp(kmin:kmax)            !
    real(DP)             :: r_Press(kmin:kmax)           !
    real(DP)             :: r_Temp(kmin:kmax)            !

    real(DP)             :: z_DTempDZ(kmin:kmax)
    real(DP)             :: DTempDZ

    integer              :: i, k, k1, k2
    logical              :: flag

    ! 
    !
    z_Temp  = 0.0d0
    r_Temp  = 0.0d0
    z_Press = 0.0d0
    r_Press = 0.0d0

    flag = .false. 

    ! ǡɤ߹
    !    
    do k = kmin, kmax
      do i = 1, NumRec
        if ( r_Z(k) == r_tmpAlt(i) ) then 
          r_Temp(k) = r_tmpTemp(i)
          r_Press(k) = r_tmpPress(i)
        end if
      end do
    end do

    ! ǡɤ߹  
    ! ޤȾʻҤ˹礦⤢Τ, ξϥǡͥ. 
    !    
    do k = kmin, kmax
      do i = 1, NumRec
        if ( z_Z(k) == r_tmpAlt(i) ) then 
          flag = .true. 
          z_Temp(k) = r_tmpTemp(i)
          z_Press(k) = r_tmpPress(i)
        end if
      end do
    end do
    
    ! r => z Ѵ
    ! 
    if (.NOT. flag) then 
      do k = kmin+1, kmax
        z_Temp(k)  = ( r_Temp(k-1)  + r_Temp(k)  ) / 2.0d0
        z_Press(k) = ( r_Press(k-1) + r_Press(k) ) / 2.0d0
      end do
    end if

    ! ǧ
    !
!    do k = kmin, kmax
!      write(*,*) z_z(k), z_Temp(k), z_Press(k)
!   end do

   
!!!
!!! ̤¸ߤˤ, Ǥβٸۤˤ䤫ˤ.
!!!
    if ( AltTr > z_Z(1) .AND. AltTr < z_Z(nz) ) then

      ! ߤβʬۤθۤ
      !
      do k = 1, kmax
        z_DTempDZ(k) = (z_Temp(k) - z_Temp(k-1)) / dz
      end do
      
      ! ή̤ΰ. ꤵ줿٤βٸΨȤ³. 
      !
      k1 = minloc( z_Z, 1, z_Z > AltTr ) 
      
      ! ٸΨ
      !
      DTempDZ = z_DTempDZ(k1-1)
      k2 = int( DelAlt / dz )    !Ѵ
      
      do k = k1, kmax
        
        ! ٸΨ򥼥˶Ť. 
        !
        DTempDZ = min( -1.0d-14, DTempDZ - DTempDZ / k2 * ( k - k1 ) )
        
        !ܾβ٤
        z_Temp(k) = z_Temp(k-1) + DTempDZ * dz
        
        !Ϥſ尵ʿդ׻
        z_Press(k) =                                      &
          &  z_Press(k-1) * ( ( z_Temp(k-1) / z_Temp(k) ) &
          &    ** (Grav / ( DTempDZ * GasRDry ) ) )
        
      end do

    end if

  end subroutine Initialdata_sounding_basic


  subroutine initialdata_sounding_wind(pyz_VelX, xqz_VelY)

    implicit none

    real(DP), intent(out) :: pyz_VelX(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xqz_VelY(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)              :: pyr_VelX(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)              :: xqr_VelY(imin:imax,jmin:jmax,kmin:kmax)
    integer               :: i, k
    logical               :: flag
    
    !
    pyz_VelX = 0.0d0
    pyr_VelX = 0.0d0
    xqz_VelY = 0.0d0
    xqr_VelY = 0.0d0

    flag = .false. 

    ! ǡɤ߹  
    !        
    do k = kmin, kmax
      do i = 1, NumRec
        if ( r_Z(k) == r_tmpAlt(i) ) then 
          pyr_VelX(:,:,k) = r_tmpVelX(i)
          xqr_VelY(:,:,k) = r_tmpVelY(i)
        end if
      end do
    end do

    ! ǡɤ߹  
    ! ޤȾʻҤ˹礦⤢Τ, ξϥǡͥ. 
    !        
    do k = kmin, kmax
      do i = 1, NumRec
        if ( z_Z(k) == r_tmpAlt(i) ) then 
          flag = .true. 
          pyz_VelX(:,:,k) = r_tmpVelX(i)
          xqz_VelY(:,:,k) = r_tmpVelY(i)
        end if
      end do
    end do

    ! r => z Ѵ
    ! 
    if (.NOT. flag) then 
      do k = kmin+1, kmax
        pyz_VelX(:,:,k) = ( pyr_VelX(:,:,k-1) + pyr_VelX(:,:,k) ) * 5.0d-1
        xqz_VelY(:,:,k) = ( xqr_VelY(:,:,k-1) + xqr_VelY(:,:,k) ) * 5.0d-1
      end do
    end if

    ! ǧ
    !
!    do k = kmin, kmax
!      write(*,*) z_z(k), pyz_VelX(1,1,k), xqz_VelY(1,1,k)
!    end do
    
  end subroutine initialdata_sounding_wind
  

  subroutine devidecsv( buf, eachcol, maxch, num )
    implicit none
    integer   :: maxch, num
    character(len=*) :: buf, eachcol(maxch)
    integer :: i, j, prev, now, now1, ll
    logical :: quote
    
    quote = .FALSE.
    
    ll = len_trim(buf)
    prev=0; now=1; i=1
    do j=1, ll
      if( buf(j:j) == '"' ) then
        quote = .NOT. quote
      end if
      if( quote .eqv. .FALSE. ) then
        if(buf(j:j) == ',') then
          now = j
          now1 = now -1
          if( now1 < prev+1 ) then
            eachcol(i) = ''
          else
            eachcol(i) = buf(prev+1:now1)
          end if
          i=i+1
          if( i > maxch ) then
            write(0,*) 'maxch is too small'
            stop
          end if
          prev=now
        end if
      end if
    end do
    
    if( prev < ll ) then
      eachcol(i) =  buf(prev+1:ll)
      num = i
    else
      num=i-1
    end if
    
  end subroutine devidecsv

end module initialdata_sounding
