!= Module initialdata_Odaka2001
!
! Authors::   MURAHASHI Kuriki
! Version::   $Id: initialdata_odaka2001.f90,v 1.0 2015-12-11 04:49:40 mkuriki Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]

module initialdata_odaka2001
  !
  ! Odaka et al. (2001) ѤƽͤͿ(mkuriki)
  ! gtool5 Ϣ 
  ! gtool5 modules
  !
  ! gtool  nc ǡɤ߹Ѥδؿɲ (mkuriki)
  use gtool_history, only: HistoryGet

  !⥸塼ɤ߹
  use dc_types,   only: STRING, DP
  use dc_iounit,   only : FileOpen      
  use dc_message, only: MessageNotify
!  use mpi_wrapper, only: myrank         
  use gridset,  only: kmin,       &! Z β
    &                 kmax,       &! Z ξ
    &                 nz
  use axesset, only:  z_Z,        &!顼ʻǤι
    &                 z_dz         !Z γʻֳ
  use constants, only: &
    &                 GasRDry,       &!ʬ갵Ǯ
    &                 CpDry,         &!ʬ갵Ǯ
    &                 Grav,          &!ϲ®
    &                 TempSfc,       &!ɽ̲
    &                 PressSfc        !ɽ̰
 
  !ۤηػ
  implicit none

  !ǥեȤ private
  private

  real(DP), parameter  :: AntA    = 27.4d0 
  real(DP), parameter  :: AntB    = 3103.0d0
  real(DP), parameter  :: TempLTP = 135.0d0
  real(DP), parameter  :: Dhight  = 6.0d2

  !
  public  initialdata_odaka2001_basic

contains

!!!------------------------------------------------------------------------------!!!

  subroutine initialdata_odaka2001_basic( z_Temp, z_Press )

    implicit none
    
    real(DP), intent(out):: z_Press(kmin:kmax)           !
    real(DP), intent(out):: z_Temp(kmin:kmax)            !
    integer              :: k
    real(DP)             :: srcProf(1:205) ! ǡɤ߹
    

    ! ncSrc/vprof.nc 굤αľʬۤɤ߹
    !
    call HistoryGet('ncSrc/vprof.nc', 'temp', srcProf, range='t=30') 
    do k = 1, nz
      z_Temp(k) = srcProf(k + 5)
    end do

    z_Press(1) = PressSfc - (Grav * PressSfc * z_dz(1) * 5.0d-1) / (GasRDry * TempSfc)
    ! ſ尵ʿդ鰵Ϥ
    !
    do k = 2, nz
      z_Press(k) = z_Press(k-1) - (Grav * z_Press(k-1) * z_dz(k-1)) &
        & / ( GasRDry * z_Temp(k-1) )
    end do

  end subroutine initialdata_odaka2001_basic
  
end module initialdata_odaka2001
