!= Module acousticmode_std
!
! Authors::   ̰ϯ(SUGIYAMA Ko-ichiro)
! Version::   $Id: acousticmode_std.f90,v 1.4 2015/02/19 02:17:22 sugiyama Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2014. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]

module acousticmode_std
  !
  ! ȥ⡼ɤ˴ؤ׻롼«ͤ⥸塼
  !
  !   ʿ explicit
  !   ľ implicit
  !
  ! ʬʿѥ⥸塼ѤƷ׻Ԥ

  !⥸塼ɤ߹
  !
  use dc_types,   only : DP

  !ۤηػ
  !
  implicit none

  !°λ
  !
  private

  ! ѿ
  !
  real(DP), save :: beta  = 0.5d0         !󥯥˥륽ˡʤ 0.5
!  real(DP), save :: beta  = 1.0d0         !󥯥˥륽ˡʤ 0.5
                                          !ˡʤ 1

  real(DP), save :: AlphaH = 0.0d0        !ȸθ그 (ʿ)
  real(DP), save :: AlphaV = 0.0d0        !ȸθ그 (ľ)

  real(DP), allocatable, save :: A(:)     !гʬ
  real(DP), allocatable, save :: B(:)     !ξ廰ʬ
  real(DP), allocatable, save :: C(:)     !βʬ
  real(DP), allocatable, save :: AL1(:)   !LU ʬη L (1 )
  integer,  allocatable, save :: IP(:)    !ʬԥܥåȸ򴹤ξǼ

  real(DP), allocatable, save :: xyr_CpVPTempBZ(:,:,:)       !η׻Ѥ
  real(DP), allocatable, save :: xyr_CpDensVPTempSQBZ(:,:,:) !η׻Ѥ
  real(DP), allocatable, save :: xyr_DensVPTempBZ(:,:,:)     !η׻Ѥ
  real(DP), allocatable, save :: xyz_VelSoundSQBZ(:,:,:)     !η׻Ѥ
  real(DP), allocatable, save :: xyz_CpDensVPTempSQBZ(:,:,:) !η׻Ѥ

  character(*), parameter:: module_name = 'acousticmode_std'
                                                  ! ⥸塼̾.
                                                  ! Module name
  ! public 
  !
  public acousticmode_std_init
  public acousticmode_std_exp
  public acousticmode_std_imp
  
contains

  subroutine acousticmode_std_exp(                   &
    & pyz_VelXN, xqz_VelYN, xyr_VelZN, xyz_ExnerN,   & !(IN)
    & xyz_VelDivN,                                   & !(OUT)
    & pyz_PGrad, pyz_SWF,                            & !(OUT)
    & xqz_PGrad, xqz_SWF                             & !(OUT)
    & )
    
    ! ⥸塼ƤӽФ
    !
    use gridset,   only : imin,            &! x β
      &                   imax,            &! x ξ
      &                   jmin,            &! y β
      &                   jmax,            &! y ξ
      &                   kmin,            &! z β
      &                   kmax,            &! z ξ
      &                   nx, ny, nz
    use constants, only : CpDry             ! ʬǮ
    use basicset,  only : pyz_VPTempBZ,    &! ܾβ
                          xqz_VPTempBZ      ! ܾβ
    use axesset,   only : pyz_xyz, xqz_xyz
    use xyz_deriv_module, &
      &            only : xyz_dx_pyz, xyz_dy_xqz, xyz_dz_xyr, &
      &                   pyz_dx_xyz, xqz_dy_xyz

    ! ۤηػ
    !
    implicit none
    
    ! ѿ
    !
    real(DP), intent(in)  :: pyz_VelXN(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)  :: xqz_VelYN(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)  :: xyr_VelZN(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)  :: xyz_ExnerN(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: xyz_VelDivN(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(out) :: pyz_PGrad(1:nx,1:ny,1:nz)
    real(DP), intent(out) :: xqz_PGrad(1:nx,1:ny,1:nz)
    real(DP), intent(out) :: pyz_SWF(1:nx,1:ny,1:nz)
    real(DP), intent(out) :: xqz_SWF(1:nx,1:ny,1:nz)

    real(DP)              :: aaa_tmp(imin:imax,jmin:jmax,kmin:kmax)

    !------------------------------------------------------------------
    ! ®٤μ«׻
    !
    xyz_VelDivN =                 &
      &   xyz_dx_pyz( pyz_VelXN ) &
      & + xyz_dy_xqz( xqz_VelYN ) &
      & + xyz_dz_xyr( xyr_VelZN )

    !------------------------------------------------------------------
    ! X 

    aaa_tmp   = + AlphaH * pyz_dx_xyz( xyz_VelDivN )     
    pyz_SWF   =   aaa_tmp(1:nx,1:ny,1:nz)

    aaa_tmp   = - CpDry * pyz_VPTempBZ * pyz_dx_xyz( xyz_ExnerN ) 
    pyz_PGrad =   aaa_tmp(1:nx,1:ny,1:nz)

    !------------------------------------------------------------------
    ! Y 
    
    aaa_tmp   =   AlphaH * xqz_dy_xyz( xyz_VelDivN ) 
    xqz_SWF   =   aaa_tmp(1:nx,1:ny,1:nz)

    aaa_tmp   = - CpDry * xqz_VPTempBZ * xqz_dy_xyz( xyz_ExnerN ) 
    xqz_PGrad =   aaa_tmp(1:nx,1:ny,1:nz)

  end subroutine Acousticmode_std_exp

!!!------------------------------------------------------------!!!

  subroutine acousticmode_std_imp(                   &
    & pyz_VelXA, xqz_VelYA, xyr_VelZN, xyz_VelDivN,  & !(IN)
    & xyz_ExnerN,                                    & !(IN)
    & xyr_DVelZDtNl, xyz_DExnerDtNl, xyz_DExnerDtNs, & !(IN)
    & xyz_ExnerA,                                    & !(OUT)
    & xyr_PGrad, xyr_SWF                             & !(OUT)
    & )
    !
    ! ˡѤʡؿ/ľ®٤η׻. 
    !
    
    ! ⥸塼ɤ߹
    !
    use dc_types, only : DP
    use gridset,  only : imin,            &! x β
      &                  imax,            &! x ξ
      &                  jmin,            &! y β
      &                  jmax,            &! y ξ
      &                  kmin,            &! z β
      &                  kmax,            &! z ξ
      &                  nx, ny, nz,      &! ʪΰ礭
      &                  nxny              ! ʪΰ礭 (nx * ny)
    use constants,only : CpDry             ! ʬǮ
    use timeset,  only : DelTimeShort
    use basicset, only : xyz_VPTempBZ,    &!ܾβ
                         xyr_VPTempBZ      !ܾβ
    use axesset,  only : dz, xyr_xyz
    use xyz_deriv_module, &
      &           only : xyr_dz_xyz, xyz_dz_xyr, xyz_dx_pyz, xyz_dy_xqz

    ! ۤηػ
    !
    implicit none

    ! ѿ
    !
    real(DP), intent(in)   :: pyz_VelXA(imin:imax,jmin:jmax,kmin:kmax) 
                                                           !® u [+]
    real(DP), intent(in)   :: xqz_VelYA(imin:imax,jmin:jmax,kmin:kmax) 
                                                           !® v [+]
    real(DP), intent(in)   :: xyr_VelZN(imin:imax,jmin:jmax,kmin:kmax) 
                                                           !® w []
    real(DP), intent(in)   :: xyz_VelDivN(imin:imax,jmin:jmax,kmin:kmax)
                                                           !\Div \Dvect{u}
    real(DP), intent(in)   :: xyz_ExnerN(imin:imax,jmin:jmax,kmin:kmax) 
                                                           !̵
    real(DP), intent(in)   :: xyr_DVelZDtNl(imin:imax,jmin:jmax,kmin:kmax) 
                                                           !Z γϹ[t]
    real(DP), intent(in)   :: xyz_DExnerDtNl(imin:imax,jmin:jmax,kmin:kmax) 
                                                           !ʡؿγϹ[t]
    real(DP), intent(in)   :: xyz_DExnerDtNs(imin:imax,jmin:jmax,kmin:kmax) 
                                                           !ʡؿγϹ[t]
    real(DP), intent(out)  :: xyz_ExnerA(imin:imax,jmin:jmax,kmin:kmax) 
                                                           !̵[+]
    real(DP), intent(out)  :: xyr_PGrad(1:nx,1:ny,1:nz)
    real(DP), intent(out)  :: xyr_SWF(1:nx,1:ny,1:nz)
    
    ! ѿ
    !
    real(DP)               :: D(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP)               :: E(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP)               :: F(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP)               :: F0(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP)               :: xyr_DExnerDz(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP)               :: xyr_DVelDivDz(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP)               :: aaa_tmp(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP)               :: dt            ! ûֳʻҴֳ
    integer                :: INFO          ! Υǥ
    integer                :: i, j, k
      
    real(DP)               :: TX(nz,nxny)    !ž֤
    character(1),parameter :: TRANS = 'N'
    

    !---------------------------------------------------------------
    ! Initialize
    !
    xyz_ExnerA = 0.0d0
    dt = DelTimeShort

    !---------------------------------------------------------------
    !׻Τη
    
    ! ̤Ƹʬ˷׻ 
    !
    xyr_DExnerDZ =  xyr_dz_xyz( xyz_ExnerN ) 
    
    xyr_DVelDivDZ = xyr_dz_xyz( xyz_VelDivN )
    
    E =                                      &
      & - ( 1.0d0 - beta ) * xyr_DExnerDZ    &
      & + (                                  &
      &     AlphaV * xyr_DVelDivDZ           &
      &   + xyr_DVelZDtNl                    &
      &   )                                  &
      &   / xyr_CpVPTempBZ
    
    F0  =                                                            &
      & + xyr_DensVPTempBZ                                           &
      &   * (                                                        &
      &     + xyr_VelZN                                              &  
      &     - xyr_CpVPTempBZ * ( 1.0d0 - beta) * xyr_DExnerDZ * dt   &
      &     + AlphaV * xyr_DVelDivDZ  * dt                           &
      &     + xyr_DVelZDtNl  * dt                                    &
      &    )
    
    F =                                  &
      & - beta * dt                      &
      &   * xyz_VelSoundSQBZ             &  
      &   / xyz_CpDensVPTempSQBZ         &  
      &   * xyz_dz_xyr( F0 )             &
      & + xyz_DExnerDtNl * dt            &
      & + xyz_DExnerDtNs * dt
    
    D =                                                           &
      & + xyz_ExnerN                                              &
      & - (1.0d0 - beta) * dt                                     &
      &   * xyz_VelSoundSQBZ                                      &  
      &   / xyz_CpDensVPTempSQBZ                                  &  
      &   * xyz_dz_xyr( xyr_DensVPTempBZ * xyr_VelZN )            &
      & - xyz_VelSoundSQBZ * dt                                   &
      &   / (CpDry * xyz_VPTempBZ )                               &
      &   * ( xyz_dx_pyz( pyz_VelXA ) + xyz_dy_xqz( xqz_VelYA ) ) &
      & + F
    
    D(:,:,1) =                                     &
      & + D(:,:,1)                                 &
      & - beta * (dt * dt)                         &
      &   * xyz_VelSoundSQBZ(:,:,1)                &  
      &   / xyz_CpDensVPTempSQBZ(:,:,1)            &  
      &   * xyr_CpDensVPTempSQBZ(:,:,0)            &
      &   * E(:,:,0)                               &
      &   / dz
    
    D(:,:,nz) =                                    &
      & + D(:,:,nz)                                &
      & + beta * (dt * dt)                         &
      &   * xyz_VelSoundSQBZ(:,:,nz)               &  
      &   / xyz_CpDensVPTempSQBZ(:,:,nz)           &  
      &   * xyr_CpDensVPTempSQBZ(:,:,nz)           &
      &   * E(:,:,nz)                              &
      &   / dz

    
    !-----------------------------------------------------------
    !ϢΩ켡β
    
    ! LAPACK λͤ˹碌ѷ 
    !
    do k = 1, nz
      do j = 1, ny
        do i = 1, nx
          TX(k, i + nx * (j - 1)) = D(i,j,k)
        end do
      end do
    end do
    
    !η׻. LAPACK . 
    !
    call DGTTRS(TRANS, nz, nxny, C, A, B, AL1, IP, TX, nz, INFO)
    
!    !Υǥå. 
!    !
!    if (INFO /= 0) then
!      call MessageNotify("Error", "lapack_linear", "INFO is not 0")
!      stop
!    end if

    do k = 1, nz
      do j = 1, ny
        do i = 1, nx
          xyz_ExnerA(i,j,k) = TX(k, i + nx * (j - 1 ))
        end do
      end do
    end do
    
!!    ! z ζͿ. ľ®٤ݤʬ뤿. 
!!    !
!!    xyz_ExnerA(:,:,nz+1) = xyz_ExnerA(:,:,nz) 

    !------------------------------------------------------------
    ! ľ®
    !
    aaa_tmp =  AlphaV * xyr_dz_xyz( xyz_VelDivN ) 
    xyr_SWF =  aaa_tmp(1:nx,1:ny,1:nz)
    
    aaa_tmp =                                               &
      & - CpDry * xyr_VPTempBZ                              &
      &   * (                                               &
      &         beta           * xyr_dz_xyz( xyz_ExnerA )   &
      &       + (1.0d0 - beta) * xyr_dz_xyz( xyz_ExnerN )   &
      &     )                                                
    xyr_PGrad =  aaa_tmp(1:nx,1:ny,1:nz)
    
  end subroutine Acousticmode_std_imp
  

!!!--------------------------------------------------------------------!!!
  subroutine acousticmode_std_init( AlphaSound )
    !
    !ʡؿ򱢲ˡǲ򤯺ݤɬפȤʤ, Ǥ, 
    !LU ʬԤ. 
    !
    
    ! ⥸塼ɤ߹
    !
    use dc_types,   only : DP
    use dc_message, only : MessageNotify
    use mpi_wrapper,only : myrank
    use gridset,    only : imin, imax,      &!
      &                    jmin, jmax,      &
      &                    kmin, kmax,      &
      &                    nx,              &! x ʪΰξ
      &                    ny,              &! x ʪΰξ
      &                    nz                ! y ʪΰξ
    use constants,  only : CpDry           ! ʬǮ
    use timeset,    only : DelTimeShort
    use axesset,    only : dx, dy, dz        ! ʻҴֳ
    use basicset,   only : xyz_VelSoundBZ,  &!ܾβ® 
      &                    xyz_DensBZ,      &!ܾ̩
      &                    xyz_VPTempBZ      !ܾβ
    use axesset,  only : xyr_xyz

    
    !ۤηػ
    !
    implicit none

    !ѿ
    !
    real(DP), intent(in) :: AlphaSound
    real(DP)             :: r_CpDensVPTempSQBZ(kmin:kmax)
    real(DP)             :: z_VelSoundSQBZ(kmin:kmax) 
    real(DP)             :: z_CpDensVPTempSQBZ(kmin:kmax) 
    real(DP)             :: dt      ! ûֳʻ
    integer              :: INFO    !Υǥå

    !----------------------------------------------------------------
    ! 

    ! ȸθ그
    ! 
    ! ģͽ̺ 49 p53 ˽, ʿȱľȤʬƹͤ. 
    !
!    AlphaH = AlphaSound * ( Min( dx * dx, dy * dy ) ) / DelTimeShort
    AlphaH = AlphaSound * ( Min( dx * dx, dy * dy, dz * dz ) ) / DelTimeShort
    AlphaV = AlphaSound * ( Min( dx * dx, dy * dy, dz * dz ) ) / DelTimeShort

    !-------------------------------------------------------------------
    ! 
    !
    if (myrank == 0) then 
      call MessageNotify( "M", module_name, "AlphaH = %f", d=(/AlphaH/) )
      call MessageNotify( "M", module_name, "AlphaV = %f", d=(/AlphaV/) )
    end if

    ! ѿ̾ĹΤ, ֤̾
    !
    dt = DelTimeShort

    ! γդ
    !
    allocate( A(1:nz) )
    allocate( B(2:nz) )
    allocate( C(1:nz-1) )
    allocate( xyz_VelSoundSQBZ(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyz_CpDensVPTempSQBZ(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyr_CpDensVPTempSQBZ(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyr_DensVPTempBZ(imin:imax,jmin:jmax,kmin:kmax) )
    allocate( xyr_CpVPTempBZ(imin:imax,jmin:jmax,kmin:kmax) )
   
    !----------------------------------------------------------------
    ! 󤪤Ӷ̤Ѥͤ
    !
    xyz_VelSoundSQBZ     = xyz_VelSoundBZ * xyz_VelSoundBZ 
    xyz_CpDensVPTempSQBZ = CpDry * xyz_DensBZ * xyz_VPTempBZ * xyz_VPTempBZ
    xyr_CpDensVPTempSQBZ = xyr_xyz( xyz_CpDensVPTempSQBZ )
    xyr_DensVPTempBZ     = xyr_xyz( xyz_DensBZ * xyz_VPTempBZ )
    xyr_CpVPTempBZ       = xyr_xyz( CpDry * xyz_VPTempBZ )

    ! ľΤߤѿˤĤƤ, ܾȤΤ, 
    ! nx, ny ͤɽ뤳ȤȤ. 
    !
    z_VelSoundSQBZ        = xyz_VelSoundSQBZ(nx,ny,:)
    z_CpDensVPTempSQBZ(:) = xyz_CpDensVPTempSQBZ(nx,ny,:)
    r_CpDensVPTempSQBZ(:) = xyr_CpDensVPTempSQBZ(nx,ny,:)

    !
    !
    A(2:nz-1) =                               &
      & + 1.0d0                               &
      & + ( beta * beta )                     &
      &    * z_VelSoundSQBZ(2:nz-1)           &
      &    / z_CpDensVPTempSQBZ(2:nz-1)       &
      &    * (                                &
      &         r_CpDensVPTempSQBZ(2:nz-1)    &
      &       + r_CpDensVPTempSQBZ(1:nz-2)    &
      &       )                               &
      &    * ( dt * dt )                      &
      &    / ( dz * dz )

    A(1) =                                    &
      & + 1.0d0                               &
      & + ( beta * beta )                     &
      &    * z_VelSoundSQBZ(1)                &
      &    / z_CpDensVPTempSQBZ(1)            &
      &   * r_CpDensVPTempSQBZ(1)             &
      &   * ( dt * dt )                       &
      &   / ( dz * dz ) 

    A(nz) =                                   &
      & + 1.0d0                               &
      & + ( beta * beta )                     &
      &    * z_VelSoundSQBZ(nz)               &
      &    / z_CpDensVPTempSQBZ(nz)           &
      &   * r_CpDensVPTempSQBZ(nz-1)          &
      &   * ( dt * dt )                       &
      &   / ( dz * dz )  

    B(2:nz) =                                 &
      & - ( beta * beta )                     &
      &    * z_VelSoundSQBZ(1:nz-1)           &
      &    / z_CpDensVPTempSQBZ(1:nz-1)       &
      &   * r_CpDensVPTempSQBZ(1:nz-1)        &
      &   * ( dt * dt )                       &
      &   / ( dz * dz )
    
    C(1:nz-1) =                               &
      & - ( beta * beta )                     &
      &    * z_VelSoundSQBZ(2:nz)             &
      &    / z_CpDensVPTempSQBZ(2:nz)         &
      &   * r_CpDensVPTempSQBZ(1:nz-1)        &
      &   * ( dt * dt )                       &
      &   / ( dz * dz )
  
    !----------------------------------------------------------------
    !  LU ʬ
    !

    ! γ
    !
    allocate( AL1(1:nz-2), IP(1:nz) )

    ! η׻. LAPACK . 
    !
    call DGTTRF(nz, C, A, B, AL1, IP, INFO)
    
    ! Υǥå. 
    !
    if (INFO /= 0) then
      call MessageNotify("Error", "lapack_linear", "INFO is not 0")
      stop
    end if

  end subroutine Acousticmode_std_init

end module Acousticmode_std
