!= Module Average
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: average.f90,v 1.4 2006/09/21 03:01:02 odakker Exp $ 
! Tag Name::  $Name: arare4-20061224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!ʪ̤ʿԤΰϢδؿޤȤ᤿ѥå⥸塼. 
!ʿ Arakawa-C, ľ Lorentz åɤȤ. 
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module average
  !
  !2 ٤ʿԤδؿ«ͤѥå⥸塼. 
  !ʿ Arakawa-C, ľ Lorentz åɤȤ. 
  !

  !⥸塼ɤ߹
  use gridset,    only: DimXMin,  &!  X β
    &                   DimXMax,  &!  X ξ
    &                   DimZMin,  &!  Z β
    &                   DimZMax    !  Z ξ
  
  !ۤηػ
  implicit none

  !°λ
  private

  !ؿ public ˤ
  public xz_avr_pz
  public xz_avr_xr
  public xz_avr_pr
  public pz_avr_xz
  public pz_avr_xr
  public pz_avr_pr
  public xr_avr_xz
  public xr_avr_pz
  public xr_avr_pr
  public pr_avr_xz
  public pr_avr_xr
  public pr_avr_pz

contains

!!!---------------------------------------------------------------------  
  function xz_avr_pz( pz_var ) 
    !
    ! z ȾʻҤ줿, x, z ȾʻҤ줿Ǥʿ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: pz_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿѱ黻оݤȤʤѿ
    real(8)              :: xz_avr_pz(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿ
    
    xz_avr_pz = pz_var    
    xz_avr_pz(DimXMin+1 : DimXMax, DimZMin : DimZMax) =          &
      &  (                                                       &
      &     pz_var(DimXMin+1 : DimXMax,   DimZMin : DimZMax)     &
      &   + pz_var(DimXMin   : DimXMax-1, DimZMin : DimZMax)     &
      &   ) * 5.0d-1

  end function xz_avr_pz
  

!!!---------------------------------------------------------------------    
  function xz_avr_xr( xr_var )
    !
    ! x ȾʻҤ줿, x, z ȾʻҤ줿Ǥʿ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: xr_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿѱ黻оݤȤʤѿ
    real(8)              :: xz_avr_xr(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿ
    
    xz_avr_xr = xr_var 
    xz_avr_xr(DimXMin : DimXMax, DimZMin+1 : DimZMax) =          &
      &  (                                                       &
      &     xr_var(DimXMin : DimXMax, DimZMin+1 : DimZMax   )    &
      &   + xr_var(DimXMin : DimXMax, DimZMin   : DimZMax-1 )    &
      &   ) * 5.0d-1

  end function xz_avr_xr
  
  
!!!---------------------------------------------------------------------  
  function xz_avr_pr( pr_var )
    !
    ! ʻҾ, x, z ȾʻҤ줿Ǥʿ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in)  :: pr_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿѱ黻оݤȤʤѿ
    real(8)              :: xz_avr_pr(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿ

    xz_avr_pr = pr_var
    xz_avr_pr(DimXMin+1 : DimXMax, DimZMin+1 : DimZMax) =           &
      &  (                                                          & 
      &     pr_var(DimXMin+1 : DimXMax,   DimZMin+1 : DimZMax   )   &
      &   + pr_var(DimXMin+1 : DimXMax,   DimZMin   : DimZMax-1 )   &
      &   + pr_var(DimXMin   : DimXMax-1, DimZMin+1 : DimZMax   )   &
      &   + pr_var(DimXMin   : DimXMax-1, DimZMin   : DimZMax-1 )   &
      &   ) * 2.5d-1

  end function xz_avr_pr
  

!!!---------------------------------------------------------------------  
  function pz_avr_xz( xz_var ) 
    !
    ! x, z ȾʻҤ줿, z ȾʻҤ줿Ǥʿ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: xz_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿѱ黻оݤȤʤѿ
    real(8)              :: pz_avr_xz(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿ
    
    pz_avr_xz = xz_var
    pz_avr_xz(DimXMin : DimXMax-1, DimZMin : DimZMax) =         &
      &  (                                                      &
      &     xz_var(DimXMin+1 : DimXMax   , DimZMin : DimZMax)   &
      &   + xz_var(DimXMin   : DimXMax-1 , DimZMin : DimZMax)   &
      &   ) * 5.0d-1

  end function pz_avr_xz


!!!---------------------------------------------------------------------  
  function pz_avr_xr( xr_var ) 
    !
    ! x ȾʻҤ줿, z ȾʻҤ줿Ǥʿ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: xr_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿѱ黻оݤȤʤѿ
    real(8)              :: pz_avr_xr(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿ    

    pz_avr_xr = xr_var
    pz_avr_xr(DimXMin : DimXMax-1, DimZMin+1 : DimZMax) =         &
      &  (                                                        &
      &     xr_var(DimXMin+1 : DimXMax,   DimZMin+1 : DimZMax  )  &
      &   + xr_var(DimXMin+1 : DimXMax,   DimZMin   : DimZMax-1)  &
      &   + xr_var(DimXMin   : DimXMax-1, DimZMin+1 : DimZMax  )  &
      &   + xr_var(DimXMin   : DimXMax-1, DimZMin   : DimZMax-1)  &
      &   ) * 2.5d-1

  end function pz_avr_xr
  

!!!---------------------------------------------------------------------  
  function pz_avr_pr( pr_var ) 
    !
    ! ʻҾ, z ȾʻҤ줿Ǥʿ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: pr_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿѱ黻оݤȤʤѿ
    real(8)              :: pz_avr_pr(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿ    

    pz_avr_pr = pr_var
    pz_avr_pr(DimXMin : DimXMax, DimZMin+1 : DimZMax) =       &
      &  (                                                    &
      &     pr_var(DimXMin : DimXMax, DimZMin+1 : DimZMax  )  &
      &   + pr_var(DimXMin : DimXMax, DimZMin   : DimZMax-1)  &
      &   ) * 5.0d-1

  end function pz_avr_pr

  
!!!---------------------------------------------------------------------    
  function xr_avr_xz( xz_var ) 
    !
    ! x, z ȾʻҤ줿, x ȾʻҤ줿Ǥʿ
    !

  !⥸塼ɤ߹
  use gridset,    only: DimXMin,  &!  X β
    &                   DimXMax,  &!  X ξ
    &                   DimZMin,  &!  Z β
    &                   DimZMax    !  Z ξ
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: xz_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿѱ黻оݤȤʤѿ
    real(8)              :: xr_avr_xz(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿ    

    xr_avr_xz = xz_var
    xr_avr_xz(DimXMin : DimXMax, DimZMin : DimZMax-1) =          &
      &  (                                                       &
      &     xz_var( DimXMin : DimXMax, DimZMin+1 :DimZMax   )    &
      &   + xz_var( DimXMin : DimXMax, DimZMin   :DimZMax-1 )    &
      &   ) * 5.0d-1

  end function xr_avr_xz

  
!!!---------------------------------------------------------------------  
  function xr_avr_pz( pz_var ) 
    !
    ! z ȾʻҤ줿, x ȾʻҤ줿Ǥʿ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: pz_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿѱ黻оݤȤʤѿ
    real(8)              :: xr_avr_pz(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿ
    
    xr_avr_pz = pz_var
    xr_avr_pz(DimXMin+1 : DimXMax, DimZMin : DimZMax-1 ) =       &
      &  (                                                       &
      &     pz_var(DimXMin+1 :DimXMax,   DimZMin+1 : DimZMax  )  &
      &   + pz_var(DimXMin+1 :DimXMax,   DimZMin   : DimZMax-1)  &
      &   + pz_var(DimXMin   :DimXMax-1, DimZMin+1 : DimZMax  )  &
      &   + pz_var(DimXMin   :DimXMax-1, DimZMin   : DimZMax-1)  &
      &  ) * 2.5d-1

  end function xr_avr_pz


!!!---------------------------------------------------------------------  
  function xr_avr_pr( pr_var ) 
    !
    ! ʻҾ, x ȾʻҤ줿Ǥʿ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: pr_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿѱ黻оݤȤʤѿ
    real(8)              :: xr_avr_pr(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿ    

    xr_avr_pr = pr_var
    xr_avr_pr(DimXMin+1 : DimXMax, DimZMin : DimZMax) =       &
      &  (                                                    &
      &     pr_var(DimXMin+1 : DimXMax,   DimZMin : DimZMax)  &
      &   + pr_var(DimXMin   : DimXMax-1, DimZMin : DimZMax)  &
      &  ) * 5.0d-1

  end function xr_avr_pr


!!!---------------------------------------------------------------------  
  function pr_avr_xz( xz_var ) 
    !
    ! x, z ȾʻҤ줿, ʻҾǤʿ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: xz_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿѱ黻оݤȤʤѿ
    real(8)              :: pr_avr_xz(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿ
    
    pr_avr_xz = xz_var
    pr_avr_xz(DimXMin : DimXMax-1, DimZMin : DimZMax-1) =          &
      &  (                                                         &
      &     xz_var(DimXMin+1 : DimXMax,   DimZMin+1 : DimZMax   )  &
      &   + xz_var(DimXMin+1 : DimXMax,   DimZMin   : DimZMax-1 )  &
      &   + xz_var(DimXMin   : DimXMax-1, DimZMin+1 : DimZMax   )  &
      &   + xz_var(DimXMin   : DimXMax-1, DimZMin   : DimZMax-1 )  &
      &  ) * 2.5d-1

  end function pr_avr_xz
  

!!!---------------------------------------------------------------------  
  function pr_avr_pz( pz_var ) 
    !
    ! z ȾʻҤ줿, ʻҾǤʿ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: pz_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿѱ黻оݤȤʤѿ
    real(8)              :: pr_avr_pz(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿ
    
    pr_avr_pz = pz_var
    pr_avr_pz(DimXMin : DimXMax, DimZMin : DimZMax-1) =       &
      &  (                                                    &
      &     pz_var(DimXMin : DimXMax, DimZMin+1 : DimZMax)    &
      &   + pz_var(DimXMin : DimXMax, DimZMin   : DimZMax-1)  &
      &   ) * 5.0d-1

  end function pr_avr_pz


!!!---------------------------------------------------------------------  
  function pr_avr_xr( xr_var ) 
    !
    ! x ȾʻҤ줿, ʻҾǤʿ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: xr_var(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿѱ黻оݤȤʤѿ
    real(8)              :: pr_avr_xr(DimXMin:DimXMax, DimZMin:DimZMax)
                                     !ʿ
    
    pr_avr_xr = xr_var
    pr_avr_xr(DimXMin : DimXMax-1 , DimZMin : DimZMax) =      &
      &  (                                                    &
      &     xr_var(DimXMin+1 : DimXMax,   DimZMin : DimZMax)  &
      &   + xr_var(DimXMin   : DimXMax-1, DimZMin : DimZMax)  &
      &   ) * 5.0d-1

  end function pr_avr_xr


end module average
