--- timing/lin/linsrc/sgelsd.f	Thu Dec  5 19:45:19 2002
+++ debian/updates/timing/lin/linsrc/sgelsd.f	Fri Oct  4 14:28:00 2002
@@ -1,10 +1,10 @@
-      SUBROUTINE SGELSD( M, N, NRHS, A, LDA, B, LDB, S, RCOND,
-     $                   RANK, WORK, LWORK, IWORK, INFO )
+      SUBROUTINE SGELSD( M, N, NRHS, A, LDA, B, LDB, S, RCOND, RANK,
+     $                   WORK, LWORK, IWORK, INFO )
 *
-*  -- LAPACK driver routine (version 3.0) --
+*  -- LAPACK driver routine (instrumented to count ops, version 3.0) --
 *     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
 *     Courant Institute, Argonne National Lab, and Rice University
-*     October 31, 1999
+*     September 26, 2002
 *
 *     .. Scalar Arguments ..
       INTEGER            INFO, LDA, LDB, LWORK, M, N, NRHS, RANK
@@ -14,6 +14,17 @@
       INTEGER            IWORK( * )
       REAL               A( LDA, * ), B( LDB, * ), S( * ), WORK( * )
 *     ..
+*     Common blocks to return operation counts and timings.
+*     .. Common blocks ..
+      COMMON             / LATIME / OPS, ITCNT
+      COMMON             / LSTIME / OPCNT, TIMNG
+*     ..
+*     .. Scalars in Common ..
+      REAL               ITCNT, OPS
+*     ..
+*     .. Arrays in Common ..
+      REAL               OPCNT( 6 ), TIMNG( 6 )
+*     ..
 *
 *  Purpose
 *  =======
@@ -140,10 +151,11 @@
 *     ..
 *     .. Local Scalars ..
       LOGICAL            LQUERY
-      INTEGER            IASCL, IBSCL, IE, IL, ITAU, ITAUP, ITAUQ,
-     $                   LDWORK, MAXMN, MAXWRK, MINMN, MINWRK, MM,
-     $                   MNTHR, NLVL, NWORK, SMLSIZ, WLALSD
-      REAL               ANRM, BIGNUM, BNRM, EPS, SFMIN, SMLNUM
+      INTEGER            GEBRD, GELQF, GELSD, GEQRF, IASCL, IBSCL, IE,
+     $                   IL, ITAU, ITAUP, ITAUQ, LALSD, LDWORK, MAXMN,
+     $                   MAXWRK, MINMN, MINWRK, MM, MNTHR, NB, NLVL,
+     $                   NWORK, ORMBR, ORMLQ, ORMQR, SMLSIZ, WLALSD
+      REAL               ANRM, BIGNUM, BNRM, EPS, SFMIN, SMLNUM, T1, T2
 *     ..
 *     .. External Subroutines ..
       EXTERNAL           SGEBRD, SGELQF, SGEQRF, SLABAD, SLACPY, SLALSD,
@@ -151,11 +163,16 @@
 *     ..
 *     .. External Functions ..
       INTEGER            ILAENV
-      REAL               SLAMCH, SLANGE
-      EXTERNAL           SLAMCH, SLANGE, ILAENV
+      REAL               SECOND, SLAMCH, SLANGE, SOPLA, SOPLA2
+      EXTERNAL           ILAENV, SECOND, SLAMCH, SLANGE, SOPLA, SOPLA2
 *     ..
 *     .. Intrinsic Functions ..
-      INTRINSIC          REAL, INT, LOG, MAX, MIN
+      INTRINSIC          INT, LOG, MAX, MIN, REAL
+*     ..
+*     .. Data statements ..
+      DATA               GEBRD / 3 / , GELQF / 2 / , GELSD / 1 / ,
+     $                   GEQRF / 2 / , LALSD / 5 / , ORMBR / 4 / ,
+     $                   ORMLQ / 4 / , ORMQR / 2 /
 *     ..
 *     .. Executable Statements ..
 *
@@ -189,8 +206,8 @@
 *
       MINWRK = 1
       MINMN = MAX( 1, MINMN )
-      NLVL = MAX( INT( LOG( REAL( MINMN ) / REAL( SMLSIZ+1 ) ) / 
-     $       LOG( TWO ) ) + 1, 0 )
+      NLVL = MAX( INT( LOG( REAL( MINMN ) / REAL( SMLSIZ+1 ) ) /
+     $       LOG( TWO ) )+1, 0 )
 *
       IF( INFO.EQ.0 ) THEN
          MAXWRK = 0
@@ -215,12 +232,14 @@
      $               ILAENV( 1, 'SORMBR', 'QLT', MM, NRHS, N, -1 ) )
             MAXWRK = MAX( MAXWRK, 3*N+( N-1 )*
      $               ILAENV( 1, 'SORMBR', 'PLN', N, NRHS, N, -1 ) )
-            WLALSD = 9*N+2*N*SMLSIZ+8*N*NLVL+N*NRHS+(SMLSIZ+1)**2
+            WLALSD = 9*N + 2*N*SMLSIZ + 8*N*NLVL + N*NRHS +
+     $               ( SMLSIZ+1 )**2
             MAXWRK = MAX( MAXWRK, 3*N+WLALSD )
             MINWRK = MAX( 3*N+MM, 3*N+NRHS, 3*N+WLALSD )
          END IF
          IF( N.GT.M ) THEN
-            WLALSD = 9*M+2*M*SMLSIZ+8*M*NLVL+M*NRHS+(SMLSIZ+1)**2
+            WLALSD = 9*M + 2*M*SMLSIZ + 8*M*NLVL + M*NRHS +
+     $               ( SMLSIZ+1 )**2
             IF( N.GE.MNTHR ) THEN
 *
 *              Path 2a - underdetermined, with many more columns
@@ -280,6 +299,7 @@
 *
       EPS = SLAMCH( 'P' )
       SFMIN = SLAMCH( 'S' )
+      OPCNT( GELSD ) = OPCNT( GELSD ) + REAL( 2 )
       SMLNUM = SFMIN / EPS
       BIGNUM = ONE / SMLNUM
       CALL SLABAD( SMLNUM, BIGNUM )
@@ -292,12 +312,14 @@
 *
 *        Scale matrix norm up to SMLNUM.
 *
+         OPCNT( GELSD ) = OPCNT( GELSD ) + REAL( M*N )
          CALL SLASCL( 'G', 0, 0, ANRM, SMLNUM, M, N, A, LDA, INFO )
          IASCL = 1
       ELSE IF( ANRM.GT.BIGNUM ) THEN
 *
 *        Scale matrix norm down to BIGNUM.
 *
+         OPCNT( GELSD ) = OPCNT( GELSD ) + REAL( M*N )
          CALL SLASCL( 'G', 0, 0, ANRM, BIGNUM, M, N, A, LDA, INFO )
          IASCL = 2
       ELSE IF( ANRM.EQ.ZERO ) THEN
@@ -318,12 +340,14 @@
 *
 *        Scale matrix norm up to SMLNUM.
 *
+         OPCNT( GELSD ) = OPCNT( GELSD ) + REAL( M*NRHS )
          CALL SLASCL( 'G', 0, 0, BNRM, SMLNUM, M, NRHS, B, LDB, INFO )
          IBSCL = 1
       ELSE IF( BNRM.GT.BIGNUM ) THEN
 *
 *        Scale matrix norm down to BIGNUM.
 *
+         OPCNT( GELSD ) = OPCNT( GELSD ) + REAL( M*NRHS )
          CALL SLASCL( 'G', 0, 0, BNRM, BIGNUM, M, NRHS, B, LDB, INFO )
          IBSCL = 2
       END IF
@@ -351,14 +375,26 @@
 *           Compute A=Q*R.
 *           (Workspace: need 2*N, prefer N+N*NB)
 *
+            NB = ILAENV( 1, 'SGEQRF', ' ', M, N, -1, -1 )
+            OPCNT( GEQRF ) = OPCNT( GEQRF ) +
+     $                       SOPLA( 'SGEQRF', M, N, 0, 0, NB )
+            T1 = SECOND( )
             CALL SGEQRF( M, N, A, LDA, WORK( ITAU ), WORK( NWORK ),
      $                   LWORK-NWORK+1, INFO )
+            T2 = SECOND( )
+            TIMNG( GEQRF ) = TIMNG( GEQRF ) + ( T2-T1 )
 *
 *           Multiply B by transpose(Q).
 *           (Workspace: need N+NRHS, prefer N+NRHS*NB)
 *
+            NB = ILAENV( 1, 'SORMQR', 'LT', M, NRHS, N, -1 )
+            OPCNT( ORMQR ) = OPCNT( ORMQR ) +
+     $                       SOPLA( 'SORMQR', M, NRHS, N, 0, NB )
+            T1 = SECOND( )
             CALL SORMQR( 'L', 'T', M, NRHS, N, A, LDA, WORK( ITAU ), B,
      $                   LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+            T2 = SECOND( )
+            TIMNG( ORMQR ) = TIMNG( ORMQR ) + ( T2-T1 )
 *
 *           Zero out below R.
 *
@@ -375,28 +411,51 @@
 *        Bidiagonalize R in A.
 *        (Workspace: need 3*N+MM, prefer 3*N+(MM+N)*NB)
 *
+         NB = ILAENV( 1, 'SGEBRD', ' ', MM, N, -1, -1 )
+         OPCNT( GEBRD ) = OPCNT( GEBRD ) +
+     $                    SOPLA( 'SGEBRD', MM, N, 0, 0, NB )
+         T1 = SECOND( )
          CALL SGEBRD( MM, N, A, LDA, S, WORK( IE ), WORK( ITAUQ ),
      $                WORK( ITAUP ), WORK( NWORK ), LWORK-NWORK+1,
      $                INFO )
+         T2 = SECOND( )
+         TIMNG( GEBRD ) = TIMNG( GEBRD ) + ( T2-T1 )
 *
 *        Multiply B by transpose of left bidiagonalizing vectors of R.
 *        (Workspace: need 3*N+NRHS, prefer 3*N+NRHS*NB)
 *
+         NB = ILAENV( 1, 'SORMBR', 'QLT', MM, NRHS, N, -1 )
+         OPCNT( ORMBR ) = OPCNT( ORMBR ) +
+     $                    SOPLA2( 'SORMBR', 'QLT', MM, NRHS, N, 0, NB )
+         T1 = SECOND( )
          CALL SORMBR( 'Q', 'L', 'T', MM, NRHS, N, A, LDA, WORK( ITAUQ ),
      $                B, LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+         T2 = SECOND( )
+         TIMNG( ORMBR ) = TIMNG( ORMBR ) + ( T2-T1 )
 *
 *        Solve the bidiagonal least squares problem.
 *
+         OPS = ZERO
+         T1 = SECOND( )
          CALL SLALSD( 'U', SMLSIZ, N, NRHS, S, WORK( IE ), B, LDB,
      $                RCOND, RANK, WORK( NWORK ), IWORK, INFO )
+         T2 = SECOND( )
+         TIMNG( LALSD ) = TIMNG( LALSD ) + ( T2-T1 )
+         OPCNT( LALSD ) = OPCNT( LALSD ) + OPS
          IF( INFO.NE.0 ) THEN
             GO TO 10
          END IF
 *
 *        Multiply B by right bidiagonalizing vectors of R.
 *
+         NB = ILAENV( 1, 'SORMBR', 'PLN', N, NRHS, N, -1 )
+         OPCNT( ORMBR ) = OPCNT( ORMBR ) +
+     $                    SOPLA2( 'SORMBR', 'PLN', N, NRHS, N, 0, NB )
+         T1 = SECOND( )
          CALL SORMBR( 'P', 'L', 'N', N, NRHS, N, A, LDA, WORK( ITAUP ),
      $                B, LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+         T2 = SECOND( )
+         TIMNG( ORMBR ) = TIMNG( ORMBR ) + ( T2-T1 )
 *
       ELSE IF( N.GE.MNTHR .AND. LWORK.GE.4*M+M*M+
      $         MAX( M, 2*M-4, NRHS, N-3*M ) ) THEN
@@ -413,8 +472,14 @@
 *        Compute A=L*Q.
 *        (Workspace: need 2*M, prefer M+M*NB)
 *
+         NB = ILAENV( 1, 'SGELQF', ' ', M, N, -1, -1 )
+         OPCNT( GELQF ) = OPCNT( GELQF ) +
+     $                    SOPLA( 'SGELQF', M, N, 0, 0, NB )
+         T1 = SECOND( )
          CALL SGELQF( M, N, A, LDA, WORK( ITAU ), WORK( NWORK ),
      $                LWORK-NWORK+1, INFO )
+         T2 = SECOND( )
+         TIMNG( GELQF ) = TIMNG( GELQF ) + ( T2-T1 )
          IL = NWORK
 *
 *        Copy L to WORK(IL), zeroing out above its diagonal.
@@ -430,30 +495,53 @@
 *        Bidiagonalize L in WORK(IL).
 *        (Workspace: need M*M+5*M, prefer M*M+4*M+2*M*NB)
 *
+         NB = ILAENV( 1, 'SGEBRD', ' ', M, M, -1, -1 )
+         OPCNT( GEBRD ) = OPCNT( GEBRD ) +
+     $                    SOPLA( 'SGEBRD', M, M, 0, 0, NB )
+         T1 = SECOND( )
          CALL SGEBRD( M, M, WORK( IL ), LDWORK, S, WORK( IE ),
      $                WORK( ITAUQ ), WORK( ITAUP ), WORK( NWORK ),
      $                LWORK-NWORK+1, INFO )
+         T2 = SECOND( )
+         TIMNG( GEBRD ) = TIMNG( GEBRD ) + ( T2-T1 )
 *
 *        Multiply B by transpose of left bidiagonalizing vectors of L.
 *        (Workspace: need M*M+4*M+NRHS, prefer M*M+4*M+NRHS*NB)
 *
+         NB = ILAENV( 1, 'SORMBR', 'QLT', M, NRHS, M, -1 )
+         OPCNT( ORMBR ) = OPCNT( ORMBR ) +
+     $                    SOPLA2( 'SORMBR', 'QLT', M, NRHS, M, 0, NB )
+         T1 = SECOND( )
          CALL SORMBR( 'Q', 'L', 'T', M, NRHS, M, WORK( IL ), LDWORK,
      $                WORK( ITAUQ ), B, LDB, WORK( NWORK ),
      $                LWORK-NWORK+1, INFO )
+         T2 = SECOND( )
+         TIMNG( ORMBR ) = TIMNG( ORMBR ) + ( T2-T1 )
 *
 *        Solve the bidiagonal least squares problem.
 *
+         OPS = ZERO
+         T1 = SECOND( )
          CALL SLALSD( 'U', SMLSIZ, M, NRHS, S, WORK( IE ), B, LDB,
      $                RCOND, RANK, WORK( NWORK ), IWORK, INFO )
+         T2 = SECOND( )
+         TIMNG( LALSD ) = TIMNG( LALSD ) + ( T2-T1 )
+         OPCNT( LALSD ) = OPCNT( LALSD ) + OPS
          IF( INFO.NE.0 ) THEN
             GO TO 10
          END IF
 *
 *        Multiply B by right bidiagonalizing vectors of L.
 *
+         NB = ILAENV( 1, 'SORMBR', 'PLN', M, NRHS, M, -1 )
+         OPCNT( ORMBR ) = OPCNT( ORMBR ) +
+     $                    SOPLA2( 'SORMBR', 'PLN', M, NRHS, M, 0, NB )
+         T1 = SECOND( )
          CALL SORMBR( 'P', 'L', 'N', M, NRHS, M, WORK( IL ), LDWORK,
      $                WORK( ITAUP ), B, LDB, WORK( NWORK ),
      $                LWORK-NWORK+1, INFO )
+         T2 = SECOND( )
+         TIMNG( ORMBR ) = TIMNG( ORMBR ) + ( T2-T1 )
 *
 *        Zero out below first M rows of B.
 *
@@ -463,8 +551,14 @@
 *        Multiply transpose(Q) by B.
 *        (Workspace: need M+NRHS, prefer M+NRHS*NB)
 *
+         NB = ILAENV( 1, 'SORMLQ', 'LT', N, NRHS, M, -1 )
+         OPCNT( ORMLQ ) = OPCNT( ORMLQ ) +
+     $                    SOPLA( 'SORMLQ', N, NRHS, M, 0, NB )
+         T1 = SECOND( )
          CALL SORMLQ( 'L', 'T', N, NRHS, M, A, LDA, WORK( ITAU ), B,
      $                LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+         T2 = SECOND( )
+         TIMNG( ORMLQ ) = TIMNG( ORMLQ ) + ( T2-T1 )
 *
       ELSE
 *
@@ -478,45 +572,72 @@
 *        Bidiagonalize A.
 *        (Workspace: need 3*M+N, prefer 3*M+(M+N)*NB)
 *
+         NB = ILAENV( 1, 'SGEBRD', ' ', M, N, -1, -1 )
+         OPCNT( GEBRD ) = OPCNT( GEBRD ) +
+     $                    SOPLA( 'SGEBRD', M, N, 0, 0, NB )
+         T1 = SECOND( )
          CALL SGEBRD( M, N, A, LDA, S, WORK( IE ), WORK( ITAUQ ),
      $                WORK( ITAUP ), WORK( NWORK ), LWORK-NWORK+1,
      $                INFO )
+         T2 = SECOND( )
+         TIMNG( GEBRD ) = TIMNG( GEBRD ) + ( T2-T1 )
 *
 *        Multiply B by transpose of left bidiagonalizing vectors.
 *        (Workspace: need 3*M+NRHS, prefer 3*M+NRHS*NB)
 *
+         NB = ILAENV( 1, 'SORMBR', 'QLT', M, NRHS, N, -1 )
+         OPCNT( ORMBR ) = OPCNT( ORMBR ) +
+     $                    SOPLA2( 'SORMBR', 'QLT', M, NRHS, N, 0, NB )
+         T1 = SECOND( )
          CALL SORMBR( 'Q', 'L', 'T', M, NRHS, N, A, LDA, WORK( ITAUQ ),
      $                B, LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+         T2 = SECOND( )
+         TIMNG( ORMBR ) = TIMNG( ORMBR ) + ( T2-T1 )
 *
 *        Solve the bidiagonal least squares problem.
 *
+         OPS = ZERO
+         T1 = SECOND( )
          CALL SLALSD( 'L', SMLSIZ, M, NRHS, S, WORK( IE ), B, LDB,
      $                RCOND, RANK, WORK( NWORK ), IWORK, INFO )
+         T2 = SECOND( )
+         TIMNG( LALSD ) = TIMNG( LALSD ) + ( T2-T1 )
+         OPCNT( LALSD ) = OPCNT( LALSD ) + OPS
          IF( INFO.NE.0 ) THEN
             GO TO 10
          END IF
 *
 *        Multiply B by right bidiagonalizing vectors of A.
 *
+         NB = ILAENV( 1, 'SORMBR', 'PLN', N, NRHS, M, -1 )
+         OPCNT( ORMBR ) = OPCNT( ORMBR ) +
+     $                    SOPLA2( 'SORMBR', 'PLN', N, NRHS, M, 0, NB )
+         T1 = SECOND( )
          CALL SORMBR( 'P', 'L', 'N', N, NRHS, M, A, LDA, WORK( ITAUP ),
      $                B, LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+         T2 = SECOND( )
+         TIMNG( ORMBR ) = TIMNG( ORMBR ) + ( T2-T1 )
 *
       END IF
 *
 *     Undo scaling.
 *
       IF( IASCL.EQ.1 ) THEN
+         OPCNT( GELSD ) = OPCNT( GELSD ) + REAL( N*NRHS+MINMN )
          CALL SLASCL( 'G', 0, 0, ANRM, SMLNUM, N, NRHS, B, LDB, INFO )
          CALL SLASCL( 'G', 0, 0, SMLNUM, ANRM, MINMN, 1, S, MINMN,
      $                INFO )
       ELSE IF( IASCL.EQ.2 ) THEN
+         OPCNT( GELSD ) = OPCNT( GELSD ) + REAL( N*NRHS+MINMN )
          CALL SLASCL( 'G', 0, 0, ANRM, BIGNUM, N, NRHS, B, LDB, INFO )
          CALL SLASCL( 'G', 0, 0, BIGNUM, ANRM, MINMN, 1, S, MINMN,
      $                INFO )
       END IF
       IF( IBSCL.EQ.1 ) THEN
+         OPCNT( GELSD ) = OPCNT( GELSD ) + REAL( N*NRHS )
          CALL SLASCL( 'G', 0, 0, SMLNUM, BNRM, N, NRHS, B, LDB, INFO )
       ELSE IF( IBSCL.EQ.2 ) THEN
+         OPCNT( GELSD ) = OPCNT( GELSD ) + REAL( N*NRHS )
          CALL SLASCL( 'G', 0, 0, BIGNUM, BNRM, N, NRHS, B, LDB, INFO )
       END IF
 *
