--- timing/lin/linsrc/dgelsd.f	Thu Dec  5 19:45:19 2002
+++ debian/updates/timing/lin/linsrc/dgelsd.f	Fri Oct  4 14:29:00 2002
@@ -1,10 +1,10 @@
       SUBROUTINE DGELSD( M, N, NRHS, A, LDA, B, LDB, S, RCOND, RANK,
      $                   WORK, LWORK, IWORK, INFO )
 *
-*  -- LAPACK driver routine (version 3.0) --
+*  -- LAPACK driver routine (instrumented to count ops, version 3.0) --
 *     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
 *     Courant Institute, Argonne National Lab, and Rice University
-*     October 31, 1999
+*     September 26, 2002 
 *
 *     .. Scalar Arguments ..
       INTEGER            INFO, LDA, LDB, LWORK, M, N, NRHS, RANK
@@ -14,6 +14,17 @@
       INTEGER            IWORK( * )
       DOUBLE PRECISION   A( LDA, * ), B( LDB, * ), S( * ), WORK( * )
 *     ..
+*     Common blocks to return operation counts and timings.
+*     .. Common blocks ..
+      COMMON             / LATIME / OPS, ITCNT
+      COMMON             / LSTIME / OPCNT, TIMNG
+*     ..
+*     .. Scalars in Common ..
+      DOUBLE PRECISION   ITCNT, OPS
+*     ..
+*     .. Arrays in Common ..
+      DOUBLE PRECISION   OPCNT( 6 ), TIMNG( 6 )
+*     ..
 *
 *  Purpose
 *  =======
@@ -140,10 +151,11 @@
 *     ..
 *     .. Local Scalars ..
       LOGICAL            LQUERY
-      INTEGER            IASCL, IBSCL, IE, IL, ITAU, ITAUP, ITAUQ,
-     $                   LDWORK, MAXMN, MAXWRK, MINMN, MINWRK, MM,
-     $                   MNTHR, NLVL, NWORK, SMLSIZ, WLALSD
-      DOUBLE PRECISION   ANRM, BIGNUM, BNRM, EPS, SFMIN, SMLNUM
+      INTEGER            GEBRD, GELQF, GELSD, GEQRF, IASCL, IBSCL, IE,
+     $                   IL, ITAU, ITAUP, ITAUQ, LALSD, LDWORK, MAXMN,
+     $                   MAXWRK, MINMN, MINWRK, MM, MNTHR, NB, NLVL,
+     $                   NWORK, ORMBR, ORMLQ, ORMQR, SMLSIZ, WLALSD
+      DOUBLE PRECISION   ANRM, BIGNUM, BNRM, EPS, SFMIN, SMLNUM, T1, T2
 *     ..
 *     .. External Subroutines ..
       EXTERNAL           DGEBRD, DGELQF, DGEQRF, DLABAD, DLACPY, DLALSD,
@@ -151,12 +163,17 @@
 *     ..
 *     .. External Functions ..
       INTEGER            ILAENV
-      DOUBLE PRECISION   DLAMCH, DLANGE
-      EXTERNAL           ILAENV, DLAMCH, DLANGE
+      DOUBLE PRECISION   DLAMCH, DLANGE, DOPLA, DSECND, SOPLA2
+      EXTERNAL           ILAENV, DLAMCH, DLANGE, DOPLA, DSECND, SOPLA2
 *     ..
 *     .. Intrinsic Functions ..
       INTRINSIC          DBLE, INT, LOG, MAX, MIN
 *     ..
+*     .. Data statements ..
+      DATA               GEBRD / 3 / , GELQF / 2 / , GELSD / 1 / ,
+     $                   GEQRF / 2 / , LALSD / 5 / , ORMBR / 4 / ,
+     $                   ORMLQ / 4 / , ORMQR / 2 /
+*     ..
 *     .. Executable Statements ..
 *
 *     Test the input arguments.
@@ -190,7 +207,7 @@
       MINWRK = 1
       MINMN = MAX( 1, MINMN )
       NLVL = MAX( INT( LOG( DBLE( MINMN ) / DBLE( SMLSIZ+1 ) ) /
-     $       LOG( TWO ) )+ 1, 0 )
+     $       LOG( TWO ) )+1, 0 )
 *
       IF( INFO.EQ.0 ) THEN
          MAXWRK = 0
@@ -215,12 +232,14 @@
      $               ILAENV( 1, 'DORMBR', 'QLT', MM, NRHS, N, -1 ) )
             MAXWRK = MAX( MAXWRK, 3*N+( N-1 )*
      $               ILAENV( 1, 'DORMBR', 'PLN', N, NRHS, N, -1 ) )
-            WLALSD = 9*N+2*N*SMLSIZ+8*N*NLVL+N*NRHS+(SMLSIZ+1)**2
+            WLALSD = 9*N + 2*N*SMLSIZ + 8*N*NLVL + N*NRHS +
+     $               ( SMLSIZ+1 )**2
             MAXWRK = MAX( MAXWRK, 3*N+WLALSD )
             MINWRK = MAX( 3*N+MM, 3*N+NRHS, 3*N+WLALSD )
          END IF
          IF( N.GT.M ) THEN
-            WLALSD = 9*M+2*M*SMLSIZ+8*M*NLVL+M*NRHS+(SMLSIZ+1)**2
+            WLALSD = 9*M + 2*M*SMLSIZ + 8*M*NLVL + M*NRHS +
+     $               ( SMLSIZ+1 )**2
             IF( N.GE.MNTHR ) THEN
 *
 *              Path 2a - underdetermined, with many more columns
@@ -280,6 +299,7 @@
 *
       EPS = DLAMCH( 'P' )
       SFMIN = DLAMCH( 'S' )
+      OPCNT( GELSD ) = OPCNT( GELSD ) + DBLE( 2 )
       SMLNUM = SFMIN / EPS
       BIGNUM = ONE / SMLNUM
       CALL DLABAD( SMLNUM, BIGNUM )
@@ -292,12 +312,14 @@
 *
 *        Scale matrix norm up to SMLNUM.
 *
+         OPCNT( GELSD ) = OPCNT( GELSD ) + DBLE( M*N )
          CALL DLASCL( 'G', 0, 0, ANRM, SMLNUM, M, N, A, LDA, INFO )
          IASCL = 1
       ELSE IF( ANRM.GT.BIGNUM ) THEN
 *
 *        Scale matrix norm down to BIGNUM.
 *
+         OPCNT( GELSD ) = OPCNT( GELSD ) + DBLE( M*N )
          CALL DLASCL( 'G', 0, 0, ANRM, BIGNUM, M, N, A, LDA, INFO )
          IASCL = 2
       ELSE IF( ANRM.EQ.ZERO ) THEN
@@ -318,12 +340,14 @@
 *
 *        Scale matrix norm up to SMLNUM.
 *
+         OPCNT( GELSD ) = OPCNT( GELSD ) + DBLE( M*NRHS )
          CALL DLASCL( 'G', 0, 0, BNRM, SMLNUM, M, NRHS, B, LDB, INFO )
          IBSCL = 1
       ELSE IF( BNRM.GT.BIGNUM ) THEN
 *
 *        Scale matrix norm down to BIGNUM.
 *
+         OPCNT( GELSD ) = OPCNT( GELSD ) + DBLE( M*NRHS )
          CALL DLASCL( 'G', 0, 0, BNRM, BIGNUM, M, NRHS, B, LDB, INFO )
          IBSCL = 2
       END IF
@@ -351,14 +375,26 @@
 *           Compute A=Q*R.
 *           (Workspace: need 2*N, prefer N+N*NB)
 *
+            NB = ILAENV( 1, 'DGEQRF', ' ', M, N, -1, -1 )
+            OPCNT( GEQRF ) = OPCNT( GEQRF ) +
+     $                       DOPLA( 'DGEQRF', M, N, 0, 0, NB )
+            T1 = DSECND( )
             CALL DGEQRF( M, N, A, LDA, WORK( ITAU ), WORK( NWORK ),
      $                   LWORK-NWORK+1, INFO )
+            T2 = DSECND( )
+            TIMNG( GEQRF ) = TIMNG( GEQRF ) + ( T2-T1 )
 *
 *           Multiply B by transpose(Q).
 *           (Workspace: need N+NRHS, prefer N+NRHS*NB)
 *
+            NB = ILAENV( 1, 'DORMQR', 'LT', M, NRHS, N, -1 )
+            OPCNT( ORMQR ) = OPCNT( ORMQR ) +
+     $                       DOPLA( 'DORMQR', M, NRHS, N, 0, NB )
+            T1 = DSECND( )
             CALL DORMQR( 'L', 'T', M, NRHS, N, A, LDA, WORK( ITAU ), B,
      $                   LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+            T2 = DSECND( )
+            TIMNG( ORMQR ) = TIMNG( ORMQR ) + ( T2-T1 )
 *
 *           Zero out below R.
 *
@@ -375,28 +411,51 @@
 *        Bidiagonalize R in A.
 *        (Workspace: need 3*N+MM, prefer 3*N+(MM+N)*NB)
 *
+         NB = ILAENV( 1, 'DGEBRD', ' ', MM, N, -1, -1 )
+         OPCNT( GEBRD ) = OPCNT( GEBRD ) +
+     $                    DOPLA( 'DGEBRD', MM, N, 0, 0, NB )
+         T1 = DSECND( )
          CALL DGEBRD( MM, N, A, LDA, S, WORK( IE ), WORK( ITAUQ ),
      $                WORK( ITAUP ), WORK( NWORK ), LWORK-NWORK+1,
      $                INFO )
+         T2 = DSECND( )
+         TIMNG( GEBRD ) = TIMNG( GEBRD ) + ( T2-T1 )
 *
 *        Multiply B by transpose of left bidiagonalizing vectors of R.
 *        (Workspace: need 3*N+NRHS, prefer 3*N+NRHS*NB)
 *
+         NB = ILAENV( 1, 'DORMBR', 'QLT', MM, NRHS, N, -1 )
+         OPCNT( ORMBR ) = OPCNT( ORMBR ) +
+     $                    SOPLA2( 'DORMBR', 'QLT', MM, NRHS, N, 0, NB )
+         T1 = DSECND( )
          CALL DORMBR( 'Q', 'L', 'T', MM, NRHS, N, A, LDA, WORK( ITAUQ ),
      $                B, LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+         T2 = DSECND( )
+         TIMNG( ORMBR ) = TIMNG( ORMBR ) + ( T2-T1 )
 *
 *        Solve the bidiagonal least squares problem.
 *
+         OPS = ZERO
+         T1 = DSECND( )
          CALL DLALSD( 'U', SMLSIZ, N, NRHS, S, WORK( IE ), B, LDB,
      $                RCOND, RANK, WORK( NWORK ), IWORK, INFO )
+         T2 = DSECND( )
+         TIMNG( LALSD ) = TIMNG( LALSD ) + ( T2-T1 )
+         OPCNT( LALSD ) = OPCNT( LALSD ) + OPS
          IF( INFO.NE.0 ) THEN
             GO TO 10
          END IF
 *
 *        Multiply B by right bidiagonalizing vectors of R.
 *
+         NB = ILAENV( 1, 'DORMBR', 'PLN', N, NRHS, N, -1 )
+         OPCNT( ORMBR ) = OPCNT( ORMBR ) +
+     $                    SOPLA2( 'DORMBR', 'PLN', N, NRHS, N, 0, NB )
+         T1 = DSECND( )
          CALL DORMBR( 'P', 'L', 'N', N, NRHS, N, A, LDA, WORK( ITAUP ),
      $                B, LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+         T2 = DSECND( )
+         TIMNG( ORMBR ) = TIMNG( ORMBR ) + ( T2-T1 )
 *
       ELSE IF( N.GE.MNTHR .AND. LWORK.GE.4*M+M*M+
      $         MAX( M, 2*M-4, NRHS, N-3*M ) ) THEN
@@ -413,8 +472,14 @@
 *        Compute A=L*Q.
 *        (Workspace: need 2*M, prefer M+M*NB)
 *
+         NB = ILAENV( 1, 'DGELQF', ' ', M, N, -1, -1 )
+         OPCNT( GELQF ) = OPCNT( GELQF ) +
+     $                    DOPLA( 'DGELQF', M, N, 0, 0, NB )
+         T1 = DSECND( )
          CALL DGELQF( M, N, A, LDA, WORK( ITAU ), WORK( NWORK ),
      $                LWORK-NWORK+1, INFO )
+         T2 = DSECND( )
+         TIMNG( GELQF ) = TIMNG( GELQF ) + ( T2-T1 )
          IL = NWORK
 *
 *        Copy L to WORK(IL), zeroing out above its diagonal.
@@ -430,30 +495,53 @@
 *        Bidiagonalize L in WORK(IL).
 *        (Workspace: need M*M+5*M, prefer M*M+4*M+2*M*NB)
 *
+         NB = ILAENV( 1, 'DGEBRD', ' ', M, M, -1, -1 )
+         OPCNT( GEBRD ) = OPCNT( GEBRD ) +
+     $                    DOPLA( 'DGEBRD', M, M, 0, 0, NB )
+         T1 = DSECND( )
          CALL DGEBRD( M, M, WORK( IL ), LDWORK, S, WORK( IE ),
      $                WORK( ITAUQ ), WORK( ITAUP ), WORK( NWORK ),
      $                LWORK-NWORK+1, INFO )
+         T2 = DSECND( )
+         TIMNG( GEBRD ) = TIMNG( GEBRD ) + ( T2-T1 )
 *
 *        Multiply B by transpose of left bidiagonalizing vectors of L.
 *        (Workspace: need M*M+4*M+NRHS, prefer M*M+4*M+NRHS*NB)
 *
+         NB = ILAENV( 1, 'DORMBR', 'QLT', M, NRHS, M, -1 )
+         OPCNT( ORMBR ) = OPCNT( ORMBR ) +
+     $                    SOPLA2( 'DORMBR', 'QLT', M, NRHS, M, 0, NB )
+         T1 = DSECND( )
          CALL DORMBR( 'Q', 'L', 'T', M, NRHS, M, WORK( IL ), LDWORK,
      $                WORK( ITAUQ ), B, LDB, WORK( NWORK ),
      $                LWORK-NWORK+1, INFO )
+         T2 = DSECND( )
+         TIMNG( ORMBR ) = TIMNG( ORMBR ) + ( T2-T1 )
 *
 *        Solve the bidiagonal least squares problem.
 *
+         OPS = ZERO
+         T1 = DSECND( )
          CALL DLALSD( 'U', SMLSIZ, M, NRHS, S, WORK( IE ), B, LDB,
      $                RCOND, RANK, WORK( NWORK ), IWORK, INFO )
+         T2 = DSECND( )
+         TIMNG( LALSD ) = TIMNG( LALSD ) + ( T2-T1 )
+         OPCNT( LALSD ) = OPCNT( LALSD ) + OPS
          IF( INFO.NE.0 ) THEN
             GO TO 10
          END IF
 *
 *        Multiply B by right bidiagonalizing vectors of L.
 *
+         NB = ILAENV( 1, 'DORMBR', 'PLN', M, NRHS, M, -1 )
+         OPCNT( ORMBR ) = OPCNT( ORMBR ) +
+     $                    SOPLA2( 'DORMBR', 'PLN', M, NRHS, M, 0, NB )
+         T1 = DSECND( )
          CALL DORMBR( 'P', 'L', 'N', M, NRHS, M, WORK( IL ), LDWORK,
      $                WORK( ITAUP ), B, LDB, WORK( NWORK ),
      $                LWORK-NWORK+1, INFO )
+         T2 = DSECND( )
+         TIMNG( ORMBR ) = TIMNG( ORMBR ) + ( T2-T1 )
 *
 *        Zero out below first M rows of B.
 *
@@ -463,8 +551,14 @@
 *        Multiply transpose(Q) by B.
 *        (Workspace: need M+NRHS, prefer M+NRHS*NB)
 *
+         NB = ILAENV( 1, 'DORMLQ', 'LT', N, NRHS, M, -1 )
+         OPCNT( ORMLQ ) = OPCNT( ORMLQ ) +
+     $                    DOPLA( 'DORMLQ', N, NRHS, M, 0, NB )
+         T1 = DSECND( )
          CALL DORMLQ( 'L', 'T', N, NRHS, M, A, LDA, WORK( ITAU ), B,
      $                LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+         T2 = DSECND( )
+         TIMNG( ORMLQ ) = TIMNG( ORMLQ ) + ( T2-T1 )
 *
       ELSE
 *
@@ -478,45 +572,72 @@
 *        Bidiagonalize A.
 *        (Workspace: need 3*M+N, prefer 3*M+(M+N)*NB)
 *
+         NB = ILAENV( 1, 'DGEBRD', ' ', M, N, -1, -1 )
+         OPCNT( GEBRD ) = OPCNT( GEBRD ) +
+     $                    DOPLA( 'DGEBRD', M, N, 0, 0, NB )
+         T1 = DSECND( )
          CALL DGEBRD( M, N, A, LDA, S, WORK( IE ), WORK( ITAUQ ),
      $                WORK( ITAUP ), WORK( NWORK ), LWORK-NWORK+1,
      $                INFO )
+         T2 = DSECND( )
+         TIMNG( GEBRD ) = TIMNG( GEBRD ) + ( T2-T1 )
 *
 *        Multiply B by transpose of left bidiagonalizing vectors.
 *        (Workspace: need 3*M+NRHS, prefer 3*M+NRHS*NB)
 *
+         NB = ILAENV( 1, 'DORMBR', 'QLT', M, NRHS, N, -1 )
+         OPCNT( ORMBR ) = OPCNT( ORMBR ) +
+     $                    SOPLA2( 'DORMBR', 'QLT', M, NRHS, N, 0, NB )
+         T1 = DSECND( )
          CALL DORMBR( 'Q', 'L', 'T', M, NRHS, N, A, LDA, WORK( ITAUQ ),
      $                B, LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+         T2 = DSECND( )
+         TIMNG( ORMBR ) = TIMNG( ORMBR ) + ( T2-T1 )
 *
 *        Solve the bidiagonal least squares problem.
 *
+         OPS = ZERO
+         T1 = DSECND( )
          CALL DLALSD( 'L', SMLSIZ, M, NRHS, S, WORK( IE ), B, LDB,
      $                RCOND, RANK, WORK( NWORK ), IWORK, INFO )
+         T2 = DSECND( )
+         TIMNG( LALSD ) = TIMNG( LALSD ) + ( T2-T1 )
+         OPCNT( LALSD ) = OPCNT( LALSD ) + OPS
          IF( INFO.NE.0 ) THEN
             GO TO 10
          END IF
 *
 *        Multiply B by right bidiagonalizing vectors of A.
 *
+         NB = ILAENV( 1, 'DORMBR', 'PLN', N, NRHS, M, -1 )
+         OPCNT( ORMBR ) = OPCNT( ORMBR ) +
+     $                    SOPLA2( 'DORMBR', 'PLN', N, NRHS, M, 0, NB )
+         T1 = DSECND( )
          CALL DORMBR( 'P', 'L', 'N', N, NRHS, M, A, LDA, WORK( ITAUP ),
      $                B, LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+         T2 = DSECND( )
+         TIMNG( ORMBR ) = TIMNG( ORMBR ) + ( T2-T1 )
 *
       END IF
 *
 *     Undo scaling.
 *
       IF( IASCL.EQ.1 ) THEN
+         OPCNT( GELSD ) = OPCNT( GELSD ) + DBLE( N*NRHS+MINMN )
          CALL DLASCL( 'G', 0, 0, ANRM, SMLNUM, N, NRHS, B, LDB, INFO )
          CALL DLASCL( 'G', 0, 0, SMLNUM, ANRM, MINMN, 1, S, MINMN,
      $                INFO )
       ELSE IF( IASCL.EQ.2 ) THEN
+         OPCNT( GELSD ) = OPCNT( GELSD ) + DBLE( N*NRHS+MINMN )
          CALL DLASCL( 'G', 0, 0, ANRM, BIGNUM, N, NRHS, B, LDB, INFO )
          CALL DLASCL( 'G', 0, 0, BIGNUM, ANRM, MINMN, 1, S, MINMN,
      $                INFO )
       END IF
       IF( IBSCL.EQ.1 ) THEN
+         OPCNT( GELSD ) = OPCNT( GELSD ) + DBLE( N*NRHS )
          CALL DLASCL( 'G', 0, 0, SMLNUM, BNRM, N, NRHS, B, LDB, INFO )
       ELSE IF( IBSCL.EQ.2 ) THEN
+         OPCNT( GELSD ) = OPCNT( GELSD ) + DBLE( N*NRHS )
          CALL DLASCL( 'G', 0, 0, BIGNUM, BNRM, N, NRHS, B, LDB, INFO )
       END IF
 *
