--- src/zggesx.f	Thu Dec  5 19:45:13 2002
+++ debian/updates/src/zggesx.f	Wed Dec  4 15:23:42 2002
@@ -7,6 +7,7 @@
 *     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
 *     Courant Institute, Argonne National Lab, and Rice University
 *     June 30, 1999
+*     8-15-00:  Do WS calculations if LWORK = -1 (eca)
 *
 *     .. Scalar Arguments ..
       CHARACTER          JOBVSL, JOBVSR, SENSE, SORT
@@ -167,6 +168,10 @@
 *          If SENSE = 'E', 'V', or 'B',
 *          LWORK >= MAX(2*N, 2*SDIM*(N-SDIM)).
 *
+*          If LWORK = -1, a workspace query is assumed.  The optimal
+*          size for the WORK array is calculated and stored in WORK(1),
+*          and no other work except argument checking is performed.
+*
 *  RWORK   (workspace) DOUBLE PRECISION array, dimension ( 8*N )
 *          Real workspace.
 *
@@ -198,6 +203,8 @@
 *  =====================================================================
 *
 *     .. Parameters ..
+      INTEGER            LQUERV
+      PARAMETER          ( LQUERV = -1 )
       DOUBLE PRECISION   ZERO, ONE
       PARAMETER          ( ZERO = 0.0D+0, ONE = 1.0D+0 )
       COMPLEX*16         CZERO, CONE
@@ -217,8 +224,9 @@
       DOUBLE PRECISION   DIF( 2 )
 *     ..
 *     .. External Subroutines ..
-      EXTERNAL           XERBLA, ZGEQRF, ZGGBAK, ZGGBAL, ZGGHRD, ZHGEQZ,
-     $                   ZLACPY, ZLASCL, ZLASET, ZTGSEN, ZUNGQR, ZUNMQR
+      EXTERNAL           DLABAD, XERBLA, ZGEQRF, ZGGBAK, ZGGBAL, ZGGHRD,
+     $                   ZHGEQZ, ZLACPY, ZLASCL, ZLASET, ZTGSEN, ZUNGQR,
+     $                   ZUNMQR
 *     ..
 *     .. External Functions ..
       LOGICAL            LSAME
@@ -303,14 +311,22 @@
 *       following subroutine, as returned by ILAENV.)
 *
       MINWRK = 1
-      IF( INFO.EQ.0 .AND. LWORK.GE.1 ) THEN
+      IF( INFO.EQ.0 ) THEN
          MINWRK = MAX( 1, 2*N )
          MAXWRK = N + N*ILAENV( 1, 'ZGEQRF', ' ', N, 1, N, 0 )
          IF( ILVSL ) THEN
             MAXWRK = MAX( MAXWRK, N+N*ILAENV( 1, 'ZUNGQR', ' ', N, 1, N,
      $               -1 ) )
          END IF
+*
+*        Estimate the workspace needed by ZTGSEN.
+*
+         IF( WANTST ) THEN
+            MAXWRK = MAX( MAXWRK, ( N*N+1 ) / 2 )
+         END IF
          WORK( 1 ) = MAXWRK
+         IF( LWORK.LT.MINWRK .AND. LWORK.NE.LQUERV )
+     $      INFO = -21
       END IF
       IF( .NOT.WANTSN ) THEN
          LIWMIN = N + 2
@@ -318,21 +334,19 @@
          LIWMIN = 1
       END IF
       IWORK( 1 ) = LIWMIN
-*
-      IF( INFO.EQ.0 .AND. LWORK.LT.MINWRK ) THEN
-         INFO = -21
-      ELSE IF( INFO.EQ.0 .AND. IJOB.GE.1 ) THEN
+      IF( INFO.EQ.0 .AND. IJOB.GE.1 ) THEN
          IF( LIWORK.LT.LIWMIN )
      $      INFO = -24
       END IF
 *
+*     Quick returns
+*
       IF( INFO.NE.0 ) THEN
          CALL XERBLA( 'ZGGESX', -INFO )
          RETURN
       END IF
-*
-*     Quick return if possible
-*
+      IF( LWORK.EQ.LQUERV )
+     $   RETURN
       IF( N.EQ.0 ) THEN
          SDIM = 0
          RETURN
