--- timing/lin/linsrc/zgelsd.f	Thu Dec  5 19:45:19 2002
+++ debian/updates/timing/lin/linsrc/zgelsd.f	Wed Dec  4 15:23:42 2002
@@ -1,10 +1,10 @@
       SUBROUTINE ZGELSD( M, N, NRHS, A, LDA, B, LDB, S, RCOND, RANK,
      $                   WORK, LWORK, RWORK, IWORK, INFO )
 *
-*  -- LAPACK driver routine (version 3.0) --
+*  -- LAPACK driver routine (instrumented to count ops, version 3.0) --
 *     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
 *     Courant Institute, Argonne National Lab, and Rice University
-*     October 31, 1999
+*     July 10, 2001
 *
 *     .. Scalar Arguments ..
       INTEGER            INFO, LDA, LDB, LWORK, M, N, NRHS, RANK
@@ -15,6 +15,17 @@
       DOUBLE PRECISION   RWORK( * ), S( * )
       COMPLEX*16         A( LDA, * ), B( LDB, * ), WORK( * )
 *     ..
+*     Common blocks to return operation counts and timings.
+*     .. Common blocks ..
+      COMMON             / LATIME / OPS, ITCNT
+      COMMON             / LSTIME / OPCNT, TIMNG
+*     ..
+*     .. Scalars in Common ..
+      DOUBLE PRECISION   ITCNT, OPS
+*     ..
+*     .. Arrays in Common ..
+      DOUBLE PRECISION   OPCNT( 6 ), TIMNG( 6 )
+*     ..
 *
 *  Purpose
 *  =======
@@ -151,10 +162,11 @@
 *     ..
 *     .. Local Scalars ..
       LOGICAL            LQUERY
-      INTEGER            IASCL, IBSCL, IE, IL, ITAU, ITAUP, ITAUQ,
-     $                   LDWORK, MAXMN, MAXWRK, MINMN, MINWRK, MM,
-     $                   MNTHR, NRWORK, NWORK, SMLSIZ
-      DOUBLE PRECISION   ANRM, BIGNUM, BNRM, EPS, SFMIN, SMLNUM
+      INTEGER            GEBRD, GELQF, GELSD, GEQRF, IASCL, IBSCL, IE,
+     $                   IL, ITAU, ITAUP, ITAUQ, LALSD, LDWORK, MAXMN,
+     $                   MAXWRK, MINMN, MINWRK, MM, MNTHR, NB, NRWORK,
+     $                   NWORK, SMLSIZ, UNMBR, UNMLQ, UNMQR
+      DOUBLE PRECISION   ANRM, BIGNUM, BNRM, EPS, SFMIN, SMLNUM, T1, T2
 *     ..
 *     .. External Subroutines ..
       EXTERNAL           DLABAD, DLASCL, DLASET, XERBLA, ZGEBRD, ZGELQF,
@@ -163,11 +175,16 @@
 *     ..
 *     .. External Functions ..
       INTEGER            ILAENV
-      DOUBLE PRECISION   DLAMCH, ZLANGE
-      EXTERNAL           ILAENV, DLAMCH, ZLANGE
+      DOUBLE PRECISION   DLAMCH, DOPLA, DSECND, SOPLA2, ZLANGE
+      EXTERNAL           ILAENV, DLAMCH, DOPLA, DSECND, SOPLA2, ZLANGE
 *     ..
 *     .. Intrinsic Functions ..
-      INTRINSIC          DCMPLX, MAX, MIN
+      INTRINSIC          DBLE, DCMPLX, MAX, MIN
+*     ..
+*     .. Data statements ..
+      DATA               GEBRD / 3 / , GELQF / 2 / , GELSD / 1 / ,
+     $                   GEQRF / 2 / , LALSD / 5 / , UNMBR / 4 / ,
+     $                   UNMLQ / 4 / , UNMQR / 2 /
 *     ..
 *     .. Executable Statements ..
 *
@@ -284,6 +301,7 @@
 *
       EPS = DLAMCH( 'P' )
       SFMIN = DLAMCH( 'S' )
+      OPCNT( GELSD ) = OPCNT( GELSD ) + DBLE( 2 )
       SMLNUM = SFMIN / EPS
       BIGNUM = ONE / SMLNUM
       CALL DLABAD( SMLNUM, BIGNUM )
@@ -296,12 +314,14 @@
 *
 *        Scale matrix norm up to SMLNUM
 *
+         OPCNT( GELSD ) = OPCNT( GELSD ) + DBLE( 6*M*N )
          CALL ZLASCL( 'G', 0, 0, ANRM, SMLNUM, M, N, A, LDA, INFO )
          IASCL = 1
       ELSE IF( ANRM.GT.BIGNUM ) THEN
 *
 *        Scale matrix norm down to BIGNUM.
 *
+         OPCNT( GELSD ) = OPCNT( GELSD ) + DBLE( 6*M*N )
          CALL ZLASCL( 'G', 0, 0, ANRM, BIGNUM, M, N, A, LDA, INFO )
          IASCL = 2
       ELSE IF( ANRM.EQ.ZERO ) THEN
@@ -322,12 +342,14 @@
 *
 *        Scale matrix norm up to SMLNUM.
 *
+         OPCNT( GELSD ) = OPCNT( GELSD ) + DBLE( 6*M*NRHS )
          CALL ZLASCL( 'G', 0, 0, BNRM, SMLNUM, M, NRHS, B, LDB, INFO )
          IBSCL = 1
       ELSE IF( BNRM.GT.BIGNUM ) THEN
 *
 *        Scale matrix norm down to BIGNUM.
 *
+         OPCNT( GELSD ) = OPCNT( GELSD ) + DBLE( 6*M*NRHS )
          CALL ZLASCL( 'G', 0, 0, BNRM, BIGNUM, M, NRHS, B, LDB, INFO )
          IBSCL = 2
       END IF
@@ -356,15 +378,27 @@
 *           (RWorkspace: need N)
 *           (CWorkspace: need N, prefer N*NB)
 *
+            NB = ILAENV( 1, 'ZGEQRF', ' ', M, N, -1, -1 )
+            OPCNT( GEQRF ) = OPCNT( GEQRF ) +
+     $                       DOPLA( 'ZGEQRF', M, N, 0, 0, NB )
+            T1 = DSECND( )
             CALL ZGEQRF( M, N, A, LDA, WORK( ITAU ), WORK( NWORK ),
      $                   LWORK-NWORK+1, INFO )
+            T2 = DSECND( )
+            TIMNG( GEQRF ) = TIMNG( GEQRF ) + ( T2-T1 )
 *
 *           Multiply B by transpose(Q).
 *           (RWorkspace: need N)
 *           (CWorkspace: need NRHS, prefer NRHS*NB)
 *
+            NB = ILAENV( 1, 'ZUNMQR', 'LC', M, NRHS, N, -1 )
+            OPCNT( UNMQR ) = OPCNT( UNMQR ) +
+     $                       DOPLA( 'ZUNMQR', M, NRHS, N, 0, NB )
+            T1 = DSECND( )
             CALL ZUNMQR( 'L', 'C', M, NRHS, N, A, LDA, WORK( ITAU ), B,
      $                   LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+            T2 = DSECND( )
+            TIMNG( UNMQR ) = TIMNG( UNMQR ) + ( T2-T1 )
 *
 *           Zero out below R.
 *
@@ -384,29 +418,52 @@
 *        (RWorkspace: need N)
 *        (CWorkspace: need 2*N+MM, prefer 2*N+(MM+N)*NB)
 *
+         NB = ILAENV( 1, 'ZGEBRD', ' ', MM, N, -1, -1 )
+         OPCNT( GEBRD ) = OPCNT( GEBRD ) +
+     $                    DOPLA( 'ZGEBRD', MM, N, 0, 0, NB )
+         T1 = DSECND( )
          CALL ZGEBRD( MM, N, A, LDA, S, RWORK( IE ), WORK( ITAUQ ),
      $                WORK( ITAUP ), WORK( NWORK ), LWORK-NWORK+1,
      $                INFO )
+         T2 = DSECND( )
+         TIMNG( GEBRD ) = TIMNG( GEBRD ) + ( T2-T1 )
 *
 *        Multiply B by transpose of left bidiagonalizing vectors of R.
 *        (CWorkspace: need 2*N+NRHS, prefer 2*N+NRHS*NB)
 *
+         NB = ILAENV( 1, 'ZUNMBR', 'QLC', MM, NRHS, N, -1 )
+         OPCNT( UNMBR ) = OPCNT( UNMBR ) +
+     $                    SOPLA2( 'ZUNMBR', 'QLC', MM, NRHS, N, 0, NB )
+         T1 = DSECND( )
          CALL ZUNMBR( 'Q', 'L', 'C', MM, NRHS, N, A, LDA, WORK( ITAUQ ),
      $                B, LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+         T2 = DSECND( )
+         TIMNG( UNMBR ) = TIMNG( UNMBR ) + ( T2-T1 )
 *
 *        Solve the bidiagonal least squares problem.
 *
+         OPS = 0
+         T1 = DSECND( )
          CALL ZLALSD( 'U', SMLSIZ, N, NRHS, S, RWORK( IE ), B, LDB,
      $                RCOND, RANK, WORK( NWORK ), RWORK( NRWORK ),
      $                IWORK, INFO )
+         T2 = DSECND( )
+         TIMNG( LALSD ) = TIMNG( LALSD ) + ( T2-T1 )
+         OPCNT( LALSD ) = OPCNT( LALSD ) + OPS
          IF( INFO.NE.0 ) THEN
             GO TO 10
          END IF
 *
 *        Multiply B by right bidiagonalizing vectors of R.
 *
+         NB = ILAENV( 1, 'ZUNMBR', 'PLN', N, NRHS, N, -1 )
+         OPCNT( UNMBR ) = OPCNT( UNMBR ) +
+     $                    SOPLA2( 'ZUNMBR', 'PLN', N, NRHS, N, 0, NB )
+         T1 = DSECND( )
          CALL ZUNMBR( 'P', 'L', 'N', N, NRHS, N, A, LDA, WORK( ITAUP ),
      $                B, LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+         T2 = DSECND( )
+         TIMNG( UNMBR ) = TIMNG( UNMBR ) + ( T2-T1 )
 *
       ELSE IF( N.GE.MNTHR .AND. LWORK.GE.4*M+M*M+
      $         MAX( M, 2*M-4, NRHS, N-3*M ) ) THEN
@@ -423,8 +480,14 @@
 *        Compute A=L*Q.
 *        (CWorkspace: need 2*M, prefer M+M*NB)
 *
+         NB = ILAENV( 1, 'ZGELQF', ' ', M, N, -1, -1 )
+         OPCNT( GELQF ) = OPCNT( GELQF ) +
+     $                    DOPLA( 'ZGELQF', M, N, 0, 0, NB )
+         T1 = DSECND( )
          CALL ZGELQF( M, N, A, LDA, WORK( ITAU ), WORK( NWORK ),
      $                LWORK-NWORK+1, INFO )
+         T2 = DSECND( )
+         TIMNG( GELQF ) = TIMNG( GELQF ) + ( T2-T1 )
          IL = NWORK
 *
 *        Copy L to WORK(IL), zeroing out above its diagonal.
@@ -442,31 +505,54 @@
 *        (RWorkspace: need M)
 *        (CWorkspace: need M*M+4*M, prefer M*M+4*M+2*M*NB)
 *
+         NB = ILAENV( 1, 'ZGEBRD', ' ', M, M, -1, -1 )
+         OPCNT( GEBRD ) = OPCNT( GEBRD ) +
+     $                    DOPLA( 'ZGEBRD', M, M, 0, 0, NB )
+         T1 = DSECND( )
          CALL ZGEBRD( M, M, WORK( IL ), LDWORK, S, RWORK( IE ),
      $                WORK( ITAUQ ), WORK( ITAUP ), WORK( NWORK ),
      $                LWORK-NWORK+1, INFO )
+         T2 = DSECND( )
+         TIMNG( GEBRD ) = TIMNG( GEBRD ) + ( T2-T1 )
 *
 *        Multiply B by transpose of left bidiagonalizing vectors of L.
 *        (CWorkspace: need M*M+4*M+NRHS, prefer M*M+4*M+NRHS*NB)
 *
+         NB = ILAENV( 1, 'ZUNMBR', 'QLC', M, NRHS, M, -1 )
+         OPCNT( UNMBR ) = OPCNT( UNMBR ) +
+     $                    SOPLA2( 'ZUNMBR', 'QLC', M, NRHS, M, 0, NB )
+         T1 = DSECND( )
          CALL ZUNMBR( 'Q', 'L', 'C', M, NRHS, M, WORK( IL ), LDWORK,
      $                WORK( ITAUQ ), B, LDB, WORK( NWORK ),
      $                LWORK-NWORK+1, INFO )
+         T2 = DSECND( )
+         TIMNG( UNMBR ) = TIMNG( UNMBR ) + ( T2-T1 )
 *
 *        Solve the bidiagonal least squares problem.
 *
+         OPS = 0
+         T1 = DSECND( )
          CALL ZLALSD( 'U', SMLSIZ, M, NRHS, S, RWORK( IE ), B, LDB,
      $                RCOND, RANK, WORK( NWORK ), RWORK( NRWORK ),
      $                IWORK, INFO )
+         T2 = DSECND( )
+         TIMNG( LALSD ) = TIMNG( LALSD ) + ( T2-T1 )
+         OPCNT( LALSD ) = OPCNT( LALSD ) + OPS
          IF( INFO.NE.0 ) THEN
             GO TO 10
          END IF
 *
 *        Multiply B by right bidiagonalizing vectors of L.
 *
+         NB = ILAENV( 1, 'ZUNMBR', 'PLN', M, NRHS, M, -1 )
+         OPCNT( UNMBR ) = OPCNT( UNMBR ) +
+     $                    SOPLA2( 'ZUNMBR', 'PLN', M, NRHS, M, 0, NB )
+         T1 = DSECND( )
          CALL ZUNMBR( 'P', 'L', 'N', M, NRHS, M, WORK( IL ), LDWORK,
      $                WORK( ITAUP ), B, LDB, WORK( NWORK ),
      $                LWORK-NWORK+1, INFO )
+         T2 = DSECND( )
+         TIMNG( UNMBR ) = TIMNG( UNMBR ) + ( T2-T1 )
 *
 *        Zero out below first M rows of B.
 *
@@ -476,8 +562,14 @@
 *        Multiply transpose(Q) by B.
 *        (CWorkspace: need NRHS, prefer NRHS*NB)
 *
+         NB = ILAENV( 1, 'ZUNMLQ', 'LC', N, NRHS, M, -1 )
+         OPCNT( UNMLQ ) = OPCNT( UNMLQ ) +
+     $                    DOPLA( 'ZUNMLQ', N, NRHS, M, 0, NB )
+         T1 = DSECND( )
          CALL ZUNMLQ( 'L', 'C', N, NRHS, M, A, LDA, WORK( ITAU ), B,
      $                LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+         T2 = DSECND( )
+         TIMNG( UNMLQ ) = TIMNG( UNMLQ ) + ( T2-T1 )
 *
       ELSE
 *
@@ -493,46 +585,73 @@
 *        (RWorkspace: need M)
 *        (CWorkspace: need 2*M+N, prefer 2*M+(M+N)*NB)
 *
+         NB = ILAENV( 1, 'ZGEBRD', ' ', M, N, -1, -1 )
+         OPCNT( GEBRD ) = OPCNT( GEBRD ) +
+     $                    DOPLA( 'ZGEBRD', M, N, 0, 0, NB )
+         T1 = DSECND( )
          CALL ZGEBRD( M, N, A, LDA, S, RWORK( IE ), WORK( ITAUQ ),
      $                WORK( ITAUP ), WORK( NWORK ), LWORK-NWORK+1,
      $                INFO )
+         T2 = DSECND( )
+         TIMNG( GEBRD ) = TIMNG( GEBRD ) + ( T2-T1 )
 *
 *        Multiply B by transpose of left bidiagonalizing vectors.
 *        (CWorkspace: need 2*M+NRHS, prefer 2*M+NRHS*NB)
 *
+         NB = ILAENV( 1, 'ZUNMBR', 'QLC', M, NRHS, N, -1 )
+         OPCNT( UNMBR ) = OPCNT( UNMBR ) +
+     $                    SOPLA2( 'ZUNMBR', 'QLC', M, NRHS, N, 0, NB )
+         T1 = DSECND( )
          CALL ZUNMBR( 'Q', 'L', 'C', M, NRHS, N, A, LDA, WORK( ITAUQ ),
      $                B, LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+         T2 = DSECND( )
+         TIMNG( UNMBR ) = TIMNG( UNMBR ) + ( T2-T1 )
 *
 *        Solve the bidiagonal least squares problem.
 *
+         OPS = 0
+         T1 = DSECND( )
          CALL ZLALSD( 'L', SMLSIZ, M, NRHS, S, RWORK( IE ), B, LDB,
      $                RCOND, RANK, WORK( NWORK ), RWORK( NRWORK ),
      $                IWORK, INFO )
+         T2 = DSECND( )
+         TIMNG( LALSD ) = TIMNG( LALSD ) + ( T2-T1 )
+         OPCNT( LALSD ) = OPCNT( LALSD ) + OPS
          IF( INFO.NE.0 ) THEN
             GO TO 10
          END IF
 *
 *        Multiply B by right bidiagonalizing vectors of A.
 *
+         NB = ILAENV( 1, 'ZUNMBR', 'PLN', N, NRHS, M, -1 )
+         OPCNT( UNMBR ) = OPCNT( UNMBR ) +
+     $                    SOPLA2( 'ZUNMBR', 'PLN', N, NRHS, M, 0, NB )
+         T1 = DSECND( )
          CALL ZUNMBR( 'P', 'L', 'N', N, NRHS, M, A, LDA, WORK( ITAUP ),
      $                B, LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+         T2 = DSECND( )
+         TIMNG( UNMBR ) = TIMNG( UNMBR ) + ( T2-T1 )
 *
       END IF
 *
 *     Undo scaling.
 *
       IF( IASCL.EQ.1 ) THEN
+         OPCNT( GELSD ) = OPCNT( GELSD ) + DBLE( 6*N*NRHS+MINMN )
          CALL ZLASCL( 'G', 0, 0, ANRM, SMLNUM, N, NRHS, B, LDB, INFO )
          CALL DLASCL( 'G', 0, 0, SMLNUM, ANRM, MINMN, 1, S, MINMN,
      $                INFO )
       ELSE IF( IASCL.EQ.2 ) THEN
+         OPCNT( GELSD ) = OPCNT( GELSD ) + DBLE( 6*N*NRHS+MINMN )
          CALL ZLASCL( 'G', 0, 0, ANRM, BIGNUM, N, NRHS, B, LDB, INFO )
          CALL DLASCL( 'G', 0, 0, BIGNUM, ANRM, MINMN, 1, S, MINMN,
      $                INFO )
       END IF
       IF( IBSCL.EQ.1 ) THEN
+         OPCNT( GELSD ) = OPCNT( GELSD ) + DBLE( 6*N*NRHS )
          CALL ZLASCL( 'G', 0, 0, SMLNUM, BNRM, N, NRHS, B, LDB, INFO )
       ELSE IF( IBSCL.EQ.2 ) THEN
+         OPCNT( GELSD ) = OPCNT( GELSD ) + DBLE( 6*N*NRHS )
          CALL ZLASCL( 'G', 0, 0, BIGNUM, BNRM, N, NRHS, B, LDB, INFO )
       END IF
 *
