!c Description:
!c   Ϸ̤ɽ
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2003-02-25    
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2003, All rights reserved

module if_display
  interface display

     subroutine Display1D_Int(var, title)
       integer, intent(in)   :: var(:)
       character(*), intent(in) :: title
     end subroutine Display1D_Int

     subroutine Display1D_Real(var, title)
       real(8), intent(in)      :: var(:)
       character(*), intent(in) :: title
     end subroutine Display1D_Real

     subroutine Display2D_Int(var, title)
       integer, intent(in)      :: var(:, :)
       character(*), intent(in) :: title
     end subroutine Display2D_Int

     subroutine Display2D_Real(var, title)
       real(8), intent(in)      :: var(:, :)
       character(*), intent(in) :: title
     end subroutine Display2D_Real

     subroutine DisplayMatrix(A, B)
       real(8), intent(in)    :: A(:,:)           !
       real(8), intent(in)    :: B(:)             !
     end subroutine DisplayMatrix

  end interface
end module if_display




subroutine Display1D_Int(var, title)
  implicit none
  integer, intent(in)   :: var(:)
  character(*), intent(in) :: title
  integer      :: i, N

  N = size(var, 1)

  write(*,*) ""
  write(*,*) "=============================================================="
  write(*,*) "==", title, "========================================="
  write(*,*) "=============================================================="
  do i = 1, N
     write(*,*) i, var(i)
  end do
  write(*,*) ""
  write(*,*) ""
end subroutine Display1D_Int



subroutine Display1D_Real(var, title)
  implicit none
  real(8), intent(in)      :: var(:)
  character(*), intent(in) :: title
  integer      :: i, N

  N = size(var, 1)

  write(*,*) ""
  write(*,*) "=============================================================="
  write(*,*) "==", title, "========================================="
  write(*,*) "=============================================================="
  do i = 1, N
     write(*,*) i, var(i)
  end do
  write(*,*) ""
  write(*,*) ""
end subroutine Display1D_Real



subroutine Display2D_Int(var, title)
  implicit none
  integer, intent(in)      :: var(:, :)
  character(*), intent(in) :: title
  integer      :: i, N
  
  N = size(var, 1)

  write(*,*) ""
  write(*,*) "=============================================================="
  write(*,*) "==", title, "========================================="
  write(*,*) "=============================================================="
  do i = 1, N
     write(*,*) i, var(i, :)
  end do
  write(*,*) ""
  write(*,*) ""
end subroutine Display2D_Int



subroutine Display2D_Real(var, title)
  implicit none
  real(8), intent(in)      :: var(:, :)
  character(*), intent(in) :: title
  integer      :: i, N
  
  N = size(var, 1)

  write(*,*) ""
  write(*,*) "=============================================================="
  write(*,*) "==", title, "========================================="
  write(*,*) "=============================================================="
  do i = 1, N
     write(*,*) i, real(var(i, :), 4)
  end do
  write(*,*) ""
  write(*,*) ""
end subroutine Display2D_Real



subroutine DisplayMatrix(A, B)
  implicit none
  real(8), intent(in)    :: A(:,:)           !
  real(8), intent(in)    :: B(:)             !
  integer             :: N, I

!!!
!!!ѿν
!!!  
  N = size(B, 1)

!!!
!!!ɽ
!!!  
  write(*,*) ""
  write(*,100) N, 'ϢΩ'
  write(*,200) ''
  do I = 1, N
     write(*,300) I, A(I,1:N)
  end do
  write(*,200) ''
  write(*,400) B
  
100 format(///23x,i3,1x,a/)
200 format(/4x,a)
300 format(4x, i3, 4(2x, f13.10)/(7x, 5(2x, f13.10)))
400 format(7x, 4(2x, f15.10))

end subroutine DisplayMatrix
