!c Description: 
!c   ʬ黻. 
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2004-08-12    ̰ϯ 
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2003, All rights reserved


module if_diff
  
  interface ss_dx_ss
     function ss_dx1d_ss(var)
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax)
       real(8)             :: ss_dx1d_ss(DimXMin:DimXMax)
     end function ss_dx1d_ss
     
     function ss_dx2d_ss(var) 
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)             :: ss_dx2d_ss(DimXMin:DimXMax, DimZMin:DimZMax)
     end function ss_dx2d_ss
  end interface

  interface ss_dz_ss
     function ss_dz1d_ss(var)
       use gridset
       real(8), intent(in) :: var(DimZMin:DimZMax)
       real(8)             :: ss_dz1d_ss(DimZMin:DimZMax)
     end function ss_dz1d_ss

     function ss_dz2d_ss(var) 
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)             :: ss_dz2d_ss(DimXMin:DimXMax, DimZMin:DimZMax)
     end function ss_dz2d_ss
  end interface

  interface ss_dx_fs
     function ss_dx1d_fs(var)     
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax)
       real(8)             :: ss_dx1d_fs(DimXMin:DimXMax)
     end function ss_dx1d_fs

     function ss_dx2d_fs(var) 
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)             :: ss_dx2d_fs(DimXMin:DimXMax, DimZMin:DimZMax)
     end function ss_dx2d_fs
  end interface
  
  interface ss_dz_sf
     function ss_dz1d_sf(var)     
       use gridset
       real(8), intent(in) :: var(DimZMin:DimZMax)
       real(8)             :: ss_dz1d_sf(DimZMin:DimZMax)
     end function ss_dz1d_sf
     
     function ss_dz2d_sf(var) 
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)             :: ss_dz2d_sf(DimXMin:DimXMax, DimZMin:DimZMax)
     end function ss_dz2d_sf
  end interface

  interface ss_dz_fs
     function ss_dz_fs(var) 
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)             :: ss_dz_fs(DimXMin:DimXMax, DimZMin:DimZMax)
     end function ss_dz_fs
  end interface

  interface ss_dx_sf
     function ss_dx_sf(var) 
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)             :: ss_dx_sf(DimXMin:DimXMax, DimZMin:DimZMax)
     end function ss_dx_sf
  end interface

  interface fs_dx_ss
     function fs_dx_ss(var) 
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)             :: fs_dx_ss(DimXMin:DimXMax, DimZMin:DimZMax)
     end function fs_dx_ss
  end interface

  interface fs_dz_ss
     function fs_dz_ss(var) 
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)             :: fs_dz_ss(DimXMin:DimXMax, DimZMin:DimZMax)
     end function fs_dz_ss
  end interface

  interface fs_dx_fs
     function fs_dx_fs(var)
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)             :: fs_dx_fs(DimXMin:DimXMax, DimZMin:DimZMax)
     end function fs_dx_fs
  end interface

  interface fs_dz_fs
     function fs_dz_fs(var) 
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)             :: fs_dz_fs(DimXMin:DimXMax, DimZMin:DimZMax)
     end function fs_dz_fs
  end interface

  interface fs_dx_sf
     function fs_dx_sf(var) 
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)             :: fs_dx_sf(DimXMin:DimXMax, DimZMin:DimZMax)
     end function fs_dx_sf
  end interface

  interface fs_dz_sf
     function fs_dz_sf(var) 
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)             :: fs_dz_sf(DimXMin:DimXMax, DimZMin:DimZMax)
     end function fs_dz_sf
  end interface

  interface sf_dx_ss
     function sf_dx_ss(var) 
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)             :: sf_dx_ss(DimXMin:DimXMax, DimZMin:DimZMax)
     end function sf_dx_ss
  end interface

  interface sf_dz_ss
     function sf_dz_ss(var) 
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)             :: sf_dz_ss(DimXMin:DimXMax, DimZMin:DimZMax)
     end function sf_dz_ss
  end interface

  interface sf_dx_fs
     function sf_dx_fs(var) 
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)             :: sf_dx_fs(DimXMin:DimXMax, DimZMin:DimZMax)
     end function sf_dx_fs
  end interface

  interface sf_dz_fs
     function sf_dz_fs(var) 
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)             :: sf_dz_fs(DimXMin:DimXMax, DimZMin:DimZMax)
     end function sf_dz_fs
  end interface

  interface sf_dx_sf
     function sf_dx_sf(var) 
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)             :: sf_dx_sf(DimXMin:DimXMax, DimZMin:DimZMax)
     end function sf_dx_sf
  end interface

  interface sf_dz_sf
     function sf_dz_sf(var) 
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)             :: sf_dz_sf(DimXMin:DimXMax, DimZMin:DimZMax)
     end function sf_dz_sf
  end interface

end module if_diff



function ss_dx1d_ss(var)
  use gridset
  implicit none

  real(8), intent(in) :: var(DimXMin:DimXMax)
  real(8)             :: ss_dx1d_ss(DimXMin:DimXMax)
  
  ss_dx1d_ss = 0.0d0
  ss_dx1d_ss(DimXMin+1:DimXMax-1) =       &
       &  (                       &
       &     var(DimXMin+2:DimXMax)     &
       &   - var(DimXMin:DimXMax-2)     &
       &  ) *5.0d-1 / DelX
end function ss_dx1d_ss


function ss_dz1d_ss(var)
  use gridset
  implicit none
  
  real(8), intent(in) :: var(DimZMin:DimZMax)
  real(8)             :: ss_dz1d_ss(DimZMin:DimZMax)
  
  ss_dz1d_ss = 0.0d0
  ss_dz1d_ss(DimZMin+1:DimZMax-1) =       &
       &  (                       &
       &     var(DimZMin+2:DimZMax)     &
       &   - var(DimZMin:DimZMax-2)     &
       &  ) * 5.0d-1 / DelZ
end function ss_dz1d_ss


function ss_dx1d_fs(var)     
  use gridset
  implicit none

  real(8), intent(in) :: var(DimXMin:DimXMax)
  real(8)             :: ss_dx1d_fs(DimXMin:DimXMax)
  
  ss_dx1d_fs = 0.0d0
  ss_dx1d_fs(DimXMin+1:DimXMax) =       &
       &  (                       &
       &     var(DimXMin+1:DimXMax)     &
       &   - var(DimXMin:DimXMax-1)     &
       &  ) / DelX
end function ss_dx1d_fs


function ss_dz1d_sf(var)     
  use gridset
  implicit none

  real(8), intent(in) :: var(DimZMin:DimZMax)
  real(8)             :: ss_dz1d_sf(DimZMin:DimZMax)
  
  ss_dz1d_sf = 0.0d0
  ss_dz1d_sf(DimZMin+1:DimZMax) =        &
       &  (                       &
       &     var(DimZMin+1:DimZMax)     &
       &   - var(DimZMin:DimZMax-1)     &
       &  ) / DelZ
end function ss_dz1d_sf


function ss_dx2d_ss(var) 
  use gridset
  implicit none

  real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)             :: ss_dx2d_ss(DimXMin:DimXMax, DimZMin:DimZMax)
  
  ss_dx2d_ss = 0.0d0 
  ss_dx2d_ss(DimXMin+1:DimXMax-1,DimZMin:DimZMax) =      &
       &  (                                 &
       &     var(DimXMin+2:DimXMax,DimZMin:DimZMax)     &
       &   - var(DimXMin:DimXMax-2,DimZMin:DimZMax)     &
       &  ) * 5.0d-1 / DelX
end function ss_dx2d_ss
  
  
function ss_dz2d_ss(var) 
  use gridset
  implicit none

  real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)             :: ss_dz2d_ss(DimXMin:DimXMax, DimZMin:DimZMax)
  
  ss_dz2d_ss = 0.0d0
  ss_dz2d_ss(DimXMin:DimXMax,DimZMin+1:DimZMax-1) =      &
       &  (                                 &
       &     var(DimXMin:DimXMax,DimZMin+2:DimZMax)   &
       &   - var(DimXMin:DimXMax,DimZMin:DimZMax-2)   &
       &  ) * 5.0d-1 / DelZ
end function ss_dz2d_ss


function ss_dx2d_fs(var) 
  use gridset
  implicit none

  real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)             :: ss_dx2d_fs(DimXMin:DimXMax, DimZMin:DimZMax)
  
  ss_dx2d_fs = 0.0d0 
  ss_dx2d_fs(DimXMin+1:DimXMax,DimZMin:DimZMax) =       &
       &  (                                 &
       &     var(DimXMin+1:DimXMax,DimZMin:DimZMax)     &
       &   - var(DimXMin:DimXMax-1,DimZMin:DimZMax)     &
       &  ) / DelX
end function ss_dx2d_fs


function ss_dz_fs(var) 
  use gridset
  implicit none

  real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)             :: ss_dz_fs(DimXMin:DimXMax, DimZMin:DimZMax)
  
  ss_dz_fs = 0.0d0
  ss_dz_fs(DimXMin+1:DimXMax,DimZMin+1:DimZMax-1) =    &
       &  (                                 &
       &     var(DimXMin+1:DimXMax,DimZMin+2:DimZMax)   &
       &   + var(DimXMin:DimXMax-1,DimZMin+2:DimZMax)   &
       &   - var(DimXMin+1:DimXMax,DimZMin:DimZMax-2)   &
       &   - var(DimXMin:DimXMax-1,DimZMin:DimZMax-2)   &
       &  ) * 2.5d-1 / DelZ
end function ss_dz_fs
  
  
function ss_dx_sf(var) 
  use gridset
  implicit none
  
  real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)             :: ss_dx_sf(DimXMin:DimXMax, DimZMin:DimZMax)
  
  ss_dx_sf = 0.0d0
  ss_dx_sf(DimXMin+1:DimXMax-1,DimZMin+1:DimZMax) =    &
       &  (                                 &
       &     var(DimXMin+2:DimXMax,DimZMin+1:DimZMax)   &
       &   + var(DimXMin+2:DimXMax,DimZMin:DimZMax-1)   &
       &   - var(DimXMin:DimXMax-2,DimZMin+1:DimZMax)   &
       &   - var(DimXMin:DimXMax-2,DimZMin:DimZMax-1)   &
       &  ) * 2.5d-1 / DelX
end function ss_dx_sf
  
  
function ss_dz2d_sf(var) 
  use gridset
  implicit none
  
  real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)             :: ss_dz2d_sf(DimXMin:DimXMax, DimZMin:DimZMax)
  
  ss_dz2d_sf = 0.0d0 
  ss_dz2d_sf(DimXMin:DimXMax,DimZMin+1:DimZMax) =        &
       &  (                                 &
       &     var(DimXMin:DimXMax,DimZMin+1:DimZMax)     &
       &   - var(DimXMin:DimXMax,DimZMin:DimZMax-1)     &
       &  ) / DelZ
end function ss_dz2d_sf



!!!
!!!® u ΰ֤Ǥʬ黻
!!!
function fs_dx_ss(var) 
  use gridset
  implicit none
  
  real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)             :: fs_dx_ss(DimXMin:DimXMax, DimZMin:DimZMax)
  
  fs_dx_ss = 0.0d0
  fs_dx_ss(DimXMin:DimXMax-1,DimZMin:DimZMax) =        &
       &  (                                 &
       &     var(DimXMin+1:DimXMax,DimZMin:DimZMax)     &
       &   - var(DimXMin:DimXMax-1,DimZMin:DimZMax)     &
       &  ) / DelX
end function fs_dx_ss

  
function fs_dz_ss(var) 
  use gridset
  implicit none

  real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)             :: fs_dz_ss(DimXMin:DimXMax, DimZMin:DimZMax)
  
  fs_dz_ss = 0.0d0
  fs_dz_ss(DimXMin:DimXMax-1,DimZMin+1:DimZMax-1) =    &
       &  (                                 &
       &     var(DimXMin+1:DimXMax,DimZMin+2:DimZMax)   &
       &   + var(DimXMin:DimXMax-1,DimZMin+2:DimZMax)   &
       &   - var(DimXMin+1:DimXMax,DimZMin:DimZMax-2)   &
       &   - var(DimXMin:DimXMax-1,DimZMin:DimZMax-2)   &
       &  ) * 2.5d-1 / DelZ
end function fs_dz_ss
  
  
function fs_dx_fs(var)
  use gridset
  implicit none

  real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)             :: fs_dx_fs(DimXMin:DimXMax, DimZMin:DimZMax)
  
  fs_dx_fs = 0.0d0 
  fs_dx_fs(DimXMin+1:DimXMax-1,DimZMin:DimZMax) =      &
       &  (                                 &
       &     var(DimXMin+2:DimXMax,DimZMin:DimZMax)     &
       &   - var(DimXMin:DimXMax-2,DimZMin:DimZMax)     &
       &  ) * 5.0d-1 / DelX
end function fs_dx_fs

  
function fs_dz_fs(var) 
  use gridset
  implicit none
  
  real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)             :: fs_dz_fs(DimXMin:DimXMax, DimZMin:DimZMax)
  
  fs_dz_fs = 0.0d0 
  fs_dz_fs(DimXMin:DimXMax,DimZMin+1:DimZMax-1) =      &
       &  (                                 &
       &     var(DimXMin:DimXMax,DimZMin+2:DimZMax)     &
       &   - var(DimXMin:DimXMax,DimZMin:DimZMax-2)     &
       &  ) * 5.0d-1 / DelZ
end function fs_dz_fs

   
function fs_dx_sf(var) 
  use gridset
  implicit none

  real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)             :: fs_dx_sf(DimXMin:DimXMax, DimZMin:DimZMax)
  
  fs_dx_sf = 0.0d0
  fs_dx_sf(DimXMin:DimXMax-1,DimZMin+1:DimZMax) =    &
       &  (                                 &
       &     var(DimXMin+1:DimXMax,DimZMin+1:DimZMax)   &
       &   + var(DimXMin+1:DimXMax,DimZMin:DimZMax-1)   &
       &   - var(DimXMin:DimXMax-1,DimZMin+1:DimZMax)   &
       &   - var(DimXMin:DimXMax-1,DimZMin:DimZMax-1)   &
       &  ) * 5.0d-1/ DelX
end function fs_dx_sf
  
  
function fs_dz_sf(var) 
  use gridset
  implicit none

  real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)             :: fs_dz_sf(DimXMin:DimXMax, DimZMin:DimZMax)
  
  fs_dz_sf = 0.0d0
  fs_dz_sf(DimXMin:DimXMax-1,DimZMin+1:DimZMax) =      &
       &  (                                 &
       &     var(DimXMin+1:DimXMax,DimZMin+1:DimZMax)   &
       &   + var(DimXMin:DimXMax-1,DimZMin+1:DimZMax)   &
       &   - var(DimXMin+1:DimXMax,DimZMin:DimZMax-1)   &
       &   - var(DimXMin:DimXMax-1,DimZMin:DimZMax-1)   &
       &  ) * 5.0d-1 / DelZ
end function fs_dz_sf


!!!
!!!® w ΰ֤Ǥʬ
!!!
function sf_dx_ss(var) 
  use gridset
  implicit none
  
  real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)             :: sf_dx_ss(DimXMin:DimXMax, DimZMin:DimZMax)
  
  sf_dx_ss = 0.0d0 
  sf_dx_ss(DimXMin+1:DimXMax-1,DimZMin:DimZMax-1) =    &
       &  (                                 &
       &     var(DimXMin+2:DimXMax,DimZMin+1:DimZMax)   &
       &   + var(DimXMin+2:DimXMax,DimZMin:DimZMax-1)   &
       &   - var(DimXMin:DimXMax-2,DimZMin+1:DimZMax)   &
       &   - var(DimXMin:DimXMax-2,DimZMin:DimZMax-1)   &
       &  ) * 2.5d-1 / DelX
end function sf_dx_ss
  
  
function sf_dz_ss(var) 
  use gridset
  implicit none

  real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)             :: sf_dz_ss(DimXMin:DimXMax, DimZMin:DimZMax)

  sf_dz_ss = 0.0d0 
  sf_dz_ss(DimXMin:DimXMax,DimZMin:DimZMax-1) =        &
       &  (                                 &
       &   + var(DimXMin:DimXMax,DimZMin+1:DimZMax)     &
       &   - var(DimXMin:DimXMax,DimZMin:DimZMax-1)     &
       &  ) / DelZ
end function sf_dz_ss

  
function sf_dx_fs(var) 
  use gridset
  implicit none

  real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)             :: sf_dx_fs(DimXMin:DimXMax, DimZMin:DimZMax)

  sf_dx_fs = 0.0d0 
  sf_dx_fs(DimXMin:DimXMax-1,DimZMin:DimZMax-1) =    &
       &  (                                 &
       &     var(DimXMin+1:DimXMax,DimZMin+1:DimZMax)   &
       &   + var(DimXMin+1:DimXMax,DimZMin:DimZMax-1)   &
       &   - var(DimXMin:DimXMax-1,DimZMin+1:DimZMax)   &
       &   - var(DimXMin:DimXMax-1,DimZMin:DimZMax-1)   &
       &  ) * 5.0d-1/ DelX
end function sf_dx_fs


function sf_dz_fs(var) 
  use gridset
  implicit none

  real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)             :: sf_dz_fs(DimXMin:DimXMax, DimZMin:DimZMax)
  
  sf_dz_fs = 0.0d0 
  sf_dz_fs(DimXMin+1:DimXMax,DimZMin:DimZMax-1) =      &
       &  (                                 &
       &     var(DimXMin+1:DimXMax,DimZMin+1:DimZMax)   &
       &   + var(DimXMin:DimXMax-1,DimZMin+1:DimZMax)   &
       &   - var(DimXMin+1:DimXMax,DimZMin:DimZMax-1)   &
       &   - var(DimXMin:DimXMax-1,DimZMin:DimZMax-1)   &
       &  ) * 5.0d-1 / DelZ
end function sf_dz_fs
  
  
function sf_dx_sf(var) 
  use gridset
  implicit none

  real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)             :: sf_dx_sf(DimXMin:DimXMax, DimZMin:DimZMax)
 
  sf_dx_sf = 0.0d0 
  sf_dx_sf(DimXMin+1:DimXMax-1,DimZMin:DimZMax) =      & 
       &  (                                 &
       &     var(DimXMin+2:DimXMax,DimZMin:DimZMax)     &
       &   - var(DimXMin:DimXMax-2,DimZMin:DimZMax)     &
       &  ) * 5.0d-1 / DelX
end function sf_dx_sf
  
  
function sf_dz_sf(var) 
  use gridset
  implicit none

  real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)             :: sf_dz_sf(DimXMin:DimXMax, DimZMin:DimZMax)
  
  sf_dz_sf = 0.0d0 
  sf_dz_sf(DimXMin:DimXMax,DimZMin+1:DimZMax-1) =      &
       &  (                                 &
       &     var(DimXMin:DimXMax,DimZMin+2:DimZMax)     &
       &   - var(DimXMin:DimXMax,DimZMin:DimZMax-2)     &
       &  ) * 5.0d-1 / DelZ
end function sf_dz_sf
