!c Description: 
!c   CFL $B>r7o$N%A%'%C%/(B
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2004, All rights reserved

subroutine cflchk

  !--- $B%b%8%e!<%k$NFI$_9~$_(B
  use gridset, only: DelX
  use timeset, only: DelTShort, beta
  use physprm, only: GasR
  use prm_tmp, only: ss_VelSoundBasicZ
  
  !--- $B0EL[$N7?@k8@6X;_(B
  implicit none
  
  !--- $BFbItJQ?t(B
  real(8)                :: ss_VelSoundMax
  real(8)                :: Cfl
  
  !--- $B2;B.$H(B CFL $B>r7o$r5a$a$k(B
  ss_VelSoundMax = maxval(ss_VelSoundBasicZ)
  Cfl = DelX / ss_VelSoundMax 
  
  !--- $B7Y9p%a%C%;!<%8(B
  if (DelTShort >= Cfl) then 
     write(*,*) "CFL Condition is broken, DelTShort * VelSound > DelX"
     write(*,*) "sound wave velocity", ss_VelSoundMax
     write(*,*) "DelX", DelX
     write(*,*) "DelTShort", DelTShort
     stop
  end if
  
  !--- $B7Y9p%a%C%;!<%8(B
  if (DelTShort >= Cfl * 5.0d-1) then 
     write(*,*) "CFL Condition is nearly broken"
     write(*,*) "sound wave velocity", ss_VelSoundMax
     write(*,*) "DelX", DelX
     write(*,*) "DelTShort", DelTShort
  end if
  
  !--- $B7Y9p%a%C%;!<%8(B
  if (ss_VelSoundMax <= 0.0d0) then 
     write(*,*) "sound wave velocity <= 0.0d0"
     stop
  end if
  
end subroutine cflchk
