!c Description: 
!c   $BB.EY(B w $B$N7W;;(B
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2003-11-04    $B9b66$3$&;R(B $B:n@.(B
!c   1.1        2003-12-22    $B?y;39L0lO/(B $B=$@5(B
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2003, All rights reserved

module if_vel_w
  interface
     
     subroutine vel_w(pi, pi_old, div, w_adv, w_byc, w_trb, w)
       use gridset, only: bm
       real(8), intent(in)        :: pi(-bm:,-bm:)
       real(8), intent(in)        :: pi_old(-bm:,-bm:)
       real(8), intent(in)        :: div(-bm:,-bm:)
       real(8), intent(in)        :: w_adv(-bm:,-bm:)
       real(8), intent(in)        :: w_byc(-bm:,-bm:)
       real(8), intent(in)        :: w_trb(-bm:,-bm:)
       real(8), intent(inout)     :: w(-bm:,-bm:)
     end subroutine vel_w
     
  end interface
end module if_vel_w




subroutine vel_w(pi, pi_old, div, w_adv, w_byc, w_trb, w)

  !--- $B%b%8%e!<%k$NFI$_9~$_(B
  use gridset, only: im, km, bm
  use jacobian, only: jcb_bz
  use integrt, only: dts, beta
  use prm, only: cp, alpha
  use basicenv, only: vtheta_bs
  use if_heikin
  use if_bibun

  !--- $B0EL[$N7?@k8@6X;_(B
  implicit none

  !--- $BF~=PNOJQ?t(B
  real(8), intent(in)      :: pi(-bm:,-bm:)
  real(8), intent(in)      :: pi_old(-bm:,-bm:)
  real(8), intent(in)      :: div(-bm:,-bm:)
  real(8), intent(in)      :: w_adv(-bm:,-bm:)
  real(8), intent(in)      :: w_byc(-bm:,-bm:)
  real(8), intent(in)      :: w_trb(-bm:,-bm:)
  real(8), intent(inout)   :: w(-bm:,-bm:)

  !--- $BFbItJQ?t(B
  real(8), allocatable     :: vtheta_bz(:,:)
  real(8), allocatable     :: pi_z(:,:)
  real(8), allocatable     :: pi_old_z(:,:)
  real(8), allocatable     :: div_z(:,:)
  
  !--- $BJ?6Q2=A`:n(B
  call heikin(31, vtheta_bs, vtheta_bz)
  
  !--- $BHyJ,1i;;(B
  call bibun(312, pi, pi_z)
  call bibun(312, pi_old, pi_old_z)
  call bibun(312, div, div_z)
  
  
  !--- $BB.EY(B w
  w(:,1:km-1) = w(:,1:km-1)                                 &
       &   - dts * cp * vtheta_bz(:,1:km-1) /jcb_bz(:,1:km-1)  &
       &     *(                                             &
       &       - alpha * div_z(:,1:km-1)                       &
       &       + (1.0d0 - beta) * pi_old_z(:,1:km-1)           &
       &      )                                             &
       &   + dts &
       &     * (- w_adv(:,1:km-1) + w_byc(:,1:km-1) + w_trb(:,1:km-1))   &
       &   - beta * cp * vtheta_bz(:,1:km-1) &
       &     * dts * pi_z(:,1:km-1) / jcb_bz(:,1:km-1)    

  !--- $B6-3&>r7o(B
  w(:,-bm:0) = 0.0d0
  w(:,km:km+bm) = 0.0d0
  w(-bm:-1,:) = 0.0d0
  w(im+1:im+bm,:) = 0.0d0
  

!  write(*,*)  - dts * beta * cp * vtheta_bz(5,5) * pi_z(5,5) 
!  write(*,*) pi(:,:)
!  write(*,*) pi_z(:,:)
  
  !---$BG[Ns$N2rJ|(B
  deallocate(vtheta_bz, pi_z, pi_old_z, div_z)


end subroutine vel_w


