# -*- coding: euc-jp -*-
require "numru/ggraph"
include NumRu


dir   = ARGV[0]
vname = ARGV[1]
ihr   = ARGV[2].to_i

gphys = GPhys::NetCDF_IO.open(dir+'/'+vname+".nc", vname)


DCL.sgscmn(14)


#< DCLΥץ >
DCL.gropn(2)
#DCL.sldiv('y',2,2)           # 2x2˲ʬ, 'y'=yoko: 墪墪...
DCL.sgpset('lcntl', false)   # ʸᤷʤ
DCL.sgpset('lfull',true)     # ɽ
DCL.uzfact(0.75)             # ɸʸ󥵥 0.75 
DCL.sgpset('lfprop',true)    # ץݡʥեȤȤ

#< GGraph ˤ  >
GGraph.set_fig 'itr'=>10, 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[0,360,-90,90]
#GGraph.set_map 'coast_world'=>true, 'grid'=>false
GGraph.set_map 'coast_world'=>false, 'grid'=>false
GGraph.set_axes('xlabelint'=>90)
GGraph.set_axes('ylabelint'=>30)

time = gphys.coord('time').val
gphysout = gphys.cut('time'=>time[ihr]).cut('sig'=>0.975)

if vname == 'Vor'
  gphysout = gphysout * 1.0e5
  gphysout.units = '1e-5 s-1'
end


# ٥ѥۤ˻
# ѥ1¿ޡޤ

if vname == 'Temp'
  levels = [252.5,255.0,257.5,260.0,262.5,265.0,267.5,270.0,272.5,275.0,277.5,280.0,282.5,285.0,287.5,290.0,292.5]
  patterns = [10999,15999,20999,25999,30999,35999,40999,45999,50999,1,55999,60999,65999,70999,75999,80999,85999,90999]
elsif vname == 'Vor'
  levels = [-7.5,-6.5,-5.5,-4.5,-3.5,-2.5,-1.5,-0.5,0.5,1.5,2.5,3.5,4.5,5.5,6.5,7.5]
  patterns = [10999,15999,20999,25999,30999,35999,40999,45999,1,55999,60999,65999,70999,75999,80999,85999,90999]
end

GGraph.tone( gphysout, true, 'lev'=>levels, 'pat'=>patterns, 'map_axes'=>true, 'annotate'=>false )
GGraph.contour( gphysout, false, 'lev'=>levels, 'index'=>3, 'annotate'=>false, 'label'=>false )
GGraph.color_bar

title = sprintf( "%0#{3}d hr", time[ihr] )

DCL::uxmttl('T', ' ', 1.0)
DCL::uxmttl('T', title, -1.0)

DCL.grcls

