require 'gphys_const_v1'
require "numru/ggraph"
include NumRu

dir = '..'
dir = '../util_s2p-2011-12-15/out'

#gphys = GPhys::NetCDF_IO.open( dir + '/'+'Ps'+'.nc', 'Ps' )
gphys = GPhys::NetCDF_IO.open( '..' + '/'+'Ps'+'.nc', 'Ps' )
tm = gphys.shape[2] # number of elements for time      dimension

daysOfYear = 0
DaysOfMonth.each do |i|
  daysOfYear += i
end
p daysOfYear

figdir = 'figs'
Dir::mkdir( figdir )

vnames = ['Temp', 'U', 'V', 'QVap']

for ivar in 0..3
  for iyr in 3..3
    for imon in 1..12
      t = daysOfYear*(iyr-1)
      for i in 1..imon-1
        t = t + DaysOfMonth[i-1]
      end

      ts = t
      te = t + DaysOfMonth[imon-1]

      ts = ts * DataNumOfDay
      te = te * DataNumOfDay - 1

      if ts > tm then
        p 'ts is in appropriate'
      end
      if te > tm then
        p 'te is in appropriate'
      end

      p vnames[ivar] + ' at Year: ' + iyr.to_s + ', Month: ' + imon.to_s + ', t = ' + ts.to_s + ' to '+ te.to_s

      system('ruby drawzm_log.rb ' + dir + ' ' + vnames[ivar] + ' ' + ts.to_s + ' ' + te.to_s + ' ' + MonNames[imon-1])

      system("pstoimg -type gif -flip r270 dcl.ps")
      com = sprintf( "mv dcl.gif " + figdir + "/dcl_zm_log_"+vnames[ivar]+"_yr%0#{3}d_mon%0#{2}d.gif", iyr, imon )
      system(com)
      com = sprintf( "mv dcl.ps " + figdir + "/dcl_zm_log_"+vnames[ivar]+"_yr%0#{3}d_mon%0#{2}d.ps", iyr, imon )
      system(com)
    end
  end
end
