# -*- coding: euc-jp -*-
require "gphys_methods_v1.4"
require "numru/ggraph"
include NumRu

dir   = ARGV[0]
vname = ARGV[1]
iyrs = ARGV[2].to_i
iyre = ARGV[3].to_i
imon = ARGV[4].to_i

title = MonNames[imon-1]


gphys = GPhys::NetCDF_IO.open(dir+'/'+vname+".nc", vname)

#< DCLΥץ >
DCL.gropn(2)
#DCL.sldiv('y',2,2)           # 2x2˲ʬ, 'y'=yoko: 墪墪...
DCL.sgpset('lcntl', false)   # ʸᤷʤ
DCL.sgpset('lfull',true)     # ɽ
DCL.uzfact(0.75)             # ɸʸ󥵥 0.75 
DCL.sgpset('lfprop',true)    # ץݡʥեȤȤ

if vname == 'SurfTemp'
  GGraph.set_fig 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[-90,90,200,320]
elsif vname == 'Rain'
  GGraph.set_fig 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[-90,90,0,10e-5]
elsif vname == 'SoilMoist'
  GGraph.set_fig 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[-90,90,0,20]
elsif vname == 'SurfSnow'
  GGraph.set_fig 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[-90,90,0,20]
elsif vname == 'OLRA'
  GGraph.set_fig 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[-90,90,100,300]
elsif vname == 'OSRA'
  GGraph.set_fig 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[-90,90,0,400]
elsif vname == 'SLRA'
  GGraph.set_fig 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[-90,90,0,100]
elsif vname == 'SSRA'
  GGraph.set_fig 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[-90,90,0,400]
elsif vname == 'SSRA'
  GGraph.set_fig 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[-90,90,0,400]
elsif vname == 'KMHF_d'
  GGraph.set_fig 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[-90,90,0,400]
elsif vname == 'Newman_d'
elsif vname == 'TauXB'
  GGraph.set_fig 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[-90,90,0,400]
elsif vname == 'TauYB'
  GGraph.set_fig 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[-90,90,0,400]
elsif vname == 'Tau'
  GGraph.set_fig 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[-90,90,0,400]
end

GGraph.set_axes('yside'=>'lr','xside'=>'tb')
GGraph.set_axes('xlabelint'=>30)

gphysout = dcpam_clim_mon_mean( iyrs, iyre, imon, gphys )
gphysout = gphysout.mean('lon')

if vname == 'SurfTemp'
elsif vname == 'Rain'
  gphysout       = gphysout / 2.5e6
  gphysout.units = 'kg m-2 s-1'
elsif vname == 'SoilMoist'
elsif vname == 'SurfSnow'
elsif vname == 'OLRA'
elsif vname == 'OSRA'
  gphysout = -gphysout
elsif vname == 'SLRA'
elsif vname == 'SSRA'
  gphysout = -gphysout
elsif vname == 'KMHF_d'
elsif vname == 'Newman_d'
elsif vname == 'TauXB'
elsif vname == 'TauYB'
elsif vname == 'Tau'
end

GGraph.line( gphysout, true, 'annotate'=>false )

#dirNCEP = "/home/yot/work/NCEP/data"
#if vname == 'SurfTemp'
#  gphysNCEP = GPhys::NetCDF_IO.open(dirNCEP+'/skt.sfc.mon.mean.nc', 'skt')
#  gphysout = ncep_clim_mean_with_mon_mean( 1988, 2007, imon, gphysNCEP )
#  gphysout = gphysout + 273.15
#  gphysout = gphysout.mean('lon')
#  GGraph.line( gphysout, false, 'type'=>2, 'index'=>3, 'annotate'=>false )
#elsif vname == 'Rain'
#  gphysNCEP = GPhys::NetCDF_IO.open(dirNCEP+'/prate.sfc.mon.mean.nc', 'prate')
#  gphysout = ncep_clim_mean_with_mon_mean( 1988, 2007, imon, gphysNCEP )
#  gphysout = gphysout.mean('lon')
#  GGraph.line( gphysout, false, 'type'=>2, 'index'=>3, 'annotate'=>false )
#elsif vname == 'SoilMoist'
#elsif vname == 'SurfSnow'
#elsif vname == 'OLRA'
#  gphysNCEP = GPhys::NetCDF_IO.open(dirNCEP+'/ulwrf.ntat.mon.mean.nc', 'ulwrf')
#  gphysout = ncep_clim_mean_with_mon_mean( 1988, 2007, imon, gphysNCEP )
#  gphysout = gphysout.mean('lon')
#  GGraph.line( gphysout, false, 'type'=>2, 'index'=>3, 'annotate'=>false )
#elsif vname == 'OSRA'
#  gphysNCEP1 = GPhys::NetCDF_IO.open(dirNCEP+'/dswrf.ntat.mon.mean.nc', 'dswrf')
#  gphysNCEP2 = GPhys::NetCDF_IO.open(dirNCEP+'/uswrf.ntat.mon.mean.nc', 'uswrf')
#  gphysNCEP  = gphysNCEP1 - gphysNCEP2
#  gphysout = ncep_clim_mean_with_mon_mean( 1988, 2007, imon, gphysNCEP )
#  gphysout = gphysout.mean('lon')
#  GGraph.line( gphysout, false, 'type'=>2, 'index'=>3, 'annotate'=>false )
#elsif vname == 'SLRA'
#  gphysNCEP = GPhys::NetCDF_IO.open(dirNCEP+'/nlwrs.sfc.mon.mean.nc', 'nlwrs')
#  gphysout = ncep_clim_mean_with_mon_mean( 1988, 2007, imon, gphysNCEP )
#  gphysout = gphysout.mean('lon')
#  GGraph.line( gphysout, false, 'type'=>2, 'index'=>3, 'annotate'=>false )
#elsif vname == 'SSRA'
#  gphysNCEP = GPhys::NetCDF_IO.open(dirNCEP+'/nswrs.sfc.mon.mean.nc', 'nswrs')
#  gphysout = ncep_clim_mean_with_mon_mean( 1988, 2007, imon, gphysNCEP )
#  gphysout = -gphysout
#  gphysout = gphysout.mean('lon')
#  GGraph.line( gphysout, false, 'type'=>2, 'index'=>3, 'annotate'=>false )
#end


DCL::uxmttl('T', ' ', 1.0)
DCL::uxmttl('T', title, -1.0)

DCL.grcls
