require "numru/ggraph"
include NumRu
include NMath

ncfn  = "../mknc_zm-2012-10-13/out/zm.nc"
vname = 'ua'
vname = 'ta2'

ncfn  = ARGV[0]
vname = ARGV[1]

gphysArr3d0 = GPhys::IO.open( ncfn, vname )

gphysArr3d = gphysArr3d0.mean('lon')

#gphysArr3d.name      = 'variance of Temperature'
#gphysArr3d.long_name = 'variance of Temperature'
#gphysArr3d.units     = gphysArr3d.units.to_s + ' 2'


DCL.gropn(2)
#DCL.sldiv('y',2,2)           # 2x2$B$K2hLLJ,3d(B, 'y'=yoko: $B:8>e"*1&>e"*:82<(B...
DCL.sgpset('lcntl', false)   # $B@)8fJ8;z$r2r<a$7$J$$(B
DCL.sgpset('lfull',true)     # $BA42hLLI=<((B
DCL.uzfact(0.7)             # $B:BI8<4$NJ8;zNs%5%$%:$r(B 0.75 $BG\(B
DCL.sgpset('lfprop',true)    # $B%W%m%]!<%7%g%J%k%U%)%s%H$r;H$&(B

#DCL.glpset('lmiss',true)
#DCL.glpset('rmiss',rmiss)

#< GGraph $B$K$h$k(B $BIA2h(B >
GGraph.set_fig 'itr'=>1, 'viewport'=>[0.15,0.85,0.15,0.6], 'window'=>[-90,90,1,0]
#GGraph.set_fig 'itr'=>1, 'viewport'=>[0.15,0.85,0.15,0.6], 'yrev'=>'units:Pa'
#GGraph.set_fig 'itr'=>2, 'viewport'=>[0.15,0.85,0.15,0.6], 'yrev'=>'units:Pa'
GGraph.set_axes('xlabelint'=>30)

if vname == 'ua' then
  gphysArr3d.long_name = 'zonal wind'
#  levels   = [-24,-20,-16,-12,-8,-4,0,4,8,12,16,20,24,28,32]
  levels   = [-64,-56,-48,-40,-32,-24,-16,-8,0,8,16,24,32,40,48,56,64]
  patterns = [10999,15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999,95999]
elsif vname == 'ta' then
  gphysArr3d.long_name = 'temperature'
  levels   = [170,180,190,200,210,220,230,240,250,260,270,280,290,300]
  patterns = [10999,15999,20999,25999,30999,35999,40999,50999,60999,65999,70999,75999,80999,90999,95999]
elsif vname == 'ta2' then
  gphysArr3d.long_name = 'temperature variance'
  levels   = [5,10,15,20,25,30,35,40,45]
  patterns = [10999,15999,20999,30999,40999,50999,60999,70999,80999,90999]
elsif vname == 'vt' then
  gphysArr3d.long_name = 'northward wind - temperature covariance'
  levels   = [-24,-21,-18,-15,-12,-9,-6,-3,0,3,6,9,12,15,18,21,24]
  patterns = [10999,15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999,95999]
elsif vname == 'qa' then
  gphysArr3d.long_name = 'specific humidity'
  levels   = [1e-3,2e-3,3e-3,4e-3,5e-3,6e-3,7e-3,8e-3,9e-3,10e-3,11e-3,12e-3,13e-3,14e-3,15e-3,16e-3,17e-3]
  patterns = [1,10999,15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,90999,95999]
else
  p "Unexpected vname"
end


if vname == 'ua' then
  DCL.sgscmn(14) # blue-white-red
elsif vname == 'vt' then
  DCL.sgscmn(14) # blue-white-red
end


#GGraph.tone( gphysArr3d, true )
GGraph.tone( gphysArr3d, true,
             'lev'=>levels,  # $B%l%Y%k!u%Q%?!<%s$rM[$K;XDj(B
             'pat'=>patterns # $B%Q%?%s$NJ}$,(B1$B$DB?"*!^!g$^$G(B
           )
GGraph.contour( gphysArr3d, false, 'lev'=>levels, 'index'=>3 )
GGraph.color_bar

DCL::uxmttl('T', gphysArr3d.units.to_s, 1.0)


## first panel
##GGraph.tone( gphyszm1, true )
#GGraph.tone( gphyszm1, true,
##             'lev'=>[200,210,220,230,240,250,260,270,280,290,300],
##             # $B%l%Y%k!u%Q%?!<%s$rM[$K;XDj(B
##             'pat'=>[10999,20999,30999,40999,50999,60999,65999,70999,75999,80999,90999,95999] )
##             # $B%Q%?%s$NJ}$,(B1$B$DB?"*!^!g$^$G(B
#             'lev'=>[170,180,190,200,210,220,230,240,250,260,270,280,290,300],
#             # $B%l%Y%k!u%Q%?!<%s$rM[$K;XDj(B
#             'pat'=>[10999,15999,20999,25999,30999,35999,40999,50999,60999,65999,70999,75999,80999,90999,95999] )
#             # $B%Q%?%s$NJ}$,(B1$B$DB?"*!^!g$^$G(B
#GGraph.color_bar
#
#
#DCL::uxmttl('T', ' ', 1.0)
#DCL::uxmttl('T', ' ', 1.0)
#DCL::uxmttl('T', title, -1.0)
#
#
## second panel
##GGraph.tone( gphyszm2, true )
#GGraph.tone( gphyszm2, true,
##             'lev'=>[-20,-10,0,10,20,30,40,50,60],
##             # $B%l%Y%k!u%Q%?!<%s$rM[$K;XDj(B
##             'pat'=>[10999,20999,30999,40999,50999,60999,65999,70999,80999,90999] )
##             # $B%Q%?%s$NJ}$,(B1$B$DB?"*!^!g$^$G(B
#             'lev'=>[-20,-15,-10,-5,0,5,10,15,20,25,30,35,40,45,50],
#             # $B%l%Y%k!u%Q%?!<%s$rM[$K;XDj(B
#             'pat'=>[10999,15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,90999] )
#             # $B%Q%?%s$NJ}$,(B1$B$DB?"*!^!g$^$G(B
#GGraph.color_bar
#
## third panel
##GGraph.tone( gphyszm3, true )
#GGraph.tone( gphyszm3, true,
##             'lev'=>[-12e0,-10e0,-8e0,-6e0,-4e0,-2e0,0,2e0,4e0,6e0,8e0,10e0,12e0],
##             # $B%l%Y%k!u%Q%?!<%s$rM[$K;XDj(B
##             'pat'=>[10999,15999,20999,25999,30999,40999,50999,60999,70999,75999,80999,85999,90999,95999] )
##             # $B%Q%?%s$NJ}$,(B1$B$DB?"*!^!g$^$G(B
#             'lev'=>[-14e0,-12e0,-10e0,-8e0,-6e0,-4e0,-2e0,0,2e0,4e0,6e0,8e0,10e0,12e0,14e0],
#             # $B%l%Y%k!u%Q%?!<%s$rM[$K;XDj(B
#             'pat'=>[10999,15999,20999,25999,30999,35999,40999,50999,60999,65999,70999,75999,80999,85999,90999,95999] )
#             # $B%Q%?%s$NJ}$,(B1$B$DB?"*!^!g$^$G(B
#GGraph.color_bar
#
## forth panel
##GGraph.tone( gphyszm4, true )
#GGraph.tone( gphyszm4, true,
#             'lev'=>[1e-4,2e-3,4e-3,6e-3,8e-3,10e-3,12e-3,14e-3,16e-3,18e-3,20e-3],
#             # $B%l%Y%k!u%Q%?!<%s$rM[$K;XDj(B
#             'pat'=>[1,10999,20999,30999,40999,50999,60999,65999,70999,80999,90999,95999] )
#GGraph.color_bar

DCL.grcls

